/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.util.PermissonType;

public class NewHomePlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String ORG_HOME = "orgid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(ORG_HOME);
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> filters = param.getListFilterParameter().getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(1);
                param.getListFilterParameter().setQFilters(filters);
            }
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            filters.add(new QFilter("id", "in", (Object)pkSet));
        });
        BasedataEdit bookType = (BasedataEdit)this.getControl("booktype");
        bookType.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_HOME);
            if (org != null) {
                QFilter f2 = new QFilter("org", "=", org.get("id")).and(new QFilter("enable", "=", (Object)"1"));
                DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,bookstype", (QFilter[])new QFilter[]{f2});
                ArrayList<Long> list = new ArrayList<Long>();
                for (DynamicObject book : books) {
                    list.add(book.getLong("bookstype"));
                }
                QFilter fid = new QFilter("id", "in", list);
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(fid);
            }
        });
    }

    public void tabSelected(TabSelectEvent event) {
        if (event.getTabKey().equals("appmiantab") || event.getTabKey().equals("tabpageap")) {
            this.refreshView();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BasedataEdit orgBd = (BasedataEdit)this.getControl(ORG_HOME);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        if (!permOrgRs.hasAllOrgPerm() && permOrgRs.getHasPermOrgs().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u603b\u8d26\u9996\u9875\u6743\u9650\uff0c\u8bf7\u5148\u5206\u914d\u6743\u9650\u3002", (String)"NewHomePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            return;
        }
        long orgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5df2\u542f\u7528\u7684\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"NewHomePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            return;
        }
        list.add(new QFilter("id", "in", (Object)AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW)));
        orgBd.setQFilters(list);
        this.getModel().setValue(ORG_HOME, (Object)orgId);
        this.updateFieldByOrg(true);
    }

    private void updateFieldByOrg(boolean isDefaultBook) {
        DynamicObject orgDyo = (DynamicObject)this.getModel().getValue(ORG_HOME);
        if (orgDyo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"NewHomePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        AccountBookInfo accountBook = null;
        Long orgId = orgDyo.getLong("id");
        if (isDefaultBook) {
            accountBook = AccSysUtil.getBookByDataPermission((Long)orgId);
            if (accountBook == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u5df2\u542f\u7528\u7684\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"NewHomePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue("booktype", (Object)accountBook.getBookTypeId());
            Set bookTypeSet = AccSysUtil.getAllBookTypeFromAccSys((long)orgId);
            if (bookTypeSet == null || bookTypeSet.size() <= 1) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"booktype"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"booktype"});
            }
        } else {
            DynamicObject bookTypeDyo = (DynamicObject)this.getModel().getValue("booktype");
            if (bookTypeDyo == null) {
                return;
            }
            accountBook = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeDyo.getLong("id"));
            if (accountBook == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u672a\u542f\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u3002", (String)"NewHomePlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        model.setValue("period", (Object)accountBook.getCurPeriodId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "orgid": {
                this.updateFieldByOrg(true);
                this.refreshView();
                break;
            }
            case "booktype": {
                ChangeData change = e.getChangeSet()[0];
                if (change != null && change.getNewValue() == null) {
                    IDataModel model = this.getModel();
                    model.beginInit();
                    model.setValue("booktype", change.getOldValue());
                    model.endInit();
                }
                this.updateFieldByOrg(false);
                this.refreshView();
                break;
            }
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void clear(String cacheKey) {
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
        if (cache != null) {
            cache.remove(cacheKey);
        }
    }
}

