/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;

public class ReciWriteOffProgressPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private static final String ISFINISH = "isFinish";
    private static final String HASWRITEOFFCOUNT = "haswriteoffcount";
    private static final String ISSUCCESS = "isSuccess";
    private static final String ERRMSG = "errMsg";
    private static final String ALLCOUNT = "allcount";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.writeoff);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        int allCount = (Integer)parameter.getCustomParam("allCount");
        String taskId = (String)parameter.getCustomParam("taskId");
        boolean isFinish = Boolean.parseBoolean(this.cache.get(taskId + ISFINISH));
        int hasWriteOffCount = Integer.parseInt(this.cache.get(taskId + HASWRITEOFFCOUNT));
        if (isFinish) {
            boolean isSuccess = Boolean.parseBoolean(this.cache.get(taskId + ISSUCCESS));
            if (isSuccess) {
                int count = Integer.parseInt(this.cache.get(taskId + HASWRITEOFFCOUNT));
                if (count > 0) {
                    progressEvent.setText(ResManager.loadKDString((String)"\u6838\u9500\u5b8c\u6210", (String)"ReciWriteOffProgresssPlugin_01", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    progressEvent.setProgress(100);
                    this.getView().close();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6761\u4ef6\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u9500\u6570\u636e\u3002", (String)"ReciprocalAutoWriteOffPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    progressEvent.setText(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\u3002", (String)"ReciprocalAutoWriteOffPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                    bar.stop();
                }
            } else {
                String errMsg = this.cache.get(taskId + ERRMSG);
                String errorResult = ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\u3002", (String)"ReciprocalAutoWriteOffPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                    errorResult = errorResult + errMsg;
                    this.cache.remove(taskId + ERRMSG);
                }
                progressEvent.setText(errorResult);
                this.getView().showErrorNotification(errorResult);
                progressEvent.setText(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\u3002", (String)"ReciprocalAutoWriteOffPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                bar.stop();
            }
            this.removeCache(taskId);
        } else {
            int progress = 100 * (hasWriteOffCount / allCount);
            if (progress < 100) {
                progressEvent.setProgress(progress);
                progressEvent.setText(ResManager.loadKDString((String)"\u6838\u9500\u4e2d...", (String)"ReciWriteOffProgresssPlugin_02", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void removeCache(String taskId) {
        this.cache.remove(taskId);
        this.cache.remove(taskId + ISFINISH);
        this.cache.remove(taskId + ISSUCCESS);
        this.cache.remove(taskId + HASWRITEOFFCOUNT);
        this.cache.remove(taskId + ALLCOUNT);
    }

    public void click(EventObject evt) {
        String Key2;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (Key2 = control.getKey()) {
            case "btnok": {
                this.getView().close();
                break;
            }
        }
    }
}

