/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.GLUtil;

public class ReciprocalRecordUnWOF7Plugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String RecordEntry = "entryentity";
    private static final String BizNum = "biznum";
    private static final String BizDate = "bizdate";
    private static final String ExpireDate = "expiredate";
    private static final String Description = "description";
    private static final String BookedDate = "bookeddate";
    private static final String Period = "period";
    private static final String VoucherType = "vouchertype";
    private static final String BillNo = "billno";
    private static final String DebitLocal = "debitlocal";
    private static final String CreditLocal = "creditlocal";
    private static final String Debitori = "debitori";
    private static final String Creditori = "creditori";
    private static final String DebitOrCreditori = "debitOrCreditori";
    private static final String Currency = "currency";
    private static final String Oricurrency = "oricurrency";
    private static final String Id = "id";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void initialize() {
        super.initialize();
        EntryGrid sendList = (EntryGrid)this.getControl(RecordEntry);
        sendList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void click(EventObject evt) {
        String Key2;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (Key2 = control.getKey()) {
            case "btnok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(RecordEntry);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ReciprocalRecordUnWOF7Plugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter parameter = this.getView().getFormShowParameter();
                String type = (String)parameter.getCustomParam("type");
                ArrayList<Long> recordIds = new ArrayList<Long>(selectRows.length);
                HashMap map = new HashMap(selectRows.length);
                IDataModel model = this.getModel();
                ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
                IUserService userService = (IUserService)this.getView().getService(IUserService.class);
                boolean resultCheck = true;
                for (int rowIndex : selectRows) {
                    Long recordId = (Long)model.getValue(Id, rowIndex);
                    recordIds.add(recordId);
                }
                String ruleId = ReciprocalUtils.checkSpecialPerm((!"1".equals(type) ? 1 : 0) != 0);
                if (StringUtils.isNotEmpty((String)ruleId)) {
                    if ("1".equals(type)) {
                        Map ids = (Map)parameter.getCustomParam("recordIds");
                        ArrayList params = new ArrayList(map.size());
                        for (Map.Entry entry : ids.entrySet()) {
                            Long id = Long.parseLong((String)entry.getKey());
                            Long writer = Long.parseLong((String)entry.getValue());
                            ReciprocalUtils.getUpdateWriterByLog((Long)id, (Long)writer, params);
                        }
                        ReciprocalUtils.updateWriteoffPersonByLog(params);
                    }
                    QFilter qFilter = ReciprocalUtils.getSpecialPermFilter((String)ruleId, (ITimeService)timeService, (IUserService)userService);
                    for (Long recordId : recordIds) {
                        QFilter qFilter1 = new QFilter(Id, "=", (Object)recordId);
                        DynamicObject[] result = BusinessDataServiceHelper.load((String)"gl_acccurrent", (String)Id, (QFilter[])new QFilter[]{qFilter, qFilter1});
                        if (result.length == 0) {
                            resultCheck = false;
                        }
                        if ("1".equals(type)) {
                            if (resultCheck) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u7279\u6b8a\u6570\u636e\u6743\u9650\u9879\uff1a\u53cd\u6838\u9500\u4eba\u548c\u6838\u9500\u4eba\u4e0d\u4e3a\u540c\u4e00\u4eba\u3002", (String)"ReciprocalRecordUnWOF7Plugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), new Object[0]));
                            return;
                        }
                        if (resultCheck) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u7279\u6b8a\u6570\u636e\u6743\u9650\u9879\uff1a\u5236\u5355\u4eba\u548c\u6838\u9500\u4eba\u4e0d\u4e3a\u540c\u4e00\u4eba\u3002", (String)"ReciprocalRecordUnWOF7Plugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), new Object[0]));
                        return;
                    }
                }
                if ("1".equals(type)) {
                    Map records = ReciprocalUtils.queryRecords(Collections.singleton(new QFilter(Id, "in", recordIds)));
                    for (ReciprocalRecord record : records.values()) {
                        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)record.getOrg(), (long)record.getBookType());
                        if (bookInfo == null || record.getAccountTable().equals(bookInfo.getAccountTableId())) continue;
                        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getAccount(), (String)"bd_accountview");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u79d1\u76ee%s\u5b58\u5728\u7248\u672c\u5316\uff0c\u4e0d\u5141\u8bb8\u53cd\u6838\u9500\u3002", (String)"ReciprocalRecordUnWOF7Plugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), acct != null ? acct.getString("number") : ""));
                        return;
                    }
                }
                this.getView().returnDataToParent(recordIds);
                this.getView().close();
                break;
            }
        }
    }

    private void initData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List ids = null;
        String type = (String)parameter.getCustomParam("reciprocalType");
        if ("writeOff".equals(type)) {
            JSONObject writeOffAmt = (JSONObject)parameter.getCustomParam("writeOffAmt");
            this.getModel().setValue("checkedwriteoffamount", writeOffAmt.get((Object)"left"));
            this.getModel().setValue("localwriteofffamount", writeOffAmt.get((Object)"right"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"writer"});
            ids = (List)parameter.getCustomParam("recordIds");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            Map map = (Map)parameter.getCustomParam("recordIds");
            ids = new ArrayList<Long>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ids.add(Long.parseLong((String)entry.getKey()));
            }
        }
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String orderFields = (String)parameter.getCustomParam("orderFields");
        int[] idxs = this.getModel().batchCreateNewEntryRow(RecordEntry, ids.size());
        DataSet dsRecord = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_acccurrent", (String)"id,biznum,bizdate,expiredate,description,voucherentry,voucherid,localcurrency currency,currency oricurrency,amount,amountbal,amountfor,amountbalfor,account.dc dc,org,booktype,creator", (QFilter[])new QFilter[]{new QFilter(Id, "in", ids)}, (String)orderFields);
        int rowIndex = this.loadVoucherData(dsRecord, idxs, "writeOff".equals(type) ? null : (Map)parameter.getCustomParam("recordIds"));
        this.loadInitRcpData(dsRecord, idxs, rowIndex);
        this.setDiffAmt(BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private int loadVoucherData(DataSet ds, int[] idxs, Map<String, String> map) {
        DataSet dsRecord = ds.copy();
        List recordFields = GLUtil.getDataSetCols((DataSet)dsRecord);
        recordFields.add(BookedDate);
        recordFields.add(Period);
        recordFields.add(VoucherType);
        recordFields.add(BillNo);
        recordFields.add(DebitLocal);
        recordFields.add(CreditLocal);
        recordFields.add(Debitori);
        recordFields.add(Creditori);
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(100);
        ArrayList<Long> vchIds = new ArrayList<Long>(100);
        long orgId = 0L;
        long booktypeId = 0L;
        try (DataSet dsEntry = dsRecord.copy();){
            while (dsEntry.hasNext()) {
                Row row = dsEntry.next();
                Long entryId = row.getLong("voucherentry");
                if (!entryId.equals(0L)) {
                    vchEntryIds.add(entryId);
                    vchIds.add(row.getLong("voucherid"));
                }
                if (orgId == 0L) {
                    orgId = row.getLong("org");
                }
                if (booktypeId != 0L) continue;
                booktypeId = row.getLong("booktype");
            }
        }
        DataSet dsVch = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id, entries.id entryid,bookeddate,period.name period,vouchertype.name vouchertype,billno,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.debitori debitori,entries.creditori creditori", (QFilter[])new QFilter[]{new QFilter("entries.id", "in", vchEntryIds), new QFilter(Id, "in", vchIds)}, null);
        int rowCount = 0;
        try (DataSet dsRst = dsRecord.join(dsVch, JoinType.INNER).on("voucherid", Id).on("voucherentry", "entryid").select(recordFields.toArray(new String[0])).finish();){
            IDataModel model = this.getModel();
            model.beginInit();
            while (dsRst.hasNext()) {
                Row row = dsRst.next();
                if (rowCount >= idxs.length) {
                    int n = rowCount;
                    return n;
                }
                int rowIndex = idxs[rowCount];
                model.setValue(BizNum, row.get(BizNum), rowIndex);
                model.setValue(BizDate, row.get(BizDate), rowIndex);
                model.setValue(ExpireDate, row.get(ExpireDate), rowIndex);
                model.setValue(Description, row.get(Description), rowIndex);
                model.setValue(BookedDate, row.get(BookedDate), rowIndex);
                model.setValue(Period, row.get(Period), rowIndex);
                model.setValue(VoucherType, row.get(VoucherType), rowIndex);
                model.setValue(BillNo, row.get(BillNo), rowIndex);
                model.setValue(DebitLocal, row.get(DebitLocal), rowIndex);
                model.setValue(CreditLocal, row.get(CreditLocal), rowIndex);
                model.setValue(Oricurrency, row.get(Oricurrency), rowIndex);
                model.setValue(Currency, row.get(Currency), rowIndex);
                BigDecimal debitori = row.getBigDecimal(Debitori);
                BigDecimal creditori = row.getBigDecimal(Creditori);
                model.setValue(DebitOrCreditori, (Object)(BigDecimal.ZERO.compareTo(debitori) == 0 ? creditori : debitori), rowIndex);
                model.setValue("unwriteoffamount", row.get("amountbalfor"), rowIndex);
                model.setValue("unwriteofflocalamount", row.get("amountbal"), rowIndex);
                model.setValue(Id, row.get(Id), rowIndex);
                model.setValue("creator", row.get("creator"), rowIndex);
                if (map != null) {
                    model.setValue("writer", (Object)map.get(row.getLong(Id).toString()), rowIndex);
                }
                model.setValue("currencyfield", row.get(Oricurrency));
                model.setValue("localcurrencyfield", row.get(Currency));
                ++rowCount;
            }
            model.endInit();
        }
        return rowCount;
    }

    private void loadInitRcpData(DataSet dsRecord, int[] idxs, int rowIndex) {
        try (DataSet dsRst = dsRecord.filter("voucherentry=0");){
            IDataModel model = this.getModel();
            model.beginInit();
            while (dsRst.hasNext()) {
                Row row = dsRst.next();
                model.setValue(BizNum, row.get(BizNum), rowIndex);
                model.setValue(BizDate, row.get(BizDate), rowIndex);
                model.setValue(ExpireDate, row.get(ExpireDate), rowIndex);
                model.setValue(Description, row.get(Description), rowIndex);
                BigDecimal amount = row.getBigDecimal("amount");
                BigDecimal amountfor = row.getBigDecimal("amountfor");
                model.setValue(DebitOrCreditori, (Object)amountfor, rowIndex);
                int accountDC = row.getInteger("dc");
                BigDecimal oriAmt = amount.multiply(new BigDecimal(accountDC));
                if (oriAmt.compareTo(BigDecimal.ZERO) > 0) {
                    model.setValue(DebitLocal, (Object)amount.abs(), rowIndex);
                } else {
                    model.setValue(CreditLocal, (Object)amount.abs(), rowIndex);
                }
                model.setValue("unwriteoffamount", row.get("amountbalfor"), rowIndex);
                model.setValue("unwriteofflocalamount", row.get("amountbal"), rowIndex);
                model.setValue(Currency, row.get(Currency), rowIndex);
                model.setValue(Oricurrency, row.get(Oricurrency), rowIndex);
                model.setValue(Id, row.get(Id), rowIndex);
                model.setValue("currencyfield", row.get(Oricurrency));
                model.setValue("localcurrencyfield", row.get(Currency));
                ++rowIndex;
            }
            model.endInit();
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            BigDecimal oritotal = BigDecimal.ZERO;
            BigDecimal localtotal = BigDecimal.ZERO;
            List selectedRows = evt.getNewRows();
            if (!selectedRows.isEmpty()) {
                Iterator iterator = selectedRows.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    BigDecimal oriAmount = (BigDecimal)this.getView().getModel().getValue("unwriteoffamount", i);
                    BigDecimal localAmount = (BigDecimal)this.getView().getModel().getValue("unwriteofflocalamount", i);
                    oritotal = oritotal.add(oriAmount);
                    localtotal = localtotal.add(localAmount);
                }
            }
            Label oriLabel = (Label)this.getControl("checkedunwriteoffamount");
            Label localLabel = (Label)this.getControl("localunwriteofffamount");
            int amtForPrecision = ((DynamicObject)this.getModel().getValue("currencyfield")).getInt("amtprecision");
            oriLabel.setText(oritotal.compareTo(BigDecimal.ZERO) == 0 ? "0" : oritotal.setScale(amtForPrecision, RoundingMode.HALF_UP).toString());
            int amtLocalPrecision = ((DynamicObject)this.getModel().getValue("localcurrencyfield")).getInt("amtprecision");
            localLabel.setText(localtotal.compareTo(BigDecimal.ZERO) == 0 ? "0" : localtotal.setScale(amtLocalPrecision, RoundingMode.HALF_UP).toString());
            this.setDiffAmt(oritotal, localtotal);
        }
    }

    private void setDiffAmt(BigDecimal oritotal, BigDecimal localAmount) {
        Label diffamtfor = (Label)this.getControl("diffamtfor");
        Label diffamtlocal = (Label)this.getControl("diffamtlocal");
        int amtForPrecision = ((DynamicObject)this.getModel().getValue("currencyfield")).getInt("amtprecision");
        BigDecimal checkedwriteoffamount = ((BigDecimal)this.getModel().getValue("checkedwriteoffamount")).add(oritotal).setScale(amtForPrecision, RoundingMode.HALF_UP);
        diffamtfor.setText(checkedwriteoffamount.compareTo(BigDecimal.ZERO) == 0 ? "0" : checkedwriteoffamount.toString());
        int amtLocalPrecision = ((DynamicObject)this.getModel().getValue("localcurrencyfield")).getInt("amtprecision");
        BigDecimal localwriteofffamount = ((BigDecimal)this.getModel().getValue("localwriteofffamount")).add(localAmount).setScale(amtLocalPrecision, RoundingMode.HALF_UP);
        diffamtlocal.setText(localwriteofffamount.compareTo(BigDecimal.ZERO) == 0 ? "0" : localwriteofffamount.toString());
    }
}

