/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.util.GLUtil;

public class ReciprocalSchemeEditPlugin
extends AbstractFormPlugin {
    private static final String GL_VOUCHER_FILTER = "gl_voucher_filter";
    private static final String ORG = "org";
    protected static final String ID = "id";
    protected static final String USEORG = "useorg";
    protected static final String VOUCHERFILTER = "voucherfilter";
    protected static final String VOUCHERFILTERJSON = "voucherfilterjson";
    protected static final String ACCOUNTTABLE = "accounttable";
    protected static final String SRCACCTABLE = "srcacctable";
    protected static final String RECIPROCALSCHEMEFIELD = "reciprocalschemefield";
    protected static final String _ID = "_id";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{VOUCHERFILTER});
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (VOUCHERFILTER.equals(ctlSource.getKey())) {
            this.showVoucherFilterForm();
        }
    }

    private void showVoucherFilterForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(GL_VOUCHER_FILTER);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String voucherfilter = (String)this.getModel().getValue(VOUCHERFILTERJSON);
        Long srcacctableid = (Long)this.getModel().getValue("accounttable_id");
        showParameter.setCustomParam(VOUCHERFILTERJSON, (Object)voucherfilter);
        showParameter.setCustomParam(SRCACCTABLE, (Object)srcacctableid);
        Long orgId = (Long)this.getModel().getValue("useorg_id");
        showParameter.setCustomParam(ORG, (Object)orgId);
        showParameter.setCustomParam(RECIPROCALSCHEMEFIELD, (Object)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VOUCHERFILTER);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "voucherfilter": {
                if (!StringUtils.isEmpty((CharSequence)(e.getChangeSet()[0].getNewValue() + ""))) break;
                this.getModel().setValue(VOUCHERFILTERJSON, (Object)"{\"filterRow\":[]}");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && VOUCHERFILTER.equals(actionId = closedCallBackEvent.getActionId())) {
            Map dataMap = (Map)closedCallBackEvent.getReturnData();
            String desc = (String)dataMap.get(VOUCHERFILTER);
            desc = desc.replaceAll("        ", "  ");
            this.getModel().setValue(VOUCHERFILTERJSON, dataMap.get(VOUCHERFILTERJSON));
            this.getModel().setValue(VOUCHERFILTER, (Object)desc);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        if (map != null && !map.isEmpty()) {
            Long accountTableId = map.get(ACCOUNTTABLE) == null ? Long.valueOf(0L) : Long.valueOf(map.get(ACCOUNTTABLE).toString());
            Long orgId = map.get(ORG) == null ? Long.valueOf(0L) : Long.valueOf(map.get(ORG).toString());
            Long booksTypeId = map.get("accounttype") == null ? Long.valueOf(0L) : Long.valueOf(map.get("accounttype").toString());
            this.getModel().setValue(ACCOUNTTABLE, (Object)accountTableId);
            this.getModel().setValue("accounttable_id", (Object)accountTableId);
            this.getModel().setValue("useorg_id", (Object)orgId);
            this.getModel().setValue(USEORG, (Object)orgId);
            this.getPageCache().put(ACCOUNTTABLE, accountTableId + "");
            DynamicObject glBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)orgId), new QFilter("bookstype", "=", (Object)booksTypeId)});
            if (glBook != null) {
                this.getModel().setValue("currency", (Object)new String[]{glBook.getString("basecurrency")});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label tips = (Label)this.getControl("labelap2");
        tips.setText(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a\u6309\u4e1a\u52a1\u65e5\u671f\u5148\u8fdb\u5148\u51fa\u6a21\u5f0f\u4e0b\uff0c\u4ec5\u652f\u6301\u6309\u4e1a\u52a1\u65e5\u671f\u7684\u987a\u5e8f\u8fdb\u884c\u5148\u8fdb\u5148\u51fa\u6838\u9500\uff0c\u4e0d\u652f\u6301\u8bbe\u7f6e\u5176\u4ed6\u6838\u9500\u6761\u4ef6\u3002\u5982\u679c\u9700\u8981\u8bbe\u7f6e\u4e2a\u6027\u5316\u6838\u9500\u6761\u4ef6\uff0c\u8bf7\u9009\u62e9\u201d\u6309\u6838\u9500\u987a\u5e8f\u6838\u9500\u201d\u7684\u6a21\u5f0f\u3002", (String)"ReciprocalSchemeEditPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue(USEORG);
            QFilter filter = AccountUtils.getAccountDataFilter((long)org.getLong(ID), (long)((DynamicObject)this.getModel().getValue(ACCOUNTTABLE)).getLong(ID));
            QFilter accounttableFilter = new QFilter(ACCOUNTTABLE, "=", (Object)((DynamicObject)this.getModel().getValue(ACCOUNTTABLE)).getLong(ID));
            QFilter isLeafQfFilter = new QFilter("isleaf", "=", (Object)"1");
            QFilter isAccheckFilter = new QFilter("accheck", "=", (Object)"1");
            QFilter qdate = new QFilter("enddate", ">=", (Object)GLUtil.getEndDate());
            qFilters.add(qdate);
            qFilters.add(filter);
            qFilters.add(accounttableFilter);
            qFilters.add(isLeafQfFilter);
            qFilters.add(isAccheckFilter);
            sp.setCustomParam("acct_filter", (Object)true);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOp = (FormOperate)args.getSource();
            IDataModel model = this.getModel();
            String operateKey = formOp.getOperateKey();
            if ("save".equals(operateKey)) {
                String number = (String)model.getValue("number");
                String voucherfilterjson = (String)model.getValue(VOUCHERFILTERJSON);
                if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ReciprocalSchemeEditPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)voucherfilterjson) && voucherfilterjson.length() > 2000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\uff1a\u201c\u51ed\u8bc1\u8fc7\u6ee4\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", (String)"ReciprocalSchemeEditPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            }
        }
    }
}

