/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Submit;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.form.BindingContext;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.enums.CashFlowItemType;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.enums.ApplyType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.formplugin.TemplateVoucherEditPropertyChangeManager;
import kd.fi.gl.formplugin.TemplateVoucherEditValueGetter;
import kd.fi.gl.formplugin.comassist.AbstractComAssistBillPlugin;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCalculator;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowPanelManager;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLFabulousOperation;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.VoucherUtil;

public class TemplateVoucherEdit
extends AbstractComAssistBillPlugin
implements ClickListener,
RowClickEventListener,
EntryGridBindDataListener {
    private VoucherEditView voucherEditView;
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String GROUP = "group_id";
    private static final String HEARTPHOTO = "heartphoto";
    private static final String HEARTCOUNT = "heartcount";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String CREATOR = "creator";
    public static final String CREATIME = "createtime";
    private static final String E_K = "voucherentity";
    private static final String KEY_DEAL_ATTACH_FLEX = "dealattachflex";
    private static final String STR_TRUE = "true";
    private static final String KEY_BOOK = "book";
    private static final String KEY_ACCOUNT = "account";
    private static final String KEY_DR_LOC_COMB = "debitlocalcomb";
    private static final String KEY_CR_LOC_COMB = "creditlocalcomb";
    private static final String KEY_AMOUNTFOR = "amountfor";
    private static final String KEY_ASSGRP = "assgrp";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_UNIT = "measureunit";
    private static final String KEY_QUANTITY = "quantity";
    private static final String KEY_PRICE = "price";
    private static final String KEY_DRLOC = "debitlocal";
    private static final String KEY_CRLOC = "creditlocal";
    private static final String APPLYTYPE = "applytype";
    private TemplateVoucherEditValueGetter valueGetter;

    private TemplateVoucherEditValueGetter getValueGetter() {
        if (null == this.valueGetter) {
            this.valueGetter = new TemplateVoucherEditValueGetter(this.getModel());
        }
        return this.valueGetter;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{GROUP, HEARTPHOTO, APPLYTYPE});
        ((EntryGrid)this.getControl(E_K)).addDataBindListener((EntryGridBindDataListener)this);
        try {
            this.groupAddBeforeF7SelectListener();
            this.accountAddBeforeF7SelectListener();
        }
        catch (KDBizException exception) {
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("closeCurrentPage", (IFormPlugin)this);
            this.getView().showConfirm(exception.getMessage(), MessageBoxOptions.OK, confirmCallBacks1);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(GLField.id_((String)this.getOrgKey()));
        long bookTypeId = (Long)model.getValue(GLField.id_((String)this.getBookTypeKey()));
        ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> Optional.ofNullable(this.getView().getControl(commonAssist.key)).map(BasedataEdit.class::cast).ifPresent(commonAssistEdit -> commonAssistEdit.setMustInput(false))));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(E_K);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl(KEY_CURRENCY);
        currency.addBeforeF7SelectListener(evt -> {
            DynamicObject account = (DynamicObject)this.getModel().getValue(KEY_ACCOUNT, evt.getRow());
            if (account != null) {
                if ("nocurrency".equals(account.get("acctcurrency"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672c\u79d1\u76ee\u4e0d\u53c2\u4e0e\u5e01\u79cd\u6838\u7b97\u3002", (String)"TemplateVoucherEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                if ("descurrency".equals(account.get("acctcurrency"))) {
                    ArrayList<Long> lstCurId = new ArrayList<Long>();
                    DynamicObjectCollection curEntry = (DynamicObjectCollection)account.get("currencyentry");
                    for (DynamicObject cur : curEntry) {
                        Long curId = cur.getLong("currency_id");
                        lstCurId.add(curId);
                    }
                    DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
                    long curLocId = curLoc.getLong("id");
                    lstCurId.add(curLocId);
                    QFilter filter = new QFilter("id", "in", lstCurId);
                    ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(filter);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\uff01", (String)"TemplateVoucherEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        });
        BasedataEdit unit = (BasedataEdit)this.getView().getControl(KEY_UNIT);
        unit.addBeforeF7SelectListener(evt -> {
            Long groupId;
            DynamicObject accout = (DynamicObject)this.getModel().getValue(KEY_ACCOUNT, evt.getRow());
            if (accout != null && (groupId = Long.valueOf(accout.getLong("measureunitgroup_id"))) != 0L) {
                QFilter filter = new QFilter("group.id", "=", (Object)groupId);
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        });
        BasedataEdit maincf = (BasedataEdit)this.getView().getControl("maincf");
        maincf.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            QFilterBuilder latestVersionFilter = CashFlowItemHelper.buildLatestVersionFilter((CashFlowItemType)CashFlowItemType.MAIN);
            filters.addAll(latestVersionFilter.getFilters());
        });
        BasedataEdit suppcf = (BasedataEdit)this.getView().getControl("suppcf");
        suppcf.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            QFilter filter = new QFilter("isleaf", "=", (Object)"1").and(new QFilter("isprefit", "=", (Object)false));
            filters.add(filter);
        });
    }

    private void initApplytype() {
        String applytype = (String)this.getModel().getValue(APPLYTYPE);
        if (ApplyType.MANUAL.getType().equals(applytype)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_DR_LOC_COMB});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CR_LOC_COMB});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_DRLOC});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_CRLOC});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_DR_LOC_COMB});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_CR_LOC_COMB});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_DRLOC});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CRLOC});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CURRENCY});
        }
    }

    private void initBooksType() {
        String bookstype = this.getPageCacheBookstype();
        if (null == bookstype || bookstype.trim().length() == 0) {
            DynamicObject accounttype = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue())});
            this.getModel().setValue("bookstype", (Object)accounttype.getLong("id"));
        } else {
            this.getModel().setValue("bookstype", (Object)Long.valueOf(bookstype));
        }
    }

    private String getPageCacheBookstype() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return null;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        return pageCache.get("bookstype");
    }

    public void afterCreateNewData(EventObject e) {
        try {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CURRENCY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PRICE, "localrate", KEY_QUANTITY, KEY_UNIT, KEY_AMOUNTFOR, KEY_ASSGRP});
            this.getPageCache().remove("cashAcctCount");
            this.getPageCache().remove("plAcctCount");
            Object applyType = this.getView().getFormShowParameter().getCustomParam(APPLYTYPE);
            String applyTypeValue = ApplyType.MANUAL.getType().equals(applyType) ? ApplyType.MANUAL.getType() : ApplyType.ELECTRONIC.getType();
            this.getModel().setValue(APPLYTYPE, (Object)applyTypeValue);
            this.initApplytype();
            this.initBooksType();
            this.initOrgAndBooks();
            DynamicObject creator = (DynamicObject)this.getModel().getValue(CREATOR);
            this.getPageCache().put(CREATOR, creator.getPkValue().toString());
            this.initUserInfo();
        }
        catch (KDBizException exception) {
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("closeCurrentPage", (IFormPlugin)this);
            this.getView().showConfirm(exception.getMessage(), MessageBoxOptions.OK, confirmCallBacks1);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        try {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CURRENCY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PRICE, "localrate", KEY_QUANTITY, KEY_UNIT, KEY_AMOUNTFOR, KEY_ASSGRP});
            this.getPageCache().remove("cashAcctCount");
            this.getPageCache().remove("plAcctCount");
            this.initApplytype();
            this.initBook();
            DynamicObject creator = (DynamicObject)this.getModel().getValue(CREATOR);
            this.getPageCache().put(CREATOR, creator.getPkValue().toString());
            this.initUserInfo();
            this.initAmountFor();
            this.setVisiblePQMA("isqty");
        }
        catch (KDBizException exception) {
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("closeCurrentPage", (IFormPlugin)this);
            this.getView().showConfirm(exception.getMessage(), MessageBoxOptions.OK, confirmCallBacks1);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CURRENCY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PRICE, KEY_QUANTITY, KEY_UNIT, KEY_AMOUNTFOR, KEY_ASSGRP});
        DynamicObject creator = (DynamicObject)this.getModel().getValue(CREATOR);
        this.getPageCache().put(CREATOR, creator.getPkValue().toString());
        this.initUserInfo();
        this.initHeartCount();
        this.initApplytype();
        this.initBook();
        this.initAmountFor();
        this.setVisiblePQMA("isqty");
        this.setVisiblePQMA("isassist");
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setAccountingType(e.getRows());
        EntryGrid entryGrid = (EntryGrid)this.getControl(E_K);
        List rows = e.getRows().stream().map(x -> {
            BindingContext bindCtx = new BindingContext(x.getDataEntity().getDataEntityType(), x.getDataEntity(), x.getRowIndex());
            return entryGrid.getRowBindValue(bindCtx);
        }).collect(Collectors.toList());
        e.getData().put("rows", rows);
        this.getModel().updateEntryCache(this.getModel().getEntryEntity(E_K));
    }

    private void setAccountingType(List<RowDataEntity> rowDataEntities) {
        if (!this.getVoucherEditView().getValueGetter().isBudget()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountingtype"});
            return;
        }
        for (RowDataEntity rowDataEntity : rowDataEntities) {
            DynamicObject rowDyn = rowDataEntity.getDataEntity();
            rowDyn.set("accountingtype", (Object)AccountUtils.parseAccountingType((DynamicObject)rowDyn.getDynamicObject(KEY_ACCOUNT)));
        }
    }

    private void groupAddBeforeF7SelectListener() {
        BasedataEdit acctorgF7 = (BasedataEdit)this.getView().getControl("group");
        acctorgF7.addBeforeF7SelectListener(e -> {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (null == orgObj) {
                return;
            }
            qFilters.add(new QFilter("org", "=", orgObj.getPkValue()));
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        });
    }

    private void accountAddBeforeF7SelectListener() {
        BasedataEdit acctorgF7 = (BasedataEdit)this.getView().getControl(KEY_ACCOUNT);
        acctorgF7.addBeforeF7SelectListener(e -> {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
            DynamicObject book = (DynamicObject)this.getModel().getValue(KEY_BOOK);
            if (null == book) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u8d26\u7c3f\u3002", (String)"TemplateVoucherEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("accounttable", "=", book.get("accounttable.id")));
            qFilters.add(new QFilter("ismanual", "=", (Object)true));
            if (null == orgObj) {
                return;
            }
            if (!this.getVoucherEditView().getValueGetter().isBudget()) {
                qFilters.add(AccountType.buildNonBudgetFilter());
            }
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key == null || key.trim().length() == 0) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(E_K);
        if (index == -1) {
            return;
        }
        IDataModel model = this.getModel();
        IPageCache cache = this.getPageCache();
        ChangeData[] data = e.getChangeSet();
        switch (key) {
            case "group": {
                this.initOrg();
                this.initBook();
                break;
            }
            case "account": {
                this.getService(VoucherEditCashFlowCalculator.class).handleAccountChanged((DynamicObject)data[0].getOldValue(), (DynamicObject)data[0].getNewValue(), data[0].getRowIndex());
                this.getService(VoucherEditCashFlowPanelManager.class).updatePanelIfCurrentRow(index);
                this.initCurrency(data);
                this.changedAcct(data);
                this.setVisiblePQMA("isqty");
                this.setVisiblePQMA("isassist");
                this.accountChangSetDefaultLocalcomb(data);
                model.setValue("accountingtype", (Object)AccountUtils.parseAccountingType((DynamicObject)((DynamicObject)data[0].getNewValue())), data[0].getRowIndex());
                break;
            }
            case "applytype": {
                this.initApplytype();
                break;
            }
            case "entrydc": {
                this.changedAmountfor(new ChangeData[]{new ChangeData(data[0].getRowIndex(), data[0].getDataEntity(), (Object)BigDecimal.ZERO, model.getValue(KEY_AMOUNTFOR, data[0].getRowIndex()))});
                this.changeEntryDCSetDefaultLocalcomb(data);
                break;
            }
            case "currency": {
                this.changedCurrency(data);
                break;
            }
            case "maincf": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                this.updateMainCFRef(data, index);
                model.setValue("maincfitem", data[0].getNewValue(), index);
                this.saveCashFlow("maincfitem", data[0].getNewValue());
                TemplateVoucherEditPropertyChangeManager.propertyChanged(e, this.getView(), this.getModel(), this.getPageCache(), E_K);
                break;
            }
            case "maincfamt": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                model.setValue("maincfamount", data[0].getNewValue(), index);
                if (model.getValue("suppcf") != null) {
                    this.updateSuppFromMain((BigDecimal)data[0].getNewValue(), index);
                }
                this.getView().updateView("suppcfamt");
                break;
            }
            case "maincfamount": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                this.changeCFUnused(data, "cashunused", index);
                break;
            }
            case "suppcf": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                if (cache.get("adjustment") != null) break;
                this.updateSuppCFRef(data, index);
                model.setValue("suppcfitem", data[0].getNewValue(), index);
                break;
            }
            case "suppcfamt": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                if (cache.get("adjustment") != null) break;
                model.setValue("suppcfamount", data[0].getNewValue(), index);
                break;
            }
            case "suppcfamount": {
                if (cache.get("showCashFlow") != null) {
                    return;
                }
                this.changeCFUnused(data, "plunused", index);
                break;
            }
            case "quantity": {
                BigDecimal price = (BigDecimal)model.getValue(KEY_PRICE, index);
                if (price == null || price.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal qty = (BigDecimal)model.getValue(KEY_QUANTITY, index);
                model.setValue(KEY_AMOUNTFOR, (Object)qty.multiply(price));
                break;
            }
            case "price": {
                BigDecimal qty = (BigDecimal)model.getValue(KEY_QUANTITY, index);
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal price1 = (BigDecimal)model.getValue(KEY_PRICE, index);
                model.setValue(KEY_AMOUNTFOR, (Object)qty.multiply(price1));
                break;
            }
            case "debitlocal": {
                this.collectTotalAmt(data, BigDecimal.ONE);
                this.changedDr(data);
                BigDecimal drValue = (BigDecimal)data[0].getNewValue();
                if (drValue.signum() != 0) {
                    this.presetCashFlowItem(index, KEY_DRLOC);
                }
                this.getService(VoucherEditCashFlowCalculator.class).calculateAndSetCashFlowAmount(index);
                this.getService(VoucherEditCashFlowCalculator.class).calculateAndSetSuppAmount(index);
                break;
            }
            case "creditlocal": {
                this.collectTotalAmt(data, BigDecimal.ONE.negate());
                this.changedCr(data);
                BigDecimal crValue = (BigDecimal)data[0].getNewValue();
                if (crValue.signum() != 0) {
                    this.presetCashFlowItem(index, KEY_CRLOC);
                }
                this.getService(VoucherEditCashFlowCalculator.class).calculateAndSetCashFlowAmount(index);
                this.getService(VoucherEditCashFlowCalculator.class).calculateAndSetSuppAmount(index);
                break;
            }
            case "amountfor": {
                this.changedAmountfor(data);
                break;
            }
            case "localrate": {
                this.changedRate(data);
                break;
            }
            case "mcfassgrp": {
                if (this.isIgnore()) {
                    return;
                }
                this.saveCashFlow("maincfassgrp", data[0].getNewValue());
                break;
            }
            default: {
                if (!key.startsWith("$$")) break;
                VoucherUtil.setAssgrpByRelation(this, e.getProperty().getAlias(), e.getChangeSet()[0].getNewValue(), key, this.getModel());
            }
        }
    }

    private boolean isIgnore() {
        return this.getPageCache().get("firstLoad") != null || this.getPageCache().get("showCashFlow") != null;
    }

    private void saveCashFlow(String id, Object from) {
        int index = this.getModel().getEntryCurrentRowIndex(E_K);
        this.getModel().setValue(id, from, index);
    }

    private void accountChangSetDefaultLocalcomb(ChangeData[] data) {
        DynamicObject account = (DynamicObject)data[0].getNewValue();
        int rowInt = data[0].getRowIndex();
        String entrydc = (String)this.getModel().getValue("entrydc", rowInt);
        if (account != null) {
            this.setDefaultLocalcomb(entrydc, rowInt);
            this.setDefaultPQM(account, rowInt);
            this.presetAcoountChanged(account, rowInt);
        }
    }

    private void changeEntryDCSetDefaultLocalcomb(ChangeData[] data) {
        String entrydc = (String)data[0].getNewValue();
        int rowInt = data[0].getRowIndex();
        this.setDefaultLocalcomb(entrydc, rowInt);
    }

    private void setDefaultLocalcomb(String entrydc, int rowInt) {
        String applytype = (String)this.getModel().getValue(APPLYTYPE);
        if (entrydc != null) {
            if (ApplyType.ELECTRONIC.getType().equals(applytype)) {
                if ("1".equals(entrydc)) {
                    String debitlocalcomb = (String)this.getModel().getValue(KEY_DR_LOC_COMB, rowInt);
                    this.getModel().setValue(KEY_CR_LOC_COMB, null, rowInt);
                    if (null == debitlocalcomb) {
                        this.getModel().setValue(KEY_DR_LOC_COMB, (Object)"0", rowInt);
                    }
                } else {
                    String creditlocalcomb = (String)this.getModel().getValue(KEY_CR_LOC_COMB, rowInt);
                    this.getModel().setValue(KEY_DR_LOC_COMB, null, rowInt);
                    if (null == creditlocalcomb) {
                        this.getModel().setValue(KEY_CR_LOC_COMB, (Object)"0", rowInt);
                    }
                }
            } else if ("1".equals(entrydc)) {
                String debitlocal = this.getModel().getValue(KEY_CRLOC, rowInt) + "";
                this.getModel().setValue(KEY_CRLOC, null, rowInt);
                this.getModel().setValue(KEY_DRLOC, (Object)debitlocal, rowInt);
            } else {
                String creditlocal = this.getModel().getValue(KEY_DRLOC, rowInt) + "";
                this.getModel().setValue(KEY_DRLOC, null, rowInt);
                this.getModel().setValue(KEY_CRLOC, (Object)creditlocal, rowInt);
            }
        }
    }

    private void changedAcct(ChangeData[] data) {
        DynamicObject account = (DynamicObject)data[0].getNewValue();
        int rowInt = data[0].getRowIndex();
        if (data[0].getOldValue() != null) {
            IDataModel m = this.getModel();
            m.setValue(KEY_UNIT, null, rowInt);
            m.setValue(KEY_QUANTITY, (Object)0, rowInt);
            m.setValue(KEY_PRICE, (Object)0, rowInt);
        }
        if (account != null && !"nocurrency".equals(account.getString("acctcurrency"))) {
            this.getView().setEnable(Boolean.valueOf(true), rowInt, new String[]{KEY_CURRENCY});
            if (this.isEqLocalCur(rowInt)) {
                this.getView().setEnable(Boolean.valueOf(false), rowInt, new String[]{"localrate"});
            }
            this.visibleAndWidth(true, this.ratioOriRateCurr(1), "oriamount", "localrate", KEY_CURRENCY);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowInt, new String[]{KEY_CURRENCY, "localrate"});
        }
    }

    private void initAmountFor() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(E_K);
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entity.get(i);
            if (dyn.getBigDecimal("debitori").compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue(KEY_AMOUNTFOR, (Object)dyn.getBigDecimal("creditori"), i);
            } else {
                this.getModel().setValue(KEY_AMOUNTFOR, (Object)dyn.getBigDecimal("debitori"), i);
            }
            DynamicObject account = dyn.getDynamicObject(KEY_ACCOUNT);
            DynamicObject assgrp = dyn.getDynamicObject(KEY_ASSGRP);
            if (assgrp != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_ASSGRP});
            }
            if (account != null && !"nocurrency".equals(account.getString("acctcurrency"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_CURRENCY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"localrate"});
                if (this.isAllCurrOriEqeLoc()) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_AMOUNTFOR});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_AMOUNTFOR});
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{KEY_CURRENCY});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{KEY_CURRENCY, "localrate"});
            if (!this.isAllNoCurrency()) continue;
            this.visibleAndWidth(false, this.ratioOriRateCurr(2), KEY_AMOUNTFOR, "localrate", KEY_CURRENCY);
        }
    }

    private void visibleAndWidth(boolean value, Map<String, LocaleString> mapFields, String ... keys) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(E_K);
        for (Map.Entry<String, LocaleString> entry : mapFields.entrySet()) {
            entryGrid.setColumnProperty(entry.getKey(), "w", (Object)entry.getValue());
        }
        this.getView().setVisible(Boolean.valueOf(value), keys);
    }

    private boolean isCur_LEquCur(int rowInt) {
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
        DynamicObject curreny = (DynamicObject)this.getModel().getValue(KEY_CURRENCY, rowInt);
        if (curreny == null) {
            return true;
        }
        return curLoc != null && curreny != null && curLoc.getLong("id") == curreny.getLong("id");
    }

    private boolean isAllNoCurrency() {
        DynamicObjectCollection entyDyns = this.getModel().getEntryEntity(E_K);
        for (int i = 0; i < entyDyns.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entyDyns.get(i);
            DynamicObject account = dyn.getDynamicObject(KEY_ACCOUNT);
            if (account == null || "nocurrency".equals(account.getString("acctcurrency"))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllCurrOriEqeLoc() {
        DynamicObjectCollection entyDyns = this.getModel().getEntryEntity(E_K);
        for (int i = 0; i < entyDyns.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entyDyns.get(i);
            DynamicObject curr = dyn.getDynamicObject(KEY_CURRENCY);
            DynamicObject currLoc = (DynamicObject)this.getModel().getValue("localcur");
            if (curr == null || currLoc == null || currLoc.getLong("id") == curr.getLong("id")) continue;
            return false;
        }
        return true;
    }

    private Map<String, LocaleString> ratioOriRateCurr(int select) {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
        if (1 == select) {
            map.put("edescription", new LocaleString("24%"));
            map.put(KEY_ACCOUNT, new LocaleString("20%"));
            map.put(KEY_ASSGRP, new LocaleString("18%"));
            map.put(KEY_DRLOC, new LocaleString("15%"));
            map.put(KEY_CRLOC, new LocaleString("15%"));
        } else if (2 == select) {
            map.put("edescription", new LocaleString("24%"));
            map.put(KEY_ACCOUNT, new LocaleString("20%"));
            map.put(KEY_ASSGRP, new LocaleString("24%"));
            map.put(KEY_DRLOC, new LocaleString("15%"));
            map.put(KEY_CRLOC, new LocaleString("15%"));
        }
        return map;
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if (arg0.getCallBackId().equals("closeCurrentPage") && MessageBoxResult.Cancel.equals((Object)arg0.getResult())) {
            this.getView().close();
        }
    }

    private void initBook() {
        IDataModel m = this.getModel();
        DynamicObject org = (DynamicObject)m.getValue("org");
        Long orgId = 0L;
        DynamicObject group = (DynamicObject)m.getValue("group");
        if (null == org) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u5f0f\u51ed\u8bc1\u7c7b\u522b\u201c%1$s\u201d,\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TemplateVoucherEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), group.getString(NAME), group.getString(NUMBER)));
        }
        orgId = org.getLong("id");
        Long bookStypeId = (Long)m.getValue("bookstype_id");
        if (null == bookStypeId || bookStypeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TemplateVoucherEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        QFilter f1 = new QFilter("bookstype", "=", (Object)bookStypeId);
        QFilter f2 = new QFilter("org", "=", (Object)orgId);
        QFilter f3 = new QFilter("isbizunit", "=", (Object)true);
        DynamicObject[] books = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)"id,accounttable,periodtype.id,bookstype,curperiod,basecurrency,defaultvouchertype", (QFilter[])new QFilter[]{f1, f2, f3});
        if (books.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u7f16\u7801\u201c%2$s\u201d\uff0c\u672a\u8bbe\u7f6e\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"TemplateVoucherEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), org.getString(NAME), org.getString(NUMBER)));
        }
        m.setValue(KEY_BOOK, (Object)books[0].getLong("id"));
        DynamicObject book = (DynamicObject)m.getValue(KEY_BOOK);
        Long locCurId = book.getLong("basecurrency.id");
        DynamicObject locCur = BusinessDataServiceHelper.loadSingleFromCache((Object)locCurId, (String)"bd_currency", (String)"id,isshowsign,sign,priceprecision,amtprecision");
        m.setValue("localcur", (Object)locCur.getLong("id"));
        DynamicObject vt = book.getDynamicObject("defaultvouchertype");
        if (vt != null) {
            m.setValue("vouchertype", (Object)vt.getLong("id"));
        }
    }

    private void initOrg() {
        IDataModel model = this.getModel();
        DynamicObject group = (DynamicObject)model.getValue("group");
        Long orgId = 0L;
        orgId = null != group ? Long.valueOf(group.getLong("org_id")) : Long.valueOf(RequestContext.get().getOrgId());
        this.getModel().setValue("org", (Object)orgId);
    }

    protected void initUserInfo() {
        String userId = this.getPageCache().get(CREATOR);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(userId), (String)"bos_user");
        ((Label)this.getControl("creatorstrv")).setText(user.getLocaleString(NAME).getLocaleValue());
        ((Label)this.getControl("orgv")).setText(this.getDptNameByUserid(Long.parseLong(userId)));
        ((Label)this.getControl("telv")).setText(user.getString("phone"));
        this.initHeartCount();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String btnKey = btn.getKey();
        if (!KEY_DEAL_ATTACH_FLEX.equals(btnKey) && HEARTPHOTO.equals(btnKey)) {
            this.doFabulous();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (BAR_SUBMIT.equals(key)) {
            String userId = RequestContext.get().getUserId();
            DynamicObject userInfoById = this.getUserInfoById(userId);
            if (null == userInfoById) {
                this.getView().showErrMessage(ResManager.loadKDString((String)"\u9519\u8bef", (String)"TemplateVoucherEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e0\u6cd5\u52a0\u8f7d\u51ed\u8bc1\u5236\u5355\u4eba\u3002", (String)"TemplateVoucherEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u65e0\u6cd5\u52a0\u8f7d\u51ed\u8bc1\u5236\u5355\u4eba\u3002", (String)"TemplateVoucherEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0])});
            }
            String creatorStr = userInfoById.getString(NAME);
            this.getModel().setValue(CREATOR, (Object)userId);
            ((Label)this.getControl("creatorstrv")).setText(creatorStr);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Submit) {
            IDataModel model = this.getModel();
            long id = (Long)model.getValue("id");
            String number = (String)model.getValue(NUMBER);
            DynamicObject org = (DynamicObject)model.getValue("org");
            String name = ((OrmLocaleValue)model.getValue(NAME)).getLocaleValue();
            int numberResult = this.checkOrgAndNumber(org.getLong("id"), number, id);
            int nameResult = this.checkOrgAndName(org.getLong("id"), name, id);
            int checkResult = nameResult + numberResult;
            if (checkResult == 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateVoucherEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            } else if (checkResult == 3) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateVoucherEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            } else if (checkResult == 4) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684\u201c\u7f16\u7801\u201d\u548c\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateVoucherEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int checkOrgAndNumber(long org, String number, long id) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        return QueryServiceHelper.exists((String)"gl_templatevoucher", (QFilter[])new QFilter[]{orgFilter, numberFilter, idFilter}) ? 1 : 0;
    }

    private int checkOrgAndName(long org, String name, long id) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter nameFilter = new QFilter(NAME, "=", (Object)name);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        return QueryServiceHelper.exists((String)"gl_templatevoucher", (QFilter[])new QFilter[]{orgFilter, nameFilter, idFilter}) ? 3 : 0;
    }

    private DynamicObject getUserInfoById(String userId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(userId), (DynamicObjectType)dataEntityType);
        return user;
    }

    private String getDptNameByUserid(Long userId) {
        Map<String, Object> result = GlFormUtil.getDptNameByUserId(userId);
        return (String)result.get("dptName");
    }

    private void initHeartCount() {
        DynamicObject user = (DynamicObject)this.getModel().getValue(CREATOR);
        if (user == null) {
            return;
        }
        long userid = user.getLong("id");
        String number = (String)this.getModel().getValue(NUMBER);
        int count = GLFabulousOperation.getFabulousOne((Long)userid, null, (boolean)false, (boolean)true);
        ((Label)this.getControl(HEARTCOUNT)).setText(String.format("%d", count));
        if (!GLFabulousOperation.isThumbUp((long)userid, (String)number)) {
            ((Image)this.getControl(HEARTPHOTO)).setUrl("/icons/pc/state/praised.png");
        }
    }

    private void doFabulous() {
        String number;
        DynamicObject user = (DynamicObject)this.getModel().getValue(CREATOR);
        if (user == null) {
            return;
        }
        long userid = user.getLong("id");
        if (GLFabulousOperation.isCanThumbUp((long)userid, (String)(number = (String)this.getModel().getValue(NUMBER)))) {
            GLFabulousOperation.createFabulous((long)userid, (String)number);
            int count = GLFabulousOperation.getFabulousOne((Long)userid, null, (boolean)false, (boolean)true);
            ((Label)this.getControl(HEARTCOUNT)).setText(String.format("%d", count));
            ((Image)this.getControl(HEARTPHOTO)).setUrl("/icons/pc/state/praised.png");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if (E_K.endsWith(entryname)) {
            boolean old = this.getModel().getDataChanged();
            this.getService(VoucherEditCashFlowCalculator.class).ensureInitCashFlowTotal();
            this.getService(VoucherEditCashFlowPanelManager.class).updatePanelIfCurrentRow(evt.getRow());
            this.getModel().setDataChanged(old);
            this.copyDesc(evt);
        }
    }

    private void copyDesc(RowClickEvent evt) {
        IDataModel m = this.getModel();
        int curIndex = evt.getRow();
        if (curIndex == 0) {
            return;
        }
        String desc = (String)m.getValue("edescription", curIndex);
        if (!StringUtils.isBlank((CharSequence)desc)) {
            return;
        }
        String preDesc = (String)m.getValue("edescription", curIndex - 1);
        if (StringUtils.isBlank((CharSequence)preDesc)) {
            return;
        }
        m.setValue("edescription", (Object)preDesc, curIndex);
    }

    private void setVisiblePQMA(String flag) {
        boolean isShow = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(E_K);
        for (DynamicObject item : collection) {
            if (item.getDynamicObject(KEY_ACCOUNT) == null || !item.getDynamicObject(KEY_ACCOUNT).getBoolean(flag)) continue;
            isShow = true;
            break;
        }
        if (flag.equals("isqty")) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{KEY_PRICE, KEY_QUANTITY, KEY_UNIT});
        } else if (flag.equals("isassist")) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{KEY_ASSGRP});
        }
    }

    private void setDefaultPQM(DynamicObject account, int rowInt) {
        if (account.getBoolean("isqty")) {
            this.getModel().setValue(KEY_UNIT, account.get("measureunit.id"), rowInt);
            this.getModel().setValue(KEY_PRICE, null, rowInt);
            this.getModel().setValue(KEY_QUANTITY, null, rowInt);
        }
    }

    private void changedCurrency(ChangeData[] data) {
        int index = data[0].getRowIndex();
        boolean curLEquCur = this.isCur_LEquCur(index);
        this.getView().setEnable(Boolean.valueOf(!curLEquCur), index, new String[]{"localrate"});
        if (!curLEquCur) {
            BigDecimal rateBig = this.getRateTable(index);
            this.getModel().setValue("localrate", (Object)rateBig, index);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_AMOUNTFOR});
        } else {
            this.getModel().setValue("localrate", (Object)new BigDecimal("1"), index);
            if (this.isAllCurrOriEqeLoc()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_AMOUNTFOR});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_AMOUNTFOR});
            }
        }
    }

    private BigDecimal getRateTable(int index) {
        DynamicObject book = (DynamicObject)this.getModel().getValue(KEY_BOOK);
        if (book == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u6240\u5728\u6838\u7b97\u4f53\u7cfb\u4e2d\u7684\u8d26\u7c3f\u3002", (String)"TemplateVoucherEdit_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return new BigDecimal("0");
        }
        DynamicObject exrateTable = book.getDynamicObject("exratetable");
        DynamicObject oriCur = (DynamicObject)this.getModel().getValue(KEY_CURRENCY, index);
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
        BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)(exrateTable == null ? 0L : exrateTable.getLong("id")), (Long)(oriCur == null ? 0L : oriCur.getLong("id")), (Long)(curLoc == null ? 0L : curLoc.getLong("id")), (Date)((Date)this.getModel().getValue("bizdate")));
        return rate;
    }

    private void hideCashFlow(boolean hideMain, boolean hideSupp) {
        if (hideMain) {
            this.getPageCache().remove("isShowMain");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"maincf", "maincfamt", "cashtotal", "cashunused", "mcfassgrp"});
            this.getModel().setValue("maincf", null);
            this.getModel().setValue("maincfamt", (Object)0);
        }
        if (hideSupp) {
            this.getPageCache().remove("isShowSupp");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"suppcf", "suppcfamt", "pltotal", "plunused"});
            this.getModel().setValue("suppcf", null);
            this.getModel().setValue("suppcfamt", (Object)0);
        }
    }

    private void showCashFlow(boolean showMain, boolean showSupp) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        cache.put("showCashFlow", STR_TRUE);
        if (showMain) {
            cache.put("isShowMain", STR_TRUE);
        } else {
            cache.remove("isShowMain");
        }
        if (showSupp) {
            cache.put("isShowSupp", STR_TRUE);
        } else {
            cache.remove("isShowSupp");
        }
        int index = model.getEntryCurrentRowIndex(E_K);
        if (showMain) {
            view.setVisible(Boolean.valueOf(true), new String[]{"maincf", "maincfamt", "cashtotal", "cashunused", "mcfassgrp"});
            Object mainCfItem = this.getModel().getValue("maincfitem", index);
            if (null == mainCfItem) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"maincfamt"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"maincfamt"});
            }
            model.setValue("maincf", model.getValue("maincfitem", index));
            model.setValue("mcfassgrp", model.getValue("maincfassgrp"), index);
            model.setValue("maincfamt", model.getValue("maincfamount", index));
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"maincfamt"});
        }
        if (showSupp) {
            if (this.isOnlySupp()) {
                view.setVisible(Boolean.valueOf(true), new String[]{"suppcf", "suppcfamt", "pltotal", "plunused"});
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"suppcf", "suppcfamt"});
                view.setVisible(Boolean.valueOf(false), new String[]{"pltotal", "plunused"});
            }
            if (!showMain) {
                view.setVisible(Boolean.valueOf(true), new String[]{"suppcfamt"});
            }
            model.setValue("suppcf", model.getValue("suppcfitem", index));
            model.setValue("suppcfamt", model.getValue("suppcfamount", index));
        }
        cache.remove("showCashFlow");
    }

    private boolean isOnlySupp() {
        String cashAcctCount = this.getPageCache().get("cashAcctCount");
        String plAcctCount = this.getPageCache().get("plAcctCount");
        return (cashAcctCount == null || "0".equals(cashAcctCount)) && plAcctCount != null && !"0".equals(plAcctCount);
    }

    private void updateMainCFRef(ChangeData[] data, int index) {
        IDataModel model = this.getModel();
        DynamicObject newValue = (DynamicObject)data[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)data[0].getOldValue();
        if (newValue == null) {
            model.setValue("maincfamt", (Object)0, index);
            this.showCashFlow(false, true);
            model.setValue("suppcf", null, index);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"suppcf"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"suppcf", "maincfamt"});
            DynamicObject suppcf = (DynamicObject)model.getValue("suppcf");
            BigDecimal suppcfamt = BigDecimal.ZERO;
            if (oldValue == null) {
                BigDecimal maincfamt = BigDecimal.ZERO;
                BigDecimal cof = BigDecimal.ONE;
                if ("o".equals(newValue.getString("direction"))) {
                    cof = cof.negate();
                }
                BigDecimal crLoc = (BigDecimal)model.getValue(KEY_CRLOC, index);
                BigDecimal drLoc = (BigDecimal)model.getValue(KEY_DRLOC, index);
                maincfamt = crLoc.subtract(drLoc).multiply(cof);
                DynamicObject account = (DynamicObject)model.getValue(KEY_ACCOUNT, index);
                if (GLUtil.isPLAcct((DynamicObject)account)) {
                    if (newValue.getBoolean("isdealactivity")) {
                        this.hideCashFlow(false, true);
                    } else if (suppcf != null) {
                        suppcfamt = drLoc.subtract(crLoc);
                    }
                } else if (!GLUtil.isCashAcct((DynamicObject)account)) {
                    if (!newValue.getBoolean("isdealactivity")) {
                        this.hideCashFlow(false, true);
                    } else if (suppcf != null) {
                        suppcfamt = crLoc.add(drLoc);
                    }
                }
                model.setValue("maincfamt", (Object)maincfamt);
                if (suppcfamt.signum() != 0) {
                    model.setValue("suppcfamt", (Object)suppcfamt);
                }
            } else {
                DynamicObject account;
                if (!oldValue.getString("direction").equals(newValue.getString("direction"))) {
                    BigDecimal oldMainCFAmt = (BigDecimal)model.getValue("maincfamt");
                    if ("i".equals(newValue.getString("direction"))) {
                        oldMainCFAmt = oldMainCFAmt.negate();
                    }
                    BigDecimal oldUsed = (BigDecimal)model.getValue("cashunused");
                    oldUsed = oldUsed.add(BigDecimal.valueOf(2L).multiply(oldMainCFAmt));
                    model.setValue("cashunused", (Object)oldUsed);
                    model.setValue("maincfamt", (Object)((BigDecimal)model.getValue("maincfamt")).negate());
                }
                if (GLUtil.isPLAcct((DynamicObject)(account = (DynamicObject)model.getValue(KEY_ACCOUNT, index)))) {
                    if (newValue.getBoolean("isdealactivity")) {
                        this.hideCashFlow(false, true);
                    } else {
                        this.showCashFlow(false, true);
                    }
                } else if (!GLUtil.isCashAcct((DynamicObject)account)) {
                    if (!newValue.getBoolean("isdealactivity")) {
                        this.hideCashFlow(false, true);
                    } else {
                        this.showCashFlow(false, true);
                    }
                }
            }
        }
        boolean assistVisible = null != newValue && newValue.getBoolean("isassist");
        this.getView().setVisible(Boolean.valueOf(assistVisible), new String[]{"mcfassgrp"});
    }

    private void updateSuppFromMain(BigDecimal newValue, int index) {
        DynamicObject account = (DynamicObject)this.getModel().getValue(KEY_ACCOUNT, index);
        if (GLUtil.isPLAcct((DynamicObject)account)) {
            this.getModel().setValue("suppcfamt", (Object)newValue.negate());
        } else {
            DynamicObject maincf = (DynamicObject)this.getModel().getValue("maincf");
            if (maincf != null) {
                if ("o".equals(maincf.getString("direction"))) {
                    this.getModel().setValue("suppcfamt", (Object)newValue.negate());
                } else {
                    this.getModel().setValue("suppcfamt", (Object)newValue);
                }
            }
        }
    }

    private void changeCFUnused(ChangeData[] data, String key, int index) {
        BigDecimal balance;
        BigDecimal newValue = (BigDecimal)data[0].getNewValue();
        BigDecimal oldValue = (BigDecimal)data[0].getOldValue();
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if ((balance = newValue.subtract(oldValue)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        IDataModel model = this.getModel();
        BigDecimal value = (BigDecimal)model.getValue(key);
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        switch (key) {
            case "cashunused": {
                DynamicObject maincf = (DynamicObject)model.getValue("maincf");
                if (maincf == null) {
                    maincf = (DynamicObject)model.getValue("maincfitem", index);
                }
                if (maincf != null) {
                    if ("o".equals(maincf.getString("direction"))) {
                        value = value.subtract(balance.negate());
                        break;
                    }
                    value = value.subtract(balance);
                    break;
                }
                value = value.subtract(balance);
                break;
            }
            case "plunused": {
                value = value.subtract(balance);
            }
        }
        model.setValue(key, (Object)value);
    }

    private void updateSuppCFRef(ChangeData[] data, int index) {
        IDataModel model = this.getModel();
        DynamicObject newValue = (DynamicObject)data[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)data[0].getOldValue();
        if (newValue == null) {
            model.setValue("suppcfamt", (Object)0, index);
        } else {
            BigDecimal result = BigDecimal.ZERO;
            if (oldValue == null) {
                if (this.isOnlySupp()) {
                    result = (BigDecimal)model.getValue(KEY_CRLOC, index);
                    if (result.abs().compareTo(BigDecimal.ZERO) == 0) {
                        result = ((BigDecimal)model.getValue(KEY_DRLOC, index)).negate();
                    }
                    model.setValue("suppcfamt", (Object)result, index);
                } else if (model.getValue("maincf") != null) {
                    result = (BigDecimal)model.getValue("maincfamt", index);
                    this.updateSuppFromMain(result, index);
                }
            } else if (model.getValue("maincf") != null) {
                result = (BigDecimal)model.getValue("maincfamt", index);
                this.updateSuppFromMain(result, index);
            }
        }
    }

    private void collectTotalAmt(ChangeData[] data, BigDecimal col) {
        BigDecimal diff;
        BigDecimal newValue;
        int index;
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue(KEY_ACCOUNT, index = data[0].getRowIndex());
        if (account == null) {
            return;
        }
        BigDecimal oldValue = (BigDecimal)data[0].getOldValue();
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if ((newValue = (BigDecimal)data[0].getNewValue()) == null) {
            newValue = BigDecimal.ZERO;
        }
        if ((diff = newValue.subtract(oldValue).multiply(col)).signum() == 0) {
            return;
        }
        if (GLUtil.isCashAcct((DynamicObject)account)) {
            BigDecimal cashTotal = ((BigDecimal)model.getValue("cashtotal")).add(diff);
            BigDecimal cashunused = ((BigDecimal)model.getValue("cashunused")).add(diff);
            model.setValue("cashtotal", (Object)cashTotal);
            model.setValue("cashunused", (Object)cashunused);
        }
        if (GLUtil.isPLAcct((DynamicObject)account)) {
            BigDecimal pltotal = ((BigDecimal)model.getValue("pltotal")).add(diff);
            BigDecimal plunused = ((BigDecimal)model.getValue("plunused")).add(diff);
            model.setValue("pltotal", (Object)pltotal);
            model.setValue("plunused", (Object)plunused);
        }
    }

    private boolean isEqLocalCur(int rowInt) {
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
        DynamicObject curreny = (DynamicObject)this.getModel().getValue(KEY_CURRENCY, rowInt);
        if (curreny == null) {
            return true;
        }
        return curLoc != null && curreny != null && curLoc.getLong("id") == curreny.getLong("id");
    }

    private void initCurrency(ChangeData[] data) {
        if (data == null || data.length <= 0) {
            return;
        }
        DynamicObject account = (DynamicObject)data[0].getNewValue();
        if (account == null) {
            return;
        }
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
        long curLocId = curLoc.getLong("id");
        this.getModel().setValue(KEY_CURRENCY, (Object)curLocId, data[0].getRowIndex());
    }

    private void initOrgAndBooks() {
        Map groupMap;
        Object groupObj = this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
        Map map = groupMap = groupObj instanceof Map ? (Map)groupObj : (Map)SerializationUtils.fromJsonString((String)String.valueOf(groupObj), Map.class);
        if (groupMap != null) {
            long groupId = Long.parseLong((String)groupMap.get("value"));
            DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"gl_templatevouchergroup");
            long orgId = 0L;
            orgId = null != group ? group.getLong("org_id") : RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)orgId);
            this.initBook();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        for (int index : e.getRowIndexs()) {
            String presetMap;
            this.getService(VoucherEditCashFlowCalculator.class).handleDeleteRow(index);
            IDataModel model = this.getModel();
            if (model.getValue(KEY_ACCOUNT, index) != null && model.getValue("maincf") != null) {
                model.setValue("maincf", null);
            }
            if ((presetMap = this.getPageCache().get("presetmap")) == null) {
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)presetMap, Map.class);
            map.remove(String.valueOf(index));
            this.getPageCache().put("presetmap", SerializationUtils.toJsonString((Object)map));
        }
    }

    private void presetCashFlowItem(int index, String amtfield) {
        IPageCache cache = this.getPageCache();
        if (cache.get("isShowMain") == null && cache.get("isShowSupp") == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject account = (DynamicObject)model.getValue(KEY_ACCOUNT, index);
        if (account == null) {
            return;
        }
        if (!this.firstPreset(String.valueOf(index), account.getString("id"), amtfield).booleanValue()) {
            return;
        }
        long orgId = ((DynamicObject)model.getValue("org")).getLong("id");
        DynamicObject assgrp = (DynamicObject)model.getValue(KEY_ASSGRP, index);
        long assgrpId = assgrp == null ? 0L : assgrp.getLong("id");
        Map presetCash = PresetCashItemUtil.getCashFlowItemIds((DynamicObject)account, (long)assgrpId, (String)amtfield, (long)orgId);
        long mainItemId = (Long)presetCash.get("mainitem");
        long suppItem = (Long)presetCash.get("suppitem");
        if (cache.get("isShowMain") != null) {
            model.setValue("maincf", (Object)mainItemId);
            cache.remove("isShowMain");
        }
        if (cache.get("isShowSupp") != null) {
            model.setValue("suppcf", (Object)suppItem);
            cache.remove("isShowSupp");
        }
        this.cachePresetInfo(String.valueOf(index), account.getString("id"), amtfield);
    }

    private Boolean firstPreset(String index, String accountId, String amtField) {
        String presetMap = this.getPageCache().get("presetmap");
        if (presetMap == null) {
            return true;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)presetMap, Map.class);
        if (map.get(index) == null) {
            return true;
        }
        String[] str = ((String)map.get(index)).split(":");
        if (str[0].equals(accountId)) {
            if (amtField.equals(str[1])) {
                return false;
            }
            return true;
        }
        return true;
    }

    private void cachePresetInfo(String index, String accountId, String amtField) {
        String presetMap = this.getPageCache().get("presetmap");
        Map<String, String> map = null;
        if (presetMap != null) {
            map = (Map)SerializationUtils.fromJsonString((String)presetMap, Map.class);
            map.put(index, accountId + ":" + amtField);
        } else {
            map = new HashMap();
            map.put(index, accountId + ":" + amtField);
        }
        this.getPageCache().put("presetmap", SerializationUtils.toJsonString(map));
    }

    private void presetAcoountChanged(DynamicObject account, int index) {
        BigDecimal dr = (BigDecimal)this.getModel().getValue(KEY_DRLOC, index);
        BigDecimal cr = (BigDecimal)this.getModel().getValue(KEY_DRLOC, index);
        if (dr.signum() != 0 || cr.signum() != 0) {
            String amtField = dr.signum() != 0 ? KEY_DRLOC : KEY_CRLOC;
            this.presetCashFlowItem(index, amtField);
        }
    }

    private void changedDr(ChangeData[] data) {
        BigDecimal drLoc = (BigDecimal)data[0].getNewValue();
        int index = data[0].getRowIndex();
        if (drLoc != null && drLoc.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal drOri = (BigDecimal)this.getModel().getValue(KEY_AMOUNTFOR, index);
            this.getModel().setValue("debitori", (Object)drOri, index);
            this.getModel().setValue("creditori", (Object)BigDecimal.ZERO, index);
        }
        if (this.isCur_LEquCur(index)) {
            BigDecimal crLoc = (BigDecimal)this.getModel().getValue(KEY_CRLOC, index);
            if (drLoc != null && drLoc.compareTo(BigDecimal.ZERO) != 0 || crLoc == null || crLoc.compareTo(BigDecimal.ZERO) == 0) {
                if (drLoc == null) {
                    return;
                }
                this.getModel().setValue("debitori", (Object)drLoc, index);
                this.getModel().setValue(KEY_AMOUNTFOR, (Object)drLoc, index);
            }
        }
    }

    private void changedCr(ChangeData[] data) {
        BigDecimal crLoc = (BigDecimal)data[0].getNewValue();
        int index = data[0].getRowIndex();
        if (crLoc != null && crLoc.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal crOri = (BigDecimal)this.getModel().getValue(KEY_AMOUNTFOR, index);
            this.getModel().setValue("creditori", (Object)crOri, index);
            this.getModel().setValue("debitori", (Object)BigDecimal.ZERO, index);
        }
        if (this.isCur_LEquCur(index)) {
            BigDecimal drLoc = (BigDecimal)this.getModel().getValue(KEY_DRLOC, index);
            if (crLoc != null && crLoc.compareTo(BigDecimal.ZERO) != 0 || drLoc == null || drLoc.compareTo(BigDecimal.ZERO) == 0) {
                if (crLoc == null) {
                    return;
                }
                this.getModel().setValue("creditori", (Object)crLoc, index);
                this.getModel().setValue(KEY_AMOUNTFOR, (Object)crLoc, index);
            }
        }
    }

    private void changedAmountfor(ChangeData[] data) {
        int index = data[0].getRowIndex();
        String entrydc = (String)this.getModel().getValue("entrydc", index);
        BigDecimal amountfor = (BigDecimal)data[0].getNewValue();
        BigDecimal rate = (BigDecimal)this.getModel().getValue("localrate", index);
        this.dealLink(index, entrydc, amountfor, rate);
    }

    private void changedRate(ChangeData[] data) {
        int index = data[0].getRowIndex();
        String entrydc = (String)this.getModel().getValue("entrydc", index);
        BigDecimal amountfor = (BigDecimal)this.getModel().getValue(KEY_AMOUNTFOR, index);
        BigDecimal rate = (BigDecimal)data[0].getNewValue();
        this.dealLink(index, entrydc, amountfor, rate);
    }

    private void dealLink(int index, String entrydc, BigDecimal amountfor, BigDecimal rate) {
        if (rate.equals(BigDecimal.ZERO)) {
            return;
        }
        if ("1".equals(entrydc)) {
            this.getModel().setValue("debitori", (Object)amountfor, index);
            this.getModel().setValue("creditori", null, index);
            this.getModel().setValue(KEY_DRLOC, (Object)amountfor.multiply(rate), index);
        } else {
            this.getModel().setValue("creditori", (Object)amountfor, index);
            this.getModel().setValue("debitori", null, index);
            this.getModel().setValue(KEY_CRLOC, (Object)amountfor.multiply(rate), index);
        }
    }

    private VoucherEditView getVoucherEditView() {
        if (null == this.voucherEditView) {
            this.voucherEditView = new VoucherEditView(this.getView(), this.getModel(), this.getPageCache());
        }
        return this.voucherEditView;
    }

    public <T> T getService(Class<T> clazz) {
        return this.getVoucherEditView().getService(clazz);
    }
}

