/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;

public class TemplateVoucherGroupEdit
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().setShowTitle(false);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String number = this.buildNum();
        model.setValue("number", (Object)number);
        String longNumber = this.buildLongNum(number);
        model.setValue("longnumber", (Object)longNumber);
        Long orgId = this.getOrgId();
        if (-1L != orgId) {
            model.setValue("org", (Object)orgId);
        }
    }

    private Long getOrgId() {
        IDataModel model;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return -1L;
        }
        String org = "";
        if (parentView instanceof ListView) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            org = pageCache.get("org");
        } else if (parentView instanceof FormView && null != (model = parentView.getParentView().getModel()).getProperty("org")) {
            org = String.valueOf(model.getValue("org_id"));
        }
        return Long.parseLong(org);
    }

    private String buildNum() {
        return this.date2String(new Date(), "yyMMddHHmmss");
    }

    private String date2String(Date date, String formatString) {
        SimpleDateFormat simpledateformat = new SimpleDateFormat(formatString);
        String strDate = simpledateformat.format(date);
        return strDate;
    }

    private String buildLongNum(String number) {
        String longNumber = "";
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        longNumber = null == parent || 0L == parent.getLong("id") ? number : parent.getString("longnumber") + number;
        return longNumber;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.setTreeListFilter();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.setTreeListFilter();
    }

    private void setTreeListFilter() {
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            ListView listView = (ListView)parentView;
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String org = pageCache.get("org");
            TreeListView treeListView = (TreeListView)listView.getTreeListView();
            TreeListModel listModel = (TreeListModel)treeListView.getTreeModel();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("org", "=", (Object)Long.valueOf(org)));
            listModel.setTreeFilter(qFilters);
            listModel.setCurrentNodeId((Object)"8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            treeListView.refreshTreeView();
        }
    }
}

