/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.listfilter.FilterContainerValues;
import kd.fi.gl.listfilter.FilterValues;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class TemplateVoucherList
extends StandardTreeListPlugin {
    public static final String ORG = "org";
    private static final String IS_CLICK_ORG = "isClickOrg";
    private static final String YES = "yes";
    private static final String ENTRY_NUMBER = "gl_templatevoucher";
    private static final String GROUP_ORG_ID = "group.org.id";
    public static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String IS_CHANGED_ORG = "isChangedOrg";
    private static final String APPLYTYPE = "applytype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnnew"});
    }

    public void click(EventObject e) {
        String org;
        super.click(e);
        Control ctl = (Control)e.getSource();
        String key = ctl.getKey();
        if ("btnnew".equals(key) && StringUtils.isBlank((CharSequence)(org = this.getPageCache().get(ORG)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"TemplateVoucherList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("new".equals(keyName)) {
            long bookTypeId;
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (StringUtils.isBlank((Object)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u5f0f\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"TemplateVoucherList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            if (currentNodeId.equals(ROOT_NODE_ID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u5f0f\u51ed\u8bc1\u7c7b\u578b\uff0c\u4e0d\u80fd\u5728\u5168\u90e8\u8282\u70b9\u4e0b\u65b0\u589e\u3002", (String)"TemplateVoucherList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            Long groupOrgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)GROUP_ORG_ID);
            if (null == groupOrgId) {
                long defOrg = AccSysUtil.getAccountingOrg((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW);
                if (defOrg == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u6570\u636e", (String)"TemplateVoucherList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
                groupOrgId = defOrg;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(ORG, "=", (Object)groupOrgId));
            String bookTypeIdCache = this.getPageCache().get("bookstype");
            long l = bookTypeId = StringUtils.isBlank((CharSequence)bookTypeIdCache) ? 0L : Long.parseLong(bookTypeIdCache);
            if (bookTypeId == 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u7c7b\u578b\u672a\u542f\u7528\u3002", (String)"TemplateVoucherList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), ""));
                args.cancel = true;
                return;
            }
            qFilters.add(new QFilter("bookstype", "=", (Object)bookTypeId));
            boolean exists = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (!exists) {
                String orgName = BusinessDataServiceHelper.loadSingleFromCache((Object)groupOrgId, (String)"bos_org").getString("name");
                String bookstypeName = BusinessDataServiceHelper.loadSingleFromCache((Object)bookTypeId, (String)"bd_accountbookstype").getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u7c7b\u578b\u672a\u542f\u7528\u3002", (String)"TemplateVoucherList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgName + "," + bookstypeName));
                args.cancel = true;
                return;
            }
        }
        super.beforeDoOperation(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List<Object> filterValue;
        super.beforeShowBill(e);
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW && !(filterValue = this.getFilterValue(APPLYTYPE)).isEmpty()) {
            e.getParameter().setCustomParam(APPLYTYPE, filterValue.get(0));
        }
    }

    private List<Object> getFilterValue(String fieldName) {
        IListView listView = (IListView)this.getView();
        ControlFilters controlFilters = listView.getControlFilters();
        if (controlFilters == null) {
            return Collections.emptyList();
        }
        List values = controlFilters.getFilter(fieldName);
        values.removeIf(""::equals);
        return values;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblrefresh".equals(itemKey)) {
            this.setTreeListFilter(this.getPageCache().get(ORG));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("bookstype")) {
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)GROUP_ORG_ID);
            List bookTypeIdList = AccSysUtil.getBookTypeIdList((List)orgIds);
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIdList));
        } else if (fieldName.startsWith("group.org")) {
            List orgIds = AccSysUtil.getAcctOrgPkList((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)GROUP_ORG_ID);
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator iterator = listFilterColumns.iterator();
        block10: while (iterator.hasNext()) {
            String fieldName;
            FilterColumn filterColumn = (FilterColumn)iterator.next();
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "group.org.id": {
                    String defaultOrgid;
                    List comboItems = AccSysUtil.getAcctOrgComboItem((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW);
                    commFilter.setComboItems(comboItems);
                    if (comboItems.isEmpty()) break;
                    String orgFilterObjId = (String)this.getView().getFormShowParameter().getCustomParam(ORG);
                    long oldOrgId = this.getCacheOrgId();
                    if (StringUtils.isNotBlank((CharSequence)orgFilterObjId)) {
                        defaultOrgid = orgFilterObjId;
                    } else if (orgIds != null && !orgIds.isEmpty()) {
                        defaultOrgid = String.valueOf(orgIds.get(0));
                        this.getPageCache().remove(IS_CLICK_ORG);
                        this.getPageCache().remove(ORG);
                    } else {
                        defaultOrgid = this.getDefaultId(comboItems);
                        long tempOrgId = AccSysUtil.getDefaultOrgId((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW);
                        if (AccSysUtil.getAllOrgIdByComboItems((Collection)comboItems).contains(tempOrgId)) {
                            defaultOrgid = String.valueOf(tempOrgId);
                        }
                    }
                    if (oldOrgId != 0L && !defaultOrgid.equals(String.valueOf(oldOrgId))) {
                        this.getPageCache().put(IS_CHANGED_ORG, YES);
                    }
                    if (StringUtils.isBlank((CharSequence)this.getPageCache().get(IS_CLICK_ORG)) && StringUtils.isBlank((CharSequence)this.getPageCache().get(ORG))) {
                        this.getPageCache().put(ORG, defaultOrgid);
                        commFilter.setDefaultValue(defaultOrgid);
                        commFilter.setDefValue(defaultOrgid);
                        commFilter.setMustInput(true);
                        this.setTreeListFilter(defaultOrgid);
                    }
                    if (orgIds != null || commFilter.getDefaultValues().isEmpty()) continue block10;
                    List defaultValue = commFilter.getDefaultValues();
                    orgIds = defaultValue.stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toList());
                    break;
                }
                case "bookstype.name": {
                    List comboItems;
                    if (orgIds == null || orgIds.isEmpty()) {
                        List ids = AccSysUtil.getBookTypeDataPermission(null);
                        comboItems = commFilter.getComboItems();
                        comboItems.removeIf(item -> !ids.contains(Long.valueOf(item.getValue())));
                    } else {
                        comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
                        commFilter.setComboItems(comboItems);
                    }
                    if (comboItems.isEmpty()) break;
                    String bookstype = this.getPageCache().get("bookstype");
                    String defBookType = bookstype != null ? bookstype : ((ComboItem)comboItems.get(0)).getValue();
                    commFilter.setDefaultValue(defBookType);
                    this.getPageCache().put("bookstype", String.valueOf(defBookType));
                    int bookTypeCount = AccSysUtil.getAllBookTypeCount();
                    if (bookTypeCount > 1) continue block10;
                    if (bookTypeCount == 1) {
                        this.getPageCache().put("bookstype", defBookType);
                    }
                    iterator.remove();
                    break;
                }
                case "applytype": {
                    String applyType = this.getPageCache().get(APPLYTYPE);
                    if (StringUtils.isBlank((CharSequence)applyType) || YES.equals(this.getPageCache().get(IS_CHANGED_ORG))) {
                        applyType = "0";
                    }
                    commFilter.setDefaultValue(applyType);
                    commFilter.setDefValue(applyType);
                    this.getPageCache().put(APPLYTYPE, applyType);
                    break;
                }
            }
        }
    }

    private long getCacheOrgId() {
        String cacheOrgStr = this.getPageCache().get(ORG);
        if (StringUtils.isBlank((CharSequence)cacheOrgStr)) {
            return 0L;
        }
        return Long.parseLong(cacheOrgStr);
    }

    private QFilter getTreeNodeFilter(long defaultOrgId) {
        if (defaultOrgId == 0L) {
            return new QFilter(ORG, "=", (Object)AccSysUtil.getAccountingOrg((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW));
        }
        return new QFilter(ORG, "=", (Object)defaultOrgId);
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        List treeFilter = this.getTreeModel().getTreeFilter();
        boolean isF7 = this.getView().getFormShowParameter().getCustomParams().getOrDefault("IS_F7", false);
        if (!isF7) {
            treeFilter.clear();
            treeFilter.add(this.getTreeNodeFilter(this.getCacheOrgId()));
        }
    }

    private void setTreeListFilter(String orgId) {
        this.getPageCache().put(ORG, orgId);
        this.getTreeModel().setCurrentNodeId((Object)ROOT_NODE_ID);
        this.getTreeListView().refreshTreeView();
    }

    private String getDefaultId(List<ComboItem> items) {
        long currOrgId = RequestContext.get().getOrgId();
        for (ComboItem item : items) {
            long nextId;
            if (null == item || item.getValue().length() == 0 || (nextId = Long.parseLong(item.getValue())) != currOrgId) continue;
            return Long.toString(currOrgId);
        }
        return items.get(0).getValue();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        FilterContainerValues filterContainerValues = new FilterContainerValues(searchClickEvent.getFilterValues());
        List<FilterValues> fastFilterValuesList = filterContainerValues.getFastFilterValuesList();
        if (!fastFilterValuesList.isEmpty() && "".equals(this.getPageCache().get(ORG))) {
            return;
        }
        List<FilterValues> customFilterValuesList = filterContainerValues.getCustomFilterValuesList();
        block10: for (FilterValues filterValues : customFilterValuesList) {
            String fieldName;
            List<Object> values = filterValues.getValues();
            switch (fieldName = filterValues.getFieldName()) {
                case "group.org.id": {
                    String orgValue;
                    if (values.isEmpty()) break;
                    String string = orgValue = values.get(0) == null ? "" : values.get(0).toString();
                    if (!fastFilterValuesList.isEmpty() && this.getPageCache().get(ORG).equals(orgValue)) continue block10;
                    this.getPageCache().put(ORG, orgValue);
                    this.getPageCache().put(IS_CLICK_ORG, YES);
                    this.setTreeListFilter(orgValue);
                    break;
                }
                case "bookstype.id": {
                    List comboItems;
                    List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)GROUP_ORG_ID);
                    if (orgIds != null && orgIds.isEmpty()) {
                        orgIds.add(AccSysUtil.getAccountingOrg((String)ENTRY_NUMBER, (boolean)false, (PermissonType)PermissonType.VIEW));
                    }
                    if (!(comboItems = AccSysUtil.getBookTypeCombo((List)orgIds)).isEmpty()) {
                        if (!values.isEmpty()) {
                            Set bookTypeSet = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toSet());
                            values.removeIf(x -> x == null || !bookTypeSet.contains(x.toString()));
                        }
                        if (values.isEmpty()) {
                            values.add(((ComboItem)comboItems.get(0)).getValue());
                        }
                    } else {
                        values.clear();
                        values.add("");
                    }
                    this.getPageCache().put("bookstype", values.get(0).toString());
                    break;
                }
                case "applytype": {
                    if (values.isEmpty()) break;
                    if (YES.equals(this.getPageCache().get(IS_CHANGED_ORG))) {
                        values.clear();
                        values.add("0");
                        this.getPageCache().put(IS_CHANGED_ORG, "no");
                    }
                    this.getPageCache().put(APPLYTYPE, values.get(0).toString());
                    break;
                }
            }
        }
        List<FilterValues> schemeFilterValuesList = filterContainerValues.getSchemeFilterValuesList();
        for (FilterValues filterValues : schemeFilterValuesList) {
            if (!"group.org.number".equals(filterValues.getFieldName()) || !CompareTypeEnum.EQUAL.getId().equalsIgnoreCase(filterValues.getCompareType()) || !filterValues.isValueSingle()) continue;
            QFilter orgFilter = new QFilter("number", "=", (Object)filterValues.getValues().get(0).toString());
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])orgFilter.toArray());
            if (orgDyn == null) break;
            this.getPageCache().put(ORG, String.valueOf(orgDyn.getLong("id")));
            this.getPageCache().put(IS_CLICK_ORG, YES);
            this.setTreeListFilter(null);
            break;
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        String org = this.getPageCache().get(ORG);
        if (StringUtils.isNotBlank((CharSequence)org)) {
            this.setTreeListFilter(org);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String org;
        super.confirmCallBack(event);
        if ("group_bar_del".equals(event.getCallBackId()) && StringUtils.isNotBlank((CharSequence)(org = this.getPageCache().get(ORG)))) {
            this.setTreeListFilter(org);
        }
    }
}

