/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.util.GLUtil;

public class VocherBreakPointList
extends AbstractListPlugin
implements ClickListener,
ProgresssListener {
    private static int lastPeriodNum = 12;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        BasedataEdit booksType = (BasedataEdit)this.getControl("bookstype");
        booksType.addBeforeF7SelectListener(select -> this.setBookTypeF7SelectFilter(select));
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(select -> this.setPeriodF7SelectFilter(select));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrgBookTypePeriod();
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        List filteCol = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filteCol) {
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            if (!filterColumn.getFieldName().equals("org.name")) continue;
            List comboItems = BreakPointCommonUtil.getOrgComboItems((AbstractFormPlugin)this);
            commFilter.setComboItems(comboItems);
            if (comboItems.isEmpty()) {
                commFilter.setDefaultValue("0");
                continue;
            }
            String curOrg = this.getPageCache().get("curOrg");
            if (StringUtils.isEmpty((String)curOrg)) {
                commFilter.setDefaultValue("0");
                continue;
            }
            commFilter.setDefaultValue(curOrg);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List orgIds = BreakPointCommonUtil.getOrgIds((AbstractFormPlugin)this);
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilterList = (List)filterValues.get("customfilter");
        if (customfilterList == null) {
            return;
        }
        for (Map filed : customfilterList) {
            String filedName = ((List)filed.get("FieldName")).get(0).toString();
            if (!"org.id".equals(filedName)) continue;
            String selectedOrg = ((List)filed.get("Value")).get(0).toString();
            this.selectOrg(selectedOrg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (keyName = e.getProperty().getName()) {
            case "bookstype": 
            case "booktype": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                String bookType = newValue instanceof DynamicObject ? String.valueOf(((DynamicObject)newValue).getLong("id")) : (String)newValue;
                this.getPageCache().put("curBooktype", bookType);
                String curPagePeriod = this.getPageCache().get("curPeriod");
                String curOrg = this.getPageCache().get("curOrg");
                long curperiodid = BreakPointCommonUtil.getCurentPeriod((long)Long.parseLong(curOrg), (long)Long.parseLong(bookType));
                if (curPagePeriod != null && (Long.parseLong(curPagePeriod) == curperiodid || BreakPointCommonUtil.checkSamePeriodType((String)curPagePeriod, (String)String.valueOf(curperiodid)))) {
                    this.updateList();
                }
                model.setValue("period", (Object)curperiodid);
                break;
            }
            case "period": {
                DynamicObject period = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (null != period) {
                    this.getPageCache().put("curPeriod", String.valueOf(period.getPkValue()));
                    this.updateList();
                    break;
                }
                DynamicObject periodOld = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (periodOld == null) break;
                model.setValue("period", periodOld.getPkValue());
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        DynamicObject booktype = this.getModel().getDataEntity().getDynamicObject("bookstype");
        if (booktype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"VocherBreakPointList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        DynamicObject periodDO = this.getModel().getDataEntity().getDynamicObject("period");
        if (periodDO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4", (String)"VocherBreakPointList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        QFilter qBookType = new QFilter("booktypeid", "=", (Object)booktype.getLong("id"));
        e.getQFilters().add(qBookType);
        QFilter qPeriod = new QFilter("periodid", "=", (Object)Long.parseLong(String.valueOf(periodDO.getPkValue())));
        e.getQFilters().add(qPeriod);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dyos = super.getData(start, limit);
                if (dyos.isEmpty()) {
                    return dyos;
                }
                DataEntityPropertyCollection properties = ((DynamicObject)dyos.get(0)).getDynamicObjectType().getProperties();
                properties.add((Object)new DynamicSimpleProperty("desc", String.class, null));
                HashSet<Long> voucheridSet = new HashSet<Long>(dyos.size());
                for (DynamicObject dyo : dyos) {
                    voucheridSet.add(dyo.getLong("voucherid"));
                }
                Map<Long, String> descMap = this.getVoucherDescMap(voucheridSet);
                for (DynamicObject dyo : dyos) {
                    long id = dyo.getLong("voucherid");
                    String desc = descMap.get(id);
                    if (desc == null) {
                        desc = ResManager.loadKDString((String)"\u6b64\u51ed\u8bc1\u5df2\u88ab\u5220\u9664\u3002", (String)"VocherBreakPointList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    }
                    dyo.set("desc", (Object)desc);
                }
                return dyos;
            }

            private Map<Long, String> getVoucherDescMap(Set<Long> voucheridSet) {
                HashMap<Long, String> descMap = new HashMap<Long, String>(voucheridSet.size());
                try (DataSet dataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id,billno,entries.edescription", (QFilter[])new QFilter[]{new QFilter("id", "in", voucheridSet), new QFilter("entries.seq", "=", (Object)1)}, null);){
                    while (dataset.hasNext()) {
                        Row row = dataset.next();
                        long id = row.getLong("id");
                        String desc = row.getString("entries.edescription");
                        if (descMap.get(id) != null) continue;
                        descMap.put(id, desc);
                    }
                }
                return descMap;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private void selectOrg(String selectedOrg) {
        String curOrg = this.getPageCache().get("curOrg");
        if (selectedOrg.equals(curOrg)) {
            return;
        }
        this.getPageCache().put("curOrg", selectedOrg);
        ComboEdit bookTypeComboEdit = (ComboEdit)this.getControl("booktype");
        List<ComboItem> bookTypeComboList = this.getBookTypeComboList(selectedOrg);
        bookTypeComboEdit.setComboItems(bookTypeComboList);
        String booktypeId = "";
        String periodId = "";
        List bookList = BreakPointCommonUtil.getOrgBooks((String)selectedOrg, (AbstractFormPlugin)this);
        String curBookType = this.getPageCache().get("curBooktype");
        String curPeriod = this.getPageCache().get("curPeriod");
        if (!CollectionUtils.isEmpty((Collection)bookList)) {
            Map<String, String> book = this.getDefaultBook(curBookType, bookList);
            booktypeId = book.get("masterId");
            periodId = book.get("curperiodPkId");
            if (periodId.equals(curPeriod) && BreakPointCommonUtil.checkSamePeriodType((String)periodId, (String)curPeriod)) {
                periodId = curPeriod;
            }
        }
        if (curBookType == null || !curBookType.equals(booktypeId)) {
            this.setBookType(booktypeId);
            this.getPageCache().put("curBooktype", booktypeId);
        }
        if (curPeriod == null || !curPeriod.equals(periodId)) {
            this.setPeriod(periodId);
            this.getPageCache().put("curPeriod", periodId);
        }
    }

    private void setBookType(String booktypeId) {
        IDataModel model = this.getModel();
        model.setValue("booktype", (Object)booktypeId);
        model.setValue("bookstype", (Object)booktypeId);
    }

    private void setPeriod(String periodId) {
        IDataModel model = this.getModel();
        model.setValue("period", (Object)periodId);
    }

    private void initData(String curOrg, String defaultBookType, String defaultCurperiod) {
        ComboEdit bookTypeComboEdit = (ComboEdit)this.getControl("booktype");
        List<ComboItem> bookTypeComboList = this.getBookTypeComboList(curOrg);
        bookTypeComboEdit.setComboItems(bookTypeComboList);
        this.setBookType(defaultBookType);
        this.setPeriod(defaultCurperiod);
    }

    private List<ComboItem> getBookTypeComboList(String curOrg) {
        List books = BreakPointCommonUtil.getOrgBooks((String)curOrg, (AbstractFormPlugin)this);
        if (CollectionUtils.isEmpty((Collection)books)) {
            return null;
        }
        ArrayList<ComboItem> bookTypeComboList = new ArrayList<ComboItem>(books.size());
        for (Map book : books) {
            bookTypeComboList.add(new ComboItem(new LocaleString((String)book.get("bookNm")), (String)book.get("masterId")));
        }
        return bookTypeComboList;
    }

    private void initOrgBookTypePeriod() {
        Long defaultOrg = BreakPointCommonUtil.getDefaultOrgId((AbstractFormPlugin)this);
        if (defaultOrg == null) {
            return;
        }
        String defaultBookType = "";
        String defaultCurperiod = "";
        List bookList = BreakPointCommonUtil.getOrgBooks((String)String.valueOf(defaultOrg), (AbstractFormPlugin)this);
        if (!CollectionUtils.isEmpty((Collection)bookList)) {
            String defaultBookTypeCombo = (String)this.getView().getFormShowParameter().getCustomParam("booktypeCombo");
            String lastPeriod = (String)this.getView().getFormShowParameter().getCustomParam("lastPeriod");
            Map<String, String> defaultBook = this.getDefaultBook(defaultBookTypeCombo, bookList);
            defaultBookType = defaultBook.get("masterId");
            long curentPeriod = BreakPointCommonUtil.getCurentPeriod((long)defaultOrg, (long)Long.parseLong(defaultBookType));
            defaultCurperiod = String.valueOf(curentPeriod);
            if (!defaultCurperiod.equals(lastPeriod) && BreakPointCommonUtil.checkSamePeriodType((String)lastPeriod, (String)defaultCurperiod)) {
                List lastPeriodIds = BreakPointCommonUtil.getLastPeriodIds((long)curentPeriod, (int)lastPeriodNum);
                lastPeriodIds.sort(Comparator.naturalOrder());
                Long first = (Long)lastPeriodIds.get(0);
                if (Long.parseLong(lastPeriod) >= first) {
                    defaultCurperiod = lastPeriod;
                }
            }
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("curOrg", String.valueOf(defaultOrg));
        pageCache.put("curBooktype", defaultBookType);
        pageCache.put("curPeriod", defaultCurperiod);
        this.initData(String.valueOf(defaultOrg), defaultBookType, defaultCurperiod);
    }

    private Map<String, String> getDefaultBook(String expectBookType, List<Map<String, String>> bookList) {
        for (Map<String, String> book : bookList) {
            if (!Objects.equals(expectBookType, book.get("masterId"))) continue;
            return book;
        }
        return bookList.get(0);
    }

    private void setBookTypeF7SelectFilter(BeforeF7SelectEvent select) {
        IPageCache pageCache = this.getPageCache();
        String curOrg = pageCache.get("curOrg");
        Set allBookByOrg = AccSysUtil.getAllBookTypeFromAccSys((long)Long.parseLong(curOrg));
        ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().add(new QFilter("id", "in", (Object)allBookByOrg));
    }

    private void setPeriodF7SelectFilter(BeforeF7SelectEvent select) {
        IPageCache pageCache = this.getPageCache();
        String curorg = pageCache.get("curOrg");
        String curBooktype = pageCache.get("curBooktype");
        if (StringUtils.isEmpty((String)curorg)) {
            return;
        }
        long periodid = BreakPointCommonUtil.getCurentPeriod((long)Long.parseLong(curorg), (long)Long.parseLong(curBooktype));
        DynamicObject curPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)periodid, (String)"bd_period");
        List lastPeriodIds = BreakPointCommonUtil.getLastPeriodIds((long)periodid, (int)lastPeriodNum);
        Long startPeriod = BreakPointCommonUtil.getStartPeriod((String)curorg, (String)curBooktype, (AbstractFormPlugin)this);
        if (!CollectionUtils.isEmpty((Collection)lastPeriodIds)) {
            lastPeriodIds.sort(Comparator.naturalOrder());
            Long first = (Long)lastPeriodIds.get(0);
            if (startPeriod < first) {
                startPeriod = first;
            }
        }
        ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        QFilter qtype = new QFilter("periodtype", "=", (Object)curPeriodDyo.getLong("periodtype.id"));
        QFilter qids = new QFilter("id", ">=", (Object)startPeriod);
        List openPeriods = GLUtil.getOpenPeriod((long)Long.parseLong(curorg), (long)Long.parseLong(curBooktype));
        if (!CollectionUtils.isEmpty((Collection)openPeriods)) {
            qids.or(new QFilter("id", "in", (Object)openPeriods));
        }
        filterParam.getQFilters().add(qtype);
        filterParam.getQFilters().add(qids);
    }

    public void onProgress(ProgressEvent arg0) {
        this.updateList();
    }

    private void updateList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }
}

