/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.formplugin.AbstractFinalProcessList;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.formplugin.comassist.ComAssistListDataProvider;
import kd.fi.gl.util.AccountBookHelper;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.VoucherAmortSchemeUtils;
import kd.fi.gl.util.VoucherUtil;

public class VoucherAmortSchemeListPlugin
extends AbstractFinalProcessList {
    private static final String KEY_ENABLE_STATUS = "billstatus";
    private static final String KEY_AMORT_STATUS = "status";
    private Map<String, Map<Long, String>> assgrpNumberMap = new HashMap<String, Map<Long, String>>(16);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AccListDataProvider(this.getView()));
        super.beforeCreateListDataProvider(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("deletevoucher".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
            IListView view = (IListView)this.getView();
            view.refresh();
        }
    }

    public static Map<String, String> getVouncherNumber(List<Long> sourceBillIdList) {
        if (CollectionUtils.isEmpty(sourceBillIdList)) {
            return new HashMap<String, String>();
        }
        String bookTypeField = "accountbooks";
        DynamicObject[] sourceBillDynObjs = BusinessDataServiceHelper.load((String)"gl_voucheramortacheme", (String)("org," + bookTypeField), (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdList)});
        if (sourceBillDynObjs.length == 0) {
            return new HashMap<String, String>();
        }
        List orgIDs = Arrays.stream(sourceBillDynObjs).map(schemeDyo -> schemeDyo.getLong("org.id")).collect(Collectors.toList());
        List bookTypeIDs = Arrays.stream(sourceBillDynObjs).map(schemeDyo -> schemeDyo.getLong(bookTypeField + ".id")).collect(Collectors.toList());
        Map curPeriodRepo = AccountBookHelper.get().queryAcctBooks(orgIDs, bookTypeIDs, "curperiod");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("srcentity", "in", sourceBillIdList);
        HashMap srcId2Period2VchId = new HashMap(sourceBillIdList.size());
        try (DataSet relationDataSet = QueryServiceHelper.queryDataSet((String)VoucherAmortSchemeListPlugin.class.getName(), (String)"gl_voucherrelation", (String)String.join((CharSequence)",", "targentity", "srcentity", "period"), (QFilter[])qfBuilder.toArray(), null);){
            for (Row row : relationDataSet) {
                Long srcBillId = row.getLong("srcentity");
                srcId2Period2VchId.putIfAbsent(srcBillId, new HashMap(16));
                ((Map)srcId2Period2VchId.get(srcBillId)).put(row.getLong("period"), row.getLong("targentity"));
            }
        }
        Collection voucherIdCollection = srcId2Period2VchId.values().stream().flatMap(x -> x.values().stream()).collect(Collectors.toList());
        HashMap<Long, String> voucherIdVoucherNoMap = new HashMap<Long, String>(voucherIdCollection.size());
        qfBuilder.clear();
        qfBuilder.add("id", "in", (Object)voucherIdCollection);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet voucherDataSet = VoucherQueryUtils.queryDataSet((String)String.join((CharSequence)",", "id", "period", "billno"), (QFilter[])qfBuilder.toArray(), null, (int)-1);){
            for (Row row : voucherDataSet) {
                voucherIdVoucherNoMap.put(row.getLong("id"), row.getString("billno"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        HashMap<String, String> sourceBillIdVoucherNoMap = new HashMap<String, String>(sourceBillDynObjs.length);
        for (DynamicObject sourceBillDynObj : sourceBillDynObjs) {
            Long bookTypeID;
            long sourceBillId = sourceBillDynObj.getLong("id");
            Long orgID = sourceBillDynObj.getLong("org.id");
            DynamicObject acctBookDyn = (DynamicObject)curPeriodRepo.get(new AccountBookHelper.Key(orgID, bookTypeID = Long.valueOf(sourceBillDynObj.getLong(bookTypeField + ".id"))));
            long curPeriodId = acctBookDyn == null ? 0L : acctBookDyn.getLong("curperiod");
            Long voucherId = (Long)srcId2Period2VchId.getOrDefault(sourceBillId, Collections.emptyMap()).get(curPeriodId);
            String voucherNo = voucherIdVoucherNoMap.getOrDefault(voucherId, "");
            if (!StringUtils.isNotBlank((CharSequence)voucherNo)) continue;
            sourceBillIdVoucherNoMap.put(String.valueOf(sourceBillId), voucherNo);
        }
        return sourceBillIdVoucherNoMap;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IFormView view = this.getView();
        ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            BillList billList = (BillList)this.getControl("BillListAp");
            String booksName = "accountbooks";
            if ("vouchernumber".equals(hyperClick.getFieldName())) {
                args.setCancel(Boolean.TRUE.booleanValue());
                Object fid = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject data = BusinessDataServiceHelper.loadSingle((String)billList.getBillFormId(), (String)("org," + booksName), (QFilter[])new QFilter[]{new QFilter("id", "=", fid)});
                if (data != null) {
                    DynamicObject accountbook = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"curperiod.id", (QFilter[])new QFilter[]{new QFilter("org", "=", data.get("org.id")), new QFilter("bookstype", "=", data.get(booksName + ".id"))});
                    QFBuilder qfBuilder = new QFBuilder();
                    qfBuilder.add("srcentity", "=", fid);
                    qfBuilder.add("period", "=", (Object)accountbook.getLong("curperiod.id"));
                    try (DataSet voucherRelationDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucherrelation", (String)"targentity", (QFilter[])qfBuilder.toArray(), null);){
                        ArrayList<Long> voucherIdList = new ArrayList<Long>(10);
                        for (Row row : voucherRelationDataSet) {
                            voucherIdList.add(row.getLong("targentity"));
                        }
                        qfBuilder.clear();
                        qfBuilder.add("id", "in", voucherIdList);
                        List voucherPkValueList = VoucherQueryUtils.queryPrimaryKeys((QFilter[])qfBuilder.toArray(), null, (int)1);
                        if (!voucherPkValueList.isEmpty()) {
                            VoucherUtil.hyperVoucher(data.getLong("org.id"), (Long)voucherPkValueList.get(0), view);
                        }
                    }
                }
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryVals;
        super.afterQueryOfExport(e);
        for (DynamicObject queryVal : queryVals = e.getQueryValues()) {
            this.setAssgrp(queryVal, "targetaccounts", "targetrowid", "targetassgrp");
            this.setAssgrp(queryVal, "destaccounts", "destrowid", "destassgrp");
        }
    }

    private void setAssgrp(DynamicObject queryVal, String accountsRowName, String rowidRowName, String assgrpRowName) {
        Long orgId = queryVal.getDynamicObject("org").getLong("id");
        DynamicObjectCollection entryEntity = queryVal.getDynamicObjectCollection(accountsRowName);
        for (DynamicObject entryRow : entryEntity) {
            DynamicProperty rowIdProperty = entryEntity.getDynamicObjectType().getProperty(rowidRowName);
            DynamicProperty assGrpProp = entryEntity.getDynamicObjectType().getProperty(assgrpRowName);
            if (assGrpProp == null) {
                return;
            }
            if (rowIdProperty == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u9700\u914d\u7f6e\u201c\u884cID\u201d\u5b57\u6bb5\u5141\u8bb8\u5bfc\u51fa\u6216\u5bfc\u5165\u3002", (String)"VoucherAmortSchemeListPlugin_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
            StringBuilder desc = new StringBuilder();
            String targetrowid = entryRow.getString(rowidRowName);
            DynamicObject assgrpDyn = FPFormUtil.queryFinalProcessAssgrpDyn(targetrowid, orgId);
            if (assgrpDyn == null) continue;
            DynamicObjectCollection entries = assgrpDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection values;
                String name = entry.getDynamicObject("fieldname").getString("name");
                String valuetype = entry.getDynamicObject("fieldname").getString("valuetype");
                if (AssistValueType.isManualTxt((String)valuetype)) {
                    desc.append(name).append(':');
                    String value = entry.getString("txtval");
                    value = value.replaceAll(";", ",");
                    desc.append(value);
                    desc.append(';');
                    entryRow.set(assgrpRowName, (Object)desc.toString());
                    continue;
                }
                DynamicObject valuesource = entry.getDynamicObject("fieldname").getDynamicObject("valuesource");
                if (valuesource == null) continue;
                String fieldnumber = valuesource.getString("number");
                if (!this.assgrpNumberMap.containsKey(fieldnumber)) {
                    this.assgrpNumberMap = this.getAssgrpNumberMap(this.assgrpNumberMap, fieldnumber);
                }
                if (!(values = entry.getDynamicObjectCollection("value")).isEmpty()) {
                    desc.append(name).append(':');
                    for (int i = 0; i < values.size(); ++i) {
                        DynamicObject value = (DynamicObject)values.get(i);
                        String number = this.assgrpNumberMap.get(fieldnumber).get(value.getLong("fbasedataid_id"));
                        desc.append(number).append(',');
                    }
                    desc.deleteCharAt(desc.length() - 1);
                    desc.append(';');
                    continue;
                }
                desc.append(name).append(':').append(';');
            }
            entryRow.set(assgrpRowName, (Object)desc.toString());
        }
    }

    private Map<String, Map<Long, String>> getAssgrpNumberMap(Map<String, Map<Long, String>> assgrpNumberMap, String fieldnumber) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)fieldnumber, (String)"id,number", null);
        HashMap<Long, String> map = new HashMap<Long, String>(dyns.size());
        for (DynamicObject dyn : dyns) {
            map.put(dyn.getLong("id"), dyn.getString("number"));
        }
        assgrpNumberMap.put(fieldnumber, map);
        return assgrpNumberMap;
    }

    public static class AccListDataProvider
    extends ComAssistListDataProvider {
        public AccListDataProvider(IFormView view) {
            super(view);
        }

        public void setListFields(List<ListField> listFields) {
            boolean existBillStatus = false;
            for (ListField listField : listFields) {
                if (!VoucherAmortSchemeListPlugin.KEY_ENABLE_STATUS.equals(listField.getFieldName())) continue;
                existBillStatus = true;
            }
            if (!existBillStatus) {
                ListField field = new ListField(VoucherAmortSchemeListPlugin.KEY_ENABLE_STATUS);
                field.setFieldName(VoucherAmortSchemeListPlugin.KEY_ENABLE_STATUS);
                listFields.add(field);
            }
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection listDyns = super.getData(start, limit);
            if (!listDyns.isEmpty()) {
                DataEntityPropertyCollection properties = ((DynamicObject)listDyns.get(0)).getDynamicObjectType().getProperties();
                properties.add((Object)new DynamicSimpleProperty("curamortamount", AmountProp.class, null));
            }
            listDyns.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("vouchernumber", String.class, (Object)""));
            ArrayList<Long> schemeIds = new ArrayList<Long>();
            for (DynamicObject dyn : listDyns) {
                schemeIds.add(dyn.getLong("id"));
            }
            Map<String, String> idAndVoucherNumber = VoucherAmortSchemeListPlugin.getVouncherNumber(schemeIds);
            DynamicObject[] dataDyns = BusinessDataServiceHelper.load((String)"gl_voucheramortacheme", (String)"id,amortstyle,org_id,accountbooks_id,begindate,enddate,startperiod,status,billstatus,totalamount,amortamount,periodamortamount,planperiod,amortperiod,policies.period,policies.amount,custompolicies.camount,custompolicies.cperiod,targetaccounts.rate", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
            HashMap<Long, DynamicObject> dbDynMap = new HashMap<Long, DynamicObject>(dataDyns.length);
            for (DynamicObject dyn : dataDyns) {
                dbDynMap.put(dyn.getLong("id"), dyn);
            }
            for (DynamicObject listDyn : listDyns) {
                AccountBookInfo bookInfo;
                listDyn.set("vouchernumber", (Object)idAndVoucherNumber.get(listDyn.getPkValue().toString()));
                DynamicObject dbDyn = (DynamicObject)dbDynMap.get(listDyn.getLong("id"));
                long orgId = dbDyn.getLong("org_id");
                long bookTypeId = dbDyn.getLong("accountbooks_id");
                AccountBookInfo accountBookInfo = bookInfo = orgId != 0L && bookTypeId != 0L ? AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId) : null;
                if (bookInfo == null) continue;
                this.setCurPeriodAmount(dbDyn, listDyn, bookInfo);
            }
            QueryBuilder qb = this.getQueryBuilder();
            List decimalFields = qb.getDecimalFields();
            ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(decimalFields.size() + 1);
            AmountProp amountProp = (AmountProp)this.getQueryBuilder().getEntityType().getProperties().get((Object)"curamortamount");
            FmtField fmtFieldCuramort = new FmtField((IDataEntityProperty)amountProp, "curamortamount", "currency");
            fmtFields.add(fmtFieldCuramort);
            for (ListField field : decimalFields) {
                FmtField fmtField = new FmtField(field.getSrcFieldProp(), field.getListFieldKey().replace('.', '_'), field.getControlField() != null ? field.getControlField().getFieldName() : "");
                fmtField.setControlFieldKey(field.getControlField() != null ? field.getControlField().getListFieldKey() : "");
                fmtFields.add(fmtField);
            }
            NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, listDyns);
            this.getQueryResult().setNumberFormatProvider(numberFormatProvider);
            return listDyns;
        }

        private BigDecimal getCustomCurAmount(DynamicObject dbDyn, Long curPeriodId) {
            BigDecimal customCurAmount = BigDecimal.ZERO;
            DynamicObjectCollection dynamicObjectCollection = dbDyn.getDynamicObjectCollection("custompolicies");
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    Long periodId;
                    DynamicObject period = dynamicObject.getDynamicObject("cperiod");
                    if (period == null || !(periodId = Long.valueOf(period.getLong("id"))).equals(curPeriodId)) continue;
                    customCurAmount = dynamicObject.getBigDecimal("camount").multiply(((DynamicObject)dbDyn.getDynamicObjectCollection("targetaccounts").get(0)).getBigDecimal("rate"));
                }
            }
            return customCurAmount;
        }

        private void setCurPeriodAmount(DynamicObject dbSchemeDyn, DynamicObject listSchemeDyn, AccountBookInfo bookInfo) {
            BigDecimal curPeriodAmount;
            String amortTypeVal = dbSchemeDyn.getString("amortstyle");
            long curPeriodId = bookInfo.getCurPeriodId();
            if (AmortStyle.CUSTOME.getValue().equals(amortTypeVal)) {
                listSchemeDyn.set("curamortamount", (Object)this.getCustomCurAmount(dbSchemeDyn, curPeriodId));
                return;
            }
            DynamicObjectCollection polices = dbSchemeDyn.getDynamicObjectCollection("policies");
            List collect = polices.stream().filter(row -> row.getDynamicObject("period").getLong("id") == curPeriodId).collect(Collectors.toList());
            BigDecimal bigDecimal = curPeriodAmount = collect.size() > 0 ? ((DynamicObject)collect.get(0)).getBigDecimal("amount") : BigDecimal.ZERO;
            if (curPeriodAmount.compareTo(BigDecimal.ZERO) != 0) {
                listSchemeDyn.set("curamortamount", (Object)curPeriodAmount);
                return;
            }
            listSchemeDyn.set("curamortamount", (Object)this.calculateCurPeriodAmount(dbSchemeDyn, bookInfo));
        }

        private BigDecimal calculateCurPeriodAmount(DynamicObject dbSchemeDyn, AccountBookInfo bookInfo) {
            Date dateBegin = null;
            Date dateEnd = null;
            long endPeriodId = 0L;
            DynamicObject startPeriodDyn = dbSchemeDyn.getDynamicObject("startperiod");
            if (AmortStyle.DATE.getValue().equals(dbSchemeDyn.getString("amortstyle"))) {
                dateBegin = dbSchemeDyn.getDate("begindate");
                dateEnd = dbSchemeDyn.getDate("enddate");
                if (dateEnd == null || dateBegin == null) {
                    return BigDecimal.ZERO;
                }
                DynamicObject endPeriod = GLUtil.getPeriodByDate((Date)dateEnd, (long)bookInfo.getPeriodTypeId(), (Boolean)false);
                if (endPeriod != null) {
                    endPeriodId = endPeriod.getLong("id");
                }
            } else {
                endPeriodId = GLUtil.getMaxPeriodIdByCount((long)startPeriodDyn.getLong("id"), (int)(dbSchemeDyn.getInt("planperiod") + dbSchemeDyn.getInt("amortperiod")));
            }
            long curPeriodId = bookInfo.getCurPeriodId();
            List amortizablePeriodIds = VoucherAmortSchemeUtils.getPeriodIds((Long)startPeriodDyn.getLong("id"), (Long)endPeriodId);
            if (!amortizablePeriodIds.contains(curPeriodId)) {
                return BigDecimal.ZERO;
            }
            BigDecimal curPeriodAmount = dbSchemeDyn.getBigDecimal("periodamortamount");
            if (AmortStyle.DATE.getValue().equals(dbSchemeDyn.getString("amortstyle"))) {
                if (endPeriodId == curPeriodId) {
                    BigDecimal total = dbSchemeDyn.getBigDecimal("totalamount");
                    total = total != null ? total : BigDecimal.ZERO;
                    BigDecimal amortAmountVal = dbSchemeDyn.getBigDecimal("amortamount");
                    amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
                    curPeriodAmount = total.subtract(amortAmountVal);
                } else {
                    BigDecimal curAmortPeriod = VoucherAmortSchemeUtils.getCurPeriodAmortPeriod((DynamicObject)startPeriodDyn, (Long)curPeriodId, (Long)endPeriodId, (BigDecimal)dbSchemeDyn.getBigDecimal("planperiod"), (Date)dateBegin, (Date)dateEnd);
                    curPeriodAmount = curPeriodAmount.multiply(curAmortPeriod);
                }
            }
            return curPeriodAmount;
        }
    }
}

