/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.EntryMergeop;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.PermissonType;

public class VoucherConvertRuleEdit
extends AbstractBillPlugIn
implements CellClickListener {
    private static final String GL_VOUCHER_RULECONDITION = "gl_voucher_rulecondition";
    private static final String GL_ENTRY_MERGEOP = "gl_entry_mergeop";
    private static final String GL_VOUCHER_FILTER = "gl_voucher_filter";
    private static final String ORG = "org";
    protected static final String ID = "id";
    protected static final String MASTERID = "masterid";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String STATUS = "status";
    protected static final String CREATOR = "creator";
    protected static final String MODIFIER = "modifier";
    protected static final String ENABLE = "enable";
    protected static final String CREATETIME = "createtime";
    protected static final String MODIFYTIME = "modifytime";
    protected static final String CREATEORG = "createorg";
    protected static final String USEORG = "useorg";
    protected static final String CTRLSTRATEGY = "ctrlstrategy";
    protected static final String TARGETACCBOOKTYPE = "targetaccbooktype";
    protected static final String VOUCHERFILTER = "voucherfilter";
    protected static final String TARGETSTATUS = "targetstatus";
    protected static final String ENTRYMERGEDESC = "entrymergedesc";
    protected static final String EXEWAY = "exeway";
    protected static final String STRIKEOPRE = "strikeopre";
    protected static final String SOURCEACCBOOKTYPE = "sourceaccbooktype";
    protected static final String VOUCHERFILTERJSON = "voucherfilterjson";
    protected static final String ENTRYMERGE = "entrymerge";
    protected static final String PERIODTYPE = "periodtype";
    protected static final String SRCACCTABLE = "srcacctable";
    protected static final String _ID = "_id";
    protected static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String ISENTITYORG = "isEntityOrg";
    private static final String ISMERGEENTRY = "ismergeentry";
    private static final String ISCROSSORGSYN = "iscrossorgsyn";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FLEX_CROSSORGREF = "crossorgrefflex";
    private static final String OPTION_IS_SAVE_CONFIRM = "option_is_save_confirm";
    private static final String CALLBACK_SAVE = "callback_save";
    private final List<ComboItem> targetStatusComboList = Arrays.asList(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"VoucherConvertRuleEdit_15", (String)"fi-gl-formplugin", (Object[])new Object[0])), "A"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"VoucherConvertRuleEdit_16", (String)"fi-gl-formplugin", (Object[])new Object[0])), "B"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"VoucherConvertRuleEdit_17", (String)"fi-gl-formplugin", (Object[])new Object[0])), "C"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u8fc7\u8d26", (String)"VoucherConvertRuleEdit_18", (String)"fi-gl-formplugin", (Object[])new Object[0])), "D"));

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{VOUCHERFILTER, ENTRYMERGEDESC});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        this.getModel().setValue(USEORG, map.get(ORG));
        this.getModel().setValue(SOURCEACCBOOKTYPE, map.get(SOURCEACCBOOKTYPE));
        this.getPageCache().put(ORG, "" + map.get(ORG));
        Long acctTableId = this.getacctTableId(map);
        this.getView().setVisible(Boolean.FALSE, new String[]{STRIKEOPRE});
        this.getModel().setValue(SRCACCTABLE, (Object)acctTableId);
        Boolean isEntityOrg = VoucherConvertRuleEdit.isEntityOrg(Long.parseLong(map.get(ORG) + ""));
        this.getPageCache().put(ISENTITYORG, isEntityOrg.toString());
    }

    private Long getacctTableId(Map<String, Object> map) {
        QFilter orgFilter = new QFilter("org.id", "=", (Object)Long.valueOf(map.get(ORG) + ""));
        QFilter bookTypeFilter = new QFilter("bookstype.id", "=", map.get(SOURCEACCBOOKTYPE));
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id accounttableid", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
        if (dyn != null) {
            return dyn.getLong("accounttableid");
        }
        return 0L;
    }

    private static boolean isEntityOrg(long orgid) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"isbizunit", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)orgid)});
        for (DynamicObject dyn : dyns) {
            if (!dyn.getBoolean("isbizunit")) continue;
            return true;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        BasedataEdit sourceOrgEdit = (BasedataEdit)this.getControl("sourceorg");
        sourceOrgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = param.getListFilterParameter();
            ArrayList<QFilter> qFilters = listFilterParameter.getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(1);
                listFilterParameter.setQFilters(qFilters);
            }
            List pkSet = AccSysUtil.getAcctOrgPkList((String)GL_VOUCHER_RULECONDITION, (boolean)false, (PermissonType)PermissonType.VIEW);
            qFilters.add(new QFilter(ID, "in", (Object)pkSet));
        });
        BasedataEdit targetOrgEdit = (BasedataEdit)this.getControl("targetorg");
        targetOrgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            ArrayList<QFilter> qFilters = listFilterParameter.getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(1);
                listFilterParameter.setQFilters(qFilters);
            }
            List pkSet = AccSysUtil.getAcctOrgPkList((String)GL_VOUCHER_RULECONDITION, (boolean)false, (PermissonType)PermissonType.VIEW);
            qFilters.add(new QFilter(ID, "in", (Object)pkSet));
        });
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (VOUCHERFILTER.equals(ctlSource.getKey())) {
            this.showVoucherFilterForm();
        } else if (ENTRYMERGEDESC.equals(ctlSource.getKey())) {
            this.showEntryMergeForm();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "exeway": {
                String exeway = this.getModel().getValue(EXEWAY) + "";
                this.getView().setVisible(Boolean.valueOf("ontime".equals(exeway)), new String[]{STRIKEOPRE});
                this.setTargetStatusItem();
                this.getModel().setValue(TARGETSTATUS, null);
                break;
            }
            case "voucherfilter": {
                if (StringUtils.isEmpty((CharSequence)(e.getChangeSet()[0].getNewValue() + ""))) {
                    this.getModel().setValue(VOUCHERFILTERJSON, (Object)"{\"filterRow\":[]}");
                }
            }
            case "entrymergedesc": {
                if (StringUtils.isEmpty((CharSequence)(e.getChangeSet()[0].getNewValue() + ""))) {
                    this.getModel().setValue(ENTRYMERGE, null);
                }
            }
            case "ismergeentry": {
                String isMergeEntry = (String)this.getModel().getValue(ISMERGEENTRY);
                if (isMergeEntry == null || "A".equals(isMergeEntry)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTRYMERGEDESC});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRYMERGEDESC});
                break;
            }
            case "iscrossorgsyn": {
                boolean isCrossOrgSyn = (Boolean)this.getModel().getValue(ISCROSSORGSYN);
                if (isCrossOrgSyn) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_CROSSORGREF});
                    this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 6);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_CROSSORGREF});
                this.getModel().deleteEntryData(ENTRYENTITY);
                break;
            }
            case "strikeopre": {
                this.setTargetStatusItem();
                this.reSetTargetStatus();
                break;
            }
        }
    }

    private void setTargetStatusItem() {
        Object exeWayValue = this.getModel().getValue(EXEWAY);
        String opValue = (String)this.getModel().getValue(STRIKEOPRE);
        ComboItem postComboItem = this.targetStatusComboList.get(3);
        if ("ontime".equals(exeWayValue) && "audit".equals(opValue)) {
            postComboItem.setDisable(true);
        } else {
            postComboItem.setDisable(false);
        }
        ComboEdit targetStatusCtrl = (ComboEdit)this.getControl(TARGETSTATUS);
        targetStatusCtrl.setComboItems(this.targetStatusComboList);
    }

    private void reSetTargetStatus() {
        String opValue = (String)this.getModel().getValue(STRIKEOPRE);
        String statusValue = (String)this.getModel().getValue(TARGETSTATUS);
        if ("audit".equals(opValue) && "D".equals(statusValue)) {
            this.getModel().setValue(TARGETSTATUS, null);
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        String isMergeEntry = (String)model.getValue(ISMERGEENTRY);
        if (isMergeEntry == null || "".equals(isMergeEntry)) {
            model.setValue(ISMERGEENTRY, (Object)"A");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String exeway = model.getValue(EXEWAY) + "";
        this.getView().setVisible(Boolean.valueOf("ontime".equals(exeway)), new String[]{STRIKEOPRE});
        this.getPageCache().put(ORG, "" + this.getModel().getValue("useorg_id"));
        Boolean isEntityOrg = VoucherConvertRuleEdit.isEntityOrg(Long.parseLong(this.getModel().getValue("useorg_id") + ""));
        this.getPageCache().put(ISENTITYORG, isEntityOrg.toString());
        String ismergeentry = (String)model.getValue(ISMERGEENTRY);
        if ("B".equals(ismergeentry)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRYMERGEDESC});
        }
        this.getModel().setDataChanged(false);
        boolean isCrossOrgSyn = (Boolean)this.getModel().getValue(ISCROSSORGSYN);
        if (!isCrossOrgSyn) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_CROSSORGREF});
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
        this.setTargetStatusItem();
    }

    private void showEntryMergeForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(GL_ENTRY_MERGEOP);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entryMerge = (String)this.getModel().getValue(ENTRYMERGE);
        showParameter.setCustomParam(ENTRYMERGE, (Object)entryMerge);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTRYMERGE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showVoucherFilterForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(GL_VOUCHER_FILTER);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String voucherfilter = (String)this.getModel().getValue(VOUCHERFILTERJSON);
        Long srcacctableid = (Long)this.getModel().getValue("srcacctable_id");
        showParameter.setCustomParam(VOUCHERFILTERJSON, (Object)voucherfilter);
        showParameter.setCustomParam(SRCACCTABLE, (Object)srcacctableid);
        Long orgId = (Long)this.getModel().getValue("useorg_id");
        showParameter.setCustomParam(ORG, (Object)orgId);
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)((Long)this.getModel().getValue("useorg_id")), (long)((Long)this.getModel().getValue("sourceaccbooktype_id")));
        if (accountBook != null) {
            showParameter.setCustomParam(PERIODTYPE, (Object)accountBook.getPeriodTypeId());
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VOUCHERFILTER);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            String actionId = closedCallBackEvent.getActionId();
            if (ENTRYMERGE.equals(actionId)) {
                String str = (String)closedCallBackEvent.getReturnData();
                this.getModel().setValue(ENTRYMERGE, (Object)str);
                if (!StringUtils.isEmpty((CharSequence)str)) {
                    EntryMergeop entryMergeop = (EntryMergeop)SerializationUtils.fromJsonString((String)str, EntryMergeop.class);
                    String desc = this.getDesc(entryMergeop);
                    this.getModel().setValue(ENTRYMERGEDESC, (Object)desc);
                }
            } else if (VOUCHERFILTER.equals(actionId)) {
                Map dataMap = (Map)closedCallBackEvent.getReturnData();
                String desc = (String)dataMap.get(VOUCHERFILTER);
                desc = desc.replaceAll("        ", "  ");
                this.getModel().setValue(VOUCHERFILTERJSON, dataMap.get(VOUCHERFILTERJSON));
                this.getModel().setValue(VOUCHERFILTER, (Object)desc);
            }
        }
    }

    public String getDesc(EntryMergeop entryMergeop) {
        boolean pricediff;
        boolean dcdiff;
        StringBuilder sb = new StringBuilder();
        boolean despdiff = entryMergeop.isDespdiff();
        if (despdiff) {
            sb.append(ResManager.loadKDString((String)"\u6458\u8981\u4e0d\u540c\uff0c\u5141\u8bb8\u5408\u5e76\u3002", (String)"VoucherConvertRuleEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (dcdiff = entryMergeop.isDcdiff()) {
            sb.append(ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411\u4e0d\u540c\uff0c\u5141\u8bb8\u5408\u5e76\u3002", (String)"VoucherConvertRuleEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        if (pricediff = entryMergeop.isPricediff()) {
            sb.append(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u540c\uff0c\u5141\u8bb8\u5408\u5e76\u53cd\u7b97\u3002", (String)"VoucherConvertRuleEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        if ("save".equals(source.getOperateKey())) {
            boolean isConfirm;
            DynamicObject[] dynamicObjectArray;
            String exeway = this.getModel().getValue(EXEWAY) + "";
            Object strikeopre = this.getModel().getValue(STRIKEOPRE);
            if ("ontime".equals(exeway) && strikeopre == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u65b9\u5f0f\u9009\u62e9\u7684\u662f\u5b9e\u65f6\uff0c\u8bf7\u9009\u62e9\u89e6\u53d1\u64cd\u4f5c\u3002", (String)"VoucherConvertRuleEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Long orgId = (Long)this.getModel().getValue("org_id");
            Long id = (Long)this.getModel().getValue(ID);
            Long sourceAccountBookTypeId = (Long)this.getModel().getValue("sourceaccbooktype_id");
            DynamicObjectCollection targetAccountBookTypes = (DynamicObjectCollection)this.getModel().getValue(TARGETACCBOOKTYPE);
            ArrayList<Long> targetAccountBookTypeIds = new ArrayList<Long>(targetAccountBookTypes.size());
            for (DynamicObject targetAccountBook : targetAccountBookTypes) {
                targetAccountBookTypeIds.add(targetAccountBook.getLong(FBASEDATAID_ID));
            }
            HashMap<Long, String> orgIdAndNames = new HashMap<Long, String>(16);
            HashMap<Long, Set> sourceOrgAndTargetOrgs = new HashMap<Long, Set>(16);
            DynamicObjectCollection entries = (DynamicObjectCollection)this.getModel().getValue(ENTRYENTITY);
            boolean iscrossorgsyn = (Boolean)this.getModel().getValue(ISCROSSORGSYN);
            if (iscrossorgsyn) {
                DynamicObject[] synration;
                Object sourceorg;
                int i;
                for (i = entries.size() - 1; i >= 0; --i) {
                    DynamicObject entry2 = (DynamicObject)entries.get(i);
                    sourceorg = entry2.getDynamicObject("sourceorg");
                    DynamicObject dynamicObject = entry2.getDynamicObject("targetorg");
                    synration = entry2.getBigDecimal("synration");
                    if (sourceorg != null || dynamicObject != null || synration.compareTo(BigDecimal.ZERO) != 0) continue;
                    entries.remove(i);
                }
                for (i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    sourceorg = entry.getDynamicObject("sourceorg");
                    DynamicObject dynamicObject = entry.getDynamicObject("targetorg");
                    synration = entry.getBigDecimal("synration");
                    if (sourceorg == null && dynamicObject == null && synration.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (sourceorg == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u7b2c%s\u884c\uff0c\u6e90\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherConvertRuleEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                        return;
                    }
                    if (dynamicObject == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u7b2c%s\u884c\uff0c\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherConvertRuleEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                        return;
                    }
                    if (synration.compareTo(BigDecimal.ZERO) == 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u7b2c%s\u884c\uff0c\u534f\u540c\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\u3002", (String)"VoucherConvertRuleEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                        return;
                    }
                    if (synration.compareTo(BigDecimal.ZERO) >= 0) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u7b2c%s\u884c\uff0c\u534f\u540c\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"VoucherConvertRuleEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), i + 1));
                    args.setCancel(true);
                    return;
                }
                for (DynamicObject entry : entries) {
                    sourceOrgAndTargetOrgs.computeIfAbsent(entry.getDynamicObject("sourceorg").getLong(ID), k -> new HashSet(10)).add(entry.getDynamicObject("targetorg").getLong(ID));
                    orgIdAndNames.put(entry.getDynamicObject("sourceorg").getLong(ID), entry.getDynamicObject("sourceorg").getString(NAME));
                    orgIdAndNames.put(entry.getDynamicObject("targetorg").getLong(ID), entry.getDynamicObject("targetorg").getString(NAME));
                }
                Set sourceOrgIds = sourceOrgAndTargetOrgs.keySet();
                HashSet targetOrgIds = new HashSet(16);
                for (Map.Entry entry : sourceOrgAndTargetOrgs.entrySet()) {
                    targetOrgIds.addAll((Collection)entry.getValue());
                }
                if (sourceOrgIds.size() == 0 || targetOrgIds.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u81f3\u5c11\u6709\u4e00\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherConvertRuleEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (targetAccountBookTypeIds.contains(sourceAccountBookTypeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u7ec4\u7ec7\u8d26\u7c3f\u534f\u540c\u65f6\uff0c\u6e90\u8d26\u7c3f\u7c7b\u578b\u4e0e\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"VoucherConvertRuleEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)GL_VOUCHER_RULECONDITION, (Long)orgId));
            if (id != 0L) {
                filters.add(new QFilter(ID, "!=", (Object)id));
            }
            DynamicObject sourceBookType = (DynamicObject)this.getModel().getValue(SOURCEACCBOOKTYPE);
            filters.add(new QFilter(SOURCEACCBOOKTYPE, "=", (Object)sourceBookType.getLong(ID)));
            ArrayList<String> selectFields = new ArrayList<String>(10);
            selectFields.add(TARGETACCBOOKTYPE);
            selectFields.add(ISCROSSORGSYN);
            selectFields.add("entryentity.sourceorg");
            selectFields.add("entryentity.targetorg");
            selectFields.add("entryentity.synration");
            for (DynamicObject dbRule : dynamicObjectArray = BusinessDataServiceHelper.load((String)GL_VOUCHER_RULECONDITION, (String)String.join((CharSequence)",", selectFields), (QFilter[])filters.toArray(new QFilter[0]))) {
                for (Long l : targetAccountBookTypeIds) {
                    DynamicObjectCollection dbTargetAccountBookTypes = dbRule.getDynamicObjectCollection(TARGETACCBOOKTYPE);
                    Iterator iterator = dbTargetAccountBookTypes.iterator();
                    while (iterator.hasNext()) {
                        long dbTargetOrgId;
                        long dbSourceOrgId;
                        DynamicObjectCollection dbEntries;
                        DynamicObject dbTargetAccountBookType = (DynamicObject)iterator.next();
                        if (l.longValue() != dbTargetAccountBookType.getLong(FBASEDATAID_ID)) continue;
                        boolean dbIsCrossorgsyn = dbRule.getBoolean(ISCROSSORGSYN);
                        if (iscrossorgsyn && dbIsCrossorgsyn) {
                            dbEntries = dbRule.getDynamicObjectCollection(ENTRYENTITY);
                            for (DynamicObject dbEntryRow : dbEntries) {
                                dbSourceOrgId = dbEntryRow.getDynamicObject("sourceorg").getLong(ID);
                                dbTargetOrgId = dbEntryRow.getDynamicObject("targetorg").getLong(ID);
                                if (!sourceOrgAndTargetOrgs.containsKey(dbSourceOrgId) || !((Set)sourceOrgAndTargetOrgs.get(dbSourceOrgId)).contains(dbTargetOrgId)) continue;
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728[\u6e90\u6838\u7b97\u7ec4\u7ec7:%1$s,\u6e90\u8d26\u7c3f\u7c7b\u578b:%2$s]\u5230[\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7:%3$s,\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b:%4$s]\u7684\u6298\u7b97\u89c4\u5219\u3002", (String)"VoucherConvertRuleEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), dbEntryRow.getDynamicObject("sourceorg").getString(NAME), sourceBookType.getString(NAME), dbEntryRow.getDynamicObject("targetorg").getString(NAME), dbTargetAccountBookType.getDynamicObject("fbasedataid").getString(NAME)));
                                args.setCancel(true);
                                return;
                            }
                        } else if (iscrossorgsyn && !dbIsCrossorgsyn) {
                            if (sourceOrgAndTargetOrgs.containsKey(orgId) && ((Set)sourceOrgAndTargetOrgs.get(orgId)).contains(orgId)) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728[\u6e90\u6838\u7b97\u7ec4\u7ec7:%1$s,\u6e90\u8d26\u7c3f\u7c7b\u578b:%2$s]\u5230[\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7:%3$s,\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b:%4$s]\u7684\u6298\u7b97\u89c4\u5219\u3002", (String)"VoucherConvertRuleEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), org.getString(NAME), sourceBookType.getString(NAME), org.getString(NAME), dbTargetAccountBookType.getDynamicObject("fbasedataid").getString(NAME)));
                                args.setCancel(true);
                                return;
                            }
                        } else if (!iscrossorgsyn && dbIsCrossorgsyn) {
                            dbEntries = dbRule.getDynamicObjectCollection(ENTRYENTITY);
                            for (DynamicObject dbEntryRow : dbEntries) {
                                dbSourceOrgId = dbEntryRow.getDynamicObject("sourceorg").getLong(ID);
                                dbTargetOrgId = dbEntryRow.getDynamicObject("targetorg").getLong(ID);
                                if (orgId != dbSourceOrgId || orgId != dbTargetOrgId) continue;
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728[\u6e90\u6838\u7b97\u7ec4\u7ec7:%1$s,\u6e90\u8d26\u7c3f\u7c7b\u578b:%2$s]\u5230[\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7:%3$s,\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b:%4$s]\u7684\u6298\u7b97\u89c4\u5219\u3002", (String)"VoucherConvertRuleEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), dbEntryRow.getDynamicObject("sourceorg").getString(NAME), sourceBookType.getString(NAME), dbEntryRow.getDynamicObject("targetorg").getString(NAME), dbTargetAccountBookType.getDynamicObject("fbasedataid").getString(NAME)));
                                args.setCancel(true);
                                return;
                            }
                        } else if (!iscrossorgsyn && !dbIsCrossorgsyn) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728[\u6e90\u6838\u7b97\u7ec4\u7ec7:%1$s,\u6e90\u8d26\u7c3f\u7c7b\u578b:%2$s]\u5230[\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7:%3$s,\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b:%4$s]\u7684\u6298\u7b97\u89c4\u5219\u3002", (String)"VoucherConvertRuleEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), org.getString(NAME), sourceBookType.getString(NAME), org.getString(NAME), dbTargetAccountBookType.getDynamicObject("fbasedataid").getString(NAME)));
                            args.setCancel(true);
                            return;
                        }
                        dbEntries = dbRule.getDynamicObjectCollection(ENTRYENTITY);
                        for (DynamicObject dbEntryRow : dbEntries) {
                            dbSourceOrgId = dbEntryRow.getDynamicObject("sourceorg").getLong(ID);
                            dbTargetOrgId = dbEntryRow.getDynamicObject("targetorg").getLong(ID);
                            if (!sourceOrgAndTargetOrgs.containsKey(dbSourceOrgId) || !((Set)sourceOrgAndTargetOrgs.get(dbSourceOrgId)).contains(dbTargetOrgId)) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728[\u6e90\u6838\u7b97\u7ec4\u7ec7:%1$s,\u6e90\u8d26\u7c3f\u7c7b\u578b:%2$s]\u5230[\u76ee\u6807\u6838\u7b97\u7ec4\u7ec7:%3$s,\u76ee\u6807\u8d26\u7c3f\u7c7b\u578b:%4$s]\u7684\u6298\u7b97\u89c4\u5219\u3002", (String)"VoucherConvertRuleEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), dbEntryRow.getDynamicObject("sourceorg").getString(NAME), sourceBookType.getString(NAME), dbEntryRow.getDynamicObject("targetorg").getString(NAME), dbTargetAccountBookType.getDynamicObject("fbasedataid").getString(NAME)));
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            }
            if (iscrossorgsyn) {
                DynamicObject sourceAccBookType;
                HashSet<Long> sourceOrgIds = new HashSet<Long>(sourceOrgAndTargetOrgs.keySet());
                Optional<String> sourceErrorMsgOp = this.checkIsExistBook(sourceOrgIds, Collections.singletonList((sourceAccBookType = (DynamicObject)this.getModel().getValue(SOURCEACCBOOKTYPE)).getLong(ID)), orgIdAndNames);
                if (sourceErrorMsgOp.isPresent()) {
                    this.getView().showTipNotification(sourceErrorMsgOp.get());
                    args.setCancel(true);
                    return;
                }
                Iterator targetOrgIds = new HashSet(16);
                for (Map.Entry entry : sourceOrgAndTargetOrgs.entrySet()) {
                    targetOrgIds.addAll((Collection)entry.getValue());
                }
                Optional<String> optional = this.checkIsExistBook((Set<Long>)((Object)targetOrgIds), (List<Long>)targetAccountBookTypeIds, (Map<Long, String>)orgIdAndNames);
                if (optional.isPresent()) {
                    this.getView().showTipNotification(optional.get());
                    args.setCancel(true);
                    return;
                }
            }
            if (iscrossorgsyn && !(isConfirm = ((Save)source).getOption().containsVariable(OPTION_IS_SAVE_CONFIRM))) {
                DynamicObject sourceAccBookType = (DynamicObject)this.getModel().getValue(SOURCEACCBOOKTYPE);
                HashMap<Long, Map> sourceAndTargetOrgTimes = new HashMap<Long, Map>(16);
                for (DynamicObject dynamicObject : entries) {
                    DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("sourceorg");
                    sourceAndTargetOrgTimes.computeIfAbsent(dynamicObject2.getLong(ID), k -> new HashMap()).compute(dynamicObject.getDynamicObject("targetorg").getLong(ID), (k, v) -> v == null || v == 0 ? 1 : v + 1);
                }
                for (Map.Entry entry : sourceAndTargetOrgTimes.entrySet()) {
                    Map map = (Map)entry.getValue();
                    for (Map.Entry entry2 : map.entrySet()) {
                        if ((Integer)entry2.getValue() <= 1) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u534f\u540c\u7ec4\u7ec7\u6620\u5c04\u5206\u5f55\u884c[%1$s]\u534f\u540c\u5230[%2$s]\u5b58\u5728\u91cd\u590d\uff0c\u91cd\u590d\u884c\u6570\u4e3a[%3$d]\uff0c\u8d85\u8fc71\u884c\uff0c\u8bf7\u8bbe\u7f6e\u8c03\u6574\u4e3a1\u884c\u3002", (String)"VoucherConvertRuleEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgIdAndNames.get(entry.getKey()), orgIdAndNames.get(entry2.getKey()), entry2.getValue()));
                        args.setCancel(true);
                        return;
                    }
                }
                HashMap<Long, Tuple> sourceAndTargetOrgsSynration = new HashMap<Long, Tuple>(16);
                for (DynamicObject dynamicObject : entries) {
                    DynamicObject sourceorg = dynamicObject.getDynamicObject("sourceorg");
                    Tuple tuple = sourceAndTargetOrgsSynration.computeIfAbsent(sourceorg.getLong(ID), k -> new Tuple((Object)BigDecimal.ZERO, new ArrayList(10)));
                    tuple.item1 = ((BigDecimal)tuple.item1).add(dynamicObject.getBigDecimal("synration"));
                    ((List)tuple.item2).add(dynamicObject.getDynamicObject("targetorg").getLong(ID));
                }
                for (Map.Entry entry : sourceAndTargetOrgsSynration.entrySet()) {
                    if (((BigDecimal)((Tuple)entry.getValue()).item1).compareTo(new BigDecimal(100)) <= 0) continue;
                    ArrayList<String> targetAccountBookTypeNames = new ArrayList<String>(targetAccountBookTypes.size());
                    for (DynamicObject targetAccountBook : targetAccountBookTypes) {
                        targetAccountBookTypeNames.add(targetAccountBook.getDynamicObject("fbasedataid").getString(NAME));
                    }
                    List list = (List)((Tuple)entry.getValue()).item2;
                    ArrayList targetOrgNames = new ArrayList(list.size());
                    for (Long targetOrgId : list) {
                        targetOrgNames.add(orgIdAndNames.get(targetOrgId));
                    }
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"[%1$s%2$s]\u534f\u540c\u5230[%3$s%4$s]\u7684\u6bd4\u4f8b\u8d85\u8fc7100%%\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"VoucherConvertRuleEdit_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgIdAndNames.get(entry.getKey()), sourceAccBookType.getString(NAME), String.join((CharSequence)MultiLangPunc.comma(), targetOrgNames), String.join((CharSequence)MultiLangPunc.comma(), targetAccountBookTypeNames)), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_SAVE, (IFormPlugin)this));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private Optional<String> checkIsExistBook(Set<Long> orgIds, List<Long> bookTypeIds, Map<Long, String> orgIdAndNames) {
        if (orgIds.isEmpty() || bookTypeIds.isEmpty()) {
            return Optional.empty();
        }
        SqlBuilder sqlBuilder = new SqlBuilder().appendIn("SELECT DISTINCT(FORGID) AS FORGID FROM T_BD_ACCOUNTBOOKS WHERE FORGID", orgIds.toArray()).appendIn("AND FBOOKSTYPEID", bookTypeIds.toArray());
        Set emptyOrgIds = (Set)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, rs -> {
            while (rs.next()) {
                orgIds.remove(rs.getLong("FORGID"));
            }
            return orgIds;
        });
        if (emptyOrgIds.isEmpty()) {
            return Optional.empty();
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = orgIds.stream().map(orgIdAndNames::get).collect(Collectors.joining(MultiLangPunc.comma()));
        return Optional.of(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u4e0b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"VoucherConvertRuleEdit_12", (String)GLApp.instance.formpluginModule(), (Object[])objectArray));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CALLBACK_SAVE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPTION_IS_SAVE_CONFIRM, "true");
            this.getView().invokeOperation("save", operateOption);
        }
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

