/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.accountbook;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.util.AccountBookUtil;
import kd.fi.gl.util.GLUtil;

public class ImportGLAccountBook
extends AbstractBillPlugIn {
    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map map = e.getSourceData();
        try {
            Map voucherTypeMap;
            Map periodtypeMap = (Map)map.get("periodtype");
            if (null != periodtypeMap) {
                String periodtypeNum = (String)periodtypeMap.get("number");
                DynamicObject periodBase = this.queryOneOrThrow("bd_period_type", "periodtype", periodtypeNum, new QFilter("number", "=", (Object)periodtypeNum).toArray());
                Object periodTypeId = periodBase.get("id");
                Map startperiodMap = (Map)map.get("startperiod");
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
                QFilter periodtype = new QFilter("periodtype", "=", periodTypeId);
                qFilterList.add(periodtype);
                if (null != startperiodMap && !((String)startperiodMap.get("number")).isEmpty()) {
                    Map cashInitPeriodMap;
                    QFilter qFilter = new QFilter("number", "=", startperiodMap.get("number"));
                    qFilterList.add(qFilter);
                    QFilter[] qFilters = new QFilter[qFilterList.size()];
                    DynamicObject period = this.queryOneOrThrow("bd_period", "startperiod", (String)startperiodMap.get("number"), qFilterList.toArray(qFilters));
                    startperiodMap.put("id", period.get("id").toString());
                    startperiodMap.put("importprop", "id");
                    Map curperiodMap = (Map)map.get("curperiod");
                    if (null != curperiodMap) {
                        curperiodMap.put("id", period.get("id").toString());
                        curperiodMap.put("importprop", "id");
                    }
                    if ((cashInitPeriodMap = (Map)map.get("cashinitperiod")) != null && !((String)cashInitPeriodMap.get("number")).isEmpty()) {
                        QFilter numberFilter = new QFilter("number", "=", cashInitPeriodMap.get("number"));
                        DynamicObject cashflowPeriod = this.queryOneOrThrow("bd_period", "cashinitperiod", (String)cashInitPeriodMap.get("number"), periodtype, numberFilter);
                        cashInitPeriodMap.put("id", cashflowPeriod.get("id").toString());
                        cashInitPeriodMap.put("importprop", "id");
                    }
                } else {
                    map.put("cashinitperiod", null);
                }
            }
            Map yearprofitacctMap = (Map)map.get("yearprofitacct");
            Map accounttableMap = (Map)map.get("accounttable");
            String accounttableNum = (String)accounttableMap.get("number");
            DynamicObject accounttable = this.queryOneOrThrow("bd_accounttable", "accounttable", accounttableNum, new QFilter("number", "=", (Object)accounttableNum).toArray());
            long acctTableID = accounttable.getLong("id");
            long orgId = this.getOrgIdByNumber((String)((Map)map.get("org")).get("number"));
            Map accountingsys = (Map)map.get("accountingsys");
            QFilter[] qf1 = new QFilter[]{new QFilter("accountingsys.number", "=", accountingsys.get("number")), new QFilter("ismainview", "=", (Object)"1")};
            DynamicObject mainSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])qf1);
            if (mainSys != null) {
                String viewIdStr = mainSys.getString("id");
                boolean leaf = OrgServiceHelper.isLeaf((long)orgId, (long)Long.parseLong(viewIdStr));
                if (leaf) {
                    Map startperiodMap = (Map)map.get("startperiod");
                    if (startperiodMap == null || startperiodMap.get("id") == null || StringUtils.isEmpty((String)((String)startperiodMap.get("id")))) {
                        String propName = this.getModel().getDataEntityType().getProperty("startperiod").getDisplayName().getLocaleValue();
                        String orgnumber = (String)((Map)map.get("org")).get("number");
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u660e\u7ec6\u7ec4\u7ec7\uff0c\u542f\u7528\u671f\u95f4\u4e3a\u5fc5\u586b\u9879\u3002", (String)"ImportGLAccountBook_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), propName, orgnumber));
                    }
                } else {
                    map.remove("cashinitperiod");
                    map.remove("defaultvouchertype");
                    map.remove("localsetdate");
                    map.remove("localset");
                    map.remove("startperiod");
                    map.remove("curperiod");
                    map.remove("yearprofitacct");
                    map.remove("o_entry");
                }
            }
            if (null != yearprofitacctMap) {
                String yearprofitacctNum = (String)yearprofitacctMap.get("number");
                QFilter baseDataF = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
                QFilter[] qf = new QFilter[]{new QFilter("number", "=", (Object)yearprofitacctNum), new QFilter("accounttable", "=", (Object)acctTableID), new QFilter("enable", "=", (Object)true), new QFilter("enddate", ">=", (Object)GLUtil.getEndDate()), baseDataF};
                DynamicObject accounttableBase = BusinessDataServiceHelper.loadSingle((String)"bd_accountview", (String)"id,isleaf,ischangecurrency", (QFilter[])qf);
                if (accounttableBase == null) {
                    throw this.throwNumberMissingException("yearprofitacct", "bd_accountview", yearprofitacctNum);
                }
                String entityName = EntityMetadataCache.getDataEntityType((String)"bd_accountview").getDisplayName().getLocaleValue();
                String propName = this.getModel().getDataEntityType().getProperty("yearprofitacct").getDisplayName().getLocaleValue();
                if (!accounttableBase.getBoolean("isleaf")) {
                    throw new IllegalStateException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7f16\u7801\u4e3a%2$s\u7684%3$s\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u3002", (String)"ImportGLAccountBook_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), propName, yearprofitacctNum, entityName));
                }
                if (accounttableBase.getBoolean("ischangecurrency")) {
                    throw new IllegalStateException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7f16\u7801\u4e3a%2$s\u7684%s\u52fe\u9009\u4e86\u671f\u672b\u8c03\u6c47\u3002", (String)"ImportGLAccountBook_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), propName, yearprofitacctNum, entityName));
                }
                yearprofitacctMap.put("id", accounttableBase.get("id").toString());
                yearprofitacctMap.put("importprop", "id");
            }
            if (null != (voucherTypeMap = (Map)map.get("defaultvouchertype"))) {
                String voucherTypeNumber = (String)voucherTypeMap.get("number");
                QFilter numberF = new QFilter("number", "=", (Object)voucherTypeNumber);
                QFilter vchTypeF = BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId);
                DynamicObject vchType = this.queryOneOrThrow("gl_vouchertype", "defaultvouchertype", voucherTypeNumber, numberF, vchTypeF);
                voucherTypeMap.put("id", vchType.get("id").toString());
                voucherTypeMap.put("importprop", "id");
            }
            Map currencyMap = (Map)map.get("basecurrency");
            String currencyNumber = (String)currencyMap.get("number");
            QFilter currencyF = new QFilter("number", "=", (Object)currencyNumber);
            QFilter enableF = new QFilter("enable", "=", (Object)true);
            DynamicObject currency = this.queryOneOrThrow("bd_currency", "basecurrency", currencyNumber, currencyF, enableF);
            currencyMap.put("id", currency.get("id").toString());
            currencyMap.put("importprop", "id");
            map.put("multiplechoiceorg", JSONObject.toJSON(map.get("org")));
            List curFields = AccountBookUtil.getCurFields();
            if (curFields.stream().anyMatch(field -> Objects.nonNull(map.get(field)))) {
                map.put("enablemullocalcur", true);
            }
        }
        catch (IllegalStateException ex) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(-1), Integer.valueOf(-1), ex.getMessage());
        }
    }

    private DynamicObject queryOneOrThrow(String entity, String prop, String number, QFilter ... filters) {
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])filters)).orElseThrow(() -> this.throwNumberMissingException(prop, entity, number));
    }

    private Long getOrgIdByNumber(String orgNumber) {
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject org = this.queryOneOrThrow("bos_org", "org", orgNumber, orgFilter);
        return org.getLong("id");
    }

    private IllegalStateException throwNumberMissingException(String prop, String entity, String missingNumber) {
        String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
        String propName = this.getModel().getDataEntityType().getProperty(prop).getDisplayName().getLocaleValue();
        return new IllegalStateException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u5b58\u5728\u542f\u7528\u7684\u7f16\u7801\u4e3a%2$s\u7684%3$s\u3002", (String)"ImportGLAccountBook_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), propName, missingNumber, entityName));
    }

    public void afterImportData(ImportDataEventArgs e) {
        if ("new".equals(e.getOption().get("importtype"))) {
            this.getModel().setValue("curperiod", this.getModel().getValue("startperiod"));
        }
    }
}

