/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cashflow;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.CashflowSumCalculator;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.BalanceCheckHelper;

class RecalCFSumThread
implements Runnable {
    private static final String PROGRESS = "progress";
    boolean recalAll = false;
    long orgId = 0L;
    long bookTypeId = 0L;
    long periodId = 0L;
    long curperiodId = 0L;
    long periodTypeId = 0L;
    IFormView view;
    Log log = LogFactory.getLog((String)"RecalCFSumThread");
    String hundred = "100";

    public RecalCFSumThread(long orgId, long bookTypeId, long periodId, long periodTypeId, long curperiodId, IFormView view, boolean recalAll) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.periodId = periodId;
        this.periodTypeId = periodTypeId;
        this.curperiodId = curperiodId;
        this.view = view;
        this.recalAll = recalAll;
    }

    @Override
    public void run() {
        try {
            if (this.recalAll) {
                long endperiodid = BalanceCheckHelper.getMaxCFPeriodId((long)this.orgId, (long)this.bookTypeId, (long)this.curperiodId);
                QFilter ftypeId = new QFilter("periodtype", "=", (Object)this.periodTypeId);
                QFilter fid1 = new QFilter("id", ">=", (Object)this.periodId);
                QFilter fid2 = new QFilter("id", "<=", (Object)endperiodid);
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");
                if (!col.isEmpty()) {
                    List<Long> ids = col.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                    this.calculate(this.orgId, this.bookTypeId, ids);
                    this.view.getPageCache().put(PROGRESS, this.hundred);
                } else {
                    this.view.getPageCache().put(PROGRESS, this.hundred);
                }
            } else {
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(this.periodId);
                this.calculate(this.orgId, this.bookTypeId, ids);
                this.view.getPageCache().put(PROGRESS, this.hundred);
            }
        }
        catch (Exception ex) {
            this.log.error((Throwable)ex);
        }
    }

    private boolean calculate(long orgId, long bookTypeId, List<Long> periodIds) {
        LockKey lockKey = LockKey.CashflowCal;
        return Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)lockKey, () -> {
            Throwable throwable;
            TXHandle txh;
            int count = 0;
            ICalculator calculator = CalculatorFactory.createCashflowCalculator();
            do {
                txh = TX.requiresNew();
                throwable = null;
                try {
                    count = calculator.calculate(orgId, bookTypeId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txh != null) {
                        if (throwable != null) {
                            try {
                                txh.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            txh.close();
                        }
                    }
                }
            } while (count > 0);
            txh = TX.requiresNew();
            throwable = null;
            try {
                try {
                    if (!periodIds.isEmpty()) {
                        BigDecimal total = new BigDecimal(periodIds.size());
                        int index = 1;
                        Iterator iterator = periodIds.iterator();
                        while (iterator.hasNext()) {
                            long id = (Long)iterator.next();
                            new CashflowSumCalculator().reCalculate(orgId, bookTypeId, id);
                            BigDecimal percent = new BigDecimal(index).divide(total, 2, RoundingMode.HALF_UP);
                            percent = percent.multiply(new BigDecimal(this.hundred)).setScale(0, RoundingMode.HALF_UP);
                            this.view.getPageCache().put(PROGRESS, percent.toPlainString());
                            ++index;
                        }
                    }
                }
                catch (Exception ex) {
                    txh.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        });
    }
}

