/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfext;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.cfversion.addassist.CfitemAddingAssistValidateTaskImpl;
import kd.fi.bd.cfversion.addassist.CfitemAssistAddingContext;
import kd.fi.bd.enhance.treetask.CfitemContext;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessHelper;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.CashflowItemOrgVo;
import kd.fi.bd.vo.CashflowItemVo;

public class CashflowAddingAssistTaskImpl
extends CfitemAddingAssistValidateTaskImpl {
    private static final Log LOG = LogFactory.getLog(CashflowAddingAssistTaskImpl.class);

    public List<TaskExecutionResult<CashflowItemOrgVo>> batchExecute(List<CfitemContext> taskContexts) {
        if (CollectionUtils.isEmpty(taskContexts)) {
            return Collections.EMPTY_LIST;
        }
        long tick = System.currentTimeMillis();
        List results = BatchProcessHelper.batchHandle((TaskType)TaskType.FIBD_CASHFLOWITEM_ADDING_ASSIST_TASK, taskContexts, x -> x.stream().map(this::execute).collect(Collectors.toList()));
        LOG.info("adding_assist_batch size: " + taskContexts.size() + " cost: " + (System.currentTimeMillis() - tick));
        return results;
    }

    public TaskExecutionResult<CashflowItemOrgVo> execute(CfitemContext taskContext) {
        long oneTick = System.currentTimeMillis();
        DynamicObject operationData = this.getOperationData(taskContext);
        CashflowItemOrgVo itemOrgPairVo = new CashflowItemOrgVo(operationData.getString("number"), Long.valueOf(operationData.getLong("useorg_id")));
        itemOrgPairVo.setItemId(Long.valueOf(operationData.getLong("id")));
        OperateOption option = OperateOption.create();
        OperationResult executeResult = this.executeOperation(option, operationData);
        LOG.info("adding_assist_one cost: " + (System.currentTimeMillis() - oneTick));
        if (!executeResult.isSuccess()) {
            String failedMsg = BDUtil.buildOperationResultFailedMsg((OperationResult)executeResult, (boolean)false);
            LOG.info(String.format("adding_assist_one node is : %s, execute failed msg is : %s", itemOrgPairVo.toString(), failedMsg));
            return TaskExecutionResult.failed((Object)itemOrgPairVo, (String)failedMsg);
        }
        LOG.info(String.format("adding_assist_one node is : %s, execute success", itemOrgPairVo.toString()));
        return TaskExecutionResult.succeed((Object)itemOrgPairVo, (String)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"AccountviewEdit_26", (String)"fi-bd-formplugin", (Object[])new Object[0]));
    }

    private OperationResult executeOperation(OperateOption option, DynamicObject ... accDynArray) {
        CashflowItemOptionVarManager.setIsVersion((OperateOption)option, (boolean)true);
        CashflowItemOptionVarManager.setAssistChange((OperateOption)option, (boolean)true);
        CashflowItemOptionVarManager.setBatchaddingAssist((OperateOption)option, (boolean)true);
        return OperationServiceHelper.executeOperate((String)"save", (String)"gl_cashflowitem", (DynamicObject[])accDynArray, (OperateOption)option);
    }

    private DynamicObject getOperationData(CfitemContext taskContext) {
        Tuple data = taskContext.getData();
        BiTreeNode cfItemNode = (BiTreeNode)data.item1;
        BiTreeNode orgNode = (BiTreeNode)data.item2;
        CfitemAssistAddingContext context = taskContext.getAssistAddingContext();
        Long orgId = (Long)orgNode.getId();
        Optional itemDyn = this.getCurrentCfitemObj(((CashflowItemVo)cfItemNode.getData()).getNumber(), orgId, context);
        Preconditions.checkState((boolean)itemDyn.isPresent());
        DynamicObject dbItemObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)itemDyn.get()).getPkValue(), (String)"gl_cashflowitem");
        List addingAssitList = context.getAddingAssitList();
        DynamicObjectCollection assistEntryCollection = dbItemObj.getDynamicObjectCollection("assistentry");
        Map<Long, DynamicObject> assistIdEntryMap = assistEntryCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstypeid.id"), x -> x));
        boolean isAssist = false;
        int seq = assistEntryCollection.size();
        for (AssistEntryVO assistEntry : addingAssitList) {
            long assistId = assistEntry.getId();
            DynamicObject assistDynObj = (DynamicObject)context.getAssistIdDynObjMap().get(assistId);
            if (assistDynObj == null) continue;
            DynamicObject entryDynObj = assistIdEntryMap.get(assistId);
            if (entryDynObj == null) {
                entryDynObj = assistEntryCollection.addNew();
                entryDynObj.set("seq", (Object)(++seq));
                entryDynObj.set("asstypeid", (Object)assistDynObj);
                entryDynObj.set("isrequire", (Object)assistEntry.isMustInput());
                entryDynObj.set("isdetail", (Object)assistEntry.isLeaf());
            } else {
                entryDynObj.set("isrequire", (Object)this.selectFirst(entryDynObj.getBoolean("isrequire"), assistEntry.isMustInput()));
                entryDynObj.set("isdetail", (Object)this.selectFirst(entryDynObj.getBoolean("isdetail"), assistEntry.isLeaf()));
            }
            isAssist = true;
        }
        if (isAssist) {
            dbItemObj.set("isassist", (Object)Boolean.TRUE);
        }
        DynamicObject orgDynObj = (DynamicObject)context.getOrgIdDynObjMap().get(orgId);
        dbItemObj.set("useorg", (Object)orgDynObj);
        dbItemObj.set("startdate", (Object)context.getVersionDate());
        LOG.info(String.format("call_adding_assist on org: %s, account(%s, %s) with: %s", orgDynObj.getLong("id"), dbItemObj.getLong("id"), dbItemObj.getString("number"), StringUtils.join((Object[])new DynamicObjectCollection[]{dbItemObj.getDynamicObjectCollection("assistentry")})));
        return dbItemObj;
    }

    private boolean selectFirst(boolean originValue, boolean waitingUpdateValue) {
        return originValue ? originValue : waitingUpdateValue;
    }
}

