/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.cfversion.addassist.CfitemAddingAssistValidateTaskImpl;
import kd.fi.bd.cfversion.addassist.CfitemAssistAddingContext;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enhance.treetask.CashflowAddingAssistAdapter;
import kd.fi.bd.enhance.treetask.CfitemContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskService;
import kd.fi.bd.enhance.treetask.TreeDepthFirstScheduleExecutor;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.CashflowItemOrgVo;
import kd.fi.bd.vo.CashflowItemVo;
import kd.fi.bd.vo.OrgVO;
import kd.fi.gl.formplugin.cfext.CashflowAddingAssistTaskImpl;

public class CashflowVersionSaveExtension {
    private static final Log LOG = LogFactory.getLog(CashflowVersionSaveExtension.class);
    public static final String PROP_FULL_CHILD = "_fullDependNodes";

    public static DependBiTreeNode<CfitemContext> executeAddAssistOp(CfitemAssistAddingContext assistAddingContext) {
        DependBiTreeNode taskTreeNode = assistAddingContext.getRootTask();
        TreeDepthFirstScheduleExecutor executor = new TreeDepthFirstScheduleExecutor(taskTreeNode);
        executor.execute((ITaskService)new CashflowAddingAssistTaskImpl());
        return taskTreeNode;
    }

    public static List<TaskExecutionResult<CashflowItemOrgVo>> executeValidateAssistOp(CfitemAssistAddingContext assistAddingContext) {
        BiTreeNode orgTreeNode = assistAddingContext.getRootOrg();
        LOG.info("org_tree_for_validate as:" + orgTreeNode.showFormatTree("\n"));
        BiTreeNode accTreeNode = assistAddingContext.getRootCfItem();
        LOG.info("cf_tree_for_validate as:" + accTreeNode.showFormatTree("\n"));
        CashflowAddingAssistAdapter adapter = new CashflowAddingAssistAdapter();
        DependBiTreeNode taskTreeNode = adapter.buildAccOrgTree(orgTreeNode, accTreeNode, (Object)assistAddingContext);
        TreeDepthFirstScheduleExecutor executor = new TreeDepthFirstScheduleExecutor(taskTreeNode);
        executor.execute((ITaskService)new CfitemAddingAssistValidateTaskImpl());
        return CashflowVersionSaveExtension.collectResults((DependBiTreeNode<CfitemContext>)taskTreeNode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskExecutionResult<CashflowItemOrgVo>> collectResults(DependBiTreeNode<CfitemContext> taskTreeNode, boolean isValidate) {
        ArrayList<TaskExecutionResult<CashflowItemOrgVo>> arrayList;
        long tick = System.currentTimeMillis();
        HashSet nodeSet = new HashSet(8);
        taskTreeNode.preTravel(x -> nodeSet.add((DependBiTreeNode)x));
        taskTreeNode.deepFirstTravel(x -> {
            HashSet fullDependNodes = new HashSet(8);
            if (!CollectionUtils.isEmpty((Collection)x.getChild()) || !((DependBiTreeNode)x).getDependencies().isEmpty()) {
                DependBiTreeNode curNode = (DependBiTreeNode)x;
                Stream.concat(curNode.getChild().stream(), curNode.getDependencies().stream()).forEach(c -> {
                    if (TaskExecutionResult.Status.failed == ((CfitemContext)c.getData()).getExecutionResult().getStatus()) {
                        fullDependNodes.add((DependBiTreeNode)c);
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Set)c.getPropValue(PROP_FULL_CHILD)))) {
                        ((Set)c.getPropValue(PROP_FULL_CHILD)).stream().forEach(y -> {
                            if (TaskExecutionResult.Status.failed == ((CfitemContext)y.getData()).getExecutionResult().getStatus()) {
                                fullDependNodes.add(y);
                            }
                        });
                    }
                });
            }
            x.setPropValue(PROP_FULL_CHILD, fullDependNodes);
        });
        LOG.info("tttt collectResults :" + taskTreeNode.showFormatTree("\n", x -> String.valueOf(x.getId()) + ((CfitemContext)((DependBiTreeNode)x).getData()).getExecutionResult().getStatus()));
        taskTreeNode.collect(x -> {
            DependBiTreeNode curNode = (DependBiTreeNode)x;
            TaskExecutionResult curResult = ((CfitemContext)x.getData()).getExecutionResult();
            CfitemAssistAddingContext assistAddingContext = ((CfitemContext)x.getData()).getAssistAddingContext();
            String accountNumber = ((CfitemContext)x.getData()).getAccountNumber();
            long orgId = ((CfitemContext)x.getData()).getOrgId();
            DynamicObject orgDyn = (DynamicObject)assistAddingContext.getOrgIdDynObjMap().get(orgId);
            if (TaskExecutionResult.Status.fast_failed == ((CfitemContext)curNode.getData()).getExecutionResult().getStatus()) {
                if (assistAddingContext.tryGetCfitemIdByOrgAndCfNum(orgId, accountNumber).isPresent()) {
                    List dependFailedNodes = ((Set)x.getPropValue(PROP_FULL_CHILD)).stream().filter(c -> TaskExecutionResult.Status.failed == ((CfitemContext)c.getData()).getExecutionResult().getStatus()).collect(Collectors.toList());
                    String refineMsg = String.join((CharSequence)",", dependFailedNodes.stream().map(c -> {
                        Tuple info = ((CfitemContext)c.getData()).getData();
                        return String.format("%s:%s", ((OrgVO)((BiTreeNode)info.item2).getData()).getName(), ((CashflowItemVo)((BiTreeNode)info.item1).getData()).getNumber());
                    }).collect(Collectors.toList()));
                    String msgTemplate = isValidate ? ResManager.loadKDString((String)"\u7531\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%s\uff09\u6821\u9a8c\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6821\u9a8c\u5931\u8d25\u7684\u7ec4\u7ec7\u4ee5\u53ca\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"CashflowVersionSaveExtension_0", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7531\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%s\uff09\u7248\u672c\u5316\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7248\u672c\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7248\u672c\u5316\u5931\u8d25\u7684\u7ec4\u7ec7\u4ee5\u53ca\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"CashflowVersionSaveExtension_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                    curResult.setFailedMsg(String.format(msgTemplate, refineMsg));
                } else {
                    curResult.setStatus(TaskExecutionResult.Status.skip);
                    curResult.setMsgCode("S001");
                    curResult.setFailedMsg(String.format(BDCommonResource.getMessageConstantsS001Text(), orgDyn == null ? "unknow" : orgDyn.getString("name"), accountNumber));
                }
            }
            return curResult;
        });
        try {
            arrayList = new ArrayList<TaskExecutionResult<CashflowItemOrgVo>>(taskTreeNode.collect(x -> {
                DependBiTreeNode curNode = (DependBiTreeNode)x;
                TaskExecutionResult curResult = ((CfitemContext)x.getData()).getExecutionResult();
                curResult.setScheduleSeq(((DependBiTreeNode)x).getScheduleSeq());
                if (Objects.nonNull(curNode.getProxyNode())) {
                    curResult.setStatus(((CfitemContext)curNode.getProxyNode().getData()).getExecutionResult().getStatus());
                }
                return curResult;
            }));
        }
        catch (Throwable throwable) {
            LOG.info(String.format("%s collect results cost: %s", CashflowVersionSaveExtension.class.getName(), System.currentTimeMillis() - tick));
            throw throwable;
        }
        LOG.info(String.format("%s collect results cost: %s", CashflowVersionSaveExtension.class.getName(), System.currentTimeMillis() - tick));
        return arrayList;
    }
}

