/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.cfitem.bdctl.assign;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.AssignOrgTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.AssignUtil;
import kd.fi.gl.formplugin.cfitem.bdctl.CashFlowItemNumTreeNode;
import kd.fi.gl.formplugin.cfitem.bdctl.assign.AssignCtx;
import kd.fi.gl.formplugin.cfitem.bdctl.assign.OrgCashFlowItemAndParent;
import kd.fi.gl.formplugin.cfitem.bdctl.assign.OrgSingleAssignCtx;

public class HandleBeforeAssign {
    private static Log LOG = LogFactory.getLog(HandleBeforeAssign.class);
    public AssignCtx assignCtx;

    public HandleBeforeAssign(String entityId, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs) {
        if (DebugTrace.enable()) {
            LOG.info("HandleBeforeAssign_construct_start");
            LOG.info(String.format("HandleBeforeAssign_construct_entityId[%1$s], assignOrgID[%2$d], dataIDs[%3$s], orgIDs[%4$s]", entityId, assignOrgID, SerializationUtils.toJsonString(dataIDs), SerializationUtils.toJsonString(orgIDs)));
        }
        this.assignCtx = new AssignCtx(entityId, assignOrgID, dataIDs, orgIDs);
    }

    public Map<Long, Map<Long, String>> handle() {
        block4: {
            try {
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                Long assignOrgID = this.assignCtx.getAssignOrgID();
                orgIds.add(assignOrgID);
                ArrayList<Long> childOrgIds = new ArrayList<Long>(10);
                while (orgIds.size() > 0) {
                    for (Long orgId : orgIds) {
                        List<Long> thisOrgChildIds = this.doAssign(orgId);
                        childOrgIds.addAll(thisOrgChildIds);
                    }
                    orgIds.clear();
                    orgIds.addAll(childOrgIds);
                    childOrgIds.clear();
                }
            }
            catch (Exception e) {
                LOG.error("HandleBeforeAssign_handle", (Throwable)e);
                if (e instanceof KDBizException) break block4;
                throw e;
            }
        }
        return this.assignCtx.getAssignCheckResMap();
    }

    private List<Long> doAssign(Long orgId) {
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_doAssign_orgId[%1$d]", orgId));
        }
        OrgSingleAssignCtx parentAssignCtx = new OrgSingleAssignCtx(this.assignCtx);
        parentAssignCtx.setUseOrgid(orgId);
        this.buildAssignRelationDatas(parentAssignCtx);
        this.buildAssignRelationDataParentDatas(parentAssignCtx);
        this.checkDataRelation(parentAssignCtx);
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.assignCtx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(orgId);
        Set childIds = assignOrgTreeNode.getChildIds();
        Iterator iterator = childIds.iterator();
        while (iterator.hasNext()) {
            Long childId = (Long)iterator.next();
            try {
                OrgSingleAssignCtx childAssignCtx = new OrgSingleAssignCtx(this.assignCtx);
                childAssignCtx.setUseOrgid(childId);
                this.buildAssignRelationDatas(childAssignCtx);
                this.buildAssignRelationDataParentDatas(childAssignCtx);
                this.checkDataRelation(childAssignCtx);
                this.removeAlreadyAssignAcctId(parentAssignCtx, childAssignCtx);
                this.checkOrgCreateSameAcctByNum(parentAssignCtx, childAssignCtx);
                this.makeAssignExcuter(parentAssignCtx, childAssignCtx);
            }
            catch (Exception e) {
                LOG.error("HandleBeforeAssign_handle", (Throwable)e);
                if (!(e instanceof KDBizException)) {
                    throw e;
                }
                iterator.remove();
            }
        }
        return new ArrayList<Long>(childIds);
    }

    private void checkDataRelation(OrgSingleAssignCtx orgAssignCtx) {
        OrgCashFlowItemAndParent orgCashFlowItemAndParent;
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_checkDataRelation_start_oapopMap[%1$s]", SerializationUtils.toJsonString((Object)orgAssignCtx)));
        }
        Map<String, OrgCashFlowItemAndParent> oapopMap = orgAssignCtx.getOrgCashFlowItemAndParentMap();
        for (Map.Entry<String, OrgCashFlowItemAndParent> entry : oapopMap.entrySet()) {
            orgCashFlowItemAndParent = entry.getValue();
            if (orgCashFlowItemAndParent.getCashFlowItemMasterId() != null) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5f02\u5e38,\u7f3a\u5931\u6700\u65b0\u7248\u672c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\uff08%2$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%3$s\uff09\u6570\u636e\u4fe1\u606f\u518d\u5206\u914d\u3002", (String)"HandleBeforeAssign_0", (String)"fi-bd-common", (Object[])new Object[0]), entry.getKey(), AssignUtil.getOrgNameById(orgAssignCtx.getUseOrgid()), entry.getKey());
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
        }
        for (Map.Entry<String, OrgCashFlowItemAndParent> entry : oapopMap.entrySet()) {
            orgCashFlowItemAndParent = entry.getValue();
            Set<Long> useregIds = orgCashFlowItemAndParent.getUseregIds();
            Set<Long> excIds = orgCashFlowItemAndParent.getExcIds();
            Set useRangeCount = useregIds.stream().filter(x -> !excIds.contains(x)).collect(Collectors.toSet());
            if (!useRangeCount.isEmpty()) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5f02\u5e38\uff0c\u6ce8\u518c\u767b\u8bb0\u6570\u636e\u548c\u6392\u9664\u6570\u636e\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\uff08%2$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%3$s\uff09\u6570\u636e\u4fe1\u606f\u518d\u5206\u914d\u3002", (String)"HandleBeforeAssign_1", (String)"fi-bd-common", (Object[])new Object[0]), entry.getKey(), AssignUtil.getOrgNameById(orgAssignCtx.getUseOrgid()), entry.getKey());
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_checkDataRelation_end_oapopMap[%1$s]", SerializationUtils.toJsonString(oapopMap)));
        }
    }

    private void buildAssignRelationDatas(OrgSingleAssignCtx ctx) {
        OrgCashFlowItemAndParent orgCashFlowItemAndParent;
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_buildAssignRelationDatas_start_ctx[%1$s]", SerializationUtils.toJsonString((Object)ctx)));
        }
        AssignCtx assignCtx = ctx.getAssignCtx();
        Map<String, OrgCashFlowItemAndParent> oapopMap = ctx.getOrgCashFlowItemAndParentMap();
        Long useOrgid = ctx.getUseOrgid();
        Set<String> cashFlowItemNums = assignCtx.getCashFlowItemNumTreeNodeMap().keySet();
        ArrayList<Object> cashFlowItemNumList = new ArrayList<Object>(cashFlowItemNums);
        try (DataSet dataSet = AssignUtil.findCashFlowItemsByCreateOrgAndNum(useOrgid, cashFlowItemNumList);){
            for (Row row : dataSet) {
                String fnumber2 = row.getString("fnumber");
                orgCashFlowItemAndParent = oapopMap.get(fnumber2);
                Long id = row.getLong("fid");
                Date fenddate = row.getDate("fenddate");
                if (orgCashFlowItemAndParent == null || fenddate.compareTo(orgCashFlowItemAndParent.getEndDate()) > 0) {
                    if (orgCashFlowItemAndParent == null) {
                        orgCashFlowItemAndParent = new OrgCashFlowItemAndParent();
                        oapopMap.put(fnumber2, orgCashFlowItemAndParent);
                        orgCashFlowItemAndParent.setNeedDeal(false);
                        orgCashFlowItemAndParent.setNeedVerison(false);
                    }
                    Long masterid = row.getLong("fmasterid");
                    Long parentId = row.getLong("fparentid");
                    orgCashFlowItemAndParent.setCashFlowItemId(id);
                    orgCashFlowItemAndParent.setCashFlowItemMasterId(masterid);
                    orgCashFlowItemAndParent.setOrgId(ctx.getUseOrgid());
                    orgCashFlowItemAndParent.setCashFlowItemNum(fnumber2);
                    orgCashFlowItemAndParent.setParentCashFlowItemId(parentId);
                    orgCashFlowItemAndParent.setCtrlstrategy(row.getString("fctrlstrategy"));
                    orgCashFlowItemAndParent.setCreateOrgId(row.getLong("fcreateorgid"));
                    orgCashFlowItemAndParent.setEndDate(fenddate);
                }
                orgCashFlowItemAndParent.getUseregIds().add(id);
            }
        }
        HashSet<Long> excludeAcct = new HashSet<Long>(10);
        ArrayList excSqlResult = new ArrayList(10);
        Throwable throwable = null;
        try (DataSet dataSet = CashflowRelationFactory.get().queryExcDataIdByNumber(useOrgid.longValue(), cashFlowItemNumList);){
            for (Row row3 : dataSet) {
                Long dataid = row3.getLong("fdataid");
                excludeAcct.add(dataid);
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                returnObj.put("fnumber", row3.getString("fnumber"));
                returnObj.put("fdataid", dataid);
                returnObj.put("fcreateorgid", row3.getLong("fcreateorgid"));
                returnObj.put("fuseorgid", useOrgid);
                excSqlResult.add(returnObj);
            }
        }
        catch (Throwable fnumber2) {
            Throwable throwable2 = fnumber2;
            throw fnumber2;
        }
        dataSet = CashflowRelationFactory.get().queryAssignDataByNumbers(useOrgid.longValue(), cashFlowItemNumList);
        Throwable throwable3 = null;
        try {
            for (Row row : dataSet) {
                String fnumber3 = row.getString("fnumber");
                OrgCashFlowItemAndParent orgCashFlowItemAndParent2 = oapopMap.get(fnumber3);
                if (null == orgCashFlowItemAndParent2) {
                    orgCashFlowItemAndParent2 = new OrgCashFlowItemAndParent();
                    oapopMap.put(fnumber3, orgCashFlowItemAndParent2);
                }
                orgCashFlowItemAndParent2.getUseregIds().add(row.getLong("fid"));
                Date fenddate = row.getDate("fenddate");
                if (excludeAcct.contains(row.getLong("fid")) || null != orgCashFlowItemAndParent2.getEndDate() && fenddate.compareTo(orgCashFlowItemAndParent2.getEndDate()) <= 0) continue;
                Long masterid = row.getLong("fmasterid");
                Long parentId = row.getLong("fparentid");
                orgCashFlowItemAndParent2.setOrgId(ctx.getUseOrgid());
                orgCashFlowItemAndParent2.setCashFlowItemNum(fnumber3);
                orgCashFlowItemAndParent2.setCashFlowItemId(row.getLong("fid"));
                orgCashFlowItemAndParent2.setCashFlowItemMasterId(masterid);
                orgCashFlowItemAndParent2.setParentCashFlowItemId(parentId);
                orgCashFlowItemAndParent2.setCtrlstrategy(row.getString("fctrlstrategy"));
                orgCashFlowItemAndParent2.setCreateOrgId(row.getLong("fcreateorgid"));
                orgCashFlowItemAndParent2.setEndDate(fenddate);
            }
        }
        catch (Throwable fnumber2) {
            Throwable throwable4 = fnumber2;
            throw fnumber2;
        }
        finally {
            if (dataSet != null) {
                if (throwable3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable fnumber2) {
                        throwable3.addSuppressed(fnumber2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Map map : excSqlResult) {
            String fnumber = (String)map.get("fnumber");
            orgCashFlowItemAndParent = oapopMap.get(fnumber);
            if (null == orgCashFlowItemAndParent) continue;
            orgCashFlowItemAndParent.getExcIds().add((Long)map.get("fdataid"));
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_buildAssignRelationDatas_end_oapopMap[%1$s]", SerializationUtils.toJsonString(oapopMap)));
        }
    }

    private void buildAssignRelationDataParentDatas(OrgSingleAssignCtx ctx) {
        Serializable pAcctId;
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_buildAssignRelationDataParentDatas_start_oapopMap[%1$s]", SerializationUtils.toJsonString((Object)ctx)));
        }
        Map<String, OrgCashFlowItemAndParent> oapopMap = ctx.getOrgCashFlowItemAndParentMap();
        HashSet<Long> parentId = new HashSet<Long>(10);
        for (Map.Entry<String, OrgCashFlowItemAndParent> oapopEntry : oapopMap.entrySet()) {
            pAcctId = oapopEntry.getValue().getParentCashFlowItemId();
            if (null == pAcctId || (Long)pAcctId == 0L) continue;
            parentId.add((Long)pAcctId);
        }
        if (null == parentId || parentId.size() == 0) {
            if (DebugTrace.enable()) {
                LOG.info("buildAssignRelationDataParentDatas_orgid : " + ctx.getUseOrgid() + " null == parentId||parentId.size()==0");
            }
            return;
        }
        HashMap cashFlowItemSqlResult = new HashMap(16);
        DataSet dataSet = AssignUtil.findCashFlowItemsByIds(new ArrayList<Object>(parentId));
        pAcctId = null;
        try {
            for (Row row : dataSet) {
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                long fid = row.getLong("fid");
                returnObj.put("fnumber", row.getString("fnumber"));
                returnObj.put("fid", fid);
                returnObj.put("fmasterid", row.getLong("fmasterid"));
                returnObj.put("fctrlstrategy", row.getString("fctrlstrategy"));
                returnObj.put("fcreateorgid", row.getLong("fcreateorgid"));
                cashFlowItemSqlResult.put(fid, returnObj);
            }
        }
        catch (Throwable throwable) {
            pAcctId = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (pAcctId != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)pAcctId).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Map.Entry<String, OrgCashFlowItemAndParent> oapopEntry : oapopMap.entrySet()) {
            OrgCashFlowItemAndParent oap = oapopEntry.getValue();
            Long pAcctId2 = oap.getParentCashFlowItemId();
            if (null == pAcctId2 || pAcctId2 == 0L) continue;
            Map cashFlowItemInfo = (Map)cashFlowItemSqlResult.get(pAcctId2);
            oap.setParentCashFlowItemNum((String)cashFlowItemInfo.get("fnumber"));
            oap.setParentCashFlowItemMasterId((Long)cashFlowItemInfo.get("fmasterid"));
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_buildAssignRelationDataParentDatas_end_oapopMap[%1$s]", SerializationUtils.toJsonString(oapopMap)));
        }
    }

    private void removeAlreadyAssignAcctId(OrgSingleAssignCtx parentAssignCtx, OrgSingleAssignCtx childAssignCtx) {
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_removeAlreadyAssignAcctId_start_parentAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)parentAssignCtx)));
            LOG.info(String.format("HandleBeforeAssign_removeAlreadyAssignAcctId_start_childAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)childAssignCtx)));
        }
        Map<String, OrgCashFlowItemAndParent> oapopMap = childAssignCtx.getOrgCashFlowItemAndParentMap();
        Map<String, OrgCashFlowItemAndParent> pctxOapopMap = parentAssignCtx.getOrgCashFlowItemAndParentMap();
        for (Map.Entry<String, OrgCashFlowItemAndParent> pctxOapopEntry : pctxOapopMap.entrySet()) {
            OrgCashFlowItemAndParent pAcctOapop;
            OrgCashFlowItemAndParent oapop;
            String pNumber = pctxOapopEntry.getKey();
            OrgCashFlowItemAndParent pctxOapop = pctxOapopEntry.getValue();
            if (DebugTrace.enable()) {
                LOG.info("removeAlreadyAssignAcctId_orgid : " + childAssignCtx.getUseOrgid() + " pNumber : " + pNumber);
                LOG.info("removeAlreadyAssignAcctId_orgid : " + childAssignCtx.getUseOrgid() + " pctxOapop : " + pctxOapop);
            }
            if ((oapop = oapopMap.get(pNumber)) != null && oapop.getEndDate().compareTo(CashflowItemVersionUtil.getEndDate()) == 0) {
                if (DebugTrace.enable()) {
                    LOG.info("removeAlreadyAssignAcctId_orgid : " + childAssignCtx.getUseOrgid() + " pNumber : " + pNumber + "containsKey:true");
                    LOG.info("removeAlreadyAssignAcctId_orgid : " + childAssignCtx.getUseOrgid() + " oapopMap : " + oapop);
                }
                if (pctxOapop.getCashFlowItemMasterId().compareTo(oapop.getCashFlowItemMasterId()) != 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\uff08%1$s\uff09\u5df2\u6709\u7f16\u7801\u76f8\u540c\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%2$s\uff09\uff0c\u540c\u4e00\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u91cd\u590d\u51fa\u73b0\u7f16\u7801\u76f8\u540c\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"HandleBeforeUnAssign_3", (String)"fi-bd-common", (Object[])new Object[0]), AssignUtil.getOrgNameById(childAssignCtx.getUseOrgid()), pNumber);
                    this.assignCtx.getAssignCheckResMap().computeIfAbsent(pctxOapop.getCashFlowItemMasterId(), k -> new HashMap()).put(childAssignCtx.getUseOrgid(), msg);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
                }
                oapop.setNeedDeal(false);
                oapop.setAssign(true);
                continue;
            }
            if (DebugTrace.enable()) {
                LOG.info("removeAlreadyAssignAcctId_orgid : " + childAssignCtx.getUseOrgid() + " pNumber : " + pNumber + "containsKey:false");
            }
            OrgCashFlowItemAndParent pctxOapopClone = new OrgCashFlowItemAndParent();
            pctxOapopClone.setNeedVerison(false);
            pctxOapopClone.setNeedDeal(true);
            pctxOapopClone.setAssign(false);
            if (!Strings.isNullOrEmpty((String)pctxOapop.getParentCashFlowItemNum()) && null != (pAcctOapop = oapopMap.get(pctxOapop.getParentCashFlowItemNum()))) {
                pctxOapopClone.setParentCashFlowItemId(pAcctOapop.getCashFlowItemId());
                pctxOapopClone.setParentCashFlowItemMasterId(pAcctOapop.getCashFlowItemMasterId());
                pctxOapopClone.setParentCashFlowItemNum(pAcctOapop.getCashFlowItemNum());
            }
            pctxOapopClone.setOrgId(childAssignCtx.getUseOrgid());
            pctxOapopClone.setCashFlowItemId(pctxOapop.getCashFlowItemId());
            pctxOapopClone.setCashFlowItemNum(pctxOapop.getCashFlowItemNum());
            pctxOapopClone.setCashFlowItemMasterId(pctxOapop.getCashFlowItemMasterId());
            pctxOapopClone.setCreateOrgId(pctxOapop.getCreateOrgId());
            pctxOapopClone.setEndDate(pctxOapop.getEndDate());
            pctxOapopClone.setCtrlstrategy(pctxOapop.getCtrlstrategy());
            pctxOapopClone.getUseregIds().addAll(pctxOapop.getUseregIds());
            pctxOapopClone.getExcIds().addAll(pctxOapop.getExcIds());
            oapopMap.put(pNumber, pctxOapopClone);
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_removeAlreadyAssignAcctId_end_oapopMap[%1$s]", SerializationUtils.toJsonString(oapopMap)));
        }
    }

    private void checkOrgCreateSameAcctByNum(OrgSingleAssignCtx parentAssignCtx, OrgSingleAssignCtx childAssignCtx) {
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_checkOrgCreateSameAcctByNum_start_parentAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)parentAssignCtx)));
            LOG.info(String.format("HandleBeforeAssign_checkOrgCreateSameAcctByNum_start_childAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)childAssignCtx)));
        }
        Map<String, OrgCashFlowItemAndParent> oapopMap = childAssignCtx.getOrgCashFlowItemAndParentMap();
        Map<String, OrgCashFlowItemAndParent> pctxOapopMap = parentAssignCtx.getOrgCashFlowItemAndParentMap();
        for (Map.Entry<String, OrgCashFlowItemAndParent> oapopEntry : oapopMap.entrySet()) {
            String currentOrgAcctNum;
            OrgCashFlowItemAndParent oapop = oapopEntry.getValue();
            if (!oapop.isNeedDeal() || !pctxOapopMap.containsKey(currentOrgAcctNum = oapopEntry.getKey())) continue;
            OrgCashFlowItemAndParent pctxOapop = pctxOapopMap.get(currentOrgAcctNum);
            Long popOrgAcctMasterId = pctxOapop.getCashFlowItemMasterId();
            Long opOrgAcctMasterId = oapopEntry.getValue().getCashFlowItemMasterId();
            if (opOrgAcctMasterId.compareTo(popOrgAcctMasterId) == 0) continue;
            oapop.setNeedDeal(false);
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_buildAssignRelationDataParentDatas_end_oapopMap[%1$s]", SerializationUtils.toJsonString(oapopMap)));
        }
    }

    private void makeAssignExcuter(OrgSingleAssignCtx parentAssignCtx, OrgSingleAssignCtx childAssignCtx) {
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_start_parentAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)parentAssignCtx)));
            LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_start_childAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)childAssignCtx)));
        }
        AssignCtx assignCtx = childAssignCtx.getAssignCtx();
        Map<String, OrgCashFlowItemAndParent> childOapopMap = childAssignCtx.getOrgCashFlowItemAndParentMap();
        Map<String, OrgCashFlowItemAndParent> parentOapopMap = parentAssignCtx.getOrgCashFlowItemAndParentMap();
        Map<String, CashFlowItemNumTreeNode> numTreeNodeMap = assignCtx.getCashFlowItemNumTreeNodeMap();
        List firstLevelNumbers = numTreeNodeMap.entrySet().stream().filter(e -> StringUtils.isEmpty((CharSequence)((CashFlowItemNumTreeNode)e.getValue()).getPnumber())).map(x -> ((CashFlowItemNumTreeNode)x.getValue()).getNumber()).collect(Collectors.toList());
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_firstLevelNumbers[%1$s]", SerializationUtils.toJsonString(firstLevelNumbers)));
        }
        ArrayList<String> cashFlowItemNumbers = new ArrayList<String>(10);
        for (String firstLevelNumber : firstLevelNumbers) {
            cashFlowItemNumbers.add(firstLevelNumber);
            this.recursionChilds(firstLevelNumber, numTreeNodeMap, cashFlowItemNumbers);
        }
        for (String cashFlowItemNumber : cashFlowItemNumbers) {
            this.excuteAssign(childAssignCtx, childOapopMap, parentOapopMap, numTreeNodeMap, cashFlowItemNumber);
        }
        if (childAssignCtx.getUseRegParams().size() > 0 || childAssignCtx.getExcParams().size() > 0) {
            CashflowItemVersionUtil.doAssign(new ArrayList<Object[]>(childAssignCtx.getExcParams().values()), new ArrayList<Object[]>(childAssignCtx.getUseRegParams().values()));
            childAssignCtx.getUseRegParams().clear();
            childAssignCtx.getExcParams().clear();
        }
    }

    private void recursionChilds(String cashFlowItemNumber, Map<String, CashFlowItemNumTreeNode> numTreeNodeMap, List<String> cashFlowItemNumbers) {
        CashFlowItemNumTreeNode cashFlowItemNumTreeNode = numTreeNodeMap.get(cashFlowItemNumber);
        Set<String> childNumbers = cashFlowItemNumTreeNode.getChildNumbers();
        for (String childNumber : childNumbers) {
            cashFlowItemNumbers.add(childNumber);
            this.recursionChilds(childNumber, numTreeNodeMap, cashFlowItemNumbers);
        }
    }

    private void excuteAssign(OrgSingleAssignCtx childAssignCtx, Map<String, OrgCashFlowItemAndParent> childOrgCashFlowItemAndParentMap, Map<String, OrgCashFlowItemAndParent> parentOrgCashFlowItemAndParentMap, Map<String, CashFlowItemNumTreeNode> cashFlowItemNumTreeNodeMap, String cashFlowItemNumber) {
        OrgCashFlowItemAndParent childOrgCashFlowItemAndParent = childOrgCashFlowItemAndParentMap.get(cashFlowItemNumber);
        if (!childOrgCashFlowItemAndParent.isNeedDeal()) {
            if (childOrgCashFlowItemAndParent.isAssign()) {
                HashMap<String, Object[]> useRegParams = new HashMap<String, Object[]>(16);
                HashMap<String, Object[]> excParams = new HashMap<String, Object[]>(16);
                OrgCashFlowItemAndParent parentOrgCashFlowItemAndParent = parentOrgCashFlowItemAndParentMap.get(cashFlowItemNumber);
                Set<Long> parentUseregIds = parentOrgCashFlowItemAndParent.getUseregIds();
                Set<Long> childUseregIds = childOrgCashFlowItemAndParent.getUseregIds();
                List<Object> subtractUseregIds = parentUseregIds.stream().filter(id -> !childUseregIds.contains(id)).collect(Collectors.toList());
                if (subtractUseregIds != null && subtractUseregIds.size() > 0) {
                    DynamicObject[] cashFlowItems = BusinessDataServiceHelper.load((Object[])subtractUseregIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_cashflowitem"));
                    if (childOrgCashFlowItemAndParentMap.get(cashFlowItemNumber).getCreateOrgId().equals(childAssignCtx.getUseOrgid())) {
                        for (DynamicObject cashFlowItem : cashFlowItems) {
                            Long createOrgId = cashFlowItem.getLong("createorg_id");
                            long dataId = cashFlowItem.getLong("id");
                            String ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
                            Long l = childAssignCtx.getAssignCtx().getAssignOrgID();
                            Object[] useregParam = new Object[]{childOrgCashFlowItemAndParent.getOrgId(), dataId, createOrgId, createOrgId, ctrlstrategy, "1", l == null ? createOrgId : l};
                            Object[] excParam = new Object[]{dataId, createOrgId, childOrgCashFlowItemAndParent.getOrgId()};
                            useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-"), useregParam);
                            excParams.putIfAbsent(StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-"), excParam);
                            String upKey = StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-");
                            childAssignCtx.getUseRegParams().putIfAbsent(upKey, useregParam);
                            childAssignCtx.getExcParams().putIfAbsent(upKey, excParam);
                            childOrgCashFlowItemAndParent.getUseregIds().add(dataId);
                            childOrgCashFlowItemAndParent.getExcIds().add(dataId);
                        }
                    } else {
                        for (DynamicObject cashFlowItem : cashFlowItems) {
                            DynamicObject[] createOrgId = Long.valueOf(cashFlowItem.getLong("createorg_id"));
                            long dataId = cashFlowItem.getLong("id");
                            String ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
                            Long l = childAssignCtx.getAssignCtx().getAssignOrgID();
                            Object[] useregParam = new Object[]{childOrgCashFlowItemAndParent.getOrgId(), dataId, createOrgId, createOrgId, ctrlstrategy, "1", l == null ? createOrgId : l};
                            useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-"), useregParam);
                            String upKey = StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-");
                            childAssignCtx.getUseRegParams().putIfAbsent(upKey, useregParam);
                            childOrgCashFlowItemAndParent.getUseregIds().add(dataId);
                        }
                        Set<Long> set = parentOrgCashFlowItemAndParent.getExcIds();
                        Set<Long> childExcIds = childOrgCashFlowItemAndParent.getExcIds();
                        List<Object> subtractExcIds = set.stream().filter(id -> !childExcIds.contains(id)).collect(Collectors.toList());
                        if (subtractExcIds != null && subtractExcIds.size() > 0) {
                            DynamicObject[] excCashFlowItems;
                            for (DynamicObject cashFlowItem : excCashFlowItems = BusinessDataServiceHelper.load((Object[])subtractExcIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_cashflowitem"))) {
                                Long l = cashFlowItem.getLong("createorg_id");
                                long dataId = cashFlowItem.getLong("id");
                                Object[] excParam = new Object[]{dataId, l, childOrgCashFlowItemAndParent.getOrgId()};
                                excParams.putIfAbsent(StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-"), excParam);
                                String upKey = StringUtils.join((Object[])new Object[]{dataId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-");
                                childAssignCtx.getExcParams().putIfAbsent(upKey, excParam);
                                childOrgCashFlowItemAndParent.getExcIds().add(dataId);
                            }
                        }
                    }
                    CashflowItemVersionUtil.doAssign(new ArrayList(excParams.values()), new ArrayList(useRegParams.values()));
                }
            }
            return;
        }
        if (DebugTrace.enable()) {
            LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_start_childAssignCtx[%1$s]", SerializationUtils.toJsonString((Object)childAssignCtx)));
            LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_start_cashFlowItemNumber[%1$s]", cashFlowItemNumber));
        }
        OrgCashFlowItemAndParent parentOrgCashFlowItemAndParent = parentOrgCashFlowItemAndParentMap.get(cashFlowItemNumber);
        String parentCashFlowItemNum = childOrgCashFlowItemAndParent.getParentCashFlowItemNum();
        if (parentOrgCashFlowItemAndParent == null || parentCashFlowItemNum == null || !childOrgCashFlowItemAndParentMap.get(parentCashFlowItemNum).getCreateOrgId().equals(childAssignCtx.getUseOrgid())) {
            if (DebugTrace.enable()) {
                LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_cashFlowItemNumber[%1$s],isNeedVersion[%2$s]", cashFlowItemNumber, "false"));
            }
            if (parentOrgCashFlowItemAndParent != null && parentCashFlowItemNum != null) {
                boolean isIncludeParentCashFlowItem;
                Long parentCashFlowItemId = parentOrgCashFlowItemAndParent.getParentCashFlowItemId();
                OrgCashFlowItemAndParent OrgCashFlowItemAndParent2 = childOrgCashFlowItemAndParentMap.get(parentCashFlowItemNum);
                boolean bl = isIncludeParentCashFlowItem = null != OrgCashFlowItemAndParent2 && OrgCashFlowItemAndParent2.getUseregIds().contains(parentCashFlowItemId);
                if (!isIncludeParentCashFlowItem) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5f02\u5e38\uff0c\u8bf7\u5bf9\u7ec4\u7ec7\uff08%2$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%3$s\uff09\u5148\u8fdb\u884c\u7248\u672c\u5316\u518d\u5206\u914d\u3002", (String)"HandleBeforeAssign_2", (String)"fi-bd-common", (Object[])new Object[0]), parentCashFlowItemNum, AssignUtil.getOrgNameById(childAssignCtx.getUseOrgid()), parentCashFlowItemNum);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
                }
            }
            HashSet<Long> dataIds = new HashSet<Long>(childOrgCashFlowItemAndParent.getUseregIds());
            dataIds.addAll(childOrgCashFlowItemAndParent.getExcIds());
            for (Long acctid : dataIds) {
                DynamicObject cashFlowItem = BusinessDataServiceHelper.loadSingleFromCache((Object)acctid, (String)"gl_cashflowitem");
                Long createOrgId = cashFlowItem.getLong("createorg_id");
                long l = cashFlowItem.getLong("id");
                if (childOrgCashFlowItemAndParent.getExcIds().contains(l)) {
                    String excKey = StringUtils.join((Object[])new Object[]{l, createOrgId, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-");
                    Object[] exeParam = new Object[]{l, createOrgId, childOrgCashFlowItemAndParent.getOrgId()};
                    childAssignCtx.getExcParams().putIfAbsent(excKey, exeParam);
                    childOrgCashFlowItemAndParent.getExcIds().add(l);
                }
                String ctrlstrategy = cashFlowItem.getString("ctrlstrategy");
                Long assignOrgId = childAssignCtx.getAssignCtx().getAssignOrgID();
                Object[] useregParam = new Object[]{childOrgCashFlowItemAndParent.getOrgId(), l, createOrgId, createOrgId, ctrlstrategy, "1", assignOrgId == null ? createOrgId : assignOrgId};
                String upKey = StringUtils.join((Object[])new Object[]{l, childOrgCashFlowItemAndParent.getOrgId()}, (String)"-");
                childAssignCtx.getUseRegParams().putIfAbsent(upKey, useregParam);
                childOrgCashFlowItemAndParent.getUseregIds().add(l);
            }
            if (childAssignCtx.getUseRegParams().size() > 500 || childAssignCtx.getExcParams().size() > 500) {
                CashflowItemVersionUtil.doAssign(new ArrayList<Object[]>(childAssignCtx.getExcParams().values()), new ArrayList<Object[]>(childAssignCtx.getUseRegParams().values()));
                childAssignCtx.getUseRegParams().clear();
                childAssignCtx.getExcParams().clear();
            }
        } else {
            DynamicObject[] successSaveAccts;
            OperationResult operationResult;
            if (DebugTrace.enable()) {
                LOG.info(String.format("HandleBeforeAssign_makeAssignExcuter_cashFlowItemNumber[%1$s],isNeedVersion[%2$s]", cashFlowItemNumber, "true"));
            }
            childOrgCashFlowItemAndParent.setNeedVerison(true);
            DynamicObject cloneCashFlowItem = BusinessDataServiceHelper.loadSingle((Object)childOrgCashFlowItemAndParent.getCashFlowItemId(), (String)"gl_cashflowitem");
            DynamicObject opCashFlowItemObj = BusinessDataServiceHelper.loadSingle((Object)childOrgCashFlowItemAndParent.getParentCashFlowItemId(), (String)"gl_cashflowitem");
            DynamicObject bos_org = BusinessDataServiceHelper.loadSingleFromCache((Object)childOrgCashFlowItemAndParent.getOrgId(), (String)"bos_org");
            cloneCashFlowItem.set("useorg", (Object)bos_org);
            cloneCashFlowItem.set("parent", (Object)opCashFlowItemObj);
            if (DebugTrace.enable()) {
                LOG.info("orgid : {}  process start", (Object)childAssignCtx.getUseOrgid());
                LOG.info("cloneAcct_startdate:{} ,enddate:{}", (Object)cloneCashFlowItem.getDate("startdate"), (Object)cloneCashFlowItem.getDate("enddate"));
                if (opCashFlowItemObj != null) {
                    LOG.info("cloneAcctParent_startdate:[],enddate:{}", (Object)opCashFlowItemObj.getDate("startdate"), (Object)opCashFlowItemObj.getDate("enddate"));
                }
            }
            HashMap<Long, Boolean> queryMidAndIsLeafRs = new HashMap<Long, Boolean>(10);
            Throwable throwable = null;
            try (DataSet dataSet = CashflowRelationFactory.get().queryDataInfoByNumber(parentOrgCashFlowItemAndParent.getOrgId().longValue(), Collections.singletonList(cloneCashFlowItem.getString("number")), "masterid, isleaf");){
                Iterator childExcIds = dataSet.iterator();
                while (childExcIds.hasNext()) {
                    Row row = (Row)childExcIds.next();
                    queryMidAndIsLeafRs.put(row.getLong("masterid"), row.getBoolean("isleaf"));
                }
            }
            catch (Throwable childExcIds) {
                Throwable throwable2 = childExcIds;
                throw childExcIds;
            }
            if (queryMidAndIsLeafRs.size() > 1) {
                for (Map.Entry entry : queryMidAndIsLeafRs.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    cloneCashFlowItem.set("masterid", entry.getKey());
                    cloneCashFlowItem.set("isleaf", (Object)true);
                    break;
                }
            }
            if (null != opCashFlowItemObj) {
                String opnumber = opCashFlowItemObj.getString("number");
                if (childOrgCashFlowItemAndParent.getParentCashFlowItemNum().equals(opnumber)) {
                    DynamicObject updateAssist;
                    ArrayList<Object> arrayList = new ArrayList<Object>(10);
                    DynamicObjectCollection cloneAssistEntry = cloneCashFlowItem.getDynamicObjectCollection("assistentry");
                    HashMap<Long, DynamicObject> cloneAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    HashMap<Long, DynamicObject> updateAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    for (DynamicObject assistRow : cloneAssistEntry) {
                        assistRow.set("id", null);
                        long assistId = assistRow.getLong("asstypeid_id");
                        cloneAssistMap.put(assistId, assistRow);
                        updateAssistMap.put(assistId, assistRow);
                    }
                    DynamicObjectCollection opAssistEntry = opCashFlowItemObj.getDynamicObjectCollection("assistentry");
                    HashMap<Long, DynamicObject> opAssistMap = new HashMap<Long, DynamicObject>(opAssistEntry.size());
                    ArrayList<Long> opAssistIdWithSeq = new ArrayList<Long>(opAssistEntry.size());
                    for (DynamicObject dynamicObject : opAssistEntry) {
                        long assistId = dynamicObject.getLong("asstypeid_id");
                        opAssistMap.put(assistId, dynamicObject);
                        opAssistIdWithSeq.add(assistId);
                    }
                    for (Map.Entry entry : opAssistMap.entrySet()) {
                        Long assistId = (Long)entry.getKey();
                        DynamicObject opAssistObj = (DynamicObject)entry.getValue();
                        if (cloneAssistMap.containsKey(assistId)) {
                            DynamicObject cloneAssist = (DynamicObject)cloneAssistMap.get(assistId);
                            if (opAssistObj.getBoolean("isrequire")) {
                                cloneAssist.set("isrequire", (Object)true);
                            }
                            if (opAssistObj.getBoolean("isdetail")) {
                                cloneAssist.set("isdetail", (Object)true);
                            }
                            updateAssistMap.put(assistId, cloneAssist);
                            continue;
                        }
                        DynamicObject dynamicObject = new DynamicObject(cloneAssistEntry.getDynamicObjectType());
                        dynamicObject.set("asstypeid", opAssistObj.get("asstypeid"));
                        dynamicObject.set("isdetail", opAssistObj.get("isdetail"));
                        dynamicObject.set("isrequire", opAssistObj.get("isrequire"));
                        updateAssistMap.put(assistId, dynamicObject);
                    }
                    int seq = 1;
                    for (Long assistId : opAssistIdWithSeq) {
                        updateAssist = (DynamicObject)updateAssistMap.get(assistId);
                        if (updateAssist != null) {
                            updateAssist.set("seq", (Object)seq);
                            arrayList.add(updateAssist);
                            ++seq;
                        }
                        updateAssistMap.remove(assistId);
                    }
                    for (Map.Entry updateEntry : updateAssistMap.entrySet()) {
                        updateAssist = (DynamicObject)updateEntry.getValue();
                        updateAssist.set("seq", (Object)seq);
                        arrayList.add(updateEntry.getValue());
                        ++seq;
                    }
                    cloneAssistEntry.clear();
                    cloneAssistEntry.addAll(arrayList);
                }
            }
            OperateOption op = OperateOption.create();
            CashflowItemOptionVarManager.setIsVersion((OperateOption)op, (boolean)true);
            op.setVariableValue("useOrgID", String.valueOf(cloneCashFlowItem.getLong("useorg_id")));
            if (cloneCashFlowItem.getDynamicObject("parent") != null && cloneCashFlowItem.getDynamicObject("parent").getBoolean("isleaf")) {
                QFilter fnumber;
                QFilter fdate;
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)cloneCashFlowItem.getLong("createorg_id"));
                boolean exists = QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qFilter, fdate = new QFilter("startdate", "=", (Object)CashflowItemVersionUtil.getBeginDate()), fnumber = new QFilter("number", "=", (Object)cloneCashFlowItem.getString("number"))});
                if (!exists) {
                    CashflowItemOptionVarManager.setIsVersionAddLeaf((OperateOption)op, (boolean)true);
                }
                CloneUtils util = new CloneUtils(false, true);
                cloneCashFlowItem = (DynamicObject)util.clone((IDataEntityBase)cloneCashFlowItem);
                cloneCashFlowItem.set("createorg", (Object)cloneCashFlowItem.getDynamicObject("useorg"));
                cloneCashFlowItem.set("org", (Object)cloneCashFlowItem.getDynamicObject("useorg"));
            }
            if (DebugTrace.enable()) {
                LOG.info("\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5206\u914d,\u9700\u8981\u7248\u672c\u5316\uff0c\u51c6\u5907\u8c03\u7528\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4fdd\u5b58\u65b9\u6cd5\uff1acloneAcct: {}", (Object)cloneCashFlowItem.toString());
            }
            Object var14_40 = null;
            try {
                operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_cashflowitem", (DynamicObject[])new DynamicObject[]{cloneCashFlowItem}, (OperateOption)op);
            }
            catch (Exception e) {
                if (DebugTrace.enable()) {
                    LOG.info("org:{}, \u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801\uff1a{}, \u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5206\u914d\uff1a\u7248\u672c\u5316\u4fdd\u5b58\u64cd\u4f5c\u62a5\u9519\u4fe1\u606f:{}", new Object[]{childOrgCashFlowItemAndParent.getOrgId(), cloneCashFlowItem.getString("number"), e});
                }
                this.assignCtx.getAssignCheckResMap().computeIfAbsent(childOrgCashFlowItemAndParent.getCashFlowItemId(), k -> new HashMap()).put(childOrgCashFlowItemAndParent.getOrgId(), String.join((CharSequence)",", e.getMessage()));
                throw e;
            }
            ArrayList<String> errorMsgs = new ArrayList<String>();
            List valResults = operationResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : valResults) {
                for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                    if (DebugTrace.enable()) {
                        LOG.info("CashFlowItem_assign\uff1aversionalized faield msg:{}", (Object)errorInfo);
                    }
                    String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u7248\u672c\u5316\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%1$s\uff09\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\uff08%2$s\uff09\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff08%3$s\uff09\u6570\u636e\u4fe1\u606f\u518d\u5206\u914d\uff0c\u9519\u8bef\u4fe1\u606f:%4$s", (String)"HandleBeforeAssign_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), cloneCashFlowItem.getString("number"), AssignUtil.getOrgNameById(childOrgCashFlowItemAndParent.getOrgId()), cloneCashFlowItem.getString("number"), errorInfo.getMessage());
                    errorMsgs.add(msg);
                }
            }
            if (errorMsgs.size() > 0) {
                this.assignCtx.getAssignCheckResMap().computeIfAbsent(childOrgCashFlowItemAndParent.getCashFlowItemId(), k -> new HashMap()).put(childOrgCashFlowItemAndParent.getOrgId(), String.join((CharSequence)",", errorMsgs));
                throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{String.join((CharSequence)";", errorMsgs)});
            }
            if (valResults == null) {
                throw new KDBizException(String.join((CharSequence)",", errorMsgs));
            }
            List successPkIds = operationResult.getSuccessPkIds();
            successPkIds.add(cloneCashFlowItem.getPkValue());
            if (DebugTrace.enable()) {
                LOG.info("CashFlowItem_assign\uff1aversionalized successed acc ids: " + StringUtils.join((Object[])new List[]{successPkIds}));
            }
            for (DynamicObject dynamicObject : successSaveAccts = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"))) {
                HashMap<String, Object[]> useRegParams = new HashMap<String, Object[]>(16);
                HashMap<String, Object[]> excParams = new HashMap<String, Object[]>(16);
                Long createOrgId = dynamicObject.getLong("createorg_id");
                long orgId = dynamicObject.getLong("org_id");
                long dataId = dynamicObject.getLong("id");
                String successSaveAcctctrlstrategy = dynamicObject.getString("ctrlstrategy");
                Long assignOrgId = childAssignCtx.getAssignCtx().getAssignOrgID();
                if ((assignOrgId == null || Objects.equals(assignOrgId, 0L)) && ((assignOrgId = parentOrgCashFlowItemAndParent.getOrgId()) == null || Objects.equals(assignOrgId, 0L))) {
                    assignOrgId = createOrgId;
                }
                useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{dataId, orgId}, (String)"-"), new Object[]{orgId, dataId, createOrgId, createOrgId, dynamicObject.getString("ctrlstrategy"), "0", assignOrgId});
                childOrgCashFlowItemAndParent.getUseregIds().add(dataId);
                if (DebugTrace.enable()) {
                    LOG.info("Account_assign\uff1aassign releation, ctrl strategy\uff1a" + successSaveAcctctrlstrategy + ",useRegParam:{fuseorgid=" + orgId + ",fdataid=" + dataId + ",fcreateorgid=" + createOrgId + ",fadminorgid=" + createOrgId + ",fctrlstrategy=" + dynamicObject.getString("ctrlstrategy") + ",fisassign=" + 0 + ",fassignorgid=" + assignOrgId);
                }
                HashSet<Long> existsUseDataIds = new HashSet<Long>(childOrgCashFlowItemAndParent.getExcIds());
                existsUseDataIds.add(childOrgCashFlowItemAndParent.getCashFlowItemId());
                OrgCashFlowItemAndParent poapop = parentOrgCashFlowItemAndParentMap.get(cashFlowItemNumber);
                HashSet<Long> pexistsUseDataIds = new HashSet<Long>(poapop.getUseregIds());
                pexistsUseDataIds.addAll(existsUseDataIds);
                for (Long acctid : pexistsUseDataIds) {
                    DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)acctid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
                    Long oldCreateOrgId = account.getLong("createorg_id");
                    String ctrlstrategy = account.getString("ctrlstrategy");
                    useRegParams.putIfAbsent(StringUtils.join((Object[])new Object[]{acctid, orgId}, (String)"-"), new Object[]{orgId, acctid, oldCreateOrgId, oldCreateOrgId, ctrlstrategy, "1", assignOrgId});
                    excParams.putIfAbsent(StringUtils.join((Object[])new Object[]{acctid, orgId}, (String)"-"), new Object[]{acctid, oldCreateOrgId, orgId});
                    childOrgCashFlowItemAndParent.getUseregIds().add(acctid);
                    childOrgCashFlowItemAndParent.getExcIds().add(acctid);
                }
                CashflowItemVersionUtil.doAssign(new ArrayList(excParams.values()), new ArrayList(useRegParams.values()));
                HashMap<Long, Long> orgAndParentOrgs = new HashMap<Long, Long>(1);
                orgAndParentOrgs.put(orgId, assignOrgId);
                CashflowItemVersionUtil.assignAllOldVersionItems((Long)dataId, (Long)assignOrgId, (Long)orgId, orgAndParentOrgs);
                if (DebugTrace.enable()) {
                    LOG.info("Account_assign\uff1aexecute assign\uff1adoAssign,execute assignAllOldVersionAccts assign current account history version:,accountId=" + dataId + ",assignorgId=" + assignOrgId + ",useOrgId=" + orgId);
                }
                childOrgCashFlowItemAndParent.setCreateOrgId(childOrgCashFlowItemAndParent.getOrgId());
                childOrgCashFlowItemAndParent.setCashFlowItemId((Long)successPkIds.get(0));
                CashFlowItemNumTreeNode assignAccountNumTreeNode = cashFlowItemNumTreeNodeMap.get(cashFlowItemNumber);
                Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
                if (null == childNumbers || childNumbers.size() <= 0) continue;
                for (String childNumber : childNumbers) {
                    OrgCashFlowItemAndParent childOap = childOrgCashFlowItemAndParentMap.get(childNumber);
                    childOap.setParentCashFlowItemId((Long)successPkIds.get(0));
                }
            }
        }
    }
}

