/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.comassist;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.FieldConfig;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.comassist.ComAssistImportPlugin;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class AbstractComAssistBillPlugin
extends AbstractBillPlugIn {
    private static final Set<String> needSetDefValEntitySet = new HashSet<String>(Arrays.asList("gl_transplprogram", "gl_autotrans", "gl_adjustexchangerate", "gl_voucheramortacheme"));
    private static final Set<String> noCleanValueEntitySet = new HashSet<String>(Collections.singletonList("gl_autotrans"));

    public void registerListener(EventObject e) {
        BasedataEdit comAssistControl;
        super.registerListener(e);
        int index = 0;
        long orgId = this.getOrgId();
        long bookTypeId = this.getBookTypeId();
        while ((comAssistControl = (BasedataEdit)this.getControl(CommonAssistUtil.getComassistField((int)(++index)))) != null) {
            int finalIndex = index;
            comAssistControl.addBeforeF7SelectListener(listener -> ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> {
                if (commonAssist.key.equals(CommonAssistUtil.getComassistField((int)finalIndex))) {
                    listener.getCustomQFilters().add(ComAssistService.generateQFilter((CommonAssist)commonAssist, (IDataEntityType)MetadataServiceHelper.getDataEntityType((String)commonAssist.valueSource)));
                }
            })));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEntityType(GetEntityTypeEventArgs e) {
        long booktypeId;
        long orgId;
        if (!CommonAssistUtil.isCommonAssistEnabled() || this.getEntityTypeForImport(e)) {
            return;
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String formId = billShowParameter.getFormId();
        Object pkId = billShowParameter.getPkId();
        IDataModel model = this.getModel();
        String orgFieldName = this.getOrgKey();
        String booktypeFieldName = this.getBookTypeKey();
        if (model.isDataLoaded()) {
            orgId = (Long)model.getValue(GLField.id_((String)orgFieldName));
            booktypeId = (Long)model.getValue(GLField.id_((String)booktypeFieldName));
        } else if (pkId == null) {
            if (!needSetDefValEntitySet.contains(formId)) return;
            Map customParams = billShowParameter.getCustomParams();
            boolean needSetDefaultValue = false;
            for (Map.Entry customParamsEntry : customParams.entrySet()) {
                if (!((String)customParamsEntry.getKey()).startsWith("comassist") || !CollectionUtils.isNotEmpty((Collection)((JSONArray)customParamsEntry.getValue()))) continue;
                needSetDefaultValue = true;
                break;
            }
            if (!needSetDefaultValue) return;
            if (StringUtils.isNotBlank(customParams.get(orgFieldName)) && GLUtil.hasPermission((String)PermissonType.NEW.getPermId(), (Long)Long.parseLong(customParams.get(orgFieldName).toString()), (String)formId)) {
                orgId = Long.parseLong(customParams.get(orgFieldName).toString());
            } else {
                orgId = RequestContext.get().getOrgId();
                if (!GLUtil.hasPermission((String)PermissonType.NEW.getPermId(), (Long)orgId, (String)formId)) {
                    orgId = AccSysUtil.getAccountingOrg((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.NEW);
                }
            }
            booktypeId = this.getDefBookTypeByOrg(orgId, booktypeFieldName);
        } else {
            DynamicObject billDyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId, (String)String.join((CharSequence)",", orgFieldName, booktypeFieldName));
            orgId = billDyn.getLong(GLField.id_((String)orgFieldName));
            booktypeId = billDyn.getLong(GLField.id_((String)booktypeFieldName));
        }
        e.setNewEntityType((MainEntityType)ComAssistTable.get((Long)orgId, (Long)booktypeId).map(table -> ComAssistTableService.modifyEntityType((ComAssistTable)table, (EntityType)e.getOriginalEntityType())).orElseGet(() -> ((GetEntityTypeEventArgs)e).getOriginalEntityType()));
        this.getModel().updateCache();
    }

    protected boolean getEntityTypeForImport(GetEntityTypeEventArgs e) {
        e.setNewEntityType(ComAssistImportPlugin.ImportHandler.getEntityType(e.getOriginalEntityType()));
        return e.getOriginalEntityType() != e.getNewEntityType();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.rebuildCommonAssistFields();
    }

    protected void rebuildCommonAssistFields() {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(GLField.id_((String)this.getOrgKey()));
        long bookTypeId = (Long)model.getValue(GLField.id_((String)this.getBookTypeKey()));
        ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> ComAssistTableService.modifyCommonAssistFields((ComAssistTable)commonAssistTable, (IFormView)this.getView()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String orgFieldName = this.getOrgKey();
        String bookTypeFieldName = this.getBookTypeKey();
        long orgId = (Long)this.getModel().getValue(GLField.id_((String)orgFieldName));
        long bookTypeId = (Long)this.getModel().getValue(GLField.id_((String)bookTypeFieldName));
        String propName = e.getProperty().getName();
        if ((propName.equals(orgFieldName) || propName.equals(bookTypeFieldName)) && !noCleanValueEntitySet.contains(this.getView().getFormShowParameter().getFormId())) {
            ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> ComAssistTableService.modifyCommonAssistFields((ComAssistTable)commonAssistTable, (IFormView)this.getView()));
            this.cleanComAssistValue();
        }
    }

    protected long getDefBookTypeByOrg(Long orgId, String bookTypeFieldName) {
        long bookTypeId = 0L;
        List bookIdList = AccSysUtil.getAllBookFromAccSys((long)orgId);
        if (!bookIdList.isEmpty()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object booktypeId = customParams.get(bookTypeFieldName);
            Map books = BusinessDataServiceHelper.loadFromCache((Object[])bookIdList.toArray(), (String)"gl_accountbook");
            DynamicObject book = null;
            if (booktypeId != null) {
                for (Map.Entry bookEntry : books.entrySet()) {
                    DynamicObject accountBook = (DynamicObject)bookEntry.getValue();
                    long btypeid = accountBook.getLong("bookstype_id");
                    if (btypeid != Long.parseLong(booktypeId.toString())) continue;
                    book = accountBook;
                    break;
                }
            }
            if (book == null && !books.isEmpty()) {
                book = (DynamicObject)books.values().iterator().next();
            }
            if (book != null) {
                bookTypeId = Long.parseLong(((DynamicObject)book.get("bookstype")).getPkValue().toString());
            }
        }
        return bookTypeId;
    }

    protected void cleanComAssistValue() {
        Set<String> comAssistFields = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toSet());
        comAssistFields.forEach(comAssistField -> {
            Object value = this.getModel().getValue(comAssistField);
            if (Objects.nonNull(value)) {
                this.getModel().setValue(comAssistField, null);
            }
        });
    }

    protected String getOrgKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)this.getView().getEntityId()).item1;
    }

    protected String getBookTypeKey() {
        return (String)FieldConfig.getOrgAndBookTypeFieldKey((String)this.getView().getEntityId()).item2;
    }

    protected long getOrgId() {
        return (Long)this.getModel().getValue(GLField.id_((String)this.getOrgKey()));
    }

    protected long getBookTypeId() {
        return (Long)this.getModel().getValue(GLField.id_((String)this.getBookTypeKey()));
    }
}

