/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.excel;

import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.plugin.impt.ImportEntityMapping;

public class ImportExcelModel {
    private Map<String, ColumnInfo> cols = new HashMap<String, ColumnInfo>();
    private Map<String, ImportExcelModel> entries = new HashMap<String, ImportExcelModel>();

    public static ImportExcelModel creatExcelModel(ImportEntityMapping mapping) {
        ImportExcelModel model = new ImportExcelModel();
        Map cols = mapping.getCols();
        HashMap<String, ColumnInfo> importCols = new HashMap<String, ColumnInfo>(cols.size());
        for (Map.Entry entry : cols.entrySet()) {
            ColumnInfo columnInfo = ImportExcelModel.buildColumnInfo((ImportEntityMapping.ColInfo)entry.getValue());
            importCols.put((String)entry.getKey(), columnInfo);
        }
        model.setCols(importCols);
        Map entries = mapping.getEntries();
        HashMap<String, ImportExcelModel> importEntries = new HashMap<String, ImportExcelModel>(entries.size());
        for (Map.Entry entry : entries.entrySet()) {
            ImportEntityMapping entryMapping = (ImportEntityMapping)entry.getValue();
            ImportExcelModel entriesSub = new ImportExcelModel();
            Map<String, ColumnInfo> importEntriesSub = entriesSub.getCols();
            for (Map.Entry col : entryMapping.getCols().entrySet()) {
                ColumnInfo columnInfo = ImportExcelModel.buildColumnInfo((ImportEntityMapping.ColInfo)col.getValue());
                importEntriesSub.put((String)col.getKey(), columnInfo);
            }
            entriesSub.setCols(importEntriesSub);
            importEntries.put((String)entry.getKey(), entriesSub);
        }
        model.setEntries(importEntries);
        return model;
    }

    private static ColumnInfo buildColumnInfo(ImportEntityMapping.ColInfo value) {
        String basedataProp = value.getBasedataProp();
        HashMap<String, Object> property = new HashMap<String, Object>();
        String classSimpleName = value.getProperty().getClass().getSimpleName();
        property.put("basedataPropType", classSimpleName);
        if (value.getProperty() instanceof BasedataProp) {
            property.put("basedataPropType", "BasedataProp");
        } else if (value.getProperty() instanceof ComboProp) {
            property.put("basedataPropType", "ComboProp");
            property.put("comboItems", ((ComboProp)value.getProperty()).getComboItems());
        }
        if (classSimpleName.equals("FlexProp")) {
            property.put("basedataPropType", "FlexProp");
            property.put("flextypeid", ((FlexProp)value.getProperty()).getFlexTypeId());
        }
        ColumnInfo columnInfo = new ColumnInfo(value.getIndex(), value.getDisplayName(), value.isMustInput(), basedataProp);
        columnInfo.setProperty(property);
        columnInfo.setFlexColIndex(value.getFlexColIndex());
        return columnInfo;
    }

    public Map<String, ColumnInfo> getCols() {
        return this.cols;
    }

    public void setCols(Map<String, ColumnInfo> cols) {
        this.cols = cols;
    }

    public void addCols(Map<String, ColumnInfo> cols) {
        this.cols = cols;
    }

    public Map<String, ImportExcelModel> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<String, ImportExcelModel> entries) {
        this.entries = entries;
    }

    private static class ColumnInfo {
        private int index;
        private String displayName;
        private boolean mustInput;
        private String basedataProp;
        private Map<String, Object> property;
        private Map<Integer, String[]> flexColIndex = new HashMap<Integer, String[]>();

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public String getBasedataProp() {
            return this.basedataProp;
        }

        public void setBasedataProp(String basedataProp) {
            this.basedataProp = basedataProp;
        }

        public Map<String, Object> getProperty() {
            return this.property;
        }

        public void setProperty(Map<String, Object> propertyType) {
            this.property = propertyType;
        }

        public ColumnInfo(int index, String displayName, boolean mustInput, String basedataProp) {
            this.index = index;
            this.displayName = displayName;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public Map<Integer, String[]> getFlexColIndex() {
            return this.flexColIndex;
        }

        public void setFlexColIndex(Map<Integer, String[]> flexColIndex) {
            this.flexColIndex = flexColIndex;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

