/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.excel;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class ThrowableHelper {
    public static String toString(Exception exception) {
        Exception cause = exception;
        return ThrowableHelper.toString((Throwable)cause);
    }

    public static String toString(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(ThrowableHelper.toString(t.getCause()) + "\n");
        }
        StringWriter sW = new StringWriter();
        try {
            PrintWriter writer = new PrintWriter(sW);
            t.printStackTrace(writer);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sW.toString();
    }

    public static String[] generatekernelMessage(Throwable throwable, int level) {
        String[] result = new String[]{};
        if (throwable == null) {
            return result;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
            String line = reader.readLine();
            boolean foundCased = false;
            while (line != null) {
                if (line.contains("Caused By") || line.contains("Exception") || foundCased) {
                    lines.add(line);
                    foundCased = true;
                }
                if (lines.size() < level) {
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            lines.add(ex.toString());
        }
        return lines.toArray(result);
    }

    public static String generatekernelMessageInfo(Throwable throwable, int level) {
        CharSequence[] msgs = ThrowableHelper.generatekernelMessage(throwable, level);
        return String.join((CharSequence)"\n", msgs);
    }

    public static String generateFirstThreadCauseMessageInfo(Throwable throwable, int level) {
        while (throwable != null && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ThrowableHelper.generatekernelMessageInfo(throwable, level);
    }

    public static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(ThrowableHelper.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sW.toString();
    }
}

