/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess.autotrans;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.Constant;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.formplugin.finalprocess.autotrans.EditView;
import kd.fi.gl.formplugin.finalprocess.autotrans.IEntryFilterListener;

public class AutoTransAccFilter
implements IEntryFilterListener {
    @Override
    public String filterField() {
        return AutoTransConstant.Entry_Key_Account.key;
    }

    @Override
    public List<QFilter> beforeF7Select(EditView editView, BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (this.checkOrgBook(editView)) {
            return filterList;
        }
        return this.getCommonFilter(editView);
    }

    @Override
    public String filterEntryField() {
        return "autotransentry";
    }

    @Override
    public List<QFilter> entryGridSetRowData(EditView editView, EntryGridSetRowDataEvent entryGridSetRowDataEvent) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (this.checkOrgBook(editView)) {
            return filterList;
        }
        BasedataEdit acctTarget = (BasedataEdit)editView.getFormView().getControl(this.filterField());
        filterList.addAll(acctTarget.getQFilters());
        filterList.addAll(this.getCommonFilter(editView));
        return filterList;
    }

    boolean checkOrgBook(EditView editView) {
        IDataModel editModel = editView.getEditModel();
        DynamicObject org = (DynamicObject)editModel.getValue(Constant.Entity_Org.toString(editView.getEntityId()));
        DynamicObject bookType = (DynamicObject)editModel.getValue(Constant.Entity_AccountBookType.toString(editView.getEntityId()));
        return org == null || bookType == null;
    }

    List<QFilter> getCommonFilter(EditView editView) {
        IDataModel editModel = editView.getEditModel();
        Object transType = editModel.getValue("transfertype");
        QFilter customFilter = null;
        if ("2".equals(transType)) {
            customFilter = QFilter.of((String)"(accounttype.accounttype=? and ischangecurrency='0') or accounttype.accounttype=?", (Object[])new Object[]{"2", "4"});
        }
        AutoTransScheme autoTransScheme = new AutoTransScheme(editModel.getDataEntity(true));
        AutoTransService autoTransService = new AutoTransService(autoTransScheme);
        if (!autoTransScheme.getAccountBookInfo().isBudget()) {
            customFilter = customFilter == null ? AccountType.buildNonBudgetFilter() : customFilter.and(AccountType.buildNonBudgetFilter());
        }
        return autoTransService.getAccountFilterInVersion(customFilter, false).toList();
    }
}

