/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess.autotrans;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.formplugin.finalprocess.autotrans.AutoTransFilterListenerFactory;
import kd.fi.gl.formplugin.finalprocess.autotrans.EditView;
import kd.fi.gl.formplugin.finalprocess.autotrans.IEditFilterListener;
import kd.fi.gl.formplugin.finalprocess.autotrans.IEntryFilterListener;
import kd.fi.gl.util.GLUtil;

public class AutoTransEditFilterService {
    public static void registerFilterListener(final EditView editView, PropertyKey baseDataField) {
        String fieldKey = baseDataField.getKey();
        Control control = editView.getFormView().getControl(fieldKey);
        if (!(control instanceof BasedataEdit)) {
            return;
        }
        Optional<IEditFilterListener> filterListener = AutoTransFilterListenerFactory.get(fieldKey);
        if (!filterListener.isPresent()) {
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)control;
        basedataEdit.addBeforeF7SelectListener(e -> {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            if (AutoTransConstant.Entry_Key_Account.getKey().equals(fieldKey)) {
                qFilters.removeIf(GLUtil::isLastVersionFilter);
            }
            qFilters.addAll(((IEditFilterListener)filterListener.get()).beforeF7Select(editView, e));
        });
        String entryKey = baseDataField.getEntryKey();
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            EntryGrid entryGrid = (EntryGrid)editView.getFormView().getControl(entryKey);
            entryGrid.addSetRowDataListener(new EntryGridSetRowDataListener(){

                public void entryGridSetRowData(EntryGridSetRowDataEvent e) {
                    super.entryGridSetRowData(e);
                    for (String field : e.getValues().keySet()) {
                        AutoTransFilterListenerFactory.get(field).ifPresent(x -> {
                            if (!(x instanceof IEntryFilterListener)) {
                                return;
                            }
                            IEntryFilterListener temp = (IEntryFilterListener)x;
                            List filters = (List)e.getQFilters().get(field);
                            List<QFilter> addFilters = temp.entryGridSetRowData(editView, e);
                            if (filters == null) {
                                e.getQFilters().put(field, addFilters);
                            } else {
                                filters.addAll(addFilters);
                            }
                        });
                    }
                }
            });
        }
    }
}

