/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.finalprocess.breakpoint;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.closeperiod.breakpoint.OrgBooktypePeriod;
import kd.fi.gl.formplugin.finalprocess.breakpoint.BreakPointAdjustmentClick;
import kd.fi.gl.formplugin.finalprocess.breakpoint.BreakPointAdjustmentTask;
import kd.fi.gl.formplugin.finalprocess.breakpoint.BreakPointAdjustmentTaskParam;
import kd.fi.gl.formplugin.finalprocess.breakpoint.BreakPointAdjustmentType;
import kd.fi.gl.formplugin.finalprocess.breakpoint.TaskResult;
import kd.fi.gl.formplugin.finalprocess.breakpoint.VoucherListAndBreakPointLogProvider;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherNumCheckUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VchBreakPointList
extends AbstractListPlugin
implements ClickListener {
    private static final String CONFIRM_SUFFIX = "_confirmType";
    public static final String ADJUST_CALL_BACK = "VchBreakPointAdjustmentCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit booksType = (BasedataEdit)this.getControl("bookstype");
        booksType.addBeforeF7SelectListener(select -> this.setBookTypeF7SelectFilter(select));
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(select -> this.setPeriodF7SelectFilter(select));
    }

    private void setBookTypeF7SelectFilter(BeforeF7SelectEvent select) {
        IPageCache pageCache = this.getPageCache();
        String curOrg = pageCache.get("curOrg");
        Set allBookByOrg = AccSysUtil.getAllBookTypeFromAccSys((long)Long.parseLong(curOrg));
        ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().add(new QFilter("id", "in", (Object)allBookByOrg));
    }

    private void setPeriodF7SelectFilter(BeforeF7SelectEvent select) {
        IPageCache pageCache = this.getPageCache();
        String curorg = pageCache.get("curOrg");
        String curBooktype = pageCache.get("curBooktype");
        ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        long curentPeriod = BreakPointCommonUtil.getCurentPeriod((long)Long.parseLong(curorg), (long)Long.parseLong(curBooktype));
        if (curentPeriod == 0L) {
            filterParam.getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            return;
        }
        long start = curentPeriod;
        DynamicObject currPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)curentPeriod, (String)"bd_period", (String)"periodtype");
        long periodtype = currPeriodDyo.getLong("periodtype.id");
        QFilter qtype = new QFilter("periodtype", "=", (Object)periodtype);
        QFilter qids = new QFilter("id", ">=", (Object)start);
        List openPeriods = GLUtil.getOpenPeriod((long)Long.parseLong(curorg), (long)Long.parseLong(curBooktype));
        if (!CollectionUtils.isEmpty((Collection)openPeriods)) {
            qids.or(new QFilter("id", "in", (Object)openPeriods));
        }
        filterParam.getQFilters().add(qtype);
        filterParam.getQFilters().add(qids);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrgBookTypePeriod();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filteCol = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filteCol) {
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            if (!filterColumn.getFieldName().equals("org.name")) continue;
            List<Long> orgIds = this.getOrgIdsChecked();
            List comboItems = BreakPointCommonUtil.getOrgComboItems(orgIds);
            commFilter.setComboItems(comboItems);
            if (comboItems.isEmpty()) {
                commFilter.setDefaultValue("0");
                continue;
            }
            String curOrg = this.getPageCache().get("curOrg");
            if (StringUtils.isEmpty((String)curOrg)) {
                commFilter.setDefaultValue("0");
                continue;
            }
            commFilter.setDefaultValue(curOrg);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilterList = (List)filterValues.get("customfilter");
        if (customfilterList == null) {
            return;
        }
        for (Map filed : customfilterList) {
            String filedName = ((List)filed.get("FieldName")).get(0).toString();
            if (!"org.id".equals(filedName)) continue;
            String selectedOrg = ((List)filed.get("Value")).get(0).toString();
            this.selectOrg(selectedOrg);
        }
    }

    public void setFilter(SetFilterEvent e) {
        CodeRuleInfo codeRuleInfo;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        String booktype = this.getPageCache().get("curBooktype");
        String period = this.getPageCache().get("curPeriod");
        String orgId = this.getPageCache().get("curOrg");
        if (StringUtils.isNotEmpty((String)orgId) && (codeRuleInfo = VoucherNumberUtils.getCodeRuleInfo((Long)Long.parseLong(orgId), (String)"B")) != null && VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)codeRuleInfo)) {
            qFilters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C", "D"}));
        }
        if (!StringUtils.isEmpty((String)booktype)) {
            qFilters.add(new QFilter("booktype", "=", (Object)Long.parseLong(booktype)));
        }
        if (!StringUtils.isEmpty((String)period)) {
            qFilters.add(new QFilter("period", "=", (Object)Long.parseLong(period)));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new VoucherListAndBreakPointLogProvider(this.getView()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List<Long> orgIds = this.getOrgIdsChecked();
        args.addCustomQFilter(new QFilter("id", "in", orgIds));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btnconfirm": 
            case "dateconfirm": 
            case "submitterconfirm": 
            case "bizdateconfirm": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u8c03\u6574\u662f\u5bf9\u672c\u671f\u6240\u6709\u51ed\u8bc1\u91cd\u65b0\u6392\u53f7\uff0c\u662f\u5426\u786e\u5b9a\u8c03\u6574\uff1f", (String)"VchBreakPointList_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(evt.getItemKey() + CONFIRM_SUFFIX, (IFormPlugin)this));
                break;
            }
            case "btnmanual": {
                this.doManualAdjustOperation();
                break;
            }
            case "baritemap": {
                this.doVoucherBrokenCheck();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.endsWith(CONFIRM_SUFFIX) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String[] split = callBackId.split("_");
            this.doAutoAdjustOperation(split[0]);
        }
    }

    private void doAutoAdjustOperation(String itemKey) {
        String curorg = this.getPageCache().get("curOrg");
        String curBooktype = this.getView().getPageCache().get("curBooktype");
        String curperiod = this.getView().getPageCache().get("curPeriod");
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong(curorg), (String)"gl", (String)"gl_voucherbreakpoint", (String)"0KVV7K8G7=01");
        if (permission == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u65ad\u53f7\u8c03\u6574\u201d\u7684\u201d\u81ea\u52a8\u8c03\u6574\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchBreakPointList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String isAdjust = this.getPageCache().get(String.format("%s+%s+isAdjust", curorg, curperiod));
        if (isAdjust != null && "success".equals(isAdjust)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5df2\u81ea\u52a8\u8c03\u6574\u65ad\u53f7\u3002", (String)"VchBreakPointList_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getCurrentListAllRowCollection().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u671f\u65e0\u6570\u636e\uff0c\u65e0\u987b\u8c03\u6574\u3002", (String)"VchBreakPointList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String bookeddateorder = BreakPointAdjustmentType.parseType(itemKey);
        String orgName = BreakPointCommonUtil.getOrgName((String)curorg);
        boolean isInterno = this.isInterno(curorg, curBooktype, curperiod, Integer.parseInt(bookeddateorder), orgName);
        if (!isInterno) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u65ad\u53f7\u3002", (String)"VchBreakPointList_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgName));
            return;
        }
        this.asyncDispatch(curorg, curBooktype, curperiod, bookeddateorder);
    }

    private void asyncDispatch(String orgId, String bookTypeId, String periodId, String type) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("gl");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u65ad\u53f7\u8c03\u6574", (String)"VchBreakPointList_10", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(BreakPointAdjustmentTask.class.getName());
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        BreakPointAdjustmentTaskParam param = new BreakPointAdjustmentTaskParam();
        param.setOrgId(orgId);
        param.setBookTypeId(bookTypeId);
        param.setPeriodId(periodId);
        param.setOrderType(type);
        jobInfo.setParams(param.toParamMap());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADJUST_CALL_BACK);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName(BreakPointAdjustmentClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void checkOperationResult(OperationResult result, String curorg, String curBooktype, String curperiod) {
        if (result.isSuccess()) {
            this.getPageCache().put(String.format("%s+%s+result", curorg, curperiod), "success");
        } else {
            this.getPageCache().put(String.format("%s+%s+result", curorg, curperiod), result.getMessage());
        }
        String opResult = this.getPageCache().get(String.format("%s+%s+result", curorg, curperiod));
        if ("success".equals(opResult)) {
            this.getPageCache().put(String.format("%s+%s+isAdjust", curorg, curperiod), "success");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u6210\u529f\u3002", (String)"VchBreakPointList_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.updateList();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8c03\u6574\u5931\u8d25\u3002", (String)"VchBreakPointList_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), opResult, MessageTypes.Default);
        }
    }

    private void doManualAdjustOperation() {
        String curorg = this.getPageCache().get("curOrg");
        String curBooktype = this.getPageCache().get("curBooktype");
        String curperiod = this.getPageCache().get("curPeriod");
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong(curorg), (String)"gl", (String)"gl_voucherbreakpoint", (String)"0KWFI5FXP6GK");
        if (permission == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u65ad\u53f7\u8c03\u6574\u201d\u7684\u201d\u4eba\u5de5\u8c03\u6574\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchBreakPointList_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelect = billList.getSelectedRows();
        if (listSelect.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4eba\u5de5\u8c03\u6574\u7684\u6570\u636e\u3002", (String)"VchBreakPointList_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else if (listSelect.size() > 10000) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4eba\u5de5\u8c03\u6574\u4e0d\u652f\u6301\u8d85\u8fc710000\u6761\u4ee5\u4e0a\u7684\u6570\u636e\u3002", (String)"VchBreakPointList_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else if (!listSelect.isEmpty() && listSelect.size() <= 10000) {
            Object[] ids = listSelect.getPrimaryKeyValues();
            this.showManualForm(curorg, curBooktype, curperiod, ids);
        }
    }

    private void doVoucherBrokenCheck() {
        new VoucherNumCheckUtil((AbstractFormPlugin)this).beforeCheckBreakPoint();
    }

    private void showManualForm(String curorg, String curBooktype, String curperiod, Object[] ids) {
        FormShowParameter currFormShowParameter = this.getView().getFormShowParameter();
        Map customParams = currFormShowParameter.getCustomParams();
        FormShowParameter show = new FormShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btnmanual");
        show.setCloseCallBack(closeCallBack);
        show.setFormId("gl_manualbreakpoint");
        show.getOpenStyle().setShowType(ShowType.Modal);
        customParams.put("voucherids", ids);
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(customParams);
        params.put("orgCol", curorg);
        params.put("booktype", curBooktype);
        params.put("periodCol", curperiod);
        show.setCustomParams(params);
        this.getView().showForm(show);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        switch (closedCallBackEvent.getActionId()) {
            case "btnmanual": {
                String manualflag = String.valueOf(returnData);
                if (manualflag == null || !"manualflag".equals(manualflag)) break;
                String curorg = this.getPageCache().get("curOrg");
                String curperiod = this.getView().getPageCache().get("curPeriod");
                this.getPageCache().remove(String.format("%s+%s+isAdjust", curorg, curperiod));
                this.updateList();
                break;
            }
            case "VchBreakPointAdjustmentCallBack": {
                if (returnData == null) break;
                TaskResult taskResult = TaskResult.fromClosedCallBackEvent(closedCallBackEvent);
                OperationResult result = taskResult.getOperationResult();
                Map<String, Object> customParam = taskResult.getCustomParam();
                Object orgId = customParam.get("orgId");
                Object bookTypeId = customParam.get("bookTypeId");
                Object periodId = customParam.get("periodId");
                this.checkOperationResult(result, String.valueOf(orgId), String.valueOf(bookTypeId), String.valueOf(periodId));
            }
        }
    }

    private void initOrgBookTypePeriod() {
        List<OrgBooktypePeriod> orgBookTypePeriodList = this.getCheckedOrgBooktypePeriods();
        if (CollectionUtils.isEmpty(orgBookTypePeriodList)) {
            return;
        }
        OrgBooktypePeriod defaultOrgBooktypePeriod = this.getDefaultOne(orgBookTypePeriodList);
        if (null == defaultOrgBooktypePeriod) {
            return;
        }
        this.updatePageValue(defaultOrgBooktypePeriod);
    }

    private OrgBooktypePeriod getDefaultOne(List<OrgBooktypePeriod> orgBookTypePeriodList) {
        for (OrgBooktypePeriod orgBooktypePeriod : orgBookTypePeriodList) {
            if (!orgBooktypePeriod.isChecked()) continue;
            return orgBooktypePeriod;
        }
        return null;
    }

    private void updatePageValue(OrgBooktypePeriod orgBooktypePeriod) {
        IPageCache pageCache = this.getPageCache();
        Long bookTypeId = orgBooktypePeriod.getBooktypeId();
        if (!Objects.equals(String.valueOf(bookTypeId), pageCache.get("curBooktype"))) {
            this.getModel().setValue("bookstype", (Object)bookTypeId);
        }
        pageCache.put("curOrg", String.valueOf(orgBooktypePeriod.getOrgId()));
        pageCache.put("curBooktype", String.valueOf(bookTypeId));
        long periodid = BreakPointCommonUtil.getCurentPeriod((long)orgBooktypePeriod.getOrgId(), (long)bookTypeId);
        pageCache.put("curPeriod", String.valueOf(periodid));
        IDataModel model = this.getModel();
        model.setValue("period", (Object)String.valueOf(periodid));
    }

    private List<Long> getOrgIdsChecked() {
        List<OrgBooktypePeriod> orgBookTypePeriodList = this.getCheckedOrgBooktypePeriods();
        if (CollectionUtils.isEmpty(orgBookTypePeriodList)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> checkOrgIds = orgBookTypePeriodList.stream().map(OrgBooktypePeriod::getOrgId).collect(Collectors.toList());
        return checkOrgIds;
    }

    private List<OrgBooktypePeriod> getCheckedOrgBooktypePeriods() {
        String orgBookTypePeriodListStr = (String)this.getView().getFormShowParameter().getCustomParam("orgBookTypePeriodList");
        if (StringUtils.isEmpty((String)orgBookTypePeriodListStr)) {
            return Collections.EMPTY_LIST;
        }
        List orgBookTypePeriodList = JSON.parseArray((String)orgBookTypePeriodListStr, OrgBooktypePeriod.class);
        return orgBookTypePeriodList;
    }

    private void selectOrg(String selectedOrg) {
        String curOrg = this.getPageCache().get("curOrg");
        if (selectedOrg.equals(curOrg)) {
            return;
        }
        OrgBooktypePeriod selectedOrgBooktypePeriod = this.getSelectedOrgBooktypePeriod(selectedOrg);
        if (null != selectedOrgBooktypePeriod) {
            this.updatePageValue(selectedOrgBooktypePeriod);
        } else {
            String booktypeId = "";
            String periodId = "";
            this.getPageCache().put("curOrg", selectedOrg);
            this.getPageCache().put("curBooktype", booktypeId);
            this.getPageCache().put("curPeriod", periodId);
        }
    }

    private OrgBooktypePeriod getSelectedOrgBooktypePeriod(String org) {
        List<OrgBooktypePeriod> orgBooktypePeriodList = this.getCheckedOrgBooktypePeriods();
        if (CollectionUtils.isEmpty(orgBooktypePeriodList)) {
            return null;
        }
        for (OrgBooktypePeriod orgBooktypePeriod : orgBooktypePeriodList) {
            if (!Objects.equals(org, String.valueOf(orgBooktypePeriod.getOrgId()))) continue;
            return orgBooktypePeriod;
        }
        return null;
    }

    private boolean isInterno(String orgid, String booksTypeId, String periodId, int dateorder, String orgName) {
        boolean result = false;
        CodeRuleInfo coderule = BreakPointCommonUtil.getCodeRuleInfo((String)orgid);
        DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)coderule);
        List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgId", orgid);
        paramMap.put("booktype", booksTypeId);
        paramMap.put("period", periodId);
        paramMap.put("orgName", orgName);
        paramMap.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)coderule));
        String[] consistent = GLBreakPointUtil.checkConsistent((String)coderule.getId(), (List)codeRuleEntryAttributes, paramMap, (int)dateorder, (boolean)coderule.getIsNonBreak());
        if ("0".equals(consistent[0])) {
            result = true;
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (keyName = e.getProperty().getName()) {
            case "period": {
                this.updateCache("curPeriod", e.getChangeSet()[0]);
                break;
            }
            case "bookstype": {
                this.updateCache("curBooktype", e.getChangeSet()[0]);
                break;
            }
        }
    }

    private void updateCache(String cacheKey, ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (null != newValue) {
            String curOrg;
            OrgBooktypePeriod curOrgBooktypePeriod;
            this.getPageCache().put(cacheKey, String.valueOf(newValue.getPkValue()));
            if ("curBooktype".equals(cacheKey) && (curOrgBooktypePeriod = this.getSelectedOrgBooktypePeriod(curOrg = this.getPageCache().get("curOrg"))) != null) {
                Map bookPeriod = curOrgBooktypePeriod.getBookTypePeriod();
                if (bookPeriod.isEmpty()) {
                    DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"curperiod", (QFilter[])QFilterBuilder.create((String)"org", (String)"=", (Object)Long.parseLong(curOrg)).add("bookstype", "=", (Object)newValue.getLong("id")).toArray(new QFilter[0]));
                    Long curPeriod = book == null ? 0L : book.getLong("curperiod");
                    this.getModel().setValue("period", (Object)curPeriod);
                } else {
                    Optional<Long> optional = bookPeriod.keySet().stream().filter(o -> o.equals(newValue.getLong("id"))).findFirst();
                    optional.ifPresent(l -> this.getModel().setValue("period", bookPeriod.get(l)));
                }
            }
            this.updateList();
        } else {
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            if (oldValue != null) {
                this.getModel().setValue("period", oldValue.getPkValue());
            }
        }
    }

    private void updateList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        BillList billList = (BillList)evt.getSource();
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object selectId = currentSelectedRowInfo.getPrimaryKeyValue();
        long mainOrgId = currentSelectedRowInfo.getMainOrgId();
        VoucherUtil.hyperVoucher(mainOrgId, (Long)selectId, this.getView());
    }
}

