/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.flex;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.ZeroBalanceCarryover;
import kd.fi.gl.balcal.acctpullupbalupdate.AcctBalUpdateProcess;
import kd.fi.gl.formplugin.voucher.count.VoucherCountFixService;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.tools.AssistDuplicateRepairTool;
import kd.fi.gl.tools.DuplicateAssistIdFinder;
import kd.fi.gl.tools.IAssistIdFinder;
import kd.fi.gl.util.BalanceCheckHelper;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.CheckCashAccHasCF;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherEntryInitProducer;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.threads.Producer;
import kd.fi.gl.util.voucher.check.VoucherCheckExecutor;
import kd.fi.gl.util.voucher.check.VoucherCheckType;

public class CheckFlexDataFormplugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOG = LogFactory.getLog(CheckFlexDataFormplugin.class);
    private static final String entryKey = "entryentity";
    private static final String ORGS = "orgs";
    private static final String PROGRESSBARAP = "progressbarapcashflow";
    private static final String PROGRESS = "progress2";
    private static final String INFO = "info";
    private static final String updateVoucherSql = "update t_gl_voucherentry set fmaincfassgrpid = ? where fentryid = ? and fmaincfitemid = ? and fmaincfassgrpid =?";
    private static final String insertCashLogSql = "INSERT INTO t_gl_cashflow_log(FID,FCREATETIME,FVOUCHERID,FORGID,FBOOKTYPEID,FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID,FAMOUNT,FCOUNT,FOPERATION,FCALCULATED) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkvoucher"});
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap", "checkvoucher"});
        MulBasedataEdit orgs = (MulBasedataEdit)this.getControl(ORGS);
        orgs.addBeforeF7SelectListener(evt -> {
            List filter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            DynamicObjectCollection col = BalanceCheckHelper.getAllBooks(null);
            Set orgids = col.stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
            filter.add(new QFilter("id", "in", orgids));
        });
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)new VoucherCheckExecutor(this.getView().getPageId()));
    }

    public void initialize() {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        HashSet<Long> orgIds = new HashSet(1);
        if (orgs != null && !orgs.isEmpty()) {
            orgIds = orgs.stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        switch (key = evt.getItemKey()) {
            case "checkcf": {
                this.checkCfitemFlow();
                break;
            }
            case "fixcf": {
                break;
            }
            case "checkbalall": {
                this.checkAllBal();
                break;
            }
            case "checkcfall": {
                this.checkAllCf();
                break;
            }
            case "checkbalper": {
                this.checkbalperiod();
                break;
            }
            case "fixerracctbal": {
                this.fixAcctErrbal();
                break;
            }
            case "fixerrcfbal": {
                this.fixCfErrbal();
                break;
            }
            case "initvouchereorg": {
                int threadParallelism = 5;
                ArrayBlockingQueue taskQueue = new ArrayBlockingQueue(threadParallelism * 8, true);
                AtomicBoolean isAbort = new AtomicBoolean(false);
                String taskIdentifier = "reinitVoucherEntryOrgAndPeriod " + RequestContext.getOrCreate().getRequestId();
                VoucherEntryInitProducer producer = new VoucherEntryInitProducer(taskQueue, taskIdentifier, isAbort);
                Consumer consumer = new Consumer(taskQueue, taskIdentifier, threadParallelism, (Producer)producer, isAbort);
                producer.setConsumer(consumer);
                ThreadService.execute((Runnable)producer, (TaskType)TaskType.GL_UPDATE_ENTRY_REDUNDANT_PRODUCER, null, (OperationContext)OperationContext.get());
                ThreadService.execute((Runnable)consumer, (TaskType)TaskType.GL_UPDATE_ENTRY_REDUNDANT_CONSUMER, null, (OperationContext)OperationContext.get());
                try {
                    consumer.getFinishLatch().await();
                }
                catch (InterruptedException e) {
                    LOG.error("failed to upgrade on " + e.getMessage(), (Throwable)e);
                    throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
                LOG.info(taskIdentifier + " upgrade done, total update voucher entry count: " + consumer.getTotalHandleItemCnt());
                break;
            }
            case "checkcashflowassgrp": {
                this.checkErrorCashflowAssgrp(false);
                break;
            }
            case "fixcashflowassgrp": {
                this.checkErrorCashflowAssgrp(true);
                break;
            }
            case "checkcashacchasmaincf": {
                this.checkCashAccHasMainCF(false);
                break;
            }
            case "fixcashacchasmaincf": {
                this.checkCashAccHasMainCF(true);
                break;
            }
            case "fixduplicateassistid": {
                try {
                    int totalReplaceCount = AssistDuplicateRepairTool.work((IAssistIdFinder)new DuplicateAssistIdFinder());
                    String msg = "repair " + totalReplaceCount + " count success. ";
                    LOG.error(msg);
                    this.getView().showTipNotification(msg);
                }
                catch (Exception e) {
                    LOG.error("failed repair on " + e.getMessage(), (Throwable)e);
                    String msg = "repair failed, traceid:" + RequestContext.getOrCreate().getTraceId();
                    this.getView().showErrMessage(msg, "Repair Assist");
                }
                break;
            }
            case "addassistuniqueindex": {
                AssistDuplicateRepairTool.fixUniqueIndex();
                this.getView().showTipNotification("add index success");
                break;
            }
            case "fixvouchercount": {
                if (CollectionUtils.isNotEmpty(orgIds)) {
                    boolean result;
                    List periods = null;
                    DynamicObjectCollection periodColl = (DynamicObjectCollection)this.getModel().getValue("periods");
                    if (!periodColl.isEmpty()) {
                        periods = periodColl.stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    }
                    if (result = new VoucherCountFixService().fixVoucherCount(orgIds, periods)) {
                        this.getView().showSuccessNotification("finish");
                        break;
                    }
                    this.getView().showErrorNotification("error");
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"CheckFlexDataFormplugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "checkcfassgrp": {
                if (CollectionUtils.isNotEmpty(orgIds)) {
                    this.checkCfAssgrp(orgIds);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"CheckFlexDataFormplugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fixvouchercfassgrp": {
                this.fixVoucherCfAssgrp();
                break;
            }
            case "checkvouchercashflow": {
                IFormView view = this.getView();
                boolean openprogress = (Boolean)view.getModel().getValue("openprogress");
                if (openprogress) {
                    this.getPageCache().put(PROGRESS, "5");
                    ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
                    progressBar.setPercent(5);
                    progressBar.start();
                    GLThreadService.submit((String)CheckFlexDataFormplugin.class.getName(), () -> this.checkVoucherCashflow(view));
                    break;
                }
                this.checkVoucherCashflow(view);
                break;
            }
            case "transferzero": {
                this.transfter();
                break;
            }
            case "recalacctbal": {
                this.recalAcctBal();
                break;
            }
        }
    }

    protected void recalAcctBal() {
        Set<Long> selOrg = this.getSelOrg();
        DynamicObjectCollection books = null;
        books = selOrg != null && !selOrg.isEmpty() ? BalanceCheckHelper.getAllBooks((QFilter)new QFilter("org", "in", selOrg)) : BalanceCheckHelper.getAllBooks(null);
        for (DynamicObject book : books) {
            long org = book.getLong("org");
            long booktype = book.getLong("bookstype");
            AcctBalUpdateProcess process = new AcctBalUpdateProcess(org, booktype);
            process.update();
        }
    }

    private void transfter() {
        Set<Long> selOrg = this.getSelOrg();
        DynamicObjectCollection books = null;
        books = selOrg != null && !selOrg.isEmpty() ? BalanceCheckHelper.getAllBooks((QFilter)new QFilter("org", "in", selOrg)) : BalanceCheckHelper.getAllBooks(null);
        for (DynamicObject book : books) {
            long org = book.getLong("org");
            long booktype = book.getLong("bookstype");
            long curperiod = book.getLong("curperiod");
            Long yearMaxPeriod = GLUtil.getCurYearMaxPeriod((long)curperiod);
            long transferPeriod = -1L;
            if (yearMaxPeriod == curperiod) {
                transferPeriod = curperiod;
            } else {
                long maxPeriod;
                DynamicObject previousYearMinPeriod = GLUtil.getPreviousYearMinPeriod((long)curperiod);
                transferPeriod = maxPeriod = GLUtil.getCurYearMaxPeriod((long)previousYearMinPeriod.getLong("id")).longValue();
            }
            if (transferPeriod <= 0L) continue;
            ZeroBalanceCarryover.carryoverBal((long)org, (long)booktype, (long)transferPeriod, (long)book.getLong("startperiod"), (boolean)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long orgId;
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        DynamicObjectCollection col = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        if (!BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.recal.all", (boolean)false) && (col.isEmpty() || col.size() > 1)) {
            this.getView().showTipNotification("Do you know what you do now? only one org support!");
            args.setCancel(true);
            return;
        }
        if (operateKey.equals("fixallacct")) {
            orgId = ((DynamicObject)col.get(0)).getDynamicObject("fbasedataid").getLong("id");
            formOp.getOption().setVariableValue("org", String.valueOf(orgId));
            formOp.getOption().setVariableValue("type", "1");
        }
        if (operateKey.equals("fixallcf")) {
            orgId = ((DynamicObject)col.get(0)).getDynamicObject("fbasedataid").getLong("id");
            formOp.getOption().setVariableValue("org", String.valueOf(orgId));
            formOp.getOption().setVariableValue("type", "2");
        }
        if (operateKey.equals("recalallacctbal")) {
            formOp.getOption().setVariableValue("type", "1");
            formOp.getOption().setVariableValue("recalall", "1");
        }
        if (operateKey.equals("recalallcfbal")) {
            formOp.getOption().setVariableValue("type", "2");
            formOp.getOption().setVariableValue("recalall", "1");
        }
        if (operateKey.equals("recalallbal")) {
            formOp.getOption().setVariableValue("type", "3");
            formOp.getOption().setVariableValue("recalall", "1");
        }
    }

    private void fixCfErrbal() {
        DynamicObjectCollection col = this.getBizOrg();
        BalanceCheckHelper.getCfBalErrData((DynamicObjectCollection)col, (boolean)true);
        this.getView().showSuccessNotification("fix finish");
    }

    private void fixAcctErrbal() {
        DynamicObjectCollection col = this.getBizOrg();
        BalanceCheckHelper.getAcctBalErrData((DynamicObjectCollection)col, (boolean)true);
        this.getView().showSuccessNotification("fix finish");
    }

    private void checkbalperiod() {
        DynamicObjectCollection col = this.getBizOrg();
        ArrayList<String> err = new ArrayList<String>(100);
        DynamicObject selperiod = (DynamicObject)this.getModel().getValue("selperiod");
        long selPid = selperiod != null ? selperiod.getLong("id") : 0L;
        for (DynamicObject obj : col) {
            long orgId = obj.getLong("org");
            long btId = obj.getLong("bookstype");
            long startPid = 0L;
            long endPid = 0L;
            if (selPid != 0L) {
                startPid = selPid;
                endPid = selPid;
            } else {
                startPid = obj.getLong("curperiod");
                endPid = BalanceCheckHelper.getMaxVchPeriodId((long)orgId, (long)btId, (long)obj.getLong("curperiod"));
            }
            err.addAll(BalanceCheckHelper.checkBalPeriod((long)orgId, (long)btId, (long)startPid, (long)endPid));
        }
        this.createEntryData(err);
    }

    private DynamicObjectCollection getBizOrg() {
        Set<Long> orgIds = this.getSelOrg();
        return BalanceCheckHelper.getBizBook(orgIds);
    }

    private Set<Long> getSelOrg() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        Set orgIds = null;
        if (orgs != null && !orgs.isEmpty()) {
            orgIds = orgs.stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        return orgIds;
    }

    private void checkAllBal() {
        DynamicObjectCollection col = this.getBizOrg();
        List err = BalanceCheckHelper.getAcctBalErrData((DynamicObjectCollection)col, (boolean)false);
        ArrayList<String> newErr = new ArrayList<String>(err.size());
        for (String e : err) {
            String[] e1 = e.split("-");
            String sql = String.format("select * from t_gl_balance where forgid=%s and fbooktypeid=%s and faccountid=%s and fcomassist1id=%s and fcomassist2id=%s and fassgrpid=%s and fcurrencyid=%s;", e1[0], e1[1], e1[2], e1[3], e1[4], e1[5], e1[6]);
            newErr.add(sql);
        }
        this.createEntryData(newErr);
    }

    private void createEntryData(List<String> err) {
        IDataModel m = this.getModel();
        m.deleteEntryData(entryKey);
        if (!err.isEmpty()) {
            m.beginInit();
            for (String e : err) {
                int i = m.createNewEntryRow(entryKey);
                m.setValue("assvals", (Object)e, i);
            }
            m.endInit();
            this.getView().updateView(entryKey);
        }
        this.getView().showSuccessNotification("check finish");
    }

    private void checkAllCf() {
        DynamicObjectCollection col = this.getBizOrg();
        List err = BalanceCheckHelper.getCfBalErrData((DynamicObjectCollection)col, (boolean)false);
        ArrayList<String> newErr = new ArrayList<String>(err.size());
        for (String e : err) {
            String[] e1 = e.split("-");
            String sql = String.format("select * from t_gl_cashflow where forgid=%s and fbooktypeid=%s and fcfitemid=%s and fassgrpid=%s;", e1[0], e1[1], e1[2], e1[3]);
            newErr.add(sql);
        }
        this.createEntryData(newErr);
    }

    private void checkCfitemFlow() {
        DynamicObjectCollection orgs = this.getBizOrg();
        ArrayList<String> err = new ArrayList<String>(100);
        for (DynamicObject obj : orgs) {
            long orgId = obj.getLong("org");
            long btId = obj.getLong("bookstype");
            err.addAll(BalanceCheckHelper.checkCfitemFlow((long)orgId, (long)btId, (long)0L, (long)obj.getLong("curperiod")));
        }
        this.createEntryData(err);
    }

    private Set<Long> getSelectOrg() {
        HashSet<Long> ids = new HashSet(1);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        if (orgs != null && !orgs.isEmpty()) {
            ids = orgs.stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        } else {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")}, null);){
                for (Row row : ds) {
                    ids.add(row.getLong("org"));
                }
            }
        }
        return ids;
    }

    private void checkErrorCashflowAssgrp(boolean isDeal) {
        Set<Long> orgs = this.getSelectOrg();
        Map<Long, Long> errorHg2RightHg = this.getErrorCashflowHg();
        IDataModel m = this.getModel();
        if (errorHg2RightHg.size() == 0) {
            m.deleteEntryData(entryKey);
            this.getView().showSuccessNotification("check finish");
            return;
        }
        if (isDeal) {
            this.dealErrorCashflowHg(orgs, errorHg2RightHg);
            this.getView().showSuccessNotification("deal finish");
        } else {
            List<String> errorStr = this.checkErrorCashflowHg(orgs, errorHg2RightHg);
            m.beginInit();
            DynamicObjectCollection col = m.getEntryEntity(entryKey);
            m.deleteEntryData(entryKey);
            col.clear();
            for (String erv : errorStr) {
                int i = m.createNewEntryRow(entryKey);
                m.setValue("assvals", (Object)erv, i);
            }
            m.endInit();
            this.getView().updateView(entryKey);
            this.getView().showSuccessNotification("check finish");
        }
    }

    private Map<Long, Long> getErrorCashflowHg() {
        Row row;
        Iterator iterator;
        HashMap<Long, Long> errorHgId2rightHgId = new HashMap<Long, Long>(16);
        HashMap<String, String> flexfield2BaseName = new HashMap<String, String>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkCashflowAssgrp", (String)"bd_asstacttype", (String)"valuesource,flexfield", (QFilter[])new QFilter[]{new QFilter("valuetype", "=", (Object)"1")}, (String)"");){
            for (Row row2 : ds) {
                String valueSource = row2.getString("valuesource");
                if ("bos_adminorg".equals(valueSource)) {
                    valueSource = "bos_org";
                }
                flexfield2BaseName.put(row2.getString("flexfield"), valueSource);
            }
        }
        if (flexfield2BaseName.size() == 0) {
            return errorHgId2rightHgId;
        }
        HashMap<String, Set> entryName2baseIds = new HashMap<String, Set>(16);
        HashMap<String, Set<Long>> baseId2groupIds = new HashMap<String, Set<Long>>(16);
        HashMap<String, Long> id2MasetrId = new HashMap<String, Long>(16);
        HashSet<Long> errorGroupIds = new HashSet<Long>(16);
        Throwable throwable = null;
        try (Object ds = QueryServiceHelper.queryDataSet((String)"checkCashflowAssgrp", (String)"gl_assist_bd", (String)"asstype,assval,hg", (QFilter[])new QFilter[]{new QFilter("asstype", "in", flexfield2BaseName.keySet())}, (String)"");){
            iterator = ds.iterator();
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                entryName2baseIds.compute((String)flexfield2BaseName.get(row.getString("asstype")), (k, v) -> {
                    if (v == null) {
                        v = new HashSet<Long>(16);
                    }
                    v.add(row.getLong("assval"));
                    return v;
                });
                baseId2groupIds.compute(this.getKey(flexfield2BaseName.get(row.getString("asstype")), row.get("assval")), (k, v) -> {
                    if (v == null) {
                        v = new HashSet<Long>(16);
                    }
                    v.add(row.getLong("hg"));
                    return v;
                });
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : entryName2baseIds.entrySet()) {
            Set baseIds = (Set)entry.getValue();
            if (baseIds == null) continue;
            String baseEntryName = (String)entry.getKey();
            this.checkError(baseIds, baseEntryName, id2MasetrId, errorGroupIds, baseId2groupIds);
        }
        ds = QueryServiceHelper.queryDataSet((String)"checkCashflowAssgrp", (String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", errorGroupIds)}, (String)"");
        Throwable throwable4 = null;
        try {
            iterator = ds.iterator();
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                String valuesJson = row.getString("assvals");
                Map errorValues = null;
                HashMap rightValues = new HashMap(16);
                try {
                    errorValues = (Map)JSONUtils.cast((String)valuesJson, Map.class);
                }
                catch (IOException e) {
                    throw new KDBizException("assgrp error: " + valuesJson);
                }
                if (errorValues == null) continue;
                for (Map.Entry entry : errorValues.entrySet()) {
                    Object newValue = null;
                    String baseName = (String)flexfield2BaseName.get(entry.getKey());
                    if (baseName != null) {
                        newValue = id2MasetrId.get(this.getKey(flexfield2BaseName.get(entry.getKey()), entry.getValue()));
                    }
                    rightValues.put(entry.getKey(), newValue == null ? (Object)entry.getValue() : newValue);
                }
                errorHgId2rightHgId.put(row.getLong("id"), FlexUtils.saveFlexData(rightValues));
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        finally {
            if (ds != null) {
                if (throwable4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable7) {
                        throwable4.addSuppressed(throwable7);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return errorHgId2rightHgId;
    }

    private String getKey(Object flexfield, Object basId) {
        StringBuilder sb = new StringBuilder(3);
        sb.append(flexfield);
        sb.append("+");
        sb.append(basId);
        return sb.toString();
    }

    private void checkError(Set<Long> baseIds, String baseEntryName, Map<String, Long> id2MasetrId, Set<Long> errorGroupIds, Map<String, Set<Long>> baseId2groupIds) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntryName);
        DynamicProperty masterid = dataEntityType.getProperty("masterid");
        if (masterid != null && StringUtils.isNotEmpty((String)masterid.getAlias())) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkCashflowAssgrp", (String)baseEntryName, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", baseIds), new QFilter("id", "!=", (Object)"masterid", true)}, (String)"");){
                for (Row row : ds) {
                    String key = this.getKey(baseEntryName, row.getLong("id"));
                    id2MasetrId.put(key, row.getLong("masterid"));
                    errorGroupIds.addAll((Collection<Long>)baseId2groupIds.get(key));
                }
            }
        }
    }

    private void dealErrorCashflowHg(Set<Long> orgs, Map<Long, Long> errorHgId2rightHgId) {
        SqlBuilder voucherSql = new SqlBuilder();
        voucherSql.appendIn("select distinct forgid,fbooktypeid,fperiodid from t_gl_voucher where forgid ", orgs.toArray());
        HashMap<String, List<Long>> orgBooktype2Periods = new HashMap<String, List<Long>>();
        HashMap<Long, Set> org2BookType = new HashMap<Long, Set>();
        try (DataSet ds = DB.queryDataSet((String)"checkCashflowAssgrp", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)voucherSql).orderBy(new String[]{"forgid", "fbooktypeid", "fperiodid"});){
            for (Row row : ds) {
                orgBooktype2Periods.compute(this.getKey(row.getLong("forgid"), row.getLong("fbooktypeid")), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Long>(16);
                    }
                    v.add(row.getLong("fperiodid"));
                    return v;
                });
                org2BookType.compute(row.getLong("forgid"), (k, v) -> {
                    if (v == null) {
                        v = new HashSet<Long>(16);
                    }
                    v.add(row.getLong("fbooktypeid"));
                    return v;
                });
            }
        }
        for (Long org : orgs) {
            this.dealErrorCashflowHgSingleOrg(org, orgBooktype2Periods, (Set)org2BookType.get(org), errorHgId2rightHgId);
        }
    }

    private void dealErrorCashflowHgSingleOrg(Long org, Map<String, List<Long>> periodIds, Set<Long> booktype, Map<Long, Long> errorHgId2rightHgId) {
        if (booktype == null) {
            return;
        }
        ArrayList periodList = new ArrayList(16);
        for (Long bookType : booktype) {
            periodList.addAll(periodIds.get(this.getKey(org, bookType)));
        }
        try (TXHandle handler = TX.requiresNew();){
            try {
                SqlBuilder voucherSql = new SqlBuilder();
                voucherSql.append(this.getSql("update t_gl_voucherentry set fmaincfassgrpid = ? where forgid = ? and fperiodid in (", periodList.size()), new Object[0]);
                voucherSql.append("and fmaincfassgrpid = ?", new Object[0]);
                ArrayList<Object[]> params = new ArrayList<Object[]>(errorHgId2rightHgId.size());
                for (Map.Entry<Long, Long> entry : errorHgId2rightHgId.entrySet()) {
                    ArrayList<Long> paramList = new ArrayList<Long>(periodList.size() + 3);
                    paramList.add(entry.getValue());
                    paramList.add(org);
                    paramList.addAll(periodList);
                    paramList.add(entry.getKey());
                    params.add(paramList.toArray());
                }
                if (params.size() != 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)voucherSql.toString(), params);
                }
                SqlBuilder cashflowSql = new SqlBuilder();
                cashflowSql.append("delete from t_gl_cashflow where forgid = ", new Object[]{org});
                cashflowSql.appendIn("and fassgrpid ", errorHgId2rightHgId.keySet().toArray());
                if (errorHgId2rightHgId.size() != 0) {
                    DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)cashflowSql);
                }
            }
            catch (Exception e) {
                handler.markRollback();
                LOG.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            if (errorHgId2rightHgId.size() == 0) {
                return;
            }
            for (Long bookType : booktype) {
                Lock.tryLock((long)org, (long)bookType, (LockKey)LockKey.CashflowCal, () -> {
                    ICalculator calculator = CalculatorFactory.createCashflowCalculator();
                    for (Long period : (List)periodIds.get(this.getKey(org, bookType))) {
                        calculator.reCalculate(org.longValue(), bookType.longValue(), period.longValue());
                    }
                });
            }
        }
    }

    private List<String> checkErrorCashflowHg(Set<Long> orgs, Map<Long, Long> errorHgId2rightHgId) {
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkCashflowAssgrp", (String)"gl_cashflow", (String)"org,org.number,cfitem,cfitem.number,assgrp,period,endperiod,amount,yearamount", (QFilter[])new QFilter[]{new QFilter("org", "in", orgs), new QFilter("assgrp", "in", errorHgId2rightHgId.keySet())}, (String)"org,cfitem,assgrp,period");){
            for (Row row : ds) {
                StringBuilder sb = new StringBuilder(16);
                sb.append("org-");
                sb.append(row.getLong("org"));
                sb.append("-orgNumber-");
                sb.append(row.getString("org.number"));
                sb.append("-cfitem-");
                sb.append(row.getLong("cfitem"));
                sb.append("-cfitemNumber-");
                sb.append(row.getString("cfitem.number"));
                sb.append("-assgrp-");
                sb.append(row.getLong("assgrp"));
                sb.append("-period-");
                sb.append(row.getLong("period"));
                sb.append("-endperiod-");
                sb.append(row.getLong("endperiod"));
                sb.append("-amount-");
                sb.append(row.getBigDecimal("amount"));
                sb.append("-yearamount-");
                sb.append(row.getBigDecimal("yearamount"));
                errorMsg.add(sb.toString());
            }
        }
        return errorMsg;
    }

    private String getSql(String sql, int size) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 1; i < size; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(5);
        StringJoiner values = new StringJoiner(",");
        for (VoucherCheckType checkType : VoucherCheckType.values()) {
            String value = String.valueOf(checkType.getValue());
            items.add(new ComboItem(new LocaleString(checkType.getDescription()), value));
            values.add(value);
        }
        ComboEdit checkTypeComboEdit = (ComboEdit)this.getControl("voucherchecktype");
        checkTypeComboEdit.setComboItems(items);
        this.getModel().setValue("voucherchecktype", (Object)values.toString());
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "checkvoucher": {
                new VoucherCheckExecutor(this.getView().getPageId()).execute();
                ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
                progressBar.start();
            }
        }
    }

    private void checkCashAccHasMainCF(boolean isdeal) {
        DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        DynamicObjectCollection periodColl = (DynamicObjectCollection)this.getModel().getValue("periods");
        if (orgColl.isEmpty() || periodColl.isEmpty()) {
            this.getView().showTipNotification("org and period not null");
            return;
        }
        ArrayList<Long> orgids = new ArrayList<Long>(orgColl.size());
        ArrayList<Long> periods = new ArrayList<Long>(16);
        for (DynamicObject org : orgColl) {
            orgids.add(org.getDynamicObject("fbasedataid").getLong("id"));
        }
        for (DynamicObject period : periodColl) {
            periods.add(period.getDynamicObject("fbasedataid").getLong("id"));
        }
        List errorVoucheers = CheckCashAccHasCF.checkCashAccHasCF(orgids, periods, (boolean)isdeal);
        if (errorVoucheers == null) {
            this.getView().showTipNotification("org and period not null");
            return;
        }
        if (!isdeal) {
            IDataModel m = this.getModel();
            m.beginInit();
            DynamicObjectCollection col = m.getEntryEntity(entryKey);
            m.deleteEntryData(entryKey);
            col.clear();
            for (String erv : errorVoucheers) {
                int i = m.createNewEntryRow(entryKey);
                m.setValue("assvals", (Object)erv, i);
            }
            m.endInit();
            this.getView().updateView(entryKey);
            this.getView().showSuccessNotification("check finish");
        } else {
            this.getView().showSuccessNotification("deal success size : " + (String)errorVoucheers.get(0));
        }
    }

    private void checkCfAssgrp(Set<Long> orgs) {
        IDataModel m = this.getModel();
        m.beginInit();
        DynamicObjectCollection col = m.getEntryEntity("entryentity1");
        m.deleteEntryData("entryentity1");
        col.clear();
        List noAssistCashflowItem = QueryServiceHelper.queryPrimaryKeys((String)((Object)((Object)this)).getClass().getName(), (String)"gl_cashflowitem", (QFilter[])new QFilter[]{new QFilter("isassist", "=", (Object)"0")}, null, (int)-1);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct a.fentryid, a.forgid  from t_gl_voucherentry a inner join t_gl_cashflowitem b on a.fmaincfitemid = b.fid where b.fisassist = '0' and a.fmaincfassgrpid <> 0 ", new Object[0]);
        sqlBuilder.appendIn("and a.fmaincfitemid ", noAssistCashflowItem.toArray());
        sqlBuilder.appendIn("and a.forgid ", orgs.toArray());
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        for (Row row : dataSet) {
            int i = m.createNewEntryRow("entryentity1");
            m.setValue("voucherid", (Object)row.getLong("fentryid"), i);
            m.setValue("errortype", (Object)ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u4e0d\u5e26\u6838\u7b97\u7ef4\u5ea6\uff0c\u4f46\u51ed\u8bc1\u63d0\u4ea4\u7684\u73b0\u91d1\u6d41\u91cf\u5e26\u6709\u6838\u7b97\u7ef4\u5ea6", (String)"CheckFlexDataFormplugin_1", (String)"fi-gl-formplugin", (Object[])new Object[]{i}));
        }
        QFilter assistFilter = new QFilter("isassist", "=", (Object)"1");
        QFilter isRequireFilter = new QFilter("assistentry.isrequire", "=", (Object)"1");
        DynamicObjectCollection cashflowItem = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id, assistentry.asstypeid.flexfield flexfield, assistentry.isrequire isrequire", (QFilter[])new QFilter[]{assistFilter, isRequireFilter});
        HashMap cashflowItemAssistMap = new HashMap(cashflowItem.size());
        for (DynamicObject dyn : cashflowItem) {
            Long itemId = dyn.getLong("id");
            String flexfield = dyn.getString("flexfield");
            if (cashflowItemAssistMap.containsKey(itemId)) {
                ((Set)cashflowItemAssistMap.get(itemId)).add(flexfield);
                continue;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(flexfield);
            cashflowItemAssistMap.put(itemId, set);
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentryid ,a.fmaincfitemid , a.fmaincfassgrpid , c.fflexfield from t_gl_voucherentry a inner join t_gl_assist b on a.fmaincfassgrpid = b.fid left join t_gl_assist_bd c on b.fid = c.fid where ", new Object[0]);
        sqlBuilder.appendIn("a.fmaincfitemid ", cashflowItemAssistMap.keySet().toArray());
        sqlBuilder.appendIn("and a.forgid ", orgs.toArray());
        sqlBuilder.append(" order by a.fentryid", new Object[0]);
        DataSet dataSet1 = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        HashMap<Long, Set<String>> entryFlexMap = new HashMap<Long, Set<String>>();
        for (Row row : dataSet1) {
            Long entryId = row.getLong("fentryid");
            Long maincfitemid = row.getLong("fmaincfitemid");
            String flexfield = row.getString("fflexfield");
            Set flexSet = (Set)cashflowItemAssistMap.get(maincfitemid);
            if (entryFlexMap.isEmpty()) {
                this.setMap(entryId, flexSet, flexfield, entryFlexMap);
                continue;
            }
            Set entrytSet = (Set)entryFlexMap.get(entryId);
            if (entrytSet != null) {
                if (kd.bos.ext.fi.util.StringUtils.isNotEmpty((String)flexfield)) {
                    entrytSet.remove(flexfield);
                }
                entryFlexMap.put(entryId, entrytSet);
                continue;
            }
            if (((Set)entryFlexMap.values().iterator().next()).size() > 0) {
                int i = m.createNewEntryRow("entryentity1");
                m.setValue("voucherid", (Object)row.getLong("fentryid"), i);
                m.setValue("errortype", (Object)ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6\u5fc5\u5f55\uff0c\u4f46\u51ed\u8bc1\u63d0\u4ea4\u7684\u73b0\u91d1\u6d41\u91cf\u6838\u7b97\u7ef4\u5ea6\u4e3a\u7a7a", (String)"CheckFlexDataFormplugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{i}));
                continue;
            }
            entryFlexMap.clear();
            this.setMap(entryId, flexSet, flexfield, entryFlexMap);
        }
        m.endInit();
        this.getView().updateView("entryentity1");
        this.getView().showSuccessNotification("check finish");
    }

    private void setMap(Long entryId, Set flexSet, String flexfield, Map<Long, Set<String>> entryFlexMap) {
        HashSet entrytSet = new HashSet(flexSet);
        if (kd.bos.ext.fi.util.StringUtils.isNotEmpty((String)flexfield)) {
            entrytSet.remove(flexfield);
        }
        entryFlexMap.put(entryId, entrytSet);
    }

    private void fixVoucherCfAssgrp() {
        DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        DynamicObjectCollection periodColl = (DynamicObjectCollection)this.getModel().getValue("periods");
        if (orgColl.isEmpty() || periodColl.isEmpty()) {
            this.getView().showTipNotification("org and period not null");
            return;
        }
        ArrayList<Long> orgids = new ArrayList<Long>(orgColl.size());
        ArrayList<Long> periods = new ArrayList<Long>(16);
        for (DynamicObject org : orgColl) {
            orgids.add(org.getDynamicObject("fbasedataid").getLong("id"));
        }
        for (DynamicObject period : periodColl) {
            periods.add(period.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashMap<Long, List> cashflowAssgrp = new HashMap<Long, List>(16);
        try (DataSet cashflowMap = QueryServiceHelper.queryDataSet((String)"CheckFlexDataFormplugin", (String)"gl_cashflowitem", (String)"id,assistentry.asstypeid.flexfield flexfield", (QFilter[])new QFilter[]{new QFilter("isassist", "=", (Object)true)}, (String)"id");){
            for (Row row : cashflowMap) {
                long cashflowId = row.getLong("id");
                String flexfield = row.getString("flexfield");
                cashflowAssgrp.compute(cashflowId, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>(8);
                    }
                    v.add(flexfield);
                    return v;
                });
            }
        }
        QFilter orgf = new QFilter("org", "in", orgids);
        QFilter periodf = new QFilter("period", "in", periods);
        QFilter cfFilter = new QFilter("entries.maincfitem", ">", (Object)0L);
        QFilter cfass = new QFilter("entries.maincfassgrp", ">", (Object)0L);
        HashSet<String> orgBooktypes = new HashSet<String>(16);
        HashSet<String> errormsg = new HashSet<String>(16);
        ArrayList<Object[]> voucherUpdateParms = new ArrayList<Object[]>(16);
        ArrayList<Object[]> cashflowLogParams = new ArrayList<Object[]>(16);
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)"org,booktype,period,id,localcur,entries.maincfitem cf,entries.id entryid, entries.maincfitem.masterid cfmasterid,entries.maincfassgrp cfassgrp,entries.maincfassgrp.value assval,entries.maincfamount amount", (QFilter[])new QFilter[]{orgf, periodf, cfFilter, cfass}, (String)"org,booktype,period,id", (int)-1);){
            for (Row row : ds) {
                String assval = row.getString("assval");
                Map assMap = null;
                try {
                    assMap = (Map)JSONUtils.cast((String)assval, Map.class);
                }
                catch (IOException ex) {
                    errormsg.add(assval);
                    continue;
                }
                HashMap assMapNew = new HashMap(assMap);
                long cfid = row.getLong("cf");
                List assList = (List)cashflowAssgrp.get(cfid);
                if (assList == null || assList.size() == 0) {
                    assMapNew = null;
                } else {
                    for (Map.Entry entry : assMap.entrySet()) {
                        if (assList.contains(entry.getKey())) continue;
                        assMapNew.remove(entry.getKey());
                    }
                }
                if (assMapNew == null || assMap.size() > assMapNew.size()) {
                    orgBooktypes.add(row.getLong("org") + "-" + row.getLong("booktype"));
                    cashflowLogParams.add(this.getLogParam(row, true, row.getLong("cfassgrp")));
                    long assgrpId = assMapNew == null ? 0L : FlexUtils.saveFlexData(assMapNew);
                    cashflowLogParams.add(this.getLogParam(row, false, assgrpId));
                    voucherUpdateParms.add(new Object[]{assgrpId, row.getLong("entryid"), row.getLong("cfmasterid"), row.getLong("cfassgrp")});
                }
                if (cashflowLogParams.size() < 998) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertCashLogSql, cashflowLogParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateVoucherSql, voucherUpdateParms);
                CashFlowItemHelper.calBal(orgBooktypes);
                cashflowLogParams.clear();
                voucherUpdateParms.clear();
                orgBooktypes.clear();
            }
        }
        if (cashflowLogParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertCashLogSql, cashflowLogParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateVoucherSql, voucherUpdateParms);
            CashFlowItemHelper.calBal(orgBooktypes);
        }
        if (errormsg.size() > 0) {
            this.getView().showTipNotification(((Object)errormsg).toString());
        } else {
            this.getView().showSuccessNotification("success");
        }
    }

    private Object[] getLogParam(Row voucher, boolean isDelete, Long assgrpid) {
        ArrayList<Object> params = new ArrayList<Object>(9);
        long id = DB.genLongId((String)"gl_cashflow_log");
        params.add(id);
        params.add(new Date());
        params.add(voucher.getLong("id"));
        params.add(voucher.getLong("org"));
        params.add(voucher.getLong("booktype"));
        params.add(voucher.getLong("period"));
        params.add(voucher.getLong("cfmasterid"));
        params.add(voucher.getLong("localcur"));
        params.add(assgrpid);
        params.add(voucher.getBigDecimal("amount"));
        if (isDelete) {
            params.add(-1);
            params.add("delete");
        } else {
            params.add(1);
            params.add("submit");
        }
        params.add(false);
        return params.toArray();
    }

    private void checkVoucherCashflow(IFormView view) {
        IDataModel model = view.getModel();
        IPageCache pagecache = view.getPageCache();
        DynamicObjectCollection orgColl = (DynamicObjectCollection)model.getValue(ORGS);
        DynamicObjectCollection periodColl = (DynamicObjectCollection)model.getValue("periods");
        ArrayList<Long> orgids = new ArrayList<Long>(orgColl.size());
        ArrayList<Long> periods = new ArrayList<Long>(16);
        for (Object org : orgColl) {
            orgids.add(org.getDynamicObject("fbasedataid").getLong("id"));
        }
        if (orgids.size() == 0) {
            this.getView().showTipNotification("org is null");
            pagecache.put(INFO, "org is null");
            pagecache.put(PROGRESS, "101");
            return;
        }
        QFilter qFilter = new QFilter("org", "=", orgids.get(0));
        if (periodColl != null && periodColl.size() > 0) {
            for (DynamicObject period : periodColl) {
                periods.add(period.getDynamicObject("fbasedataid").getLong("id"));
            }
        } else {
            this.getView().showTipNotification("periods is null");
            pagecache.put(INFO, "periods is null");
            pagecache.put(PROGRESS, "101");
            return;
        }
        QFilter periodF = new QFilter("period", "=", periods.get(0));
        ArrayList<Long> booktypes = new ArrayList<Long>(1);
        Map books = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{new QFilter("org", "=", orgids.get(0))});
        for (Map.Entry book : books.entrySet()) {
            booktypes.add(((DynamicObject)book.getValue()).getLong("bookstype_id"));
        }
        QFilter bookTypeFilter = new QFilter("booktype", "in", booktypes);
        Date date = (Date)this.getModel().getValue("datefield");
        if (date != null) {
            periodF.and(new QFilter("bookeddate", "=", (Object)date));
        }
        QFilter sourceFilter = new QFilter("sourcetype", "!=", (Object)"1");
        String field = "id,billno,org,period,sourcetype,entries.account.pltype pltype,entries.debitlocal debit,entries.creditlocal credit,entries.maincfitem.isdealactivity isdealactivity,entries.maincfamount maincfamount,entries.maincfitem.direction direction,entries.suppcfamount suppcfamount";
        ArrayList<String> errorVouchers = new ArrayList<String>(16);
        pagecache.put(PROGRESS, "30");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CheckFlexDataFormplugin.class.getName(), (String)"gl_voucher", (String)field, (QFilter[])new QFilter[]{qFilter, bookTypeFilter, periodF, sourceFilter}, (String)"id");){
            pagecache.put(PROGRESS, "60");
            BigDecimal mainDealactivityAmount = BigDecimal.ZERO;
            BigDecimal suppAmount = BigDecimal.ZERO;
            BigDecimal netProfitsAmount = BigDecimal.ZERO;
            long voucherId = 0L;
            long orgid = 0L;
            long periodid = 0L;
            String vouchernumber = "";
            for (Row row : ds) {
                if (voucherId != 0L && voucherId != row.getLong("id")) {
                    if (mainDealactivityAmount.subtract(suppAmount).compareTo(netProfitsAmount) != 0) {
                        errorVouchers.add(orgid + "-" + periodid + "-" + vouchernumber + "-" + voucherId);
                    }
                    mainDealactivityAmount = BigDecimal.ZERO;
                    suppAmount = BigDecimal.ZERO;
                    netProfitsAmount = BigDecimal.ZERO;
                    voucherId = row.getLong("id");
                    orgid = row.getLong("org");
                    periodid = row.getLong("period");
                    vouchernumber = row.getString("billno");
                } else if (voucherId == 0L) {
                    voucherId = row.getLong("id");
                    orgid = row.getLong("org");
                    periodid = row.getLong("period");
                    vouchernumber = row.getString("billno");
                }
                if (row.getBoolean("isdealactivity").booleanValue()) {
                    BigDecimal rowMainAmount = "i".equals(row.getString("direction")) ? row.getBigDecimal("maincfamount") : row.getBigDecimal("maincfamount").negate();
                    mainDealactivityAmount = mainDealactivityAmount.add(rowMainAmount);
                }
                suppAmount = suppAmount.add(row.getBigDecimal("suppcfamount"));
                if ("0".equals(row.getString("pltype"))) continue;
                netProfitsAmount = netProfitsAmount.add(row.getBigDecimal("credit")).subtract(row.getBigDecimal("debit"));
            }
        }
        pagecache.put(PROGRESS, "80");
        if (DebugTrace.enable()) {
            LOG.info("checkVoucherCashflow_filter {}", (Object)(orgids.get(0) + "-" + booktypes.get(0) + "-" + periods.get(0) + "-" + date));
            LOG.info("checkVoucherCashflow_errorvoucher {}", errorVouchers);
        }
        IDataModel m = this.getModel();
        m.beginInit();
        DynamicObjectCollection col = m.getEntryEntity(entryKey);
        m.deleteEntryData(entryKey);
        col.clear();
        for (String erv : errorVouchers) {
            int i = m.createNewEntryRow(entryKey);
            m.setValue("assvals", (Object)erv, i);
        }
        m.endInit();
        this.getView().updateView(entryKey);
        this.getView().showSuccessNotification("check finish");
        pagecache.put(INFO, "check finish");
        pagecache.put(PROGRESS, "100");
        model.updateCache();
        model.getDataEntity(true);
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = this.getPageCache().get(PROGRESS) == null ? 5 : Integer.parseInt(this.getPageCache().get(PROGRESS));
        progressEvent.setProgress(percent);
        if (percent >= 100) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.setPercent(percent);
            progressBar.stop();
            if (percent == 100) {
                this.getView().showSuccessNotification(this.getPageCache().get(INFO));
            } else {
                this.getView().showTipNotification(this.getPageCache().get(INFO));
            }
            this.getPageCache().remove(INFO);
            this.getView().updateView(entryKey);
        }
    }
}

