/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.multilingual.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.formplugin.multilingual.MultilingualImportPlugin;
import kd.fi.gl.formplugin.multilingual.MultilingualRepairPlugin;
import kd.fi.gl.formplugin.multilingual.MultilingualResultBean;
import org.apache.poi.ss.usermodel.Row;

public class AccMultilingual
extends MultilingualImportPlugin {
    private static Log log = LogFactory.getLog(AccMultilingual.class);

    @Override
    public MultilingualResultBean getOutputData(String filter) {
        LinkedHashMap<List<String>, Map<String, List<String>>> map = new LinkedHashMap<List<String>, Map<String, List<String>>>(16);
        ArrayList<String> datas = null;
        String sql = "select tbau.fdataid ,tbau.fuseorgid forg,tba.faccounttableid faccounttable,tba.fnumber ,tbal.flocaleid ,tbal.fname ,tbal.ffullname,tba.fcreateorgid,tbac.fname acctablename from (select distinct fdataid,fuseorgid from t_bd_account_u) tbau inner join t_bd_account tba on tbau.fdataid = tba.fid inner join t_bd_account_l tbal on tbau.fdataid = tbal.fid  inner join T_BD_Accounttable tbac on tba.faccounttableid = tbac.fid  order by tba.fnumber  ";
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name", null, null);
        for (kd.bos.algo.Row row : orgDataSet) {
            orgMap.put(row.getLong("id"), row.getString("name"));
        }
        ArrayList<String> localeList = new ArrayList<String>();
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql, null);
        Object object = null;
        try {
            DataSet ds = dataSet;
            if (!StringUtils.isEmpty((String)filter)) {
                ds = dataSet.filter(filter);
            }
            for (kd.bos.algo.Row row : ds) {
                datas = new ArrayList<String>(4);
                HashMap<String, ArrayList<String>> localMap = new HashMap<String, ArrayList<String>>();
                ArrayList<String> headList = new ArrayList<String>();
                headList.add(row.getString("fdataid"));
                headList.add(row.getString("fnumber"));
                headList.add(row.getString("acctablename"));
                headList.add((String)orgMap.get(row.getLong("fcreateorgid")));
                String localeid = row.getString("flocaleid");
                if (!StringUtils.isBlank((String)localeid) && !localeList.contains(localeid)) {
                    localeList.add(localeid);
                }
                if (map.containsKey(headList)) {
                    if (((Map)map.get(headList)).containsKey(localeid)) continue;
                    datas.add(row.getString("fname"));
                    datas.add(row.getString("ffullname"));
                    ((Map)map.get(headList)).put(localeid, datas);
                    continue;
                }
                datas.add(row.getString("fname"));
                datas.add(row.getString("ffullname"));
                localMap.put(localeid, datas);
                map.put(headList, localMap);
            }
        }
        catch (Throwable ds) {
            object = ds;
            throw ds;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable ds) {
                        ((Throwable)object).addSuppressed(ds);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<String> headList = new ArrayList<String>(10);
        headList.add(ResManager.loadKDString((String)"\u79d1\u76eeID", (String)"AccMultilingualPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"AccMultilingualPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u8868", (String)"AccMultilingualPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"AccMultilingualPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        for (String localId : localeList) {
            headList.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0&%s", (String)"AccMultilingualPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), localId));
            headList.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u957f\u540d\u79f0&%s", (String)"AccMultilingualPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), localId));
        }
        MultilingualResultBean bean = new MultilingualResultBean();
        bean.setHeadNameList(headList);
        bean.setDataMap(map);
        bean.setLocaleList(localeList);
        return bean;
    }

    @Override
    protected Object setInfo(Long id, String number, Row row, MultilingualRepairPlugin.Local local) {
        AccountLInfo info = new AccountLInfo();
        info.setId(id);
        info.setNumber(number);
        info.setLocalId(local.getLocalId());
        info.setName(row.getCell(local.getNameIndex()) == null ? "" : this.getCell(row.getCell(local.getNameIndex())));
        info.setFullName(row.getCell(local.getFullNameIndex()) == null ? "" : this.getCell(row.getCell(local.getFullNameIndex())));
        return info;
    }

    @Override
    protected void insertInfoToDB(List<Object> list) {
        if (!CollectionUtils.isEmpty(list)) {
            try (TXHandle h1 = TX.requiresNew();){
                try {
                    ArrayList<Long> accList = new ArrayList<Long>(list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        AccountLInfo acc = (AccountLInfo)list.get(i);
                        long id = acc.getId();
                        if (accList.contains(id)) continue;
                        accList.add(id);
                    }
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,masterid,number", (QFilter[])new QFilter("id", "in", accList).toArray(), null);
                    DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id as rid,masterid as rmasterid,number as rnumber", (QFilter[])new QFilter("id", "in", accList).toArray(), null);
                    dataSet = dataSet.join(dataSet1, JoinType.INNER).on("masterid", "rmasterid").on("number", "rnumber").select(new String[]{"id"}).finish();
                    HashMap accVersionMap = new HashMap(list.size());
                    for (kd.bos.algo.Row row : dataSet) {
                        long fid = row.getLong("id");
                        if (accVersionMap.containsKey(fid)) {
                            ((Set)accVersionMap.get(fid)).add(fid);
                            continue;
                        }
                        HashSet<Long> set = new HashSet<Long>(1);
                        set.add(fid);
                        accVersionMap.put(fid, set);
                    }
                    ArrayList<Long> fidList = new ArrayList<Long>(list.size());
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        AccountLInfo acc = (AccountLInfo)list.get(i);
                        Set accSet = (Set)accVersionMap.get(acc.getId());
                        Iterator iterator = accSet.iterator();
                        while (iterator.hasNext()) {
                            long accId = (Long)iterator.next();
                            paramsList.add(this.setAccInfo(accId, acc));
                            fidList.add(accId);
                        }
                    }
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_bd_account_l where ", new Object[0]);
                    sql.appendIn(" fid", fidList);
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_account_l(fid,fpkid,flocaleid,fname,ffullname) values(?,?,?,?,?)", paramsList);
                }
                catch (Throwable e1) {
                    log.error(e1);
                    h1.markRollback();
                }
            }
        }
        log.info("AccMultilingual import end");
    }

    private Object[] setAccInfo(long id, AccountLInfo acc) {
        return new Object[]{id, DB.genStringId((String)"t_bd_account_l"), acc.getLocalId(), acc.getName(), acc.getFullName()};
    }

    @Override
    protected boolean isFiledIndex(String value) {
        return value.contains(ResManager.loadKDString((String)"\u79d1\u76eeID", (String)"AccMultilingualImortPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean isFiledNumIndex(String value) {
        return value.contains(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"AccMultilingualImortPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    static class AccountLInfo {
        private long id;
        private String pkId;
        private String localId;
        private String name;
        private String fullName;
        private String number;

        AccountLInfo() {
        }

        public String getPkId() {
            return this.pkId;
        }

        public void setPkId(String pkId) {
            this.pkId = pkId;
        }

        public String getLocalId() {
            return this.localId;
        }

        public void setLocalId(String localId) {
            this.localId = localId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }
}

