/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.multilingual.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.formplugin.multilingual.MultilingualImportPlugin;
import kd.fi.gl.formplugin.multilingual.MultilingualRepairPlugin;
import kd.fi.gl.formplugin.multilingual.MultilingualResultBean;
import org.apache.poi.ss.usermodel.Row;

public class AccTypeMultilingual
extends MultilingualImportPlugin {
    private static Log log = LogFactory.getLog(AccTypeMultilingual.class);

    @Override
    public MultilingualResultBean getOutputData(String filter) {
        super.getOutputData(filter);
        LinkedHashMap<List<String>, Map<String, List<String>>> map = new LinkedHashMap<List<String>, Map<String, List<String>>>(16);
        ArrayList<String> datas = null;
        String sql = "select a.faccounttableid faccounttable, c.fname acctablename,a.fnumber ,a.fname , a.fcreatorid forg, b.flocaleid ,b.ffullname ,b.fname fname_l from t_bd_accounttype a ,t_bd_accounttype_l b,T_BD_Accounttable c where a.fid = b.fid and a.faccounttableid  = c.fid";
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name", null, null);
        for (kd.bos.algo.Row row : orgDataSet) {
            orgMap.put(row.getLong("id"), row.getString("name"));
        }
        ArrayList<String> localeList = new ArrayList<String>();
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql, null);
        Object object = null;
        try {
            for (kd.bos.algo.Row row : dataSet) {
                datas = new ArrayList<String>(4);
                HashMap<String, ArrayList<String>> localMap = new HashMap<String, ArrayList<String>>();
                ArrayList<String> headList = new ArrayList<String>();
                headList.add(row.getString("faccounttable"));
                headList.add(row.getString("acctablename"));
                headList.add(row.getString("fnumber"));
                headList.add(row.getString("fname"));
                headList.add((String)orgMap.get(row.getLong("forg")));
                String localeid = row.getString("flocaleid");
                if (!StringUtils.isBlank((CharSequence)localeid) && !localeList.contains(localeid)) {
                    localeList.add(localeid);
                }
                if (map.containsKey(headList)) {
                    if (((Map)map.get(headList)).containsKey(localeid)) continue;
                    datas.add(row.getString("fname"));
                    datas.add(row.getString("ffullname"));
                    ((Map)map.get(headList)).put(localeid, datas);
                    continue;
                }
                datas.add(row.getString("fname"));
                datas.add(row.getString("ffullname"));
                localMap.put(localeid, datas);
                map.put(headList, localMap);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<String> headList = new ArrayList<String>(10);
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u8868ID", (String)"AccTypeMultilingual_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u8868", (String)"AccTypeMultilingual_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u7f16\u7801", (String)"AccTypeMultilingual_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u540d\u79f0", (String)"AccTypeMultilingual_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        headList.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"AccTypeMultilingual_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        for (String localId : localeList) {
            headList.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u540d\u79f0&%s", (String)"AccTypeMultilingual_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), localId));
            headList.add(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u957f\u540d\u79f0&%s", (String)"AccTypeMultilingual_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), localId));
        }
        MultilingualResultBean bean = new MultilingualResultBean();
        bean.setHeadNameList(headList);
        bean.setDataMap(map);
        bean.setLocaleList(localeList);
        return bean;
    }

    @Override
    protected boolean isFiledIndex(String value) {
        return value.contains(ResManager.loadKDString((String)"\u79d1\u76ee\u8868ID", (String)"AccTypeMultilingual_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean isFiledNumIndex(String value) {
        return value.contains(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u7f16\u7801", (String)"AccTypeMultilingual_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected Object setInfo(Long id, String number, Row row, MultilingualRepairPlugin.Local local) {
        AccountLInfo info = new AccountLInfo();
        info.setId(id);
        info.setNumber(number);
        info.setLocalId(local.getLocalId());
        info.setName(row.getCell(local.getNameIndex()) == null ? "" : this.getCell(row.getCell(local.getNameIndex())));
        info.setFullName(row.getCell(local.getFullNameIndex()) == null ? "" : this.getCell(row.getCell(local.getFullNameIndex())));
        return info;
    }

    @Override
    protected void insertInfoToDB(List<Object> list) {
        if (!CollectionUtils.isEmpty(list)) {
            try (TXHandle h1 = TX.requiresNew();){
                try {
                    HashMap<String, AccountLInfo> accTypeMap = new HashMap<String, AccountLInfo>(list.size());
                    HashSet<String> numberSet = new HashSet<String>(list.size());
                    HashSet<Long> accounttableSet = new HashSet<Long>(list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        AccountLInfo acc = (AccountLInfo)list.get(i);
                        String key = acc.getNumber() + "_" + acc.getId();
                        accTypeMap.put(key, acc);
                        numberSet.add(acc.getNumber());
                        accounttableSet.add(acc.getId());
                    }
                    QFilter qFilter = new QFilter("number", "in", numberSet);
                    QFilter qFilter1 = new QFilter("accounttableid", "in", accounttableSet);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_accounttype", (String)"id, number, accounttableid", (QFilter[])new QFilter[]{qFilter, qFilter1});
                    ArrayList<Long> fidList = new ArrayList<Long>(collection.size());
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(collection.size());
                    for (DynamicObject dyn : collection) {
                        String key = dyn.getString("number") + "_" + dyn.getLong("accounttableid");
                        paramsList.add(this.setAccInfo(dyn.getLong("id"), (AccountLInfo)accTypeMap.get(key)));
                        fidList.add(dyn.getLong("id"));
                    }
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_bd_accounttype_l where ", new Object[0]);
                    sql.appendIn(" fid", fidList);
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_accounttype_l(fid,fpkid,flocaleid,fname,ffullname) values(?,?,?,?,?)", paramsList);
                }
                catch (Throwable e1) {
                    log.error(e1);
                    h1.markRollback();
                }
            }
        }
        log.info("AccMultilingualImortPlugin import end");
    }

    private Object[] setAccInfo(long id, AccountLInfo acc) {
        return new Object[]{id, DB.genStringId((String)"t_bd_accounttype_l"), acc.getLocalId(), acc.getName(), acc.getFullName()};
    }

    static class AccountLInfo {
        private long id;
        private String pkId;
        private String localId;
        private String name;
        private String fullName;
        private String number;

        AccountLInfo() {
        }

        public String getPkId() {
            return this.pkId;
        }

        public void setPkId(String pkId) {
            this.pkId = pkId;
        }

        public String getLocalId() {
            return this.localId;
        }

        public void setLocalId(String localId) {
            this.localId = localId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }
}

