/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.replace;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.StringUtils;

public class ReplaceLedgerService
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ReplaceLedgerService.class);
    private static final DBRoute gl = DBRoute.of((String)"gl");
    private static final Long NO_EXIST = 999999999L;
    private static final String BTN_OK = "btnok";
    private static final String UPDATE_GL = "updategl";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
        this.addClickListeners(new String[]{UPDATE_GL});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control btn = (Control)evt.getSource();
        switch (key = btn.getKey()) {
            case "updategl": {
                this.updateTableData(UPDATE_GL);
                break;
            }
            default: {
                LOGGER.error("update failure!");
            }
        }
    }

    private void updateTableData(String key) {
        DynamicObject bookType;
        Long bookTypeId;
        DynamicObject masterBookType;
        Long masterBookTypeId;
        IDataModel model = this.getModel();
        DynamicObjectCollection orgObject = (DynamicObjectCollection)model.getValue("org");
        List<Long> orgIds = orgObject.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
        boolean replace = this.replace(orgIds, masterBookTypeId = Long.valueOf((masterBookType = (DynamicObject)model.getValue("masterbooktype")).getLong("masterid")), bookTypeId = Long.valueOf((bookType = (DynamicObject)model.getValue("booktype")).getLong("masterid")), key);
        if (replace) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u8d26\u7c3f\u66ff\u6362\u6210\u529f", (String)"ReplaceLedgerService_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean replace(List<Long> orgIdList, Long masterBookTypeId, Long bookTypeId, String key) {
        if (bookTypeId.equals(0L) || masterBookTypeId.equals(0L) || orgIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u548c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReplaceLedgerService_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try {
            List<Object[]> glList = this.getGlList();
            List<Object[]> relationList = this.getRelationList();
            ArrayList<Long> orgList = new ArrayList<Long>();
            boolean isGlSucceed = true;
            boolean isRelationSucceed = true;
            boolean isBdaiSucceed = true;
            for (Long orgId : orgIdList) {
                if (key.equalsIgnoreCase(UPDATE_GL)) {
                    try (TXHandle txh = TX.requiresNew();){
                        try {
                            isGlSucceed = this.sqlExecute(glList, orgId, masterBookTypeId, bookTypeId, gl);
                            isRelationSucceed = this.sqlRelationExecute(relationList, orgId, masterBookTypeId, bookTypeId);
                        }
                        catch (Exception ex) {
                            txh.markRollback();
                            throw ex;
                        }
                    }
                }
                if (!isGlSucceed || !isRelationSucceed) {
                    orgList.add(orgId);
                }
                if (isBdaiSucceed) continue;
                orgList.add(orgId);
            }
            if (orgList.isEmpty()) {
                return true;
            }
            String orgNames = this.getOrgName(orgList);
            this.getModel().setValue("failureorg", (Object)orgNames);
            return false;
        }
        catch (Exception ex) {
            String str = GLUtil.printError((Throwable)ex);
            LOGGER.error("account replace exception..." + str);
            throw new KDBizException(str);
        }
    }

    private String getOrgName(List<Long> orgList) {
        ArrayList<String> orgNameList = new ArrayList<String>(10);
        for (Long orgId : orgList) {
            DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
            String orgName = String.valueOf(bosOrg.get("name"));
            orgNameList.add(orgName);
        }
        return StringUtils.join((Object[])orgNameList.toArray(), (String)", ");
    }

    private boolean sqlExecute(List<Object[]> glList, Long orgId, Long masterBookTypeId, Long bookTypeId, DBRoute gl) {
        try {
            for (Object[] objects : glList) {
                StringBuilder sb = new StringBuilder();
                sb.append("update ").append(objects[0]).append(" set ").append(objects[1]).append(" = ").append(NO_EXIST).append(" where ").append(objects[2]).append(" = ").append(orgId).append(" and ").append(objects[1]).append(" = ").append(masterBookTypeId);
                StringBuilder sb2 = new StringBuilder();
                sb2.append("update ").append(objects[0]).append(" set ").append(objects[1]).append(" = ").append(masterBookTypeId).append(" where ").append(objects[2]).append(" = ").append(orgId).append(" and ").append(objects[1]).append(" = ").append(bookTypeId);
                StringBuilder sb3 = new StringBuilder();
                sb3.append("update ").append(objects[0]).append(" set ").append(objects[1]).append(" = ").append(bookTypeId).append(" where ").append(objects[2]).append(" = ").append(orgId).append(" and ").append(objects[1]).append(" = ").append(NO_EXIST);
                this.bdExecuteGl(gl, sb, sb2, sb3);
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("sqlExecute exception.." + ex);
            return false;
        }
    }

    private boolean sqlRelationExecute(List<Object[]> getRelationList, Long orgId, Long masterBookTypeId, Long bookTypeId) {
        try {
            for (Object[] objects : getRelationList) {
                StringBuilder sb4 = new StringBuilder();
                sb4.append("select b.").append(objects[1]).append(" fbasedata,fpkid").append(" from ").append(objects[0]).append(" b, ").append(objects[3]).append(" l where b.").append(objects[2]).append(" = l.").append(objects[5]).append(" and l.").append(objects[4]).append(" = ").append(orgId);
                ArrayList<Long> masterBaseList = new ArrayList<Long>(20);
                ArrayList<Long> managerList = new ArrayList<Long>(20);
                this.loadRefId(masterBookTypeId, sb4, masterBaseList, managerList);
                String updateSql = "update " + objects[0] + " set fbasedataid = ? where fpkid=?";
                ArrayList<Object[]> param1 = new ArrayList<Object[]>(10);
                for (Long pkid : masterBaseList) {
                    param1.add(new Object[]{bookTypeId, pkid});
                }
                if (!param1.isEmpty()) {
                    this.executeUpdate(updateSql, param1);
                }
                ArrayList<Object[]> param2 = new ArrayList<Object[]>(10);
                for (Long pkid : managerList) {
                    param2.add(new Object[]{masterBookTypeId, pkid});
                }
                if (param2.isEmpty()) continue;
                this.executeUpdate(updateSql, param2);
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("sqlRelationExecute exception.." + ex);
            return false;
        }
    }

    private void loadRefId(final Long masterBookTypeId, StringBuilder sb4, final List<Long> masterBaseList, final List<Long> managerList) {
        DB.query((DBRoute)gl, (String)sb4.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Long baseDataId = resultSet.getLong("fbasedata");
                    if (baseDataId.equals(masterBookTypeId)) {
                        masterBaseList.add(resultSet.getLong("fpkid"));
                        continue;
                    }
                    managerList.add(resultSet.getLong("fpkid"));
                }
                return Collections.emptyList();
            }
        });
    }

    private void executeUpdate(String updateSql, List<Object[]> param) {
        DB.executeBatch((DBRoute)gl, (String)updateSql, param);
    }

    private void bdExecuteGl(DBRoute gl, StringBuilder sb, StringBuilder sb2, StringBuilder sb3) {
        DB.execute((DBRoute)gl, (String)sb.toString());
        DB.execute((DBRoute)gl, (String)sb2.toString());
        DB.execute((DBRoute)gl, (String)sb3.toString());
    }

    private List<Object[]> getGlList() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(35);
        list.add(new Object[]{"t_ai_accountmaptype", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_ai_daptracker", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_ai_recon_scheme", "fbooktype", "forgid"});
        list.add(new Object[]{"t_ai_vchtemplate", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_bd_accountbooks", "fbookstypeid", "forgid"});
        list.add(new Object[]{"t_fr_manutalbill", "faccountbook", "ftallycompany"});
        list.add(new Object[]{"t_gl_acccurrent", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_cfnotice", "fbookstypeid", "forgid"});
        list.add(new Object[]{"t_gl_acnotice", "faccountbookstypeid", "forgid"});
        list.add(new Object[]{"t_gl_adjustexchangerate", "fbookstypeid", "forgid"});
        list.add(new Object[]{"t_gl_autotrans", "fbookid", "forgid"});
        list.add(new Object[]{"t_gl_balance", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_balance_log", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_balancesheet", "fbooktypeid", "faccountorgid"});
        list.add(new Object[]{"t_gl_balancesheetexpmain", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_book_version", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_cashflow", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_cashflow_log", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_financial_indicators", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_incomeedit", "fbooktypeid", "faccountorgid"});
        list.add(new Object[]{"t_gl_incomeexp", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_initacccurrent", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_initbalance", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_initcashflow", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_multcolumn_scheme", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_openedperiod", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_reci_init_state", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_reciprocal_log", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_taxassigntable", "fbooktypeid", "fuseorgid"});
        list.add(new Object[]{"t_gl_templatevoucher", "fbookstypeid", "forgid"});
        list.add(new Object[]{"t_gl_transplprogram", "fbookid", "forgid"});
        list.add(new Object[]{"t_gl_voucher", "fbooktypeid", "forgid"});
        list.add(new Object[]{"t_gl_voucheramortscheme", "faccountbooksid", "forgid"});
        return list;
    }

    private List<Object[]> getRelationList() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(2);
        list.add(new Object[]{"t_ai_vchbooktypes", "fbasedataid", "fid", "t_ai_vchtemplate", "forgid", "fid"});
        return list;
    }
}

