/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.reportfieldset;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class ReportFieldSettingFromPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String DISPLAY_ENTRY_ENTITY = "displayentryentity";
    private static final String FILTER_ENTRY_ENTITY = "filterentryentity";
    private static final String TYPE_DISPLAY = "1";
    private static final String TYPE_FILTER = "2";
    private static final String[] DISPLAY_FIELD = new String[]{"bookeddate", "period", "currency", "localrate", "measureunit", "entrydc", "bizdate", "vouchertype", "billno", "edescription", "debitori", "creditori", "debitlocal", "creditlocal", "quantity", "assgrp", "account", "org", "price", "sourcebill", "booktype", "book", "maincfassgrp"};
    private static final String[] FILTER_FIELD = new String[]{"account", "period", "booktype", "org", "maincfassgrp"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("form_id");
        if (StringUtils.isEmpty((String)formId)) {
            return;
        }
        Label tips = (Label)this.getControl("tips");
        tips.setText(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a\u8bbe\u7f6e\u8fc7\u6ee4\u5b57\u6bb5\u4fdd\u5b58\u540e\u8bf7\u9000\u51fa\u83dc\u5355\u91cd\u65b0\u6253\u5f00\u3002", (String)"ReportFieldSettingFromPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        ComboEdit dispalyComboEdit = (ComboEdit)this.getControl("displaycombofield");
        ComboEdit filterComboEdit = (ComboEdit)this.getControl("filtercombofield");
        dispalyComboEdit.setComboItems(this.getComboItems(DISPLAY_FIELD));
        filterComboEdit.setComboItems(this.getComboItems(FILTER_FIELD));
        this.getModel().setValue("formid", (Object)formId);
        List list = ReportFieldSettingUtil.getConfigs((String)formId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter displaysetter = new TableValueSetter(new String[0]);
        TableValueSetter filtersetter = new TableValueSetter(new String[0]);
        for (int i = 0; i < list.size(); ++i) {
            ReportFieldSettingVo vo = (ReportFieldSettingVo)list.get(i);
            if (TYPE_DISPLAY.equals(vo.getType())) {
                displaysetter.addField("displaycombofield", new Object[]{vo.getField()});
                displaysetter.addField("displaytextfield", new Object[]{vo.getFieldMark()});
                displaysetter.addField("displayissys", new Object[]{vo.getIsSys()});
                continue;
            }
            if (!TYPE_FILTER.equals(vo.getType())) continue;
            filtersetter.addField("filtercombofield", new Object[]{vo.getField()});
            filtersetter.addField("filtertextfield", new Object[]{vo.getFieldMark()});
            filtersetter.addField("filterissys", new Object[]{vo.getIsSys()});
        }
        model.beginInit();
        model.deleteEntryData(DISPLAY_ENTRY_ENTITY);
        model.batchCreateNewEntryRow(DISPLAY_ENTRY_ENTITY, displaysetter);
        model.deleteEntryData(FILTER_ENTRY_ENTITY);
        model.batchCreateNewEntryRow(FILTER_ENTRY_ENTITY, filtersetter);
        model.endInit();
        this.getView().updateView(DISPLAY_ENTRY_ENTITY);
        this.getView().updateView(FILTER_ENTRY_ENTITY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        Object newValue = data.getNewValue();
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        String[] setValue = new String[]{newValue.toString()};
        switch (propertyName) {
            case "displaycombofield": {
                voucherEntity.getAllEntities().entrySet().forEach(stringEntityTypeEntry -> {
                    if ("entries".equals(stringEntityTypeEntry.getKey())) {
                        ((EntityType)stringEntityTypeEntry.getValue()).getFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                            if (((String)stringIDataEntityPropertyEntry.getKey()).equals(newValue)) {
                                setValue[0] = stringIDataEntityPropertyEntry.getValue() instanceof BasedataProp ? "entries." + newValue + ".name" : "entries." + newValue;
                            }
                        });
                    } else if ("gl_voucher".equals(stringEntityTypeEntry.getKey())) {
                        ((EntityType)stringEntityTypeEntry.getValue()).getFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                            if (((String)stringIDataEntityPropertyEntry.getKey()).equals(newValue) && stringIDataEntityPropertyEntry.getValue() instanceof BasedataProp) {
                                setValue[0] = newValue + ".name";
                            }
                        });
                    }
                });
                this.getModel().setValue("displaytextfield", (Object)setValue[0]);
                this.getModel().setValue("displayissys", (Object)"0");
                break;
            }
            case "filtercombofield": {
                voucherEntity.getAllFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                    if (((String)stringIDataEntityPropertyEntry.getKey()).equals(newValue) && stringIDataEntityPropertyEntry.getValue() instanceof BasedataProp) {
                        setValue[0] = newValue + ".number";
                    }
                });
                this.getModel().setValue("filtertextfield", (Object)setValue[0]);
                this.getModel().setValue("filterissys", (Object)"0");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "addnewbtn": {
                model.createNewEntryRow(DISPLAY_ENTRY_ENTITY);
                break;
            }
            case "removebtn": {
                int rowIndex = model.getEntryCurrentRowIndex(DISPLAY_ENTRY_ENTITY);
                if (rowIndex == -1) {
                    return;
                }
                DynamicObject dynamicObject = model.getEntryRowEntity(DISPLAY_ENTRY_ENTITY, rowIndex);
                if (dynamicObject == null || TYPE_DISPLAY.equals(dynamicObject.get("displayissys"))) break;
                model.deleteEntryRow(DISPLAY_ENTRY_ENTITY, rowIndex);
                break;
            }
            case "addnewbtn1": {
                model.createNewEntryRow(FILTER_ENTRY_ENTITY);
                break;
            }
            case "removebtn1": {
                int rowIndexFilter = model.getEntryCurrentRowIndex(FILTER_ENTRY_ENTITY);
                model.deleteEntryRow(FILTER_ENTRY_ENTITY, rowIndexFilter);
                break;
            }
        }
    }

    private List<ComboItem> getComboItems(String[] finalFields) {
        HashSet ignoreFields = Sets.newHashSet((Object[])finalFields);
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
        voucherEntity.getAllEntities().entrySet().forEach(stringEntityTypeEntry -> {
            if ("entries".equals(stringEntityTypeEntry.getKey()) || "gl_voucher".equals(stringEntityTypeEntry.getKey())) {
                ((EntityType)stringEntityTypeEntry.getValue()).getFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                    IDataEntityProperty dataEntityProperty = (IDataEntityProperty)stringIDataEntityPropertyEntry.getValue();
                    String key = (String)stringIDataEntityPropertyEntry.getKey();
                    if (StringUtils.isNotEmpty((String)dataEntityProperty.getAlias()) && !ignoreFields.contains(key) && !key.contains("comassist")) {
                        items.add(new ComboItem(dataEntityProperty.getDisplayName(), dataEntityProperty.getName()));
                    }
                });
            }
        });
        return items;
    }
}

