/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.consts.AccountType;
import kd.fi.gl.util.GLUtil;

public class BudgetVoucherPrintPlugin
extends AbstractPrintPlugin {
    private static final String CONFIG_CUSTOM = "gl_voucher_customprintsetting";
    private static final String SUMBYACCT = "1";
    private static final String SUMBYACCTWITHASSGRP = "2";
    private static final String SUMBYACCTWTIHCF = "3";
    private static final String FIELDS = "id,bookeddate,org.id orgid,debitlocamount,creditlocamount,entries.quantity quantity,entries.edescription edescription,entries.currency.name currencyname,entries.currency.id currencyid,entries.debitori debitori,entries.debitlocal debitlocal, entries.creditlocal creditlocal,entries.creditori creditori,entries.localrate localrate,entries.account.id accountid,entries.assgrp.id assgrpid,entries.assgrp.value assgrpvalue,localcur,localcur.amtprecision localcuramtprecision,localcur.number localcurnumber,localcur.sign localcursign,entries.measureunit.id measureunitid,entries.maincfitem maincfitem,entries.maincfitem.id maincfitemid,entries.entrydc entrydc";
    private static final String FORMID_2_NAME_AND_NUMBER_PROP_CACHEKEY = "formId2nameAndNumberPropCacheKey";
    private static final String VALUEID_2_DYN_CACHEKEY = "valueId2DynCacheKey";
    private static final String ASSGRP_ID_SQL = "select a.forgid orgid,a.fbookeddate bookeddate,v.fassgrpid assgrpid from t_gl_voucher a inner join t_gl_voucherentry v on a.fid=v.fid where v.fassgrpid <> 0 and v.fid in (?";
    private static final Log logger = LogFactory.getLog(BudgetVoucherPrintPlugin.class);

    public void loadCustomData(CustomDataLoadEvent e) {
        super.loadCustomData(e);
        CustomDataSource dataSource = e.getDataSource();
        List customDataRows = e.getCustomDataRows();
        Object voucherId = dataSource.getPkId();
        ArrayList<Object> voucherIdList = new ArrayList<Object>(1);
        voucherIdList.add(voucherId);
        if (voucherId == null) {
            logger.info("=====BudgetVoucherPrintPlugin_loadCustomData,no dataSource=====");
            return;
        }
        PrintConfig printConfig = this.getPrintConfig();
        List entryFields = dataSource.getQueryField();
        boolean containAssgrp = this.checkContainAssgrp(entryFields);
        Map<String, String[]> formId2nameAndNumberProp = this.getCachedFormDisplayPropMap();
        Table<Long, Date, Map<String, Map<Object, DynamicObject>>> valueId2Dyn = this.cacheAssistIfNecessary(containAssgrp, voucherIdList, formId2nameAndNumberProp);
        DynamicObjectCollection col = this.buildVoucherId2DynMap(voucherId);
        DynamicObject vou = (DynamicObject)col.get(0);
        Date bookdedDate = vou.getDate("bookeddate");
        Long orgId = vou.getLong("orgid");
        int amtprecision = vou.getInt("localcuramtprecision");
        String localCurrencyNumber = vou.getString("localcurnumber");
        String localCurrencySign = vou.getString("localcursign");
        List<DynamicObject> dyn = this.sumDataByConfig(col, printConfig.getSumfilter());
        Map<Object, DynamicObject> accountMap = this.getAccountMap(dyn);
        int fiIndex = 0;
        int budgetIndex = 0;
        int seq = 1;
        for (DynamicObject d : dyn) {
            Long accountId = d.getLong("accountid");
            DynamicObject account = accountMap.get(accountId);
            String accountType = account.getDynamicObject("accounttype").getString("accounttype");
            boolean isBudGetType = AccountType.isBudGetType((String)accountType);
            int curIndex = isBudGetType ? ++budgetIndex : ++fiIndex;
            DataRowSet newEntryDataRowSet = customDataRows.size() >= curIndex ? (DataRowSet)customDataRows.get(curIndex - 1) : new DataRowSet();
            newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "edescription"), (Field)new TextField(d.getString("edescription")));
            String accNumber = account.getString("number");
            String fullName = account.getString("fullname");
            newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "account"), (Field)new TextField(accNumber + " " + fullName));
            if (containAssgrp) {
                this.putAssgrpIfExists(newEntryDataRowSet, d, accountMap, (Map)valueId2Dyn.get((Object)orgId, (Object)bookdedDate), formId2nameAndNumberProp, isBudGetType);
            }
            String currencyName = d.getString("currencyname");
            newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "currency"), (Field)new TextField(currencyName));
            BigDecimal crLoc = d.getBigDecimal("creditlocal");
            BigDecimal drLoc = d.getBigDecimal("debitlocal");
            if (SUMBYACCT.equals(printConfig.getExcludezero()) && crLoc.compareTo(BigDecimal.ZERO) == 0 && drLoc.compareTo(BigDecimal.ZERO) == 0) continue;
            DecimalField crLocField = new DecimalField(crLoc.setScale(amtprecision, 4));
            crLocField.setSymbol(localCurrencySign);
            crLocField.setCode(localCurrencyNumber);
            DecimalField drLocField = new DecimalField(drLoc.setScale(amtprecision, 4));
            drLocField.setSymbol(localCurrencySign);
            drLocField.setCode(localCurrencyNumber);
            newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "creditlocal"), (Field)crLocField);
            newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "debitlocal"), (Field)drLocField);
            if (customDataRows.size() >= curIndex) continue;
            newEntryDataRowSet.put("seq", (Field)new IntegerField(Integer.valueOf(seq++)));
            customDataRows.add(newEntryDataRowSet);
        }
    }

    private String getFieldKey(boolean isBudGetType, String fieldKey) {
        return isBudGetType ? "g" + fieldKey : fieldKey;
    }

    private Table<Long, Date, Map<String, Map<Object, DynamicObject>>> cacheAssistIfNecessary(boolean containAssgrp, List<Object> voucherIdList, Map<String, String[]> formId2nameAndNumberProp) {
        Table<Long, Date, Map<String, Map<Object, DynamicObject>>> valueId2Dyn = HashBasedTable.create();
        if (containAssgrp) {
            valueId2Dyn = this.cacheAssist(voucherIdList, formId2nameAndNumberProp);
        }
        return valueId2Dyn;
    }

    private Table<Long, Date, Map<String, Map<Object, DynamicObject>>> cacheAssist(List<Object> pkIds, Map<String, String[]> cachedFormDisplayPropMap) {
        List<Object> cachedPkIds = this.getCachedPkIds();
        ArrayList<Object> batchPkIds = new ArrayList<Object>(pkIds);
        batchPkIds.removeAll(cachedPkIds);
        cachedPkIds.addAll(batchPkIds);
        Table<Long, Date, Map<String, Map<Object, DynamicObject>>> cachedValueIdDynMap = this.getCachedValueIdDynMap();
        if (batchPkIds.isEmpty()) {
            return cachedValueIdDynMap;
        }
        String sql = this.getSql(batchPkIds.size(), ASSGRP_ID_SQL, "a.forgid,a.fbookeddate,v.fassgrpid");
        Object[] params = batchPkIds.toArray();
        HashBasedTable orgBookedDateAssGrpIdTable = HashBasedTable.create();
        HashSet<Long> allAssgrpIdSet = new HashSet<Long>(64);
        try (DataSet rows = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])params);){
            for (Row row : rows) {
                Date bookeddate = row.getDate("bookeddate");
                Long orgId = row.getLong("orgid");
                Long assgrpId = row.getLong("assgrpid");
                HashSet<Long> assgrpIds = (HashSet<Long>)orgBookedDateAssGrpIdTable.get((Object)orgId, (Object)bookeddate);
                if (CollectionUtils.isNotEmpty((Collection)assgrpIds)) {
                    assgrpIds.add(assgrpId);
                } else {
                    assgrpIds = new HashSet<Long>(64);
                    assgrpIds.add(assgrpId);
                    orgBookedDateAssGrpIdTable.put((Object)orgId, (Object)bookeddate, assgrpIds);
                }
                allAssgrpIdSet.add(assgrpId);
            }
        }
        if (orgBookedDateAssGrpIdTable.isEmpty()) {
            return cachedValueIdDynMap;
        }
        HashMap<Long, String> assgrpIdValueMap = new HashMap<Long, String>(64);
        DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter[]{new QFilter("id", "in", allAssgrpIdSet)}, null);
        Object object = null;
        try {
            for (Row row : rows) {
                assgrpIdValueMap.put(row.getLong("id"), row.getString("assvals"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rows != null) {
                if (object != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rows.close();
                }
            }
        }
        HashBasedTable orgBookedDateAssGrpValTable = HashBasedTable.create();
        orgBookedDateAssGrpIdTable.rowKeySet().stream().forEach(arg_0 -> BudgetVoucherPrintPlugin.lambda$cacheAssist$3((Table)orgBookedDateAssGrpIdTable, assgrpIdValueMap, (Table)orgBookedDateAssGrpValTable, arg_0));
        Table<Long, Date, Map<String, Set<Object>>> cachedFormIdValuesMap = this.getCachedFormIdValuesMap();
        GLUtil.batchDealAssgrp((Table)orgBookedDateAssGrpValTable, this.getCachedFlexFieldFormIdMap(), cachedFormDisplayPropMap, cachedFormIdValuesMap);
        cachedFormIdValuesMap.rowKeySet().stream().forEach(x -> {
            Map cachedFormIdValues = cachedFormIdValuesMap.row(x);
            cachedFormIdValues.entrySet().stream().forEach(entry -> {
                HashMap<String, Map> cachedValueIdDyn = new HashMap<String, Map>(64);
                for (Map.Entry assistValueEntry : ((Map)entry.getValue()).entrySet()) {
                    String key = (String)assistValueEntry.getKey();
                    String[] fields = (String[])cachedFormDisplayPropMap.get(key);
                    String select = StringUtils.equals((CharSequence)fields[0], (CharSequence)fields[1]) ? "id," + fields[0] : "id," + fields[0] + "," + fields[1];
                    QFilter idFilter = new QFilter("id", "in", assistValueEntry.getValue());
                    DynamicObjectCollection assists = Objects.equals("bos_assistantdata_detail", key) ? QueryServiceHelper.query((String)key, (String)select, (QFilter[])idFilter.toArray()) : BaseDataServiceHelper.queryBaseDataByDate((String)key, (Long)x, (QFilter)idFilter, (String)select, (Date)((Date)entry.getKey()));
                    Map idDynMap = cachedValueIdDyn.computeIfAbsent(key, k -> new HashMap(assists.size()));
                    for (DynamicObject assist : assists) {
                        idDynMap.put(assist.get("id"), assist);
                    }
                }
                cachedValueIdDynMap.put(x, entry.getKey(), cachedValueIdDyn);
            });
        });
        return cachedValueIdDynMap;
    }

    private String getSql(int size, String sql, String groupBy) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 0; i < size - 1; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        if (groupBy != null) {
            sb.append(" group by ");
            sb.append(groupBy);
        }
        return sb.toString();
    }

    private void putAssgrpIfExists(DataRowSet newEntryDataRowSet, DynamicObject voucherEntry, Map<Object, DynamicObject> accountMap, Map<String, Map<Object, DynamicObject>> valueId2Dyn, Map<String, String[]> formId2nameAndNumberProp, boolean isBudGetType) {
        String assgrp = voucherEntry.getString("assgrpvalue");
        if (assgrp == null) {
            return;
        }
        JSONObject valueJson = JSONObject.parseObject((String)assgrp);
        JSONObject sortItems = this.sortItems(valueJson, accountMap.get(voucherEntry.getLong("accountid")));
        String itemStr = GLUtil.dealAssgrp((JSONObject)sortItems, (String)"\n", valueId2Dyn, formId2nameAndNumberProp);
        newEntryDataRowSet.put(this.getFieldKey(isBudGetType, "assgrp"), (Field)new TextField(itemStr));
    }

    private JSONObject sortItems(JSONObject valueJson, DynamicObject account) {
        DynamicObjectCollection accountEntries = (DynamicObjectCollection)account.getDynamicObjectCollection("checkitementry").clone();
        accountEntries.sort(Comparator.comparingInt(arg0 -> arg0.getInt("seq")));
        JSONObject js = new JSONObject(true);
        for (DynamicObject entry : accountEntries) {
            String flexfield = entry.getDynamicObject("asstactitem").getString("flexfield");
            Object objId = valueJson.get((Object)flexfield);
            if (null == objId) continue;
            js.put(flexfield, objId);
        }
        return js;
    }

    private Map<Object, DynamicObject> getAccountMap(List<DynamicObject> entries) {
        Object[] accountIdArray = entries.stream().filter(v -> null != v.get("accountid")).map(v -> v.getLong("accountid")).toArray();
        Map accountMap = BusinessDataServiceHelper.loadFromCache((Object[])accountIdArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        return accountMap;
    }

    private boolean checkContainAssgrp(List<String> entryFields) {
        return entryFields.contains("assgrp");
    }

    private PrintConfig getPrintConfig() {
        PrintConfig printConfig = new PrintConfig();
        String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)CONFIG_CUSTOM);
        try {
            Map cusdata = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            printConfig.setSumfilter((String)cusdata.get("sumfilter"));
            printConfig.setExcludezero((String)cusdata.get("excludezero"));
        }
        catch (Exception ex) {
            printConfig.setSumfilter(settingData);
        }
        return printConfig;
    }

    private Map<String, String[]> getCachedFormDisplayPropMap() {
        return (Map)ThreadCache.get((Object)FORMID_2_NAME_AND_NUMBER_PROP_CACHEKEY, () -> new HashMap(16));
    }

    private Table<Long, Date, Map<String, Set<Object>>> getCachedFormIdValuesMap() {
        return (Table)ThreadCache.get((Object)"formId2valueIds", () -> HashBasedTable.create());
    }

    private List<Object> getCachedPkIds() {
        return (List)ThreadCache.get((Object)"voucher_print_pkids", () -> new ArrayList(10));
    }

    private Table<Long, Date, Map<String, Map<Object, DynamicObject>>> getCachedValueIdDynMap() {
        return (Table)ThreadCache.get((Object)VALUEID_2_DYN_CACHEKEY, () -> HashBasedTable.create());
    }

    private Map<String, String> getCachedFlexFieldFormIdMap() {
        return (Map)ThreadCache.get((Object)"flexField2FormId", () -> new HashMap(16));
    }

    private DynamicObjectCollection buildVoucherId2DynMap(Object voucherId) {
        DynamicObjectCollection vchEntryColl = QueryServiceHelper.query((String)"gl_voucher", (String)FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "=", voucherId)});
        return vchEntryColl;
    }

    private List<DynamicObject> sumDataByConfig(DynamicObjectCollection entries, String sumFilter) {
        if (StringUtils.isNotEmpty((CharSequence)sumFilter)) {
            switch (sumFilter) {
                case "1": 
                case "2": 
                case "3": {
                    return this.sumData((Collection<DynamicObject>)entries, sumFilter);
                }
            }
        }
        ArrayList<DynamicObject> dyn = new ArrayList<DynamicObject>((Collection<DynamicObject>)entries);
        return dyn;
    }

    private List<DynamicObject> sumData(Collection<DynamicObject> values, String sumType) {
        String key = "";
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>();
        for (DynamicObject obj : values) {
            switch (sumType) {
                case "1": {
                    key = obj.getString("accountid") + "-" + obj.getString("currencyid") + "-" + obj.getString("measureunitid") + "-" + obj.getString("entrydc");
                    break;
                }
                case "2": {
                    key = obj.getString("accountid") + "-" + obj.getString("assgrpid") + "-" + obj.getString("currencyid") + "-" + obj.getString("measureunitid") + "-" + obj.getString("entrydc");
                    break;
                }
                case "3": {
                    key = obj.getString("accountid") + "-" + obj.getString("maincfitemid") + "-" + obj.getString("currencyid") + "-" + obj.getString("measureunitid") + "-" + obj.getString("entrydc");
                    break;
                }
            }
            if (map.containsKey(key)) {
                DynamicObject o = (DynamicObject)map.get(key);
                o.set("creditori", (Object)obj.getBigDecimal("creditori").add(o.getBigDecimal("creditori")));
                o.set("debitori", (Object)obj.getBigDecimal("debitori").add(o.getBigDecimal("debitori")));
                o.set("creditlocal", (Object)obj.getBigDecimal("creditlocal").add(o.getBigDecimal("creditlocal")));
                o.set("debitlocal", (Object)obj.getBigDecimal("debitlocal").add(o.getBigDecimal("debitlocal")));
                o.set("quantity", (Object)this.sumQty(o, obj));
                continue;
            }
            DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone(obj.getDataEntityType(), (Object)obj);
            if (sumType.equals(SUMBYACCT)) {
                newObj.set("assgrpid", null);
                newObj.set("maincfitem", null);
            } else if (sumType.equals(SUMBYACCTWTIHCF)) {
                newObj.set("assgrpid", null);
            }
            map.put(key, newObj);
        }
        return new ArrayList<DynamicObject>(map.values());
    }

    private BigDecimal sumQty(DynamicObject e1, DynamicObject e2) {
        BigDecimal qty1 = e1.getBigDecimal("quantity");
        BigDecimal qty2 = e2.getBigDecimal("quantity");
        if (qty1 == null) {
            return qty2;
        }
        if (qty2 == null) {
            return qty1;
        }
        return qty1.add(qty2);
    }

    private static /* synthetic */ void lambda$cacheAssist$3(Table orgBookedDateAssGrpIdTable, Map assgrpIdValueMap, Table orgBookedDateAssGrpValTable, Long x) {
        Map bookedDateAssGrpId = orgBookedDateAssGrpIdTable.row((Object)x);
        bookedDateAssGrpId.entrySet().stream().forEach(entry -> {
            Set valSet = ((Set)entry.getValue()).stream().map(id -> (String)assgrpIdValueMap.get(id)).filter(y -> !Objects.isNull(y)).collect(Collectors.toSet());
            orgBookedDateAssGrpValTable.put((Object)x, entry.getKey(), valSet);
        });
    }

    private static class PrintConfig {
        private String sumfilter;
        private String excludezero;

        private PrintConfig() {
        }

        public String getSumfilter() {
            return this.sumfilter;
        }

        public void setSumfilter(String sumfilter) {
            this.sumfilter = sumfilter;
        }

        public String getExcludezero() {
            return this.excludezero;
        }

        public void setExcludezero(String excludezero) {
            this.excludezero = excludezero;
        }
    }
}

