/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.fi.gl.formplugin.voucher.MulBaseData;
import kd.fi.gl.formplugin.voucher.MulBaseDataQuery;
import kd.fi.gl.formplugin.voucher.MulBaseDataQueryInfo;

public class DataSetMapper {
    private RowMeta rowMeta;
    private DynamicObjectType dt;
    private List<Row> rowList = new ArrayList<Row>();
    private List<ListField> pkFields = new ArrayList<ListField>();
    private MainEntityType mainEntityType;
    private int pkIndex = -1;
    private int entryPkIndex = -1;
    private int subEntryPkIndex = -1;

    DataSetMapper(MainEntityType mainEntityType, DynamicObjectType dt, RowMeta rowMeta, List<Row> rowList, List<ListField> pkFields) {
        this.mainEntityType = mainEntityType;
        this.dt = dt;
        this.rowMeta = rowMeta;
        this.rowList = rowList;
        this.pkFields = pkFields;
    }

    DynamicObjectCollection getDynamicObjectCollection() {
        int size = this.pkFields.size();
        int n = this.rowMeta.getFieldCount();
        ArrayList<MulBasedataProp> mulBasedataProps = new ArrayList<MulBasedataProp>();
        for (int i = 0; i < n; ++i) {
            if (this.rowMeta.getField(i).getName().equals(this.pkFields.get(0).getFieldName())) {
                this.pkIndex = i;
            } else if (size >= 2 && this.rowMeta.getField(i).getName().equals(this.pkFields.get(1).getFieldName())) {
                this.entryPkIndex = i;
            } else if (size >= 3 && this.rowMeta.getField(i).getName().equals(this.pkFields.get(2).getFieldName())) {
                this.subEntryPkIndex = i;
            }
            DynamicProperty property = this.dt.getProperty(this.rowMeta.getField(i).getName());
            if (!(property instanceof MulBasedataProp)) continue;
            mulBasedataProps.add((MulBasedataProp)property);
        }
        return this.createDynamicObjectCollection(this.pkIndex, this.entryPkIndex, this.subEntryPkIndex, mulBasedataProps);
    }

    private DynamicObjectCollection createDynamicObjectCollection(int pkIndex, int entryPkIndex, int subEntryPkIndex, List<MulBasedataProp> mulBasedataProps) {
        ArrayList<Object> pkList = new ArrayList<Object>();
        ArrayList<Object> entryPkList = new ArrayList<Object>();
        ArrayList<Object> subEntryPkList = new ArrayList<Object>();
        for (Row row : this.rowList) {
            if (pkIndex > -1) {
                pkList.add(row.get(pkIndex));
            }
            if (entryPkIndex > -1) {
                entryPkList.add(row.get(entryPkIndex));
            }
            if (subEntryPkIndex <= -1) continue;
            subEntryPkList.add(row.get(subEntryPkIndex));
        }
        HashMap<MulBasedataProp, List<MulBaseData>> mulBasedataDataMap = new HashMap<MulBasedataProp, List<MulBaseData>>();
        for (MulBasedataProp mulBasedataProp : mulBasedataProps) {
            this.buildMulBasedataDataMap(pkList, entryPkList, subEntryPkList, mulBasedataDataMap, mulBasedataProp);
        }
        return this.createDynamicObjectCollection(mulBasedataDataMap);
    }

    private void buildMulBasedataDataMap(List<Object> pkList, List<Object> entryPkList, List<Object> subEntryPkList, Map<MulBasedataProp, List<MulBaseData>> mulBasedataDataMap, MulBasedataProp mulBasedataProp) {
        MulBaseDataQueryInfo mulBaseDataQueryInfo;
        IDataEntityType complexType = mulBasedataProp.getComplexType();
        boolean isPkLongType = complexType.getPrimaryKey() instanceof LongProp;
        FilterField filterField = FilterField.create((MainEntityType)this.mainEntityType, (String)mulBasedataProp.getName());
        if (filterField != null && filterField.getFieldProp().getParent() instanceof EntryType) {
            boolean isSubEntry = filterField.getFieldProp().getParent() instanceof SubEntryType;
            mulBaseDataQueryInfo = new MulBaseDataQueryInfo(complexType.getDBRouteKey(), mulBasedataProp.getAlias(), isSubEntry ? "FDETAILID" : "FENTRYID", isPkLongType, isSubEntry ? subEntryPkList : entryPkList);
        } else {
            mulBaseDataQueryInfo = new MulBaseDataQueryInfo(complexType.getDBRouteKey(), mulBasedataProp.getAlias(), "FID", isPkLongType, pkList);
        }
        mulBasedataDataMap.put(mulBasedataProp, MulBaseDataQuery.getMulBaseData(mulBaseDataQueryInfo));
    }

    private DynamicObjectCollection createDynamicObjectCollection(Map<MulBasedataProp, List<MulBaseData>> mulBasedataDataMap) {
        int n = this.rowMeta.getFieldCount();
        Iterator<Row> iterator = this.rowList.iterator();
        DynamicObjectCollection ret = new DynamicObjectCollection(this.dt, null);
        ret.beginInit();
        while (iterator.hasNext()) {
            Row row = iterator.next();
            DynamicObject obj = new DynamicObject(this.dt);
            for (int i = 0; i < n; ++i) {
                this.setPropertyValue(row, obj, i, mulBasedataDataMap);
            }
            ret.add((Object)obj);
        }
        ret.endInit();
        BusinessDataReader.loadRefence((Object[])ret.toArray((Object[])new DynamicObject[ret.size()]), (IDataEntityType)this.dt);
        return ret;
    }

    private void setPropertyValue(Row row, DynamicObject obj, int i, Map<MulBasedataProp, List<MulBaseData>> mulBasedataDataMap) {
        DynamicProperty property = this.dt.getProperty(this.rowMeta.getField(i).getName());
        if (property != null) {
            if (property instanceof MulBasedataProp) {
                List<MulBaseData> mulBaseDatas = mulBasedataDataMap.get(property);
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                FilterField filterField = FilterField.create((MainEntityType)this.mainEntityType, (String)mulBasedataProp.getName());
                int thisPkIndex = this.pkIndex;
                if (filterField != null && filterField.getFieldProp().getParent() instanceof SubEntryType) {
                    thisPkIndex = this.subEntryPkIndex;
                } else if (filterField != null && filterField.getFieldProp().getParent() instanceof EntryType) {
                    thisPkIndex = this.entryPkIndex;
                }
                Object[] pkList = this.getPkList(row.get(thisPkIndex), mulBaseDatas);
                Map refBaseDynObj = BusinessDataReader.loadFromCache((Object[])pkList, (DynamicObjectType)((DynamicObjectType)mulBasedataProp.getRefBaseProp().getComplexType()));
                mulBasedataProp.setValueFast((Object)obj, (Object)this.getMulBasedataPropValue(mulBasedataProp, refBaseDynObj));
            } else {
                if (property instanceof BasedataProp) {
                    property = ((BasedataProp)property).getRefIdProp();
                }
                property.setValueFast((Object)obj, row.get(i));
            }
        }
    }

    private DynamicObjectCollection getMulBasedataPropValue(MulBasedataProp mulBasedataProp, Map<Object, DynamicObject> refBaseDynObj) {
        DynamicObjectCollection objs = new DynamicObjectCollection(mulBasedataProp.getDynamicCollectionItemPropertyType(), null);
        for (Map.Entry<Object, DynamicObject> entry : refBaseDynObj.entrySet()) {
            DynamicObject bsdObj = entry.getValue();
            DynamicObject newObj = new DynamicObject(mulBasedataProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)bsdObj);
            newObj.set("fbasedataid_id", entry.getKey());
            objs.add((Object)newObj);
        }
        return objs;
    }

    private Object[] getPkList(Object pkValue, List<MulBaseData> mulBaseDatas) {
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (MulBaseData mulBaseData : mulBaseDatas) {
            if (!pkValue.equals(mulBaseData.getFid())) continue;
            pkList.add(mulBaseData.getfBaseDataId());
        }
        return pkList.toArray(new Object[0]);
    }
}

