/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.listfilter.FilterContainerValues;
import kd.fi.gl.listfilter.FilterValues;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class MainVoucherListF7
extends AbstractListPlugin
implements ClickListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btnok"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String name = evt.getItemKey();
        if ("btnok".equals(name)) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            if (selectedRows != null && selectedRows.size() > 0) {
                Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                this.getView().returnDataToParent(primaryKeyValue);
            }
            this.getView().close();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFBuilder vchQF = new QFBuilder().add("srcbook.org", "=", (Object)GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id")).add("srcbook.bookstype.id", "=", (Object)GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"booktype.id")).add("destbook.org", "=", (Object)this.getDestOrgId()).add("destbook.bookstype", "=", (Object)this.getDestBookTypeId());
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_voucher_relation", (String)"srcvoucherid", (QFilter[])vchQF.toArray());
        ArrayList<Long> exIds = new ArrayList<Long>(10);
        if (dyns != null && dyns.size() > 0) {
            for (DynamicObject dyn : dyns) {
                exIds.add(dyn.getLong("srcvoucherid"));
            }
        }
        QFilter filterOrg = new QFilter("org.id", "=", (Object)GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id"));
        QFilter sourceFilter = new QFilter("sourcetype", "not in", (Object)new String[]{"1", "2"});
        QFilter exIdF = new QFilter("id", "not in", exIds);
        QFilter[] filter = new QFilter[]{filterOrg, sourceFilter, exIdF};
        List qFilters = e.getQFilters();
        qFilters.addAll(Arrays.asList(filter));
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("org.name".equals(args.getFieldName())) {
            FilterColumn column = (FilterColumn)args.getSource();
            String entityId = column.getEntityType().getName();
            QFilter filter = AccSysUtil.getAccountingOrgFilter((String)entityId, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Optional<FilterColumn> nameFilterColumn;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        long cusOrgId = Long.parseLong(paramMap.get("org").toString());
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Optional<FilterColumn> orgFilterColumn = commonFilterColumns.stream().filter(x -> "org.name".equals(x.getFieldName())).findFirst();
        if (orgFilterColumn.isPresent()) {
            CommonFilterColumn commFilter = (CommonFilterColumn)orgFilterColumn.get();
            commFilter.setDefaultValues(new Object[]{paramMap.get("org").toString()});
        }
        if ((nameFilterColumn = commonFilterColumns.stream().filter(x -> "booktype.name".equals(x.getFieldName())).findFirst()).isPresent()) {
            CommonFilterColumn commFilter = (CommonFilterColumn)nameFilterColumn.get();
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            if (CollectionUtils.isEmpty((Collection)orgIds)) {
                orgIds = commonFilterColumns.stream().filter(f -> f.getFieldName().equals("org.name")).findFirst().map(f -> BDUtil.extractToList((Collection)f.getDefaultValues(), defVal -> Long.parseLong(defVal.toString()))).orElseGet(() -> Collections.emptyList());
            }
            List comboItems = AccSysUtil.getBookTypeCombo((List)orgIds);
            String cusBookType = paramMap.get("booktype").toString();
            long orgId = 0L;
            if (orgIds != null && orgIds.size() == 1) {
                orgId = (Long)orgIds.get(0);
            } else {
                List defaultOrgValues = orgFilterColumn.get().getDefaultValues();
                if (defaultOrgValues != null && defaultOrgValues.size() > 0) {
                    orgId = Long.parseLong(defaultOrgValues.get(0).toString());
                }
            }
            if (orgId == cusOrgId) {
                comboItems.removeIf(x -> x.getValue().equals(cusBookType));
            }
            commFilter.setComboItems(comboItems);
            String defBookType = comboItems.isEmpty() ? "0" : ((ComboItem)comboItems.get(0)).getValue();
            commFilter.setDefaultValue(defBookType);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String field = args.getFieldName();
        if (field.equals("booktype.id")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map paramMap = formShowParameter.getCustomParams();
            long cusOrgId = Long.parseLong(paramMap.get("org").toString());
            Long orgId = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
            if (orgId == null) {
                return;
            }
            List bookTypeIds = AccSysUtil.getAllBookTypeByOrg((long)orgId);
            if (orgId.compareTo(cusOrgId) == 0) {
                long targetBookTypeId = Long.parseLong(paramMap.get("booktype").toString());
                bookTypeIds.remove(targetBookTypeId);
            }
            args.addCustomQFilter(new QFilter("id", "in", (Object)bookTypeIds));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterContainerValues filterContainerValues = new FilterContainerValues(args.getFilterValues());
        List<FilterValues> customFilterValuesList = filterContainerValues.getCustomFilterValuesList();
        Optional<FilterValues> optionalFilterValues = customFilterValuesList.stream().filter(filterValues -> filterValues.getFieldName().equals("booktype.id") && !filterValues.unlimitedValue()).findFirst();
        if (optionalFilterValues.isPresent()) {
            FilterValues filterValues2 = optionalFilterValues.get();
            List orgIds = GLUtil.getCustomFilterIds((IFormView)this.getView(), (String)"org.id");
            if (orgIds != null && !orgIds.isEmpty()) {
                FormShowParameter formShowParameter;
                Map paramMap;
                Long cusOrgId;
                Long orgId;
                List bookTypeComboList = AccSysUtil.getBookTypeCombo((List)orgIds);
                if (!bookTypeComboList.isEmpty() && (orgId = (Long)orgIds.get(0)).compareTo(cusOrgId = Long.valueOf(Long.parseLong((paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).get("org").toString()))) == 0) {
                    bookTypeComboList.removeIf(x -> x.getValue().equals(paramMap.get("booktype").toString()));
                }
                if (bookTypeComboList.isEmpty()) {
                    filterValues2.getValues().clear();
                    filterValues2.getValues().add("");
                } else {
                    Set bookTypeSet = bookTypeComboList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
                    filterValues2.getValues().removeIf(x -> !bookTypeSet.contains(x.toString()));
                    if (filterValues2.getValues().isEmpty()) {
                        filterValues2.getValues().add(((ComboItem)bookTypeComboList.get(0)).getValue());
                    }
                }
            }
        }
    }

    private long getDestOrgId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return Long.parseLong(String.valueOf(paramMap.get("org")));
    }

    private long getDestBookTypeId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return Long.parseLong(String.valueOf(paramMap.get("booktype")));
    }
}

