/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillModel;
import kd.fi.bd.consts.VoucherStatus;
import kd.fi.gl.formplugin.voucher.VoucherEdit;
import kd.fi.gl.formplugin.voucher.VoucherEditControlStateRecoder;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.args.AutoBalanceArg;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateIgnoreService;
import kd.fi.gl.formplugin.voucher.service.IAutoBalanceService;

public class ShortCutsPlugin
extends AbstractFormPlugin {
    private static final String GL_VOUCHER_ENTRY = "entries";
    private static final String KEY_EDESCRIPTION = "edescription";
    private static final String KEY_DEBITLOCAL = "debitlocal";
    private static final String KEY_CREDITLOCAL = "creditlocal";
    private static final String CACHEKEY_SUBPAGEID = "subpageid";
    private VoucherEditControlStateRecoder controlStateRecoder;
    private VoucherEditView voucherEditView;
    private static final List<IAutoBalanceService> SERVICES = new ArrayList<IAutoBalanceService>(2);

    public VoucherEditView getVoucherEditView() {
        if (this.voucherEditView == null) {
            this.voucherEditView = new VoucherEditView(this.getView(), this.getModel(), this.getPageCache());
        }
        return this.voucherEditView;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setShortCuts();
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"shortcuts", "shortcutspg"});
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+s");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"alt+n");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+r");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+p");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+enter");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"=");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"space");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"F4");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"alt+g");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"alt+c");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("shortCuts".equalsIgnoreCase(e.getEventName())) {
            String key;
            switch (key = e.getEventArgs()) {
                case "[17,83]": {
                    this.getView().invokeOperation("save");
                    break;
                }
                case "[17,13]": {
                    this.getView().invokeOperation("submit");
                    break;
                }
                case "[18,78]": 
                case "alt+": {
                    this.getView().invokeOperation("new");
                    break;
                }
                case "[17,82]": {
                    this.getView().invokeOperation("copy");
                    break;
                }
                case "[17,80]": {
                    this.getView().invokeOperation("printpreview");
                    break;
                }
                case "[191,191]": {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
                    if (rowIndex <= 0) break;
                    Object explation = this.getModel().getValue(KEY_EDESCRIPTION, 0);
                    this.getModel().setValue(KEY_EDESCRIPTION, explation, rowIndex);
                    break;
                }
                case "[190,190]": {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
                    if (rowIndex <= 0) break;
                    Object explation = this.getModel().getValue(KEY_EDESCRIPTION, rowIndex - 1);
                    this.getModel().setValue(KEY_EDESCRIPTION, explation, rowIndex);
                    break;
                }
                case "[187]": {
                    this.autoBalanceAmount();
                    break;
                }
                case "[32]": {
                    this.exchangeDebitAndCredit();
                    break;
                }
                case "[18,38]": {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
                    if (rowIndex <= 0) break;
                    this.getModel().moveEntryRowsUp(GL_VOUCHER_ENTRY, new int[]{rowIndex});
                    break;
                }
                case "[18,40]": {
                    int entryRowCount = this.getModel().getEntryRowCount(GL_VOUCHER_ENTRY);
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
                    if (entryRowCount <= rowIndex + 1) break;
                    this.getModel().moveEntryRowsDown(GL_VOUCHER_ENTRY, new int[]{rowIndex});
                    break;
                }
                case "[16,67]": {
                    this.copyPreRow();
                    break;
                }
                case "[115]": {
                    this.autoBalMainCFAmt();
                    break;
                }
                case "[18,71]": {
                    this.replace();
                    break;
                }
                case "[18,67]": {
                    this.showDescRepo();
                    break;
                }
            }
        }
    }

    private void showDescRepo() {
        String focusField = ((EntryGrid)this.getControl(GL_VOUCHER_ENTRY)).getEntryState().getFocusField();
        if (!focusField.equals(KEY_EDESCRIPTION)) {
            return;
        }
        if (!VoucherStatus.canModify((DynamicObject)this.getModel().getDataEntity())) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
        if (!this.getControlStateRecoder().getEntryState(KEY_EDESCRIPTION, rowIndex)) {
            return;
        }
        TextEdit edescEdit = (TextEdit)this.getControl(KEY_EDESCRIPTION);
        ((BillViewPluginProxy)this.getView().getService(FormViewPluginProxy.class)).getPlugIns().stream().filter(plugin -> plugin instanceof VoucherEdit).findFirst().ifPresent(arg_0 -> ((TextEdit)edescEdit).addClickListener(arg_0));
        edescEdit.click();
    }

    private void replace() {
        IFormView replaceView;
        if (!VoucherStatus.canModify((DynamicObject)this.getModel().getDataEntity())) {
            return;
        }
        String subPageId = this.getPageCache().get(CACHEKEY_SUBPAGEID);
        if (subPageId != null && (replaceView = SessionManager.getCurrent().getView(subPageId)) != null) {
            replaceView.activate();
            this.getView().sendFormAction(replaceView);
            return;
        }
        FormShowParameter show = new FormShowParameter();
        show.setFormId("gl_voucher_search");
        show.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(show);
        this.getPageCache().put(CACHEKEY_SUBPAGEID, show.getPageId());
    }

    private void autoBalMainCFAmt() {
        BigDecimal cashunused;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
        IDataModel m = this.getModel();
        DynamicObject mainCf = (DynamicObject)m.getValue("maincf");
        if (null != m.getValue("account", rowIndex) && null != mainCf && (cashunused = (BigDecimal)m.getValue("cashunused")).compareTo(BigDecimal.ZERO) != 0) {
            int dc = "o".equals(mainCf.getString("direction")) ? -1 : 1;
            BigDecimal maincfamt = (BigDecimal)m.getValue("maincfamt");
            m.setValue("maincfamt", (Object)cashunused.multiply(new BigDecimal(dc)).add(maincfamt));
        }
    }

    private void exchangeDebitAndCredit() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(GL_VOUCHER_ENTRY);
        String focusField = entryGrid.getEntryState().getFocusField();
        if (!focusField.equalsIgnoreCase(KEY_DEBITLOCAL) && !focusField.equalsIgnoreCase(KEY_CREDITLOCAL)) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
        if (!this.isLocalAmountEditable(rowIndex, KEY_DEBITLOCAL, KEY_CREDITLOCAL)) {
            return;
        }
        BigDecimal focusLocalAmount = (BigDecimal)this.getModel().getValue(focusField, rowIndex);
        if (focusLocalAmount.signum() != 0) {
            return;
        }
        String srcField = focusField.equals(KEY_DEBITLOCAL) ? KEY_CREDITLOCAL : KEY_DEBITLOCAL;
        BackCalculateIgnoreService.setIgnore(rowIndex, KEY_DEBITLOCAL);
        BackCalculateIgnoreService.setIgnore(rowIndex, KEY_CREDITLOCAL);
        BackCalculateIgnoreService.setIgnore(rowIndex, "oriamount");
        this.getModel().setValue(focusField, this.getModel().getValue(srcField, rowIndex), rowIndex);
    }

    public static synchronized void register(IAutoBalanceService service) {
        SERVICES.add(service);
    }

    private void autoBalanceAmount() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(GL_VOUCHER_ENTRY);
        String focusField = entryGrid.getEntryState().getFocusField();
        Set fields = SERVICES.stream().flatMap(x -> Arrays.stream(x.fields())).collect(Collectors.toSet());
        fields.addAll(Arrays.asList(KEY_CREDITLOCAL, KEY_DEBITLOCAL));
        if (!fields.contains(focusField)) {
            return;
        }
        int currentRow = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
        if (!this.isLocalAmountEditable(currentRow, focusField)) {
            return;
        }
        DynamicObjectCollection items = this.getModel().getEntryEntity(GL_VOUCHER_ENTRY);
        AutoBalanceArg arg = new AutoBalanceArg();
        arg.setView(this.getVoucherEditView());
        arg.setFocusField(focusField);
        arg.setRowIndex(currentRow);
        arg.setEntries(items);
        this.doAutoBalance(arg);
        for (IAutoBalanceService service : SERVICES) {
            service.autoBalance(arg);
        }
    }

    private void doAutoBalance(AutoBalanceArg arg) {
        String focusField = arg.getFocusField();
        if (!focusField.equalsIgnoreCase(KEY_DEBITLOCAL) && !focusField.equalsIgnoreCase(KEY_CREDITLOCAL)) {
            return;
        }
        int currentSeq = arg.getRowIndex() + 1;
        BigDecimal debitAmount = BigDecimal.ZERO;
        BigDecimal creditAmount = BigDecimal.ZERO;
        for (DynamicObject obj : arg.getEntries()) {
            if (obj.getInt("seq") == currentSeq) continue;
            BigDecimal deAmount = obj.getBigDecimal(KEY_DEBITLOCAL);
            debitAmount = debitAmount.add(deAmount);
            BigDecimal crAmount = obj.getBigDecimal(KEY_CREDITLOCAL);
            creditAmount = creditAmount.add(crAmount);
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("localcur");
        int scale = currency.getInt("amtprecision");
        BigDecimal amount = debitAmount.subtract(creditAmount).setScale(scale, RoundingMode.HALF_UP);
        if (focusField.equals(KEY_DEBITLOCAL)) {
            amount = amount.multiply(new BigDecimal(-1));
        }
        this.getModel().setValue(focusField, (Object)amount, arg.getRowIndex());
    }

    private void copyPreRow() {
        int entryRowCount = this.getModel().getEntryRowCount(GL_VOUCHER_ENTRY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(GL_VOUCHER_ENTRY);
        this.getModel().copyEntryRow(GL_VOUCHER_ENTRY, new int[]{rowIndex}, true);
        ((BillModel)this.getModel()).setEntryCurrentRowIndex(GL_VOUCHER_ENTRY, entryRowCount, true);
        for (int i = 0; i < entryRowCount - rowIndex - 1; ++i) {
            this.getModel().moveEntryRowsUp(GL_VOUCHER_ENTRY, new int[]{entryRowCount - i});
        }
    }

    private boolean isLocalAmountEditable(int rowIndex, String ... fields) {
        if (!VoucherStatus.canModify((DynamicObject)this.getModel().getDataEntity())) {
            return false;
        }
        if (fields != null) {
            return Arrays.stream(fields).allMatch(x -> this.getControlStateRecoder().getEntryState((String)x, rowIndex));
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.Showinfo();
    }

    private void Showinfo() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        StyleCss css = new StyleCss();
        css.setWidth("450px");
        css.setHeight("500px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setFormId("gl_vouchershortcutset");
        this.getView().showForm(parameter);
    }

    private VoucherEditControlStateRecoder getControlStateRecoder() {
        if (this.controlStateRecoder == null) {
            this.controlStateRecoder = new VoucherEditControlStateRecoder(this.getPageCache());
        }
        return this.controlStateRecoder;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!VoucherStatus.canModify((DynamicObject)this.getModel().getDataEntity())) {
            this.tryCloseReplaceView();
        }
    }

    private boolean tryCloseReplaceView() {
        String subPageId = this.getPageCache().get(CACHEKEY_SUBPAGEID);
        if (subPageId == null) {
            return false;
        }
        IFormView replaceView = SessionManager.getCurrent().getViewNoPlugin(subPageId);
        if (replaceView == null) {
            return false;
        }
        replaceView.close();
        this.getView().sendFormAction(replaceView);
        return true;
    }
}

