/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.ext.fi.servicehelper.ServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.voucher.relation.VchRelationId;
import kd.fi.gl.voucher.relation.VoucherRelationHelper;

public class ViewInvoiceExecutor {
    private static final ViewInvoiceExecutor INSTANCE = new ViewInvoiceExecutor();
    private static final Log logger = ExtLogFactory.getLog(ViewInvoiceExecutor.class, (String)"---showinvoice---");
    private static final String EXECUTOR_MSERVICE_NAME = "ViewInvoiceService";
    private static final String EXECUTOR_MSERVICE_METHOD = "getInvoiceResult";
    private static final int DEFAULT_MSG_DURATION = 5000;

    private ViewInvoiceExecutor() {
    }

    public static ViewInvoiceExecutor getINSTANCE() {
        return INSTANCE;
    }

    protected void execute(IFormView formView) {
        try {
            this.internalExecute(formView);
        }
        catch (Throwable e) {
            logger.error(e);
            formView.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u770b\u53d1\u7968\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ShowInvoiceExecutor_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    private void internalExecute(IFormView formView) {
        long voucherId;
        if (formView instanceof IListView) {
            BillList voucerList = (BillList)formView.getControl("billlistap");
            ListSelectedRowCollection selectedRows = voucerList.getSelectedRows();
            voucherId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        } else {
            voucherId = (Long)formView.getModel().getValue("id");
        }
        List relations = VoucherRelationHelper.getVoucherRelationIds((long)voucherId);
        logger.info("method:internalExecute voucherId={}, relations={}", (Object)voucherId, (Object)relations.toString());
        List<InvoiceResult> invoiceResultList = this.buildResultList(relations);
        if (invoiceResultList.isEmpty()) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u53d1\u7968\u4fe1\u606f\u3002", (String)"ShowInvoiceExecutor_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        this.buildAndShowFailedMsg(formView, invoiceResultList);
        this.openSuccessForms(formView, invoiceResultList);
    }

    private List<InvoiceResult> buildResultList(List<VchRelationId> relations) {
        return relations.stream().collect(Collectors.groupingBy(r -> EntityMetadataCache.getDataEntityType((String)r.getEntityId()).getAppId(), HashMap::new, Collectors.groupingBy(VchRelationId::getEntityId, LinkedHashMap::new, Collectors.mapping(VchRelationId::getBillId, Collectors.toList())))).entrySet().stream().flatMap(entry -> this.invokeService((String)entry.getKey(), (Map)entry.getValue()).stream()).collect(Collectors.toList());
    }

    private List<InvoiceResult> invokeService(String appId, Map<String, List<Long>> billTypeIdsMap) {
        logger.info("method:invokeService param:appId={}, map={}", (Object)appId, (Object)billTypeIdsMap.toString());
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        List result = (List)((DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId)).invoke(ServiceFactory.class.getName(), EXECUTOR_MSERVICE_NAME, EXECUTOR_MSERVICE_METHOD, new Object[]{appId, billTypeIdsMap});
        logger.info("method:invokeService result={}", (Object)result);
        return result;
    }

    private void openSuccessForms(IFormView formView, List<InvoiceResult> invoiceResultList) {
        invoiceResultList.stream().filter(InvoiceResult::isSuccess).map(InvoiceResult::getFormShowParameter).forEach(arg_0 -> ((IFormView)formView).showForm(arg_0));
    }

    private void buildAndShowFailedMsg(IFormView formView, List<InvoiceResult> invoiceResultList) {
        String failedMsg = invoiceResultList.stream().filter(r -> !r.isSuccess()).map(result -> {
            BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)result.getEntityId());
            String billNoProp = type.getBillNo();
            String billTypeName = type.getDisplayName().getLocaleValue();
            String billNo = QueryServiceHelper.queryOne((String)result.getEntityId(), (String)billNoProp, (QFilter[])QFilterBuilder.create((String)"id", (String)"=", (Object)result.getBillId()).toArray(new QFilter[0])).getString(billNoProp);
            return String.format("%s%s:%s", billTypeName, billNo, result.getErrorMsg());
        }).collect(Collectors.joining(System.lineSeparator()));
        if (StringUtils.isNotBlank((CharSequence)failedMsg)) {
            formView.showTipNotification(failedMsg, Integer.valueOf(5000));
        }
    }
}

