/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.google.common.collect.ImmutableSet;
import com.kingdee.bos.ctrl.common.currency.FormatRMB;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.consts.MappingTypeEnum;
import kd.fi.bd.model.schema.basedata.AccountBookSchema;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCalculator;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowPanelManager;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowStatusManager;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.AssgrpDefValUtil;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherEditAjust
extends AbstractBillPlugIn
implements HyperLinkClickListener,
EntryGridBindDataListener {
    private VoucherEditView voucherEditView;
    private static final VoucherSchema voucherSchema = new VoucherSchema();
    private static final Log logger = LogFactory.getLog(VoucherEditAjust.class);
    private static final Set<String> cashflowProp = ImmutableSet.of((Object)"maincfitem", (Object)"maincfassgrp", (Object)"maincfamount", (Object)"suppcfitem", (Object)"suppcfamount");
    private static final String AMT_PRECISION = "amtprecision";
    private static final String PRICE_PRECISION = "priceprecision";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbsave"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entries_main");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entries_main");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.initOriAMO();
        this.setQtyVisible();
        this.getSourceBook().ifPresent(sourceBookInfo -> this.getView().setVisible(Boolean.valueOf(sourceBookInfo.isBudget()), new String[]{"accountingtype_main"}));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String name = evt.getItemKey();
        IDataModel model = this.getModel();
        if ("importmainvoucher".equals(name)) {
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("gl_voucher_f7new");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("org", model.getValue("org_id"));
            show.setCustomParam("booktype", model.getValue("booktype_id"));
            show.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("600");
            styleCss.setWidth("1000");
            show.setMultiSelect(false);
            show.getOpenStyle().setInlineStyleCss(styleCss);
            show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "voucherid"));
            this.getView().showForm((FormShowParameter)show);
        }
    }

    private DataEntityPropertyCollection getVoucherEntryProps() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"gl_voucher");
        DynamicCollectionProperty properties = (DynamicCollectionProperty)dataEntityType.getProperty("entries");
        DynamicObjectType dynamicCollectionItemPropertyType = properties.getDynamicCollectionItemPropertyType();
        DataEntityPropertyCollection entryProps = dynamicCollectionItemPropertyType.getProperties();
        return entryProps;
    }

    private String getVoucherSelects(DataEntityPropertyCollection props) {
        StringBuilder sb = new StringBuilder(String.join((CharSequence)",", "localcur", "billno", "book", "creator", "org", "bizdate", "bookeddate", "entries"));
        for (IDataEntityProperty prop : props) {
            sb.append(",");
            sb.append(prop.getName());
        }
        return sb.toString();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String name = closedCallBackEvent.getActionId();
        IPageCache pageCache = this.getPageCache();
        if ("voucherid".equals(name) && closedCallBackEvent.getReturnData() != null) {
            DataEntityPropertyCollection entryProps = this.getVoucherEntryProps();
            long vouid = Long.parseLong(closedCallBackEvent.getReturnData().toString());
            DynamicObject srcVchDyn = BusinessDataServiceHelper.loadSingle((Object)vouid, (String)"gl_voucher", (String)this.getVoucherSelects(this.getVoucherEntryProps()));
            IDataModel model = this.getModel();
            long orgid = (Long)model.getValue("org_id");
            long accTableId = srcVchDyn.getDynamicObject("book").getLong("accounttable_id");
            pageCache.put("bookId", String.valueOf(srcVchDyn.getLong("book_id")));
            pageCache.put("sourceVoucherId", String.valueOf(srcVchDyn.getLong("id")));
            long ajustAccTableId = ((DynamicObject)model.getValue("book")).getLong("accounttable_id");
            boolean curLocalSet = Boolean.parseBoolean(this.getPageCache().get("localSet"));
            boolean sourceLocalSet = CashflowLocalSetUtil.isLocalSet((long)srcVchDyn.getLong(GLField.id_((String)"org")), (Date)srcVchDyn.getDate("bookeddate"));
            AccountBookInfo manageBook = this.getTargetBook();
            long mainBookLocalCurrency = srcVchDyn.getLong(VoucherEditAjust.voucherSchema.book.toInnerProp(new AccountBookSchema().localeCurrency).toFullNameWithID());
            HashMap<Long, Long> sourceToTargetAcc = new HashMap<Long, Long>(40);
            QFilter amFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)orgid);
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            QFilter srcFilter = new QFilter("srcacttable", "=", (Object)accTableId);
            QFilter mappingTypeFilter = new QFilter("mappingtype", "=", (Object)MappingTypeEnum.PRIMARY_SECONDARY.getValue());
            DynamicObject[] acMappings = BusinessDataServiceHelper.load((String)"bd_accountmapping", (String)"srcacttable,goalacttable,goalacttable.masterid,mappinginfoentry,mappinginfoentry.srcact,mappinginfoentry.goalact", (QFilter[])new QFilter[]{amFilter, enableFilter, srcFilter, mappingTypeFilter});
            boolean flag = true;
            if (null != acMappings && acMappings.length != 0) {
                for (DynamicObject mappingDyn : acMappings) {
                    for (DynamicObject source : mappingDyn.getDynamicObjectCollection("mappinginfoentry")) {
                        if (source.getLong("goalact.accounttable.id") != ajustAccTableId) continue;
                        sourceToTargetAcc.put(source.getLong("srcact.masterid"), source.getLong("goalact.masterid"));
                    }
                }
                if (sourceToTargetAcc.size() > 0) {
                    flag = false;
                }
            }
            if (accTableId != ajustAccTableId && (acMappings == null || acMappings.length == 0 || sourceToTargetAcc.size() == 0)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u3002", (String)"VoucherEditAjust_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            QFilter accounttableF = new QFilter("accounttable", "=", (Object)ajustAccTableId);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid);
            DynamicObject period = (DynamicObject)model.getValue("period");
            QFilter qdate = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
            QFilter qdate2 = new QFilter("enddate", ">", (Object)period.getDate("enddate"));
            DynamicObjectCollection accountsLocs = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,acctcurrency,currencyentry.currency currency", (QFilter[])new QFilter[]{accounttableF, baseDataFilter, qdate, qdate2});
            HashMap accToCurrency = new HashMap(accountsLocs.size());
            HashMap<Long, Long> accountLocMap = new HashMap<Long, Long>(accountsLocs.size());
            for (DynamicObject account : accountsLocs) {
                long accountId = account.getLong("id");
                ArrayList<Long> list = (ArrayList<Long>)accToCurrency.get(accountId);
                if (list == null) {
                    list = new ArrayList<Long>(6);
                }
                if ("nocurrency".equals(account.getString("acctcurrency"))) {
                    accToCurrency.put(accountId, null);
                } else if ("allcurrency".equals(account.getString("acctcurrency"))) {
                    accToCurrency.put(accountId, list);
                } else {
                    list.add(account.getLong("currency"));
                    accToCurrency.put(accountId, list);
                }
                accountLocMap.put(account.getLong("masterid"), account.getLong("id"));
            }
            DynamicObjectCollection sourceEntrys = srcVchDyn.getDynamicObjectCollection("entries");
            Set<String> localEntryPros = this.getLocalEntryProp("entries");
            Set<String> localMainEntryPros = this.getLocalEntryProp("entries_main");
            model.deleteEntryData("entries");
            model.deleteEntryData("entries_main");
            model.setValue("localcur_main", srcVchDyn.get("localcur"));
            Date bizDate = (Date)model.getValue("bizdate");
            Map<Long, ExchangeRate> exchangeRateRepoForManage = this.parseRateForAccountBook(manageBook, bizDate);
            boolean isAllLocalCurrency = true;
            boolean isSourceBookBudget = this.getSourceBook().get().isBudget();
            for (DynamicObject sourceEntry : sourceEntrys) {
                Map assgrpFieldInMain;
                List accCurrency;
                boolean setAjustEntry = true;
                int row = model.createNewEntryRow("entries");
                int rowMain = model.createNewEntryRow("entries_main");
                Long accountLoc = 0L;
                DynamicObject srcAcctDyn = sourceEntry.getDynamicObject("account");
                if (srcAcctDyn == null) continue;
                long accountMasterid = srcAcctDyn.getLong("masterid");
                if (flag) {
                    accountLoc = (Long)accountLocMap.get(accountMasterid);
                    if (accountLoc == null || accountLoc == 0L) {
                        setAjustEntry = false;
                    }
                } else {
                    Long accTarget = (Long)sourceToTargetAcc.get(accountMasterid);
                    if (accTarget == null || accTarget == 0L) {
                        setAjustEntry = false;
                    } else {
                        accountLoc = (Long)accountLocMap.get(accTarget);
                        if (accountLoc == null || accountLoc == 0L) {
                            setAjustEntry = false;
                        }
                    }
                }
                model.setValue("account_main", sourceEntry.get("account"), rowMain);
                if (isSourceBookBudget) {
                    model.setValue("accountingtype_main", (Object)AccountUtils.parseAccountingType((DynamicObject)srcAcctDyn), rowMain);
                }
                model.beginInit();
                model.setValue("account", (Object)accountLoc, row);
                model.setValue("account_id", (Object)accountLoc, row);
                long currencyOri = sourceEntry.getLong("currency.id");
                if (currencyOri != mainBookLocalCurrency) {
                    isAllLocalCurrency = false;
                }
                model.setValue("currency_main", (Object)currencyOri, row);
                boolean curPermitDesignCashflow = CashFlowItemHelper.permitDesignCashflow((IDataModel)model);
                for (IDataEntityProperty prop : entryProps) {
                    String proName = prop.getName();
                    if (proName.equals("id") || proName.equals("seq") || proName.equals("account") || proName.endsWith("_id") || proName.equals("oriamount") || proName.equals("assgrp") || proName.equals("accountingtype") || !localEntryPros.contains(proName) || !localMainEntryPros.contains(proName + "_main")) continue;
                    if (setAjustEntry && !cashflowProp.contains(proName)) {
                        model.setValue(proName, sourceEntry.get(proName), row);
                    }
                    model.setValue(proName + "_main", sourceEntry.get(proName), rowMain);
                }
                model.setValue("currency_main", sourceEntry.get("currency"), rowMain);
                model.setValue("oriamount_main", (Object)this.getOriAmt(sourceEntry), rowMain);
                model.setValue("assgrp_main", sourceEntry.get("assgrp"), rowMain);
                if (!setAjustEntry) {
                    model.endInit();
                    continue;
                }
                DynamicObject targetAccountDyn = (DynamicObject)model.getValue("account", row);
                long currency = sourceEntry.getLong("currency.id");
                long localCurrency = (Long)model.getValue("localcur_id");
                int localCurrencyScale = BusinessDataServiceHelper.loadSingleFromCache((Object)localCurrency, (String)"bd_currency").getInt(AMT_PRECISION);
                ExchangeRate rate = this.getRate(exchangeRateRepoForManage, currency, localCurrency, bizDate);
                BigDecimal oriAmt = this.getOriAmt(sourceEntry);
                BigDecimal locAmt = rate.getRateType().getRateCalculator().calLocAmount(rate.getValue(), oriAmt, localCurrencyScale);
                BigDecimal sourceSuppCfAmount = sourceEntry.getBigDecimal("suppcfamount");
                if (currency != manageBook.getBaseCurrencyId() && ((accCurrency = (List)accToCurrency.get(accountLoc)) == null || accCurrency.size() != 0 && !accCurrency.contains(currency))) {
                    rate = (ExchangeRate)rate.clone();
                    oriAmt = locAmt;
                    rate.setDirectRate(BigDecimal.ONE);
                    rate.setIndirectRate(BigDecimal.ONE);
                    currency = manageBook.getBaseCurrencyId();
                }
                model.setValue("currency", (Object)currency, row);
                this.setLocAmt(model, locAmt, rowMain);
                this.setCashFlowInfo(srcVchDyn, sourceEntry, row);
                int oriScale = ((DynamicObject)model.getValue("currency", row)).getInt(AMT_PRECISION);
                BigDecimal tarOriAmount = rate.getRateType().getRateCalculator().calOriAmount(rate.getValue(), locAmt, oriScale);
                model.setValue(model.getValue("entrydc", row).equals("1") ? "debitori" : "creditori", (Object)tarOriAmount, rowMain);
                model.setValue("localrate", (Object)rate.getValue(), rowMain);
                model.setValue("ratetype", (Object)rate.getRateType().getStrValue(), rowMain);
                BigDecimal sourceEntryQty = sourceEntry.getBigDecimal("quantity");
                if (sourceEntryQty.signum() != 0 && targetAccountDyn.getBoolean("isqty")) {
                    int priceScale = ((DynamicObject)model.getValue("currency")).getInt(PRICE_PRECISION);
                    model.setValue("price", (Object)oriAmt.divide(sourceEntryQty, priceScale, RoundingMode.HALF_UP));
                }
                long accountIDInManage = (Long)model.getValue("account_id", rowMain);
                long accountIDInMain = (Long)model.getValue("account_main_id", rowMain);
                DynamicObject assgrpDyoInMain = sourceEntry.getDynamicObject("assgrp");
                HashMap assgrpFieldInManage = new HashMap();
                Set<String> fieldSetInManage = VoucherEditAjust.getFlexFields(accountIDInManage);
                Set<String> fieldSetInMain = VoucherEditAjust.getFlexFields(accountIDInMain);
                if (assgrpDyoInMain != null) {
                    assgrpFieldInMain = (Map)SerializationUtils.fromJsonString((String)assgrpDyoInMain.getString("value"), Map.class);
                } else {
                    assgrpFieldInMain = new HashMap();
                    fieldSetInMain.forEach(field -> assgrpFieldInMain.put(field, null));
                }
                assgrpFieldInMain.entrySet().stream().filter(entry -> fieldSetInManage.contains(entry.getKey())).forEach(entry -> assgrpFieldInManage.put(entry.getKey(), entry.getValue()));
                List<String> nullFieldToRemove = assgrpFieldInManage.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
                nullFieldToRemove.forEach(assgrpFieldInManage::remove);
                Long currencyID = (Long)model.getValue("currency_id", rowMain);
                Long accountID = (Long)model.getValue("account_id", rowMain);
                Long acctTableID = manageBook.getAccountTableId();
                Long orgID = manageBook.getOrgId();
                Long userID = ContextUtil.getUserId();
                Object assgrpPK = AssgrpDefValUtil.getAssgrpDefVal((Long)orgID, (Long)manageBook.getBookTypeId(), (Long)acctTableID, (Long)userID, (Long)accountID, (Long)currencyID, assgrpFieldInManage);
                model.setValue("assgrp_main", assgrpDyoInMain == null ? Long.valueOf(0L) : assgrpDyoInMain.getPkValue(), rowMain);
                model.setValue("assgrp", assgrpPK, rowMain);
                DynamicObject acctDyoInManage = BusinessDataServiceHelper.loadSingleFromCache((Object)accountID, (String)"bd_accountview", (String)"accheck");
                if (acctDyoInManage != null && acctDyoInManage.getBoolean("accheck")) {
                    this.getView().getModel().setValue("expiredate", (Object)bizDate, rowMain);
                }
                model.endInit();
                this.getView().updateView("entries");
                this.getView().updateView("entries_main");
            }
            this.updateMainEntryRateType(srcVchDyn.getLong("org.id"), ContextUtil.getUserId(), srcVchDyn.getDate("bizdate"), srcVchDyn.getDate("bookeddate"), srcVchDyn.getLong(GLField.id_((String)"localcur")));
            this.caclSumDebitLocalAmt();
            this.showNoneRateFoundTips(exchangeRateRepoForManage, this.getView(), this.getTargetBook());
            if (!isAllLocalCurrency) {
                this.visibleAndWidth(true, this.ratioOriRateCurr(1), "ratetype_main", "oriamount_main", "localrate_main");
            }
            this.getVoucherEditView().doVersionReplacementForCashFlowItem();
            this.getView().updateView("entries");
            this.getView().updateView("entries_main");
            this.getVoucherEditView().getService(VoucherEditCashFlowCalculator.class).ensureInitCashFlowTotal(true);
            this.voucherEditView.getService(VoucherEditCashFlowPanelManager.class).updatePanelForCurrentRow();
        }
    }

    private void setCashFlowInfo(DynamicObject sourceVoucher, DynamicObject sourceEntry, int row) {
        long suppCfItemId;
        boolean sourceLocalSet;
        VoucherEditValueGetter valueGetter = this.getVoucherEditView().getValueGetter();
        boolean curLocalSet = this.getVoucherEditView().getService(VoucherEditCashFlowStatusManager.class).isLocalSet();
        if (curLocalSet != (sourceLocalSet = CashflowLocalSetUtil.isLocalSet((long)sourceVoucher.getLong(GLField.id_((String)"org")), (Date)sourceVoucher.getDate("bookeddate"))) || !CashFlowItemHelper.permitDesignCashflow((IDataModel)this.getModel())) {
            return;
        }
        long mainCfItemId = sourceEntry.getLong(GLField.id_((String)"maincfitem"));
        if (mainCfItemId > 0L && null == VoucherUtils.getCFitem((long)valueGetter.getOrgId(), (long)mainCfItemId)) {
            return;
        }
        BigDecimal localAmt = valueGetter.getCreditLocAmt(row).add(valueGetter.getDebitLocAmt(row));
        if (mainCfItemId > 0L) {
            this.getModel().setValue("maincfitem", (Object)mainCfItemId, row);
            this.getModel().setValue("maincfassgrp", (Object)sourceEntry.getLong(GLField.id_((String)"maincfassgrp")), row);
            BigDecimal coff = "o".equals(sourceEntry.getString("maincfitem.direction")) ? BigDecimal.ONE.negate() : BigDecimal.ONE;
            coff = coff.multiply(new BigDecimal(sourceEntry.getString("entrydc"))).negate();
            this.getModel().setValue("maincfamount", (Object)localAmt.multiply(coff), row);
        }
        if ((suppCfItemId = sourceEntry.getLong(GLField.id_((String)"suppcfitem"))) == 0L || suppCfItemId > 0L && null == VoucherUtils.getCFitem((long)valueGetter.getOrgId(), (long)suppCfItemId)) {
            return;
        }
        this.getModel().setValue("suppcfitem", (Object)suppCfItemId, row);
        BigDecimal sourceSuppCfAmount = sourceEntry.getBigDecimal("suppcfamount");
        BigDecimal locSubtract = ((BigDecimal)this.getModel().getValue("creditlocal", row)).subtract((BigDecimal)this.getModel().getValue("debitlocal", row));
        if (sourceSuppCfAmount.signum() != locSubtract.signum()) {
            locSubtract = locSubtract.negate();
        }
        this.getModel().setValue("suppcfamount", (Object)locSubtract, row);
    }

    private void showNoneRateFoundTips(Map<Long, ExchangeRate> exchangeRateRepoForManage, IFormView view, AccountBookInfo manageBook) {
        List currencyWithNoneRate = exchangeRateRepoForManage.entrySet().stream().filter(entry -> ((ExchangeRate)entry.getValue()).getValue().compareTo(BigDecimal.ZERO) == 0).mapToLong(Map.Entry::getKey).boxed().collect(Collectors.toList());
        if (currencyWithNoneRate.isEmpty()) {
            return;
        }
        currencyWithNoneRate.add(manageBook.getBaseCurrencyId());
        Map currencyRepo = BusinessDataServiceHelper.loadFromCache((Object[])currencyWithNoneRate.toArray(), (String)"bd_currency");
        String localeCurrencyName = ((DynamicObject)currencyRepo.remove(manageBook.getBaseCurrencyId())).getLocaleString("name").getLocaleValue();
        if (currencyRepo.isEmpty()) {
            return;
        }
        String noneRateNameStr = currencyRepo.values().stream().map(currencyDyo -> currencyDyo.getLocaleString("name").getLocaleValue()).collect(Collectors.joining("\uff0c"));
        String bookTypeName = BusinessDataServiceHelper.loadSingleFromCache((Object)manageBook.getBookTypeId(), (String)"bd_accountbookstype").getLocaleString("name").getLocaleValue();
        String tipsNoneRate = String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u7684\u6c47\u7387\u8868\u4e0d\u5b58\u5728%2$s\u548c\u4ee5\u4e0b\u5e01\u522b\u7684\u6c47\u7387\uff1a%3$s\u3002", (String)"VoucherEditAjust_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), bookTypeName, localeCurrencyName, noneRateNameStr);
        view.showTipNotification(tipsNoneRate, Integer.valueOf(5000));
    }

    private ExchangeRate getRate(Map<Long, ExchangeRate> exchangeRateRepoForManage, long currency, long locCurrency, Date bizDate) {
        ExchangeRate exchangeRate = exchangeRateRepoForManage.get(currency);
        if (exchangeRate == null) {
            exchangeRate = new ExchangeRate();
            exchangeRate.setRateType(RateServiceHelper.getRateType((long)currency, (long)locCurrency, (Date)bizDate));
            exchangeRate.setDirectRate(BigDecimal.ZERO);
            exchangeRate.setIndirectRate(BigDecimal.ZERO);
        } else if (exchangeRate.getValue() == null) {
            exchangeRate.setDirectRate(BigDecimal.ZERO);
            exchangeRate.setIndirectRate(BigDecimal.ZERO);
        }
        exchangeRateRepoForManage.put(currency, exchangeRate);
        return exchangeRate;
    }

    private void setLocAmt(IDataModel model, BigDecimal amt, int row) {
        String dc;
        String string = dc = model.getValue("entrydc", row) == null ? "1" : (String)model.getValue("entrydc", row);
        if ("1".equals(dc)) {
            model.setValue("debitlocal", (Object)amt, row);
        } else {
            model.setValue("creditlocal", (Object)amt, row);
        }
    }

    private BigDecimal getOriAmt(DynamicObject entry) {
        String dc = entry.getString("entrydc") == null ? "1" : entry.getString("entrydc");
        BigDecimal rs = "1".equals(dc) ? entry.getBigDecimal("debitori") : entry.getBigDecimal("creditori");
        return rs;
    }

    private Map<Long, ExchangeRate> parseRateForAccountBook(AccountBookInfo book, Date accountingDate) {
        long baseCurrency = book.getBaseCurrencyId();
        return RateServiceHelper.batchGetExchangeRate(null, (Long)baseCurrency, (Long)book.getExrateTableId(), (Date)accountingDate);
    }

    public static Set<String> getFlexFields(long accountid) {
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountid, (String)"bd_accountview");
        DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
        HashSet<String> flexfields = new HashSet<String>(col.size());
        for (DynamicObject dyn : col) {
            DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
            if (assgrp == null) continue;
            flexfields.add(assgrp.getString("flexfield"));
        }
        return flexfields;
    }

    Set<String> getLocalEntryProp(String entry) {
        EntryProp entryProperty = (EntryProp)this.getModel().getDataEntityType().getProperty(entry);
        DataEntityPropertyCollection entryProperties = entryProperty.getDynamicCollectionItemPropertyType().getProperties();
        return entryProperties.stream().map(x -> x.getName()).collect(Collectors.toSet());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.visibleAndWidth(false, this.ratioOriRateCurr(2), "oriamount_main", "localrate_main", "currency_main", "quantity_main", "price_main", "quantity_main", "businessnum_main", "expiredate_main", "ratetype_main");
        this.initOriAMO();
        this.setAssgrpEnable();
        Object bt = this.getModel().getValue("booktype");
        if (Objects.isNull(bt)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"importmainvoucher"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.visibleAndWidth(false, this.ratioOriRateCurr(2), "oriamount_main", "localrate_main", "currency_main", "quantity_main", "price_main", "quantity_main", "businessnum_main", "expiredate_main", "ratetype_main");
        this.initOriAMO();
        this.setAssgrpEnable();
        IDataModel model = this.getModel();
        Object id = model.getValue("id");
        if (!id.equals(0L)) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"gl_voucher_relation", (String)"srcvoucherid,destvoucherid,srcbook,destbook", (QFilter[])new QFilter[]{new QFilter("destvoucherid", "=", (Object)Long.parseLong(model.getValue("id").toString()))});
            if (dyn != null) {
                DataEntityPropertyCollection entryProps = this.getVoucherEntryProps();
                DynamicObject[] sourceVoucher = BusinessDataServiceHelper.load((String)"gl_voucher", (String)this.getVoucherSelects(this.getVoucherEntryProps()), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dyn.getLong("srcvoucherid"))});
                if (sourceVoucher == null || sourceVoucher.length == 0) {
                    return;
                }
                DynamicObject srcVchDyn = sourceVoucher[0];
                DynamicObject localCur = srcVchDyn.getDynamicObject("localcur");
                model.setValue("localcur_main", (Object)localCur);
                DynamicObjectCollection sourceEntrys = srcVchDyn.getDynamicObjectCollection("entries");
                Set<String> localEntryPros = this.getLocalEntryProp("entries");
                Set<String> localMainEntryPros = this.getLocalEntryProp("entries_main");
                model.deleteEntryData("entries_main");
                for (DynamicObject sourceEntry : sourceEntrys) {
                    int rowMain = model.createNewEntryRow("entries_main");
                    model.setValue("account_main", sourceEntry.get("account"), rowMain);
                    for (IDataEntityProperty prop : entryProps) {
                        String proName = prop.getName();
                        if (proName.equals("id") || proName.equals("seq") || proName.equals("account") || proName.endsWith("_id") || proName.equals("oriamount") || !localEntryPros.contains(proName) || !localMainEntryPros.contains(proName + "_main")) continue;
                        model.setValue(proName + "_main", sourceEntry.get(proName), rowMain);
                    }
                }
                this.updateMainEntryRateType(srcVchDyn.getLong("org.id"), ContextUtil.getUserId(), srcVchDyn.getDate("bizdate"), srcVchDyn.getDate("bookeddate"), srcVchDyn.getLong(GLField.id_((String)"localcur")));
                this.caclSumDebitLocalAmt();
            }
            this.caclSumDebitLocalAmt();
        }
        this.getView().updateView("entries_main");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        if (("save".equals(key) || "submit".equals(key)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            String srcBookId = pageCache.get("bookId");
            String srcVoucherId = pageCache.get("sourceVoucherId");
            if (srcBookId == null || srcVoucherId == null) {
                return;
            }
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"gl_voucher_relation", (String)"srcvoucherid,destvoucherid,srcbook,destbook,createdate", (QFilter[])new QFilter[]{new QFilter("destvoucherid", "=", (Object)Long.parseLong(model.getValue("id").toString()))});
            if (dyn == null) {
                dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher_relation"));
                dyn.set("destvoucherid", (Object)Long.parseLong(model.getValue("id").toString()));
                dyn.set("destbook", (Object)Long.parseLong(model.getValue("book_id").toString()));
                dyn.set("ruleid", (Object)0L);
            }
            dyn.set("srcvoucherid", (Object)Long.parseLong(srcVoucherId));
            dyn.set("srcbook", (Object)Long.parseLong(srcBookId));
            dyn.set("createdate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
            model.setDataChanged(false);
        }
    }

    public boolean isEqLocalCur(int rowInt) {
        DynamicObject curLoc = (DynamicObject)this.getModel().getValue("localcur");
        DynamicObject curreny = (DynamicObject)this.getModel().getValue("currency_main", rowInt);
        if (curreny == null) {
            return true;
        }
        return curLoc != null && curreny != null && curLoc.getLong("id") == curreny.getLong("id");
    }

    private void initOriAMO() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entyDyns = model.getEntryEntity("entries_main");
        boolean flag = false;
        boolean isAc = false;
        for (int i = 0; i < entyDyns.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entyDyns.get(i);
            if (dyn.getBigDecimal("debitori_main").compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("oriamount_main", (Object)dyn.getBigDecimal("creditori_main"), i);
            } else {
                model.setValue("oriamount_main", (Object)dyn.getBigDecimal("debitori_main"), i);
            }
            DynamicObject account = dyn.getDynamicObject("account_main");
            if (account != null && !"nocurrency".equals(account.getString("acctcurrency"))) {
                flag = true;
                if (this.isEqLocalCur(i)) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"localrate_main"});
                }
            } else {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"localrate_main", "currency_main"});
            }
            if (account == null) continue;
            if (!account.getBoolean("accheck")) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"businessnum_main", "expiredate_main"});
                continue;
            }
            isAc = true;
        }
        if (flag) {
            if (model.getValue("sourcetype").equals("2")) {
                this.visibleAndWidth(true, this.ratioOriRateCurr(4), "localrate_main", "currency_main", "ratetype_main");
            } else {
                this.visibleAndWidth(true, this.ratioOriRateCurr(1), "oriamount_main", "localrate_main", "currency_main", "ratetype_main");
            }
        } else {
            this.visibleAndWidth(false, this.ratioOriRateCurr(2), "oriamount_main", "localrate_main", "currency_main", "ratetype_main");
        }
        this.visibleAndWidth(isAc, this.ratioOriRateCurr(5), "businessnum_main", "expiredate_main");
    }

    private void setQtyVisible() {
        boolean existsQtyAccount = this.getModel().getEntryEntity("entries_main").stream().anyMatch(row -> row.getBoolean(GLField.join((String[])new String[]{"account_main", "isqty"})));
        this.getView().setVisible(Boolean.valueOf(existsQtyAccount), new String[]{"measureunit_main", "price_main", "quantity_main"});
    }

    private void visibleAndWidth(boolean value, Map<String, LocaleString> mapFields, String ... keys) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entries");
        for (Map.Entry<String, LocaleString> entry : mapFields.entrySet()) {
            entryGrid.setColumnProperty(entry.getKey(), "w", (Object)entry.getValue());
        }
        this.getView().setVisible(Boolean.valueOf(value), keys);
    }

    private void setAssgrpEnable() {
        String status = (String)this.getModel().getValue("billstatus");
        if ("B".equals(status) || "A".equals(status)) {
            DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("entries_main");
            int i = 0;
            for (DynamicObject entry : entries) {
                DynamicObject account = entry.getDynamicObject("account_main");
                if (null != account && account.getDynamicObjectCollection("checkitementry").size() == 0) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entries_main", "assgrp_main"});
                }
                ++i;
            }
        }
    }

    private Map<String, LocaleString> ratioOriRateCurr(int select) {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(8);
        if (1 == select) {
            map.put("edescription_main", new LocaleString("18%"));
            map.put("account_main", new LocaleString("16%"));
            map.put("assgrp_main", new LocaleString("14%"));
            map.put("currency_main", new LocaleString("6%"));
            map.put("oriamount_main", new LocaleString("12%"));
            map.put("localrate_main", new LocaleString("10%"));
            map.put("debitlocal", new LocaleString("12%"));
            map.put("creditlocal", new LocaleString("12%"));
        } else if (2 == select) {
            map.put("edescription_main", new LocaleString("25%"));
            map.put("account_main", new LocaleString("20%"));
            map.put("assgrp_main", new LocaleString("23%"));
            map.put("debitlocal", new LocaleString("15%"));
            map.put("creditlocal", new LocaleString("15%"));
        } else if (3 == select) {
            map.put("edescription_main", new LocaleString("22%"));
            map.put("account_main", new LocaleString("18%"));
            map.put("assgrp_main", new LocaleString("22%"));
            map.put("currency_main", new LocaleString("8%"));
            map.put("debitlocal", new LocaleString("15%"));
            map.put("creditlocal", new LocaleString("15%"));
        } else if (4 == select) {
            map.put("edescription_main", new LocaleString("18%"));
            map.put("account_main", new LocaleString("18%"));
            map.put("assgrp_main", new LocaleString("16%"));
            map.put("currency_main", new LocaleString("12%"));
            map.put("localrate_main", new LocaleString("12%"));
            map.put("debitlocal", new LocaleString("12%"));
            map.put("creditlocal", new LocaleString("12%"));
        } else if (5 == select) {
            map.put("edescription_main", new LocaleString("18%"));
            map.put("account_main", new LocaleString("16%"));
            map.put("assgrp_main", new LocaleString("14%"));
            map.put("expiredate_main", new LocaleString("6%"));
            map.put("businessnum_main", new LocaleString("12%"));
            map.put("debitlocal", new LocaleString("12%"));
            map.put("creditlocal", new LocaleString("12%"));
        }
        return map;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if ("account_main".equals(key)) {
            int rowIndex = evt.getRowIndex();
            this.hyperSublidger(rowIndex);
        } else if ("assgrp_main".equals(key)) {
            int rowIndex = evt.getRowIndex();
            this.hyperSubsidiaryledger(rowIndex);
        }
    }

    private void hyperSublidger(int rowIndex) {
        IDataModel model = this.getModel();
        long acctId = (Long)model.getValue(Voucher.id_((String)"account_main"), rowIndex);
        DynamicObject account = (DynamicObject)model.getValue("account_main", rowIndex);
        long accountTableId = 0L;
        if (account != null) {
            accountTableId = account.getLong("accounttable_id");
        }
        long curId = (Long)model.getValue(Voucher.id_((String)"currency_main"), rowIndex);
        if (acctId == 0L) {
            return;
        }
        DynamicObject voucherRelation = BusinessDataServiceHelper.loadSingle((String)"gl_voucher_relation", (String)"srcvoucherid,destvoucherid,srcbook,destbook", (QFilter[])new QFilter[]{new QFilter("destvoucherid", "=", (Object)Long.parseLong(model.getValue("id").toString()))});
        if (voucherRelation != null) {
            DynamicObject mainVoucher = BusinessDataServiceHelper.loadSingle((Object)voucherRelation.getLong("srcvoucherid"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher"));
            VoucherUtil.hyperSublidger(mainVoucher, acctId, curId, this.getView(), accountTableId);
        }
    }

    private AccountBookInfo getTargetBook() {
        long orgID = (Long)this.getModel().getValue("org_id");
        long bookTypeID = (Long)this.getModel().getValue("booktype_id");
        return AccSysUtil.getBookFromAccSys((long)orgID, (long)bookTypeID);
    }

    private Optional<AccountBookInfo> getSourceBook() {
        String sourceBookId = this.getPageCache().get("bookId");
        if (StringUtils.isBlank((CharSequence)sourceBookId)) {
            return Optional.empty();
        }
        return Optional.of(new AccountBookInfo(Long.parseLong(sourceBookId)));
    }

    private void hyperSubsidiaryledger(int rowIndex) {
        IDataModel model = this.getModel();
        long acctId = (Long)model.getValue(Voucher.id_((String)"account_main"), rowIndex);
        DynamicObject account = (DynamicObject)model.getValue("account_main", rowIndex);
        long accountTableId = 0L;
        if (account != null) {
            accountTableId = account.getLong("accounttable_id");
        }
        long curId = (Long)model.getValue(Voucher.id_((String)"currency_main"), rowIndex);
        DynamicObject assgrp = (DynamicObject)model.getValue("assgrp_main", rowIndex);
        BigDecimal quantity = (BigDecimal)model.getValue("quantity_main", rowIndex);
        DynamicObject voucherRelation = BusinessDataServiceHelper.loadSingle((String)"gl_voucher_relation", (String)"srcvoucherid,destvoucherid,srcbook,destbook", (QFilter[])new QFilter[]{new QFilter("destvoucherid", "=", (Object)Long.parseLong(model.getValue("id").toString()))});
        if (voucherRelation != null) {
            DynamicObject mainVoucher = BusinessDataServiceHelper.loadSingle((Object)voucherRelation.getLong("srcvoucherid"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher"));
            if (assgrp == null) {
                VoucherUtil.hyperSublidger(mainVoucher, acctId, curId, this.getView(), accountTableId);
            } else {
                VoucherUtil.hyperSubsidiaryledger(mainVoucher, acctId, curId, assgrp, quantity, this.getView(), accountTableId);
            }
        }
    }

    private void caclSumDebitLocalAmt() {
        EntryGrid entryGridMain = (EntryGrid)this.getControl("entries_main");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entries");
        HashMap<String, String> floatButtomDataMain = new HashMap<String, String>(1);
        HashMap<String, String> floatButtomData = new HashMap<String, String>(1);
        BigDecimal sumDebitLocalMain = entryGridMain.getSum("debitlocal_main");
        BigDecimal sumDebitLocal = entryGrid.getSum("debitlocal");
        DynamicObject localcur = (DynamicObject)this.getModel().getValue("localcur");
        String sumDebitLocalStrMain = "";
        String sumDebitLocalStr = "";
        Locale locale = RequestContext.getOrCreate().getLang().getLocale();
        if (locale == Locale.SIMPLIFIED_CHINESE) {
            FormatRMB formatRMB = new FormatRMB();
            if (null != localcur && localcur.getString("number").equals("CNY") && BigDecimal.ZERO.compareTo(sumDebitLocal) != 0) {
                sumDebitLocalStrMain = formatRMB.format(locale, new Variant((Object)sumDebitLocalMain), false);
                sumDebitLocalStr = formatRMB.format(locale, new Variant((Object)sumDebitLocal), false);
            }
        }
        floatButtomDataMain.put("edescription_main", sumDebitLocalStrMain);
        entryGridMain.setFloatButtomData(floatButtomDataMain);
        floatButtomData.put("edescription", sumDebitLocalStr);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    private void updateMainEntryRateType(long orgId, long creatorId, Date bizDate, Date bookedDate, long locCurrencyId) {
        if (!RateServiceHelper.isEnableIndirectRateConversion()) {
            return;
        }
        DynamicObjectCollection entryDynColl = this.getModel().getEntryEntity("entries_main");
        Set curIdSet = entryDynColl.stream().map(x -> x.getLong(GLField.id_((String)"currency_main"))).collect(Collectors.toSet());
        boolean bizDateCtrlRate = VoucherEditArgHelper.isBizDateCtrlRate((long)orgId, (long)creatorId);
        Date ctrlDate = bizDateCtrlRate ? bizDate : bookedDate;
        Map rateTypeMap = RateServiceHelper.batchGetRateType(curIdSet, (Long)locCurrencyId, (Date)ctrlDate);
        int i = 0;
        for (DynamicObject entryDyn : entryDynColl) {
            long curId = entryDyn.getLong(GLField.id_((String)"currency_main"));
            if (curId == 0L) continue;
            this.getModel().setValue("ratetype_main", (Object)((RateType)rateTypeMap.get(curId)).getStrValue(), i++);
        }
    }

    private VoucherEditView getVoucherEditView() {
        if (null == this.voucherEditView) {
            this.voucherEditView = new VoucherEditView(this.getView(), this.getModel(), this.getPageCache());
        }
        return this.voucherEditView;
    }
}

