/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.fi.gl.formplugin.voucher.service.IControlStateService;

public class VoucherEditControlStateRecoder
implements AutoCloseable {
    private static final CopyOnWriteArrayList<IControlStateService> SERVICES = new CopyOnWriteArrayList();
    protected static final String KEY_CONTROL_STATE = "voucherControlState";
    private final IPageCache pageCache;
    private final Map<String, Boolean> headStateMap;
    private final Table<String, Integer, Boolean> entryStateTable;

    public static void register(IControlStateService service) {
        SERVICES.add(service);
    }

    protected VoucherEditControlStateRecoder(IPageCache pageCache) {
        this.pageCache = pageCache;
        this.headStateMap = new HashMap<String, Boolean>(8);
        this.entryStateTable = HashBasedTable.create();
        this.initConfig();
    }

    private void initConfig() {
        for (IControlStateService service : SERVICES) {
            for (String key : service.getEntryConfig()) {
                Configuration.registerEntry(key);
            }
        }
    }

    protected void recordHeadState(boolean enable, String ... ctrlKeys) {
        for (String ctrlKey : ctrlKeys) {
            if (!Configuration.HEAD_INDEX.containsKey(ctrlKey)) continue;
            this.headStateMap.put(ctrlKey, enable);
        }
    }

    protected void recordEntryState(boolean enable, int rowIndex, String ... ctrlKeys) {
        for (String ctrlKey : ctrlKeys) {
            if (!Configuration.ENTRY_FACTOR.containsKey(ctrlKey)) continue;
            this.entryStateTable.put((Object)ctrlKey, (Object)rowIndex, (Object)enable);
        }
    }

    protected boolean getEntryState(String ctrlKey, int rowIndex) {
        if (!Configuration.ENTRY_FACTOR.containsKey(ctrlKey)) {
            return true;
        }
        BitSet controlState = this.getOrCreateStateFromCache();
        for (Integer headIndex : Configuration.HEAD_INDEX.values()) {
            if (!controlState.get(headIndex)) continue;
            return false;
        }
        return !controlState.get(Configuration.calcEntryIndex(ctrlKey, rowIndex));
    }

    @Override
    public void close() {
        if (this.headStateMap.isEmpty() && this.entryStateTable.isEmpty()) {
            return;
        }
        BitSet controlState = this.getOrCreateStateFromCache();
        this.headStateMap.forEach((key, enable) -> controlState.set((int)Configuration.calcHeadIndex(key), enable == false));
        this.entryStateTable.cellSet().forEach(cell -> controlState.set((int)Configuration.calcEntryIndex((String)cell.getRowKey(), (Integer)cell.getColumnKey()), (Boolean)cell.getValue() == false));
        this.pageCache.put(KEY_CONTROL_STATE, SerializationUtils.toJsonString((Object)controlState.toByteArray()));
        this.headStateMap.clear();
        this.entryStateTable.clear();
    }

    private BitSet getOrCreateStateFromCache() {
        String controlState = this.pageCache.get(KEY_CONTROL_STATE);
        if (controlState == null) {
            return new BitSet();
        }
        return BitSet.valueOf((byte[])SerializationUtils.fromJsonString((String)controlState, byte[].class));
    }

    private static class Configuration {
        private static final Map<String, Integer> HEAD_INDEX = new ConcurrentHashMap<String, Integer>(4);
        private static final Map<String, Integer> ENTRY_FACTOR = new ConcurrentHashMap<String, Integer>(8);
        private static final AtomicInteger ENTRY_INDEX = new AtomicInteger(3);

        private Configuration() {
        }

        private static void registerEntry(String key) {
            ENTRY_FACTOR.computeIfAbsent(key, k -> ENTRY_INDEX.incrementAndGet());
        }

        private static Integer calcHeadIndex(String headKey) {
            return HEAD_INDEX.get(headKey);
        }

        private static Integer calcEntryIndex(String entryKey, int rowIndex) {
            int offset = rowIndex * ENTRY_FACTOR.size() + ENTRY_FACTOR.get(entryKey);
            return HEAD_INDEX.size() - 1 + offset;
        }

        static {
            HEAD_INDEX.put("vpanel", 0);
            HEAD_INDEX.put("advconap", 1);
            HEAD_INDEX.put("entriespanel", 2);
            HEAD_INDEX.put("entries", 3);
            ENTRY_FACTOR.put("debitlocal", 1);
            ENTRY_FACTOR.put("creditlocal", 2);
            ENTRY_FACTOR.put("edescription", 3);
        }
    }
}

