/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.gl.business.service.voucher.option.helper.VoucherCarryConfigServiceHelper;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.enums.voucher.VoucherExpireDateOption;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.VoucherEditVisibleHelper;
import kd.fi.gl.util.GLUtil;

public class VoucherEditExpireDateHelper {
    private VoucherEditExpireDateHelper() {
    }

    protected static void handleExpireDate(int rowIndex, DynamicObject rowAccount, IDataModel voucherEditModel, IFormView voucherEditView) {
        if (Objects.isNull(rowAccount)) {
            return;
        }
        if (rowAccount.getBoolean("accheck")) {
            Date preDate;
            VoucherEditVisibleHelper.setVisibleAndWidth(voucherEditView, 5, true, "expiredate", "businessnum");
            voucherEditView.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"expiredate", "businessnum"});
            boolean isAutoFill = VoucherCarryConfigServiceHelper.isCarry((long)((Long)voucherEditModel.getValue(Voucher.id_((String)"org"))), (long)RequestContext.get().getCurrUserId(), (String)"expiredate");
            if (isAutoFill && rowIndex != 0 && (preDate = (Date)voucherEditModel.getValue("expiredate", rowIndex - 1)) != null) {
                voucherEditModel.setValue("expiredate", (Object)preDate, rowIndex);
                return;
            }
            Optional<Date> expireDate = VoucherEditExpireDateHelper.getExpireDateByVoucherSetting(rowAccount, voucherEditModel);
            voucherEditModel.setValue("expiredate", expireDate.orElse(null), rowIndex);
        } else {
            voucherEditModel.setValue("expiredate", null, rowIndex);
            voucherEditModel.setValue("businessnum", null, rowIndex);
            voucherEditView.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"expiredate", "businessnum"});
        }
    }

    public static Optional<Date> getExpireDateByVoucherSetting(DynamicObject account, IDataModel voucherEditModel) {
        boolean accountCurrent;
        boolean bl = accountCurrent = account != null && account.getBoolean("accheck");
        if (!accountCurrent) {
            return Optional.empty();
        }
        VoucherExpireDateOption expireDateOption = VoucherEditArgHelper.getExpireDateOption((DynamicObject)voucherEditModel.getDataEntity());
        return Optional.of(expireDateOption.getDateParser().apply(voucherEditModel.getDataEntity()));
    }

    protected static void afterChangeBizDate(Date newBizDate, IDataModel voucherEditModel) {
        DynamicObjectCollection entries = voucherEditModel.getEntryEntity("entries");
        for (DynamicObject entry : entries) {
            Date expireDate = entry.getDate("expiredate");
            if (null == expireDate || expireDate.compareTo(newBizDate) >= 0) continue;
            voucherEditModel.setValue("expiredate", (Object)newBizDate, entry.getInt("seq") - 1);
        }
    }

    protected static void refreshExpireDate(VoucherEditView voucherEditView) {
        VoucherEditExpireDateHelper.refreshExpireDate(voucherEditView, date -> true);
    }

    protected static void refreshExpireDate(VoucherEditView voucherEditView, Predicate<Date> originalValueUpdatable) {
        IDataModel model = voucherEditView.getVoucherEditModel();
        IntStream.range(0, voucherEditView.getValueGetter().getEntryCount()).forEach(i -> {
            if (originalValueUpdatable.test(voucherEditView.getValueGetter().getExpireDate(i))) {
                VoucherEditExpireDateHelper.getExpireDateByVoucherSetting(voucherEditView.getValueGetter().getAccount(i), model).ifPresent(newDate -> model.setValue("expiredate", newDate, i));
            }
        });
    }

    protected static boolean isSyncUpdateWhenDateChanged(VoucherEditView voucherEditView, String propertyName) {
        VoucherExpireDateOption expireDateOption = VoucherEditArgHelper.getExpireDateOption((DynamicObject)voucherEditView.getVoucherEditModel().getDataEntity());
        if (!propertyName.equals(expireDateOption.getSrcProperty())) {
            return false;
        }
        return voucherEditView.getValueGetter().getVoucherEntries().stream().anyMatch(row -> GLUtil.isAccheckAcct((DynamicObject)row.getDynamicObject("account")));
    }
}

