/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.fi.gl.util.GLApp;

public class VoucherEditMarkError
extends AbstractBillPlugIn
implements ItemClickListener {
    private static final String GL_MARKERROR = "gl_markerror";
    private static final String ERROR_TAB = "errortab";
    private static final String ERRORIMAGE = "errorimage";
    private static final String MARKERROR = "markerror";
    private static final String CANCELMARKERROR = "cancelmarkerror";
    private static final String TBSAVE = "tbsave";
    private static final String CONTENT = "content";
    private static final Set<String> TOUCH_OPERATES = Sets.newHashSet((Object[])new String[]{"submit", "audit", "cancelmarkerror"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBSAVE});
    }

    public void afterCreateNewData(EventObject e) {
        this.setErrorStatus("0");
        this.setErrorMsg("");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshControlStatus();
    }

    private void refreshControlStatus() {
        boolean errorStatus = this.isErrorStatus();
        this.showErrorTab("1".equals(this.getErrorStatus()) || "2".equals(this.getErrorStatus()));
        this.showErrorImage(errorStatus);
        this.setCancelMarkErrorEnable(errorStatus);
        this.setOperateEnable(!errorStatus);
    }

    public void afterCopyData(EventObject e) {
        this.setErrorStatus("0");
        this.setErrorMsg("");
        this.showErrorTab(false);
        this.showErrorImage(false);
    }

    private boolean isErrorStatus() {
        return "1".equals(this.getErrorStatus());
    }

    private String getErrorStatus() {
        return (String)this.getModel().getValue("errorstatus");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (MARKERROR.equals(itemKey)) {
            this.showMarkErrorEdit();
        }
    }

    private void showMarkErrorEdit() {
        if ("B".equals(this.getVoucherStatus())) {
            if (this.getModel().getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u63d0\u4ea4\u3002", (String)"VoucherEditMarkError_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(GL_MARKERROR);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, GL_MARKERROR));
            parameter.setCustomParam(CONTENT, (Object)this.getErrorMsg());
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u7684\u51ed\u8bc1\u53ef\u4ee5\u5ba1\u6838\u9a73\u56de\u3002", (String)"VoucherEditMarkError_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    private String getVoucherStatus() {
        return (String)this.getModel().getValue("billstatus");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (GL_MARKERROR.equals(actionId)) {
            this.markError((String)closedCallBackEvent.getReturnData());
        }
    }

    private void markError(String errorMsg) {
        if (errorMsg == null) {
            return;
        }
        this.setErrorStatus("1");
        this.setErrorMsg(errorMsg);
        this.getModel().clearNoDataRow();
        OperationResult operationResult = this.getView().invokeOperation(MARKERROR, OperateOption.create());
        if (!operationResult.isSuccess()) {
            this.removeError();
            this.getView().showOperationResult(operationResult);
        } else {
            this.showErrorTab(Boolean.TRUE);
            this.showErrorImage(Boolean.TRUE);
            this.setCancelMarkErrorEnable(true);
            this.setOperateEnable(false);
        }
    }

    private void removeError() {
        this.setErrorStatus("0");
        this.setErrorMsg("");
        this.showErrorTab(Boolean.FALSE);
        this.showErrorImage(Boolean.FALSE);
        this.setCancelMarkErrorEnable(false);
        this.setOperateEnable(true);
    }

    private void setErrorStatus(String errorStatus) {
        this.getModel().setValue("errorstatus", (Object)errorStatus);
    }

    private void setErrorMsg(String errorMsg) {
        this.getModel().setValue("errormsg", (Object)errorMsg);
    }

    private String getErrorMsg() {
        return (String)this.getModel().getValue("errormsg");
    }

    private void showErrorTab(Boolean visible) {
        this.getView().setVisible(visible, new String[]{ERROR_TAB});
    }

    private void showErrorImage(Boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible != false && Lang.get() == Lang.zh_CN), new String[]{ERRORIMAGE});
    }

    private void setCancelMarkErrorEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{CANCELMARKERROR});
    }

    private void setOperateEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"bar_audit", "bar_check"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && CANCELMARKERROR.equals(operateKey = ((AbstractOperate)source).getOperateKey())) {
            if (this.getModel().getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u63d0\u4ea4\u3002", (String)"VoucherEditMarkError_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            this.getModel().clearNoDataRow();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (TOUCH_OPERATES.contains(operateKey)) {
            this.refreshControlStatus();
        }
    }
}

