/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.control.events.RowClickEvent;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.formplugin.voucher.VoucherEdit;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.args.EntryExRateArg;
import kd.fi.gl.formplugin.voucher.args.EntryGridBindDataExRateArg;
import kd.fi.gl.formplugin.voucher.service.IVoucherEditExRateService;
import kd.fi.gl.util.GLUtil;

public class VoucherEditRateManager {
    private Boolean enableIndirect;
    private static final List<IVoucherEditExRateService> SERVICES = new ArrayList<IVoucherEditExRateService>(2);

    protected VoucherEditRateManager() {
    }

    protected boolean isDisableInderictRate() {
        if (this.enableIndirect == null) {
            this.enableIndirect = RateServiceHelper.isEnableIndirectRateConversion();
        }
        return Boolean.FALSE.equals(this.enableIndirect);
    }

    protected void updateEntryRateType(VoucherEditView voucherEditView) {
        if (this.isDisableInderictRate()) {
            return;
        }
        this.updateEntryRateType(voucherEditView, this.getRateCtrlDate(voucherEditView));
    }

    protected void updateEntryRateType(VoucherEditView voucherEditView, Date date) {
        if (this.isDisableInderictRate()) {
            return;
        }
        EntryInfo entryPageInfo = voucherEditView.getEntryPageInfo();
        int startRowIndex = entryPageInfo.getStartRowIndex();
        int entryCurrentPageSize = voucherEditView.getEntryCurrentPageSize() + startRowIndex;
        for (int i = startRowIndex; i < entryCurrentPageSize; ++i) {
            this.setRateType(i, voucherEditView, date);
        }
    }

    protected void updateEntryRateType(VoucherEditView voucherEditView, List<RowDataEntity> rows) {
        if (this.isDisableInderictRate() || rows.isEmpty()) {
            return;
        }
        Date date = this.getRateCtrlDate(voucherEditView);
        IDataEntityProperty rateTypeProp = (IDataEntityProperty)rows.get(0).getDataEntity().getDataEntityType().getProperties().get((Object)"ratetype");
        int ordinal = rateTypeProp.getOrdinal();
        EntryGridBindDataExRateArg arg = new EntryGridBindDataExRateArg();
        arg.setView(voucherEditView);
        arg.setExRateDate(date);
        for (RowDataEntity row : rows) {
            DynamicObject entryDyn = row.getDataEntity();
            long currencyId = entryDyn.getLong("currency_id");
            arg.setEntry(entryDyn);
            arg.setCurrencyId(currencyId);
            rateTypeProp.setValue((Object)entryDyn, (Object)this.getRateType(entryDyn, voucherEditView, date));
            entryDyn.getDataEntityState().setBizChanged(ordinal, false);
            for (IVoucherEditExRateService service : SERVICES) {
                service.updateExRateType(arg);
            }
        }
    }

    private String getRateType(DynamicObject entryDyn, VoucherEditView voucherEditView, Date date) {
        long currencyId = entryDyn.getLong("currency_id");
        return this.getRateType(currencyId, voucherEditView.getValueGetter().getLocalCurrencyID(), date);
    }

    protected void setRateType(int rowIndex, VoucherEditView voucherEditView) {
        if (this.isDisableInderictRate()) {
            return;
        }
        this.setRateType(rowIndex, voucherEditView, this.getRateCtrlDate(voucherEditView));
    }

    protected void setRateType(int rowIndex, VoucherEditView voucherEditView, Date date) {
        if (this.isDisableInderictRate()) {
            return;
        }
        voucherEditView.getVoucherEditModel().setValue("ratetype", (Object)this.getRateType(rowIndex, voucherEditView, date), rowIndex);
        EntryExRateArg arg = new EntryExRateArg(voucherEditView, rowIndex, date);
        for (IVoucherEditExRateService service : SERVICES) {
            service.updateExRateType(arg);
        }
    }

    protected String getRateType(int rowIndex, VoucherEditView voucherEditView, Date date) {
        long currencyId = voucherEditView.getValueGetter().getCurrencyId(rowIndex);
        return this.getRateType(currencyId, voucherEditView.getValueGetter().getLocalCurrencyID(), date);
    }

    private String getRateType(long currencyId, long baseCurrencyId, Date date) {
        if (currencyId == 0L) {
            return null;
        }
        if (baseCurrencyId == 0L || date == null) {
            return RateType.DIRECT_RATE.getStrValue();
        }
        return RateServiceHelper.getRateType((long)currencyId, (long)baseCurrencyId, (Date)date).getStrValue();
    }

    protected Date getRateCtrlDate(VoucherEditView voucherEditView) {
        if (VoucherEditArgHelper.isBizDateCtrlRate((IDataModel)voucherEditView.getVoucherEditModel())) {
            return voucherEditView.getValueGetter().getBizDate();
        }
        return voucherEditView.getValueGetter().getBookDate();
    }

    protected void refreshRate(VoucherEditView voucherEditView, VoucherEdit voucherEdit) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int curRowIndex = voucherEditView.getVoucherEditModel().getEntryCurrentRowIndex("entries");
        EntryExRateArg arg = new EntryExRateArg();
        arg.setView(voucherEditView);
        arg.setExRateDate(this.getRateCtrlDate(voucherEditView));
        for (int i = 0; i < valueGetter.getEntryCount(); ++i) {
            arg.setRowIndex(i);
            voucherEditView.getVoucherEditModel().setValue("localrate", (Object)this.fetchRowRate(voucherEditView, i), i);
            for (IVoucherEditExRateService service : SERVICES) {
                service.updateExRate(arg);
            }
        }
        voucherEditView.getVoucherEditModel().setEntryCurrentRowIndex("entries", curRowIndex);
        voucherEditView.getPageCache().remove("entryRowClick");
        voucherEdit.entryRowClick(new RowClickEvent((Object)voucherEdit.getControl("entries"), curRowIndex));
    }

    protected BigDecimal fetchRowRate(VoucherEditView voucherEditView, int rowIndex) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        return GLUtil.getExchangeRate((Long)valueGetter.getExRateTable().getLong("id"), (Long)valueGetter.getCurrencyId(rowIndex), (Long)valueGetter.getLocalCurrencyID(), (Date)this.getRateCtrlDate(voucherEditView));
    }

    protected boolean isSyncUpdateWhenDateChanged(VoucherEditView voucherEditView, String propertyName) {
        if (!VoucherEditArgHelper.enableUpdateRate((DynamicObject)voucherEditView.getVoucherEditModel().getDataEntity())) {
            return false;
        }
        if (VoucherEditArgHelper.isBizDateCtrlRate((IDataModel)voucherEditView.getVoucherEditModel()) && propertyName.equals("bookeddate")) {
            return false;
        }
        if (!VoucherEditArgHelper.isBizDateCtrlRate((IDataModel)voucherEditView.getVoucherEditModel()) && propertyName.equals("bizdate")) {
            return false;
        }
        long localCurrencyId = voucherEditView.getValueGetter().getLocalCurrencyID();
        DynamicObjectCollection entries = voucherEditView.getValueGetter().getVoucherEntries();
        boolean existsForeignCurrencyEntry = entries.stream().anyMatch(row -> {
            long entryCurrencyId = row.getLong("currency.id");
            return entryCurrencyId != 0L && entryCurrencyId != localCurrencyId;
        });
        return existsForeignCurrencyEntry || SERVICES.stream().anyMatch(x -> x.isExistsForeignCurrencyEntry(voucherEditView, entries));
    }

    public static synchronized void register(IVoucherEditExRateService service) {
        SERVICES.add(service);
    }
}

