/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCalculator;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCounter;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowPanelManager;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowStatusManager;
import kd.fi.gl.formplugin.voucher.VoucherEditControlStatusManager;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.service.VoucherEditJournalService;
import kd.fi.gl.formplugin.voucher.service.VoucherEditUserRequestLogger;

public class VoucherEditServiceLoader {
    private static final List<Function<VoucherEditView, Object>> SERVICE_BUILDERS = Collections.synchronizedList(new ArrayList(5));
    private final Map<Class<?>, Object> services = new HashMap(8);

    public static void register(Function<VoucherEditView, Object> serviceBuilder) {
        SERVICE_BUILDERS.add(serviceBuilder);
    }

    protected static VoucherEditServiceLoader create(VoucherEditView voucherEditView) {
        VoucherEditServiceLoader serviceLoader = new VoucherEditServiceLoader();
        serviceLoader.initService(voucherEditView);
        return serviceLoader;
    }

    private void initService(VoucherEditView voucherEditView) {
        for (Function<VoucherEditView, Object> serviceBuilder : SERVICE_BUILDERS) {
            Object service = serviceBuilder.apply(voucherEditView);
            this.addService(service.getClass(), service);
        }
    }

    public void addService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    public <T> T getService(Class<? extends T> clazz) {
        return (T)this.services.get(clazz);
    }

    static {
        VoucherEditServiceLoader.register(VoucherEditCashFlowCalculator::new);
        VoucherEditServiceLoader.register(VoucherEditCashFlowCounter::new);
        VoucherEditServiceLoader.register(VoucherEditCashFlowStatusManager::new);
        VoucherEditServiceLoader.register(VoucherEditCashFlowPanelManager::new);
        VoucherEditServiceLoader.register(VoucherEditControlStatusManager::new);
        VoucherEditServiceLoader.register(VoucherEditJournalService::new);
        VoucherEditServiceLoader.register(VoucherEditUserRequestLogger::new);
    }
}

