/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.util.ArrayKey;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.LongProp;
import kd.bos.list.query.DBCostCache;
import kd.bos.list.query.DBCostCacheFactory;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.QueryUtils;
import kd.bos.list.query.impl.Query;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.util.ConfigurationUtil;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.formplugin.voucher.DataSetMapper;
import kd.fi.gl.formplugin.voucher.list.result.RowsResult;
import kd.fi.gl.formplugin.voucher.list.result.VoucherRowsResultBuilder;
import kd.fi.gl.service.GLThreadService;

public class VoucherIdQuery
extends Query {
    private static final Log LOG = LogFactory.getLog(VoucherIdQuery.class);
    protected static DBCostCache ics = DBCostCacheFactory.createCache();
    private Map<String, String> idCacheMap;
    private List<SummaryResult> cacheSummaryResults = new ArrayList<SummaryResult>();
    private static final String COMMA = ",";
    private static final String ID = "id";
    private static final String ENTRY_PREF = "entries.";
    private boolean querySumFields = true;

    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        PerformanceWatch watch = new PerformanceWatch(VoucherIdQuery.class, "voucherlist-IdQuery:getData", true);
        this.idCacheMap = new HashMap<String, String>();
        String cacheKey = PageRowCacheUtils.getCacheKey();
        Map allCachemap = ics.getCacheMap(cacheKey);
        String controlKey = PageRowCacheUtils.getControlKey();
        String mapKeyPrfix = StringUtils.isEmpty((CharSequence)controlKey) ? "" : controlKey;
        PageRowCacheUtils.touchFlag();
        if (this.isCache(allCachemap, mapKeyPrfix)) {
            watch.start("getfromcache");
            String cacheId = (String)allCachemap.get(mapKeyPrfix + "BILLLIST_cacheId");
            CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cds.getRowCount();
            int start = queryBuilder.getStart();
            String bdcMsg = (String)allCachemap.get(mapKeyPrfix + "BILLLIST_billDataCount");
            int billDataCount = StringUtils.isEmpty((CharSequence)bdcMsg) ? 0 : Integer.parseInt(bdcMsg);
            DynamicObjectCollection collection = null;
            if (start >= rowCount) {
                collection = new DynamicObjectCollection(queryBuilder.getReturnEntityType(), null);
            } else {
                List<Object> sortLs = cds.getList(start, queryBuilder.getLimit());
                try (DataSet ds = this.getDataSetByPks(queryBuilder, (List<Row>)sortLs);){
                    List<Object> dsLs = queryBuilder.isNeedResum() ? this.dataSetToRowList(mapKeyPrfix, ds, queryBuilder, false) : this.dataSetToRowList(ds);
                    collection = this.getDynamicCollection((List<Row>)dsLs, (List<Row>)(queryBuilder.isNeedResum() ? dsLs : sortLs), ds.getRowMeta(), queryBuilder);
                    if (!queryBuilder.isNeedResum()) {
                        this.cacheSummaryResults = QueryUtils.getSRList((String)((String)allCachemap.get(mapKeyPrfix + "BILLLIST_sumResults")));
                    }
                }
            }
            LOG.info("VoucherList_IDQuery got from cache. ");
            this.setQueryResult(collection, rowCount, billDataCount, queryBuilder, this.cacheSummaryResults);
            watch.stop();
            return collection;
        }
        int rowSize = 0;
        watch.start("queryvoucherdb");
        try (DataSet ds = this.queryDB(queryBuilder);){
            watch.stop();
            watch.start("dataSetToRowList");
            List<Row> dsLs = this.dataSetToRowList(mapKeyPrfix, ds, queryBuilder, true);
            watch.stop();
            rowSize = dsLs.size();
            watch.start("getDataSetByPks");
            List<Row> sortLs = queryBuilder.isNeedResum() ? dsLs : this.getRowList(dsLs, queryBuilder.getStart(), queryBuilder.getLimit());
            try (DataSet allFieldDs = this.getDataSetByPks(queryBuilder, sortLs);){
                DynamicObjectCollection collection = this.getDynamicCollection(this.dataSetToRowList(allFieldDs), sortLs, allFieldDs.getRowMeta(), queryBuilder);
                String bdcMsg = this.idCacheMap.get(mapKeyPrfix + "BILLLIST_billDataCount");
                int billDataCount = StringUtils.isEmpty((CharSequence)bdcMsg) ? 0 : Integer.parseInt(bdcMsg);
                this.setQueryResult(collection, rowSize, billDataCount, queryBuilder, this.cacheSummaryResults);
            }
            watch.stop();
            if (!queryBuilder.isNeedResum()) {
                watch.start("isNeedResum");
                if (rowSize <= queryBuilder.getLimit()) {
                    this.idCacheMap.put(mapKeyPrfix + "BILLLIST_cacheId", "onlyonepage_" + rowSize);
                    ics.cacheData(cacheKey, this.idCacheMap);
                } else if (!"run".equals(allCachemap.get(mapKeyPrfix + "BILLLIST_cacheState"))) {
                    GLThreadService.ayncCommonTask((String)(((Object)((Object)this)).getClass().getName() + "_cacheids"), (Runnable)new IdRunner(cacheKey, this.idCacheMap, mapKeyPrfix, queryBuilder, dsLs, RequestContext.get()));
                }
                watch.stop();
            }
        }
        DebugTraceHelper.forceLog((String)("performance_watch:" + watch.show()), (Object[])new Object[0]);
        return this.getQueryResult().getCollection();
    }

    private boolean isCache(Map<String, String> allCachemap, String mapKeyPrfix) {
        String cacheId = allCachemap.get(mapKeyPrfix + "BILLLIST_cacheId");
        String cacheState = allCachemap.get(mapKeyPrfix + "BILLLIST_cacheState");
        return StringUtils.isNotEmpty((CharSequence)cacheId) && !cacheId.startsWith("onlyonepage_") && "end".equals(cacheState);
    }

    private void setQuerySumFields(QueryBuilder queryBuilder) {
        QFilter[] filters = queryBuilder.getFilters();
        this.querySumFields = Arrays.stream(filters).anyMatch(x -> ID.equalsIgnoreCase(x.getProperty()) && "in".equalsIgnoreCase(x.getCP()));
    }

    protected DataSet queryDB(QueryBuilder queryBuilder) {
        PerformanceWatch watch = new PerformanceWatch(VoucherIdQuery.class, "voucherlist-IdQuery:querydb", true);
        watch.start("firstpart");
        this.setQuerySumFields(queryBuilder);
        List pkFieldList = queryBuilder.getPkFields();
        Set<String> selectFiledSet = pkFieldList.stream().map(ListField::getFieldName).collect(Collectors.toSet());
        String orderByStr = queryBuilder.getOrderBys();
        Object[] orderByStrArray = orderByStr.split(COMMA);
        Tuple<List<String>, List<String>> headAndEntryOrderFieldList = this.getHeadAndEntryOrderFieldList((String[])orderByStrArray);
        List headOrderByFieldList = (List)headAndEntryOrderFieldList.item1;
        Set headOrderByFieldNameSet = headOrderByFieldList.stream().map(x -> x.split(" ")[0]).collect(Collectors.toSet());
        List entryOrderByFiledList = (List)headAndEntryOrderFieldList.item2;
        Set entryOrderByFieldNameSet = entryOrderByFiledList.stream().map(x -> x.split(" ")[0]).collect(Collectors.toSet());
        selectFiledSet.addAll(headOrderByFieldNameSet);
        selectFiledSet.addAll(entryOrderByFieldNameSet);
        if (this.querySumFields) {
            Set sumFieldNameSet = queryBuilder.getSumFields().stream().map(ListField::getFieldName).collect(Collectors.toSet());
            selectFiledSet.addAll(sumFieldNameSet);
        }
        String headOrderByStr = String.join((CharSequence)COMMA, headOrderByFieldList.toArray(new String[0]));
        ORM orm = ORM.create();
        orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
        if (this.getDataEntityTypes() != null) {
            for (IDataEntityType iDataEntityType : this.getDataEntityTypes()) {
                this.setDataEntityType(orm, iDataEntityType);
            }
        }
        Object[] filters = (QFilter[])queryBuilder.getFilters().clone();
        LOG.info(String.format("VoucherList_IDQuery query db, selected fields: %s, filter: %s, headOrderByStr: %s, WithEntityEntryDistinctable: %s", String.join((CharSequence)COMMA, selectFiledSet.toArray(new String[0])), StringUtils.join((Object[])filters), headOrderByStr, WithEntityEntryDistinctable.get()));
        watch.stop();
        watch.start("querydataset");
        DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), queryBuilder.getEntityName(), String.join((CharSequence)COMMA, selectFiledSet.toArray(new String[0])), (QFilter[])filters, headOrderByStr, this.getMaxRowCount(queryBuilder), (Distinctable)WithEntityEntryDistinctable.get());
        watch.stop();
        if (!entryOrderByFiledList.isEmpty()) {
            watch.start("datasetorder");
            LOG.info(String.format("VoucherList_IDQuery reset order field: %s", StringUtils.join((Object[])orderByStrArray)));
            ds = ds.orderBy((String[])orderByStrArray);
            watch.stop();
        }
        DebugTraceHelper.forceLog((String)("performance_watch:" + watch.show()), (Object[])new Object[0]);
        return ds;
    }

    private void setDataEntityType(ORM orm, IDataEntityType dataEntityType) {
        orm.setDataEntityType(dataEntityType.getName(), dataEntityType);
    }

    private Tuple<List<String>, List<String>> getHeadAndEntryOrderFieldList(String[] orderByStrArray) {
        Map<Boolean, List<String>> orderFieldMap = Arrays.stream(orderByStrArray).map(String::trim).collect(Collectors.groupingBy(x -> x.startsWith(ENTRY_PREF)));
        return new Tuple(orderFieldMap.getOrDefault(Boolean.FALSE, Collections.emptyList()), orderFieldMap.getOrDefault(Boolean.TRUE, Collections.emptyList()));
    }

    private int getMaxRowCount(QueryBuilder queryBuilder) {
        int cacheRowCount = queryBuilder.getMaxReturnData();
        String maxRowStr = System.getProperty("bos.billlist.maxRowCount", "100000");
        int maxrowcount = Integer.parseInt(maxRowStr);
        return Math.min(cacheRowCount, maxrowcount);
    }

    protected DynamicObjectCollection getDynamicCollection(List<Row> dsLs, List<Row> sortDsLs, RowMeta dsRowMeta, QueryBuilder qb) {
        final List pkFields = qb.getPkFields();
        String seqField = qb.getSeqField();
        if (sortDsLs == null) {
            sortDsLs = dsLs;
        }
        final HashMap<ArrayKey, Integer> sortMap = new HashMap<ArrayKey, Integer>(sortDsLs.size());
        int sortIndex = 0;
        for (Row row : sortDsLs) {
            Object[] keyValues = this.getPksValue(pkFields, row);
            ArrayKey ak = new ArrayKey(keyValues);
            sortMap.put(ak, ++sortIndex);
        }
        dsLs.sort(new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                Object[] row1KeyValues = VoucherIdQuery.this.getPksValue(pkFields, row1);
                Object[] row2KeyValues = VoucherIdQuery.this.getPksValue(pkFields, row2);
                ArrayKey row1Ak = new ArrayKey(row1KeyValues);
                ArrayKey row2Ak = new ArrayKey(row2KeyValues);
                if (Objects.isNull(sortMap.get(row1Ak))) {
                    return -1;
                }
                if (Objects.isNull(sortMap.get(row2Ak))) {
                    return 1;
                }
                return ((Integer)sortMap.get(row1Ak)).compareTo((Integer)sortMap.get(row2Ak));
            }
        });
        if (StringUtils.isEmpty((CharSequence)seqField)) {
            return this.getDynamicObjectCollection((MainEntityType)qb.getEntityType(), qb.getReturnEntityType(), dsLs, dsRowMeta, qb.getPkFields());
        }
        ArrayList<Row> seqRows = new ArrayList<Row>(dsLs.size());
        RowMeta seqRowMeta = this.rowMetaAddField(dsRowMeta, seqField, (DataType)DataType.IntegerType);
        boolean isFirstFlag = true;
        boolean isAddSeqField = true;
        for (Row row : dsLs) {
            Object[] rowKeyValues;
            ArrayKey rowAk;
            if (isFirstFlag) {
                isAddSeqField = this.isAddSeqField(((AbstractRow)row).getRowMeta(), seqField);
                isFirstFlag = false;
            }
            if (Objects.isNull(sortMap.get(rowAk = new ArrayKey(rowKeyValues = this.getPksValue(pkFields, row))))) continue;
            if (isAddSeqField) {
                int seqIndex = (Integer)sortMap.get(rowAk);
                seqRows.add(this.rowAddField(row, seqIndex, seqRowMeta));
                continue;
            }
            seqRows.add(row);
        }
        return this.getDynamicObjectCollection((MainEntityType)qb.getEntityType(), qb.getReturnEntityType(), seqRows, seqRowMeta, qb.getPkFields());
    }

    private boolean isAddSeqField(RowMeta meta, String seqField) {
        for (Field field : meta.getFields()) {
            if (!seqField.equals(field.getName()) && !seqField.equals(field.getAlias())) continue;
            return false;
        }
        return true;
    }

    private DynamicObjectCollection getDynamicObjectCollection(MainEntityType mainEntityType, DynamicObjectType dt, List<Row> rowList, RowMeta rowMeta, List<ListField> pkListFields) {
        DataSetMapper dataSetMapper = new DataSetMapper(mainEntityType, dt, rowMeta, rowList, pkListFields);
        return dataSetMapper.getDynamicObjectCollection();
    }

    private DataSet getDataSetByPks(QueryBuilder qb, List<Row> rows) {
        List pkFields = qb.getPkFields();
        int pkSize = pkFields.size();
        int rowSize = rows.size();
        QFilter[] filters = new QFilter[pkSize];
        int index = 0;
        for (ListField field : pkFields) {
            boolean entryHaveNull = false;
            ArrayList<Object> pkObjValues = new ArrayList<Object>(rowSize);
            String filterPk = field.getFieldName();
            for (int i = 0; i < rowSize; ++i) {
                Object pkObj = rows.get(i).get(filterPk);
                if (this.pkValueIsNull(pkObj)) {
                    entryHaveNull = true;
                    continue;
                }
                pkObjValues.add(pkObj);
            }
            filters[index] = new QFilter(filterPk, "in", pkObjValues);
            if (entryHaveNull) {
                filters[index] = filters[index].or(QFilter.notExists((String)filterPk));
            }
            ++index;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (qb.isNeedResum() && !qb.isSelectedAllRows()) {
            qFilters.addAll(Arrays.asList(qb.getFilters()));
        } else {
            qFilters.addAll(Arrays.asList(filters));
        }
        if (qb.isNeedResum() && !StringUtils.isEmpty((CharSequence)qb.getOrderBys())) {
            ArrayList selectFiledList = new ArrayList();
            List sumFields = qb.getSumFields();
            if (sumFields != null && !sumFields.isEmpty()) {
                selectFiledList.addAll(sumFields);
            }
            selectFiledList.addAll(qb.getPkFields());
            HashSet<String> selectFiledSet = new HashSet<String>(selectFiledList.size());
            for (ListField field : selectFiledList) {
                selectFiledSet.add(field.getFieldName());
            }
            if (!qb.isSelectedAllRows()) {
                String[] tempStrs;
                for (String temp : tempStrs = qb.getOrderBys().split(COMMA)) {
                    selectFiledSet.add(temp.trim().split(" ")[0]);
                }
            }
            String lowerSelectFields = qb.getSelectFields().toLowerCase() + COMMA;
            StringBuilder selectFileds = new StringBuilder(qb.getSelectFields());
            selectFileds.append(COMMA);
            for (String field : selectFiledSet) {
                boolean exists = false;
                String lowerField = field.toLowerCase(Locale.ENGLISH);
                if (lowerSelectFields.startsWith(lowerField)) {
                    boolean bl = exists = lowerSelectFields.startsWith(lowerField + " ") || lowerSelectFields.startsWith(lowerField + COMMA);
                }
                if (!exists) {
                    boolean bl = exists = lowerSelectFields.indexOf(" " + lowerField + " ") != -1 || lowerSelectFields.indexOf(COMMA + lowerField + " ") != -1 || lowerSelectFields.indexOf(COMMA + lowerField + COMMA) != -1 || lowerSelectFields.indexOf(" " + lowerField + COMMA) != -1;
                }
                if (exists) continue;
                selectFileds.append(field);
                selectFileds.append(COMMA);
            }
            qb.setSelectFields(selectFileds.substring(0, selectFileds.length() - 1));
        }
        ORM orm = ORM.create();
        orm.setDataEntityType(qb.getEntityName(), qb.getEntityType());
        if (qb.getEntityType() instanceof QueryEntityType) {
            QueryEntityType queryEntityType = (QueryEntityType)qb.getEntityType();
            return queryEntityType.getQueryDataSetByPK(qb, qFilters, qb.getSelectFields(), false);
        }
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), qb.getEntityName(), qb.getSelectFields(), qFilters.toArray(new QFilter[0]), qb.isNeedResum() ? qb.getOrderBys() : null);
    }

    private Object[] getPksValue(List<ListField> pkFields, Row row) {
        ArrayList<Object> pkValues = new ArrayList<Object>();
        for (ListField field : pkFields) {
            String pk = field.getFieldName();
            Object pkObj = row.get(pk);
            if (this.pkValueIsNull(pkObj)) continue;
            pkValues.add(pkObj);
        }
        return pkValues.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Row> dataSetToRowList(DataSet ds) {
        try {
            ArrayList<Row> dsLs = new ArrayList<Row>();
            for (Row row : ds) {
                dsLs.add(RowUtil.persist((Row)row));
            }
            ArrayList<Row> arrayList = dsLs;
            return arrayList;
        }
        finally {
            ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> dataSetToRowList(String mapKeyPrfix, DataSet ds, QueryBuilder qb, boolean isNeedCache) {
        try {
            RowsResult rowsResult = this.getRowsResult(ds, qb);
            this.cacheSummaryResults(mapKeyPrfix, qb, isNeedCache, rowsResult);
            List<Row> list = rowsResult.getDealRows();
            return list;
        }
        finally {
            ds.close();
        }
    }

    protected RowsResult getRowsResult(DataSet ds, QueryBuilder qb) {
        VoucherRowsResultBuilder rowsResultBuilder = new VoucherRowsResultBuilder(qb);
        if (null != ds) {
            for (Row row : ds) {
                rowsResultBuilder.addRow(RowUtil.persist((Row)row));
            }
        }
        return rowsResultBuilder.build();
    }

    private void cacheSummaryResults(String mapKeyPrfix, QueryBuilder qb, boolean isNeedCache, RowsResult rowResult) {
        if (!qb.getSumFields().isEmpty()) {
            this.cacheSummaryResults = rowResult.getSummaryResults();
            if (isNeedCache && !qb.isNeedResum()) {
                this.idCacheMap.put(mapKeyPrfix + "BILLLIST_sumResults", QueryUtils.sRListToStr(rowResult.getSummaryResults()));
            }
        }
        if (isNeedCache && !qb.isNeedResum()) {
            this.idCacheMap.put(mapKeyPrfix + "BILLLIST_billDataCount", Integer.toString(rowResult.getBillDataCount()));
        }
    }

    private Row rowAddField(Row row, Object fieldValue, RowMeta newRowMeta) {
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return RowFactory.createRow((RowMeta)newRowMeta, (Object[])newValues);
    }

    private RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    private List<Row> getRowList(List<Row> rows, int begin, final int limit) {
        final Iterator<Row> iter = rows.iterator();
        for (int i = 0; i < begin && iter.hasNext(); ++i) {
            iter.next();
        }
        Iterator<Row> limitIter = new Iterator<Row>(){
            private int i = 0;

            @Override
            public Row next() {
                return (Row)iter.next();
            }

            @Override
            public boolean hasNext() {
                if (++this.i > limit) {
                    return false;
                }
                return iter.hasNext();
            }
        };
        ArrayList<Row> limitRows = new ArrayList<Row>();
        while (limitIter.hasNext()) {
            limitRows.add((Row)limitIter.next());
        }
        return limitRows;
    }

    protected void setQueryResult(DynamicObjectCollection collection, int dataCount, int billDataCount, QueryBuilder qb, List<SummaryResult> summaryResults) {
        QueryResult queryResult = this.getQueryResult();
        queryResult.setCollection(collection);
        queryResult.setDataCount(dataCount);
        queryResult.setBillDataCount(billDataCount);
        List decimalFields = qb.getDecimalFields();
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(decimalFields.size());
        for (ListField field : decimalFields) {
            FmtField fmtField = new FmtField(field.getSrcFieldProp(), field.getListFieldKey().replace('.', '_'), field.getControlField() != null ? field.getControlField().getFieldName() : "");
            fmtField.setControlFieldKey(field.getControlField() != null ? field.getControlField().getListFieldKey() : "");
            fmtFields.add(fmtField);
        }
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, collection);
        queryResult.setNumberFormatProvider(numberFormatProvider);
        if (!qb.getSumFields().isEmpty()) {
            for (SummaryResult summaryResult : summaryResults) {
                NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(summaryResult.getFieldName(), null);
                numberPrecision.setResult(summaryResult.getNumberPrecision().getResult());
                summaryResult.setNumberPrecision(numberPrecision);
            }
            queryResult.setSummaryResults(summaryResults);
        }
    }

    private String cacheData(QueryBuilder qb, List<Row> rows) {
        if (!qb.getSumFields().isEmpty()) {
            List pkFields = qb.getPkFields();
            int pkSize = pkFields.size();
            String seqField = qb.getSeqField();
            boolean seqIsEntity = StringUtils.isEmpty((CharSequence)seqField);
            String[] fieldNames = new String[pkSize];
            DataType[] dataTypes = new DataType[pkSize];
            for (int i = 0; i < pkSize; ++i) {
                fieldNames[i] = ((ListField)pkFields.get(i)).getFieldName();
                dataTypes[i] = ((ListField)pkFields.get(i)).getSrcFieldProp() instanceof LongProp ? DataType.LongType : DataType.StringType;
            }
            RowMeta idRowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
            ArrayList<Row> cacheRows = new ArrayList<Row>(rows.size());
            RowMeta newIdRowMeta = null;
            for (Row row : rows) {
                Object[] values = new Object[pkSize];
                for (int i = 0; i < pkSize; ++i) {
                    values[i] = row.get(((ListField)pkFields.get(i)).getFieldName());
                }
                Row idRow = RowFactory.createRow((RowMeta)idRowMeta, (Object[])values);
                if (newIdRowMeta == null) {
                    newIdRowMeta = this.rowMetaAddField(idRowMeta, seqField, (DataType)DataType.IntegerType);
                }
                if (!seqIsEntity) {
                    idRow = this.rowAddField(idRow, row.get(seqField), newIdRowMeta);
                }
                cacheRows.add(idRow);
            }
            RowMeta rowMeta = ((AbstractRow)cacheRows.get(0)).getRowMeta();
            return this.cacheRowList(cacheRows, rowMeta);
        }
        RowMeta rowMeta = ((AbstractRow)rows.get(0)).getRowMeta();
        return this.cacheRowList(rows, rowMeta);
    }

    private String cacheRowList(List<Row> rows, RowMeta rowMeta) {
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)1000).intValue());
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(rowMeta, cacheHint, ((Object)((Object)this)).getClass().getSimpleName() + ".cacheAlgo.rows");
        cacheBuilder.append(rows.iterator());
        CachedDataSet cds = cacheBuilder.build();
        return cds.getCacheId();
    }

    private boolean pkValueIsNull(Object pkValue) {
        return pkValue == null || "0".equals(String.valueOf(pkValue)) || String.valueOf(pkValue).length() == 0;
    }

    class IdRunner
    implements Runnable {
        private String cacheKey;
        private Map<String, String> map;
        private String preFixStr;
        private QueryBuilder qb;
        private List<Row> rows;
        private RequestContext rc;

        public IdRunner(String cacheKey, Map<String, String> map, String preFixStr, QueryBuilder qb, List<Row> rows, RequestContext rc) {
            this.preFixStr = preFixStr;
            this.cacheKey = cacheKey;
            this.map = map;
            this.qb = qb;
            this.rows = rows;
            this.rc = rc;
        }

        @Override
        public void run() {
            RequestContext.copyAndSet((RequestContext)this.rc);
            this.map.put(this.preFixStr + "BILLLIST_cacheState", "run");
            ics.cacheData(this.cacheKey, this.map);
            String cacheId = VoucherIdQuery.this.cacheData(this.qb, this.rows);
            this.map.put(this.preFixStr + "BILLLIST_cacheId", cacheId);
            this.map.put(this.preFixStr + "BILLLIST_cacheState", "end");
            ics.cacheData(this.cacheKey, this.map);
        }
    }
}

