/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.image.api.ImageService;
import kd.bos.image.enums.ImageQueryTypeEnum;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.service.ServiceFactory;

public class VoucherPrintImageNew
extends AbstractPrintPlugin {
    private static final Log log = LogFactory.getLog(VoucherPrintImageNew.class);

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        Object id = evt.getDataSource().getPkId();
        if (id == null) {
            return;
        }
        ArrayList<String> idsOrNumbers = new ArrayList<String>(1);
        idsOrNumbers.add(id.toString());
        Map<String, ImageInfo> imageInfoMap = VoucherPrintImageNew.batchGetImageInfo(idsOrNumbers);
        if (imageInfoMap == null) {
            return;
        }
        List customDataRows = evt.getCustomDataRows();
        for (Map.Entry<String, ImageInfo> entry : imageInfoMap.entrySet()) {
            DataRowSet dsRow = new DataRowSet();
            dsRow.put("imagenumber", (Field)new TextField(entry.getValue().getImageNo()));
            customDataRows.add(dsRow);
        }
    }

    private static Map<String, ImageInfo> batchGetImageInfo(List<String> ids) {
        Map imageInfos = (Map)ThreadCache.get((Object)"voucher_print_Image_cachekey");
        if (imageInfos == null || imageInfos.size() == 0) {
            ImageService service = (ImageService)ServiceFactory.getService(ImageService.class);
            imageInfos = service.getImageInfoInsideBatch(ids, ImageQueryTypeEnum.BillId.getField());
            ThreadCache.put((Object)"voucher_print_Image_cachekey", (Object)imageInfos);
        } else if (!imageInfos.containsKey(ids.get(0))) {
            ImageService service = (ImageService)ServiceFactory.getService(ImageService.class);
            Map imageInfoMap = service.getImageInfoInsideBatch(ids, ImageQueryTypeEnum.BillId.getField());
            imageInfos.putAll(imageInfoMap);
        }
        return imageInfos;
    }
}

