/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculateService;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;
import kd.fi.gl.formplugin.voucher.valuechange.events.UpdateRowEventArgs;

public class BackCalculateServiceImpl
implements IBackCalculateService {
    private final CopyOnWriteArrayList<IBackCalculator> allCalculators = new CopyOnWriteArrayList();

    @Override
    public void register(IBackCalculator ... calculators) {
        if (calculators == null) {
            return;
        }
        this.allCalculators.addAll(Arrays.asList(calculators));
    }

    private Collection<IBackCalculator> get(String propKey) {
        return (Collection)ThreadCache.get((Object)("BackCalculateServiceImpl#get_" + propKey), () -> this.allCalculators.stream().filter(x -> x.applicable(propKey)).collect(Collectors.toList()));
    }

    @Override
    public void backCalc(UpdateRowEventArgs args) {
        Collection<IBackCalculator> calculators = this.get(args.getPropKey());
        if (CollectionUtils.isEmpty(calculators)) {
            return;
        }
        if (this.isIgnore(args.getRowIndex(), args.getPropKey())) {
            return;
        }
        this.setIgnore(args.getRowIndex(), args.getPropKey());
        BackCalculateChangedValue changedValue = new BackCalculateChangedValue(args);
        for (IBackCalculator calculator : calculators) {
            if (!calculator.applicable(args.getPropKey())) continue;
            this.doBackCalculate(changedValue, calculator);
        }
    }

    private void doBackCalculate(BackCalculateChangedValue changedValue, IBackCalculator backCalculator) {
        String group;
        String propKey;
        int rowIndex = changedValue.getRowIndex();
        if (this.isIgnore(rowIndex, propKey = changedValue.getPropKey(), group = backCalculator.group())) {
            return;
        }
        this.setIgnore(rowIndex, propKey, group);
        if (backCalculator.isIgnoreEmptyValue() && changedValue.isEmptyChangedValue()) {
            return;
        }
        Optional<BackCalculateResult> result = backCalculator.backCalculate(changedValue);
        result.ifPresent(x -> this.setValue(changedValue, group, (BackCalculateResult)x));
    }

    private void setValue(BackCalculateChangedValue changedValue, String group, BackCalculateResult result) {
        int rowIndex = changedValue.getRowIndex();
        this.setIgnore(rowIndex, result.getPropKey(), group);
        BigDecimal originalValue = changedValue.getVoucherEditView().getValueGetter().getEntryBigDecimalValue(result.getPropKey(), rowIndex);
        if (originalValue.compareTo(result.getValue()) != 0) {
            changedValue.getVoucherEditView().getVoucherEditModel().setValue(result.getPropKey(), (Object)result.getValue(), rowIndex);
        }
        if (!result.getResults().isEmpty()) {
            for (BackCalculateResult subResult : result.getResults()) {
                this.setValue(changedValue, group, subResult);
            }
        }
    }

    @Override
    public void setIgnore(int rowIndex, String field) {
        ThreadCache.put((Object)(this.getClass().getName() + "#ignore_" + String.join((CharSequence)"_", String.valueOf(rowIndex), field)), (Object)true);
    }

    @Override
    public void setIgnore(int rowIndex, String field, String group) {
        ThreadCache.put((Object)(this.getClass().getName() + "#ignore_group_" + String.join((CharSequence)"_", String.valueOf(rowIndex), field, group)), (Object)true);
    }

    @Override
    public boolean isIgnore(int rowIndex, String field) {
        return (Boolean)ThreadCache.get((Object)(this.getClass().getName() + "#ignore_" + String.join((CharSequence)"_", String.valueOf(rowIndex), field)), () -> false);
    }

    @Override
    public boolean isIgnore(int rowIndex, String field, String group) {
        return (Boolean)ThreadCache.get((Object)(this.getClass().getName() + "#ignore_group_" + String.join((CharSequence)"_", String.valueOf(rowIndex), field, group)), () -> false);
    }
}

