/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculatorGroup;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;
import kd.fi.gl.formplugin.voucher.backcalculate.impl.LocalAmountChanged;

public class ExchangeRateChanged
implements IBackCalculator {
    @Override
    public String group() {
        return BackCalculatorGroup.ORI_AMT_RATE_LOC_AMT.name();
    }

    @Override
    public String[] applicableChangedFields() {
        return new String[]{"localrate"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculate(BackCalculateChangedValue changedValue) {
        VoucherEditView voucherEditView = changedValue.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int rowIndex = changedValue.getRowIndex();
        BigDecimal originalAmount = valueGetter.getOriginalAmount(rowIndex);
        BigDecimal localAmount = valueGetter.getLocalAmount(rowIndex);
        BigDecimal exchangeRate = changedValue.getValue();
        if (originalAmount.signum() != 0) {
            return LocalAmountChanged.calculateLocalAmount(voucherEditView, rowIndex, originalAmount, exchangeRate);
        }
        if (localAmount.signum() != 0) {
            return LocalAmountChanged.calculateOriginalAmount(voucherEditView, rowIndex, localAmount, exchangeRate);
        }
        return Optional.empty();
    }
}

