/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.voucher.QtyPriceReCalRuleEnum;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculatorGroup;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;

public class OriginalAmountChangedInQPA
implements IBackCalculator {
    @Override
    public String group() {
        return BackCalculatorGroup.QUANTITY_PRICE_AMOUNT.name();
    }

    @Override
    public String[] applicableChangedFields() {
        return new String[]{"oriamount"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculate(BackCalculateChangedValue changedValue) {
        VoucherEditView voucherEditView = changedValue.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int rowIndex = changedValue.getRowIndex();
        BigDecimal quantity = valueGetter.getQuantity(rowIndex);
        BigDecimal price = valueGetter.getPrice(rowIndex);
        QtyPriceReCalRuleEnum backCalculateRule = null;
        if (quantity.signum() != 0 && price.signum() != 0) {
            backCalculateRule = VoucherEditArgHelper.getQtyPriceReCalRule((long)valueGetter.getOrgId());
        }
        if (backCalculateRule == null || backCalculateRule == QtyPriceReCalRuleEnum.NO_RE_CAL) {
            if (quantity.signum() != 0 && price.signum() == 0) {
                backCalculateRule = QtyPriceReCalRuleEnum.RE_CAL_PRICE;
            } else if (quantity.signum() == 0 && price.signum() != 0) {
                backCalculateRule = QtyPriceReCalRuleEnum.RE_CAL_QTY;
            }
        }
        if (backCalculateRule == null) {
            return Optional.empty();
        }
        BigDecimal originalAmount = changedValue.getValue();
        switch (backCalculateRule) {
            case RE_CAL_PRICE: {
                return OriginalAmountChangedInQPA.calculatePrice(voucherEditView, rowIndex, originalAmount, quantity);
            }
            case RE_CAL_QTY: {
                return OriginalAmountChangedInQPA.calculateQuantity(voucherEditView, rowIndex, originalAmount, price);
            }
        }
        return Optional.empty();
    }

    public static Optional<BackCalculateResult> calculateQuantity(VoucherEditView voucherEditView, int rowIndex, BigDecimal originalAmount, BigDecimal price) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        Tuple<Integer, RoundingMode> quantityPrecision = valueGetter.getQuantityPrecision(rowIndex);
        BigDecimal quantity = originalAmount.divide(price, (int)((Integer)quantityPrecision.item1), (RoundingMode)((Object)quantityPrecision.item2));
        return Optional.of(new BackCalculateResult("quantity", quantity));
    }

    public static Optional<BackCalculateResult> calculatePrice(VoucherEditView voucherEditView, int rowIndex, BigDecimal originalAmount, BigDecimal quantity) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        BigDecimal price = originalAmount.divide(quantity, valueGetter.getCurrencyPricePrecision(rowIndex), RoundingMode.HALF_UP);
        return Optional.of(new BackCalculateResult("price", price));
    }

    public static Optional<BackCalculateResult> calculateOriginalAmount(VoucherEditView voucherEditView, int rowIndex, BigDecimal quantity, BigDecimal price) {
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        BigDecimal originalAmount = quantity.multiply(price).setScale(valueGetter.getCurrencyAmountPrecision(rowIndex), RoundingMode.HALF_UP);
        return Optional.of(new BackCalculateResult("oriamount", originalAmount));
    }
}

