/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculatorGroup;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;
import kd.fi.gl.formplugin.voucher.backcalculate.impl.OriginalAmountChangedInQPA;

public class PriceChangedInQPA
implements IBackCalculator {
    @Override
    public String group() {
        return BackCalculatorGroup.QUANTITY_PRICE_AMOUNT.name();
    }

    @Override
    public String[] applicableChangedFields() {
        return new String[]{"price"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculate(BackCalculateChangedValue changedValue) {
        VoucherEditView voucherEditView = changedValue.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int rowIndex = changedValue.getRowIndex();
        BigDecimal originalAmount = valueGetter.getOriginalAmount(rowIndex);
        BigDecimal quantity = valueGetter.getQuantity(rowIndex);
        BigDecimal price = changedValue.getValue();
        if (quantity.signum() != 0) {
            return OriginalAmountChangedInQPA.calculateOriginalAmount(voucherEditView, rowIndex, quantity, price);
        }
        if (originalAmount.signum() != 0) {
            return OriginalAmountChangedInQPA.calculateQuantity(voucherEditView, rowIndex, originalAmount, price);
        }
        return Optional.empty();
    }
}

