/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.backcalculate.impl;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculatorGroup;
import kd.fi.gl.formplugin.voucher.backcalculate.IBackCalculator;
import kd.fi.gl.formplugin.voucher.backcalculate.impl.OriginalAmountChangedInQPA;

public class QuantityChangedInQPA
implements IBackCalculator {
    @Override
    public String group() {
        return BackCalculatorGroup.QUANTITY_PRICE_AMOUNT.name();
    }

    @Override
    public String[] applicableChangedFields() {
        return new String[]{"quantity"};
    }

    @Override
    public Optional<BackCalculateResult> backCalculate(BackCalculateChangedValue changedValue) {
        VoucherEditView voucherEditView = changedValue.getVoucherEditView();
        VoucherEditValueGetter valueGetter = voucherEditView.getValueGetter();
        int rowIndex = changedValue.getRowIndex();
        BigDecimal originalAmount = valueGetter.getOriginalAmount(rowIndex);
        BigDecimal price = valueGetter.getPrice(rowIndex);
        BigDecimal quantity = changedValue.getValue();
        if (price.signum() != 0) {
            return OriginalAmountChangedInQPA.calculateOriginalAmount(voucherEditView, rowIndex, quantity, price);
        }
        if (originalAmount.signum() != 0) {
            return OriginalAmountChangedInQPA.calculatePrice(voucherEditView, rowIndex, originalAmount, quantity);
        }
        return Optional.empty();
    }
}

