/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.cashflow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.formplugin.voucher.cashflow.ICashflowInfo;
import kd.fi.gl.formplugin.voucher.cashflow.Result;
import kd.fi.gl.util.GLUtil;

public class DataSetRowCalculator
implements ICashflowInfo {
    private static final String[] fields = new String[]{"id", "isbank", "iscash", "iscashequivalent", "accounttype", "pltype"};

    @Override
    public Result calCfInfo(DynamicObject voucher, boolean localSet) {
        BigDecimal cashtotalamt = BigDecimal.ZERO;
        BigDecimal pltotalamt = BigDecimal.ZERO;
        BigDecimal cashtotalused = BigDecimal.ZERO;
        BigDecimal pltotalused = BigDecimal.ZERO;
        int cashCount = 0;
        int plCount = 0;
        int nnCount = 0;
        boolean hasSupp = false;
        HashMap<Long, Boolean> plAcctMap = new HashMap<Long, Boolean>();
        Map<Object, DynamicObject> cfMap = this.loadCashflow(voucher.getLong("org_id"));
        long accttableid = 0L;
        for (DynamicObject obj : voucher.getDynamicObjectCollection("entries")) {
            if (obj.getDynamicObject("account") == null) continue;
            accttableid = obj.getDynamicObject("account").getLong("accounttable_id");
            break;
        }
        Map<Long, DynamicObject> acctMap = this.loadAccount(voucher.getLong("org_id"), accttableid);
        long id = voucher.getLong("id");
        HintCondition hintId = new HintCondition("fid", "=", (Object)id);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintId}).prepareShardingIndex();){
            DataSet dataSet = VoucherQueryUtils.queryDataSet((String)"entries.account,entries.maincfitem,entries.maincfamount,entries.suppcfitem,entries.suppcfamount,entries.debitlocal,entries.creditlocal", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, null, (int)-1);
            for (Row row : dataSet) {
                boolean isPLAcct;
                long maincfId;
                long acctId = row.getLong("entries.account");
                if (acctId == 0L) {
                    long mainCFId = row.getLong("entries.maincfitem");
                    if (mainCFId == 0L) continue;
                    DynamicObject mainCF = this.getCashflow(cfMap, mainCFId);
                    BigDecimal mainCfamt = row.getBigDecimal("entries.maincfamount");
                    if ("o".equals(mainCF.getString("direction"))) {
                        cashtotalused = cashtotalused.subtract(mainCfamt);
                        continue;
                    }
                    cashtotalused = cashtotalused.add(mainCfamt);
                    continue;
                }
                DynamicObject acct = this.getAccount(acctMap, acctId);
                if (AccountType.isBudgetType((long)acct.getLong("accounttype"))) continue;
                if (GLUtil.isCashAcct((DynamicObject)acct)) {
                    ++cashCount;
                    BigDecimal drLoc = row.getBigDecimal("entries.debitlocal");
                    BigDecimal crLoc = row.getBigDecimal("entries.creditlocal");
                    cashtotalamt = cashtotalamt.add(drLoc).subtract(crLoc);
                    if (!localSet) continue;
                }
                if ((maincfId = row.getLong("entries.maincfitem").longValue()) != 0L) {
                    DynamicObject mainCF = this.getCashflow(cfMap, row.getLong("entries.maincfitem"));
                    BigDecimal mainCfamt = row.getBigDecimal("entries.maincfamount");
                    cashtotalused = "o".equals(mainCF.getString("direction")) ? cashtotalused.subtract(mainCfamt) : cashtotalused.add(mainCfamt);
                }
                BigDecimal suppCfamt = row.getBigDecimal("entries.suppcfamount");
                pltotalused = pltotalused.add(suppCfamt);
                if (plAcctMap.get(acctId) == null) {
                    isPLAcct = DataSetRowCalculator.isPLAcct(acct);
                    plAcctMap.put(acctId, isPLAcct);
                } else {
                    isPLAcct = (Boolean)plAcctMap.get(acctId);
                }
                if (!hasSupp && row.getLong("entries.suppcfitem") > 0L) {
                    hasSupp = true;
                }
                if (isPLAcct) {
                    ++plCount;
                    BigDecimal drLoc = row.getBigDecimal("entries.debitlocal");
                    BigDecimal crLoc = row.getBigDecimal("entries.creditlocal");
                    pltotalamt = pltotalamt.add(drLoc).subtract(crLoc);
                }
                if (GLUtil.isCashAcct((DynamicObject)acct) || isPLAcct) continue;
                ++nnCount;
            }
        }
        Result result = new Result();
        result.setCashCount(cashCount);
        result.setPlCount(plCount);
        result.setNnCount(nnCount);
        result.setCashtotalamt(cashtotalamt);
        result.setPltotalamt(pltotalamt);
        result.setCashtotalused(cashtotalused);
        result.setPltotalused(pltotalused);
        result.setHasSupp(hasSupp);
        return result;
    }

    private DynamicObject getCashflow(Map<Object, DynamicObject> cfMap, long cfId) {
        DynamicObject mainCF = cfMap.get(cfId);
        if (mainCF == null) {
            mainCF = BusinessDataServiceHelper.loadSingleFromCache((Object)cfId, (String)"gl_cashflowitem", (String)"direction");
            cfMap.put(cfId, mainCF);
        }
        return mainCF;
    }

    public static boolean isPLAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        return !"0".equals(acct.getString("pltype"));
    }

    private Map<Object, DynamicObject> loadCashflow(long orgId) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"direction", (QFilter[])new QFilter[]{filter});
        return map;
    }

    private DynamicObject getAccount(Map<Long, DynamicObject> acctMap, long acctId) {
        DynamicObject mainCF = acctMap.get(acctId);
        if (mainCF == null) {
            QFilter fid = new QFilter("id", "=", (Object)acctId);
            mainCF = QueryServiceHelper.queryOne((String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{fid});
            acctMap.put(acctId, mainCF);
        }
        return mainCF;
    }

    private Map<Long, DynamicObject> loadAccount(long orgId, long accttableId) {
        Map map = AccountUtils.loadAccounts((long)orgId, (long)accttableId, (boolean)true, new ArrayList(2), (String[])fields);
        return map;
    }
}

