/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.ipt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ThreadLocals;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportBookInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportDataCollection;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportPeriodInfo;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class VoucherImportContext {
    private static final ThreadLocal<VoucherImportContext> CONTEXT = ThreadLocals.create();
    private static final String ACCOUNT_TYPE = "accounttype";
    private Set<String> curBatchOrgNumberSet;
    private Set<Long> curBatchOrgIdSet;
    private Set<String> curBatchBookTypeNumSet;
    private Set<Long> curBatchBookTypeIdSet;
    private Set<String> curBatchPeriodNumberSet;
    private Map<String, Long> orgNumberIdMap;
    private Map<String, Long> bookTypeNumberIdMap;
    private Tuple<String, Long> mainBookType;
    private Map<Long, Map<Long, VoucherImportBookInfo>> bookInfoMap;
    private Map<Long, Date> periodIdEndDateMap;
    private Map<String, Map<Long, VoucherImportPeriodInfo>> periodNumberTypeInfoMap;
    private Map<Long, List<VoucherImportPeriodInfo>> periodTypePeriodInfoMap;
    private Map<Long, Map<Long, Set<Long>>> openedPeriodIdMap;
    private Date maxDate;
    private Date minDate;

    protected static VoucherImportContext getOrCreate() {
        VoucherImportContext voucherImportContext = VoucherImportContext.get();
        if (voucherImportContext == null) {
            voucherImportContext = VoucherImportContext.create(Boolean.TRUE);
        }
        return voucherImportContext;
    }

    protected static VoucherImportContext create(boolean isSet) {
        VoucherImportContext voucherImportContext = new VoucherImportContext();
        if (isSet) {
            VoucherImportContext.set(voucherImportContext);
        }
        return voucherImportContext;
    }

    protected static VoucherImportContext get() {
        return CONTEXT.get();
    }

    protected static void set(VoucherImportContext voucherImportContext) {
        CONTEXT.set(voucherImportContext);
    }

    protected static void remove() {
        CONTEXT.remove();
    }

    protected Map<String, Long> getOrgNumberIdMap() {
        return this.orgNumberIdMap;
    }

    protected Map<String, Long> getBookTypeNumberIdMap() {
        return this.bookTypeNumberIdMap;
    }

    protected Tuple<String, Long> getMainBookType() {
        return this.mainBookType;
    }

    protected Map<Long, Map<Long, VoucherImportBookInfo>> getBookInfoMap() {
        return this.bookInfoMap;
    }

    protected Map<Long, Date> getPeriodIdEndDateMap() {
        return this.periodIdEndDateMap;
    }

    protected Map<String, Map<Long, VoucherImportPeriodInfo>> getPeriodNumberTypeInfoMap() {
        return this.periodNumberTypeInfoMap;
    }

    protected Map<Long, List<VoucherImportPeriodInfo>> getPeriodTypePeriodInfoMap() {
        return this.periodTypePeriodInfoMap;
    }

    protected Map<Long, Map<Long, Set<Long>>> getOpenedPeriodIdMap() {
        return this.openedPeriodIdMap;
    }

    protected void init(VoucherImportDataCollection voucherImportDataCollection) {
        this.initCurBatchSet(voucherImportDataCollection);
        this.initOrgNumberIdMap();
        this.initBookTypeNumberIdMap();
        this.initBookInfoMap();
        this.initPeriodNumberTypeIdMap();
        this.initOpenedPeriodMap();
        this.initPeriodTypePeriodInfoMap(voucherImportDataCollection.getMinDate(), voucherImportDataCollection.getMaxDate());
    }

    private void initCurBatchSet(VoucherImportDataCollection voucherImportDataCollection) {
        this.curBatchOrgNumberSet = new HashSet<String>(voucherImportDataCollection.getOrgNumberSet());
        this.curBatchBookTypeNumSet = new HashSet<String>(voucherImportDataCollection.getBookTypeNumberSet());
        this.curBatchPeriodNumberSet = new HashSet<String>(voucherImportDataCollection.getPeriodNumberSet());
        this.curBatchOrgIdSet = new HashSet<Long>(this.curBatchOrgNumberSet.size());
        this.curBatchBookTypeIdSet = new HashSet<Long>(this.curBatchBookTypeNumSet.size());
    }

    private void initOrgNumberIdMap() {
        if (this.orgNumberIdMap == null) {
            this.orgNumberIdMap = new HashMap<String, Long>(this.curBatchOrgNumberSet.size());
        }
        Set filterNumberSet = this.curBatchOrgNumberSet.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        filterNumberSet.removeAll(this.orgNumberIdMap.keySet());
        if (!filterNumberSet.isEmpty()) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("number", "in", filterNumberSet);
            List hasPermOrgIdList = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)Boolean.FALSE, (PermissonType)PermissonType.VIEW);
            qfBuilder.add("id", "in", (Object)hasPermOrgIdList);
            Collection orgDyns = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])qfBuilder.toArray()).values();
            for (DynamicObject orgDyn : orgDyns) {
                Long orgId = orgDyn.getLong("id");
                this.orgNumberIdMap.put(orgDyn.getString("number"), orgId);
            }
        }
        this.curBatchOrgIdSet = this.curBatchOrgNumberSet.stream().map(x -> this.orgNumberIdMap.get(x)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void initBookTypeNumberIdMap() {
        QFBuilder qfBuilder;
        if (this.bookTypeNumberIdMap == null) {
            this.bookTypeNumberIdMap = new HashMap<String, Long>(this.curBatchBookTypeNumSet.size());
        }
        Set filterNumberSet = this.curBatchBookTypeNumSet.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        filterNumberSet.removeAll(this.bookTypeNumberIdMap.keySet());
        if (!filterNumberSet.isEmpty()) {
            qfBuilder = new QFBuilder();
            qfBuilder.add("number", "in", filterNumberSet);
            Collection bookTypeDyns = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbookstype", (String)String.join((CharSequence)",", "id", "number", ACCOUNT_TYPE), (QFilter[])qfBuilder.toArray()).values();
            for (DynamicObject bookTypeDyn : bookTypeDyns) {
                Long bookTypeId = bookTypeDyn.getLong("id");
                String bookTypeNum = bookTypeDyn.getString("number");
                this.bookTypeNumberIdMap.put(bookTypeNum, bookTypeId);
                if (!AccountBooksType.MAIN_BOOK.getValue().equals(bookTypeDyn.getString(ACCOUNT_TYPE))) continue;
                this.mainBookType = Tuple.create((Object)bookTypeNum, (Object)bookTypeId);
            }
        }
        if (this.mainBookType == null) {
            qfBuilder = new QFBuilder();
            qfBuilder.add(ACCOUNT_TYPE, "=", (Object)AccountBooksType.MAIN_BOOK.getValue());
            DynamicObject bookTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])qfBuilder.toArray());
            if (bookTypeDyn != null) {
                Long bookTypeId = bookTypeDyn.getLong("id");
                String bookTypeNum = bookTypeDyn.getString("number");
                this.mainBookType = Tuple.create((Object)bookTypeNum, (Object)bookTypeId);
            }
        }
        if (null != this.mainBookType) {
            this.curBatchBookTypeNumSet.add((String)this.mainBookType.item1);
            this.bookTypeNumberIdMap.put((String)this.mainBookType.item1, (Long)this.mainBookType.item2);
        }
        this.curBatchBookTypeIdSet = this.curBatchBookTypeNumSet.stream().map(x -> this.bookTypeNumberIdMap.get(x)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void initBookInfoMap() {
        if (this.bookInfoMap == null) {
            this.bookInfoMap = new HashMap<Long, Map<Long, VoucherImportBookInfo>>(this.orgNumberIdMap.size());
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "in", this.curBatchOrgIdSet);
        qfBuilder.add("bookstype", "in", this.curBatchBookTypeIdSet);
        qfBuilder.add("isbizunit", "=", (Object)Boolean.TRUE);
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        Map bookDynMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)String.join((CharSequence)",", "id", "org.id", "bookstype.id", "periodtype.id", "curperiod.id", "basecurrency.id", "basecurrency.number"), (QFilter[])qfBuilder.toArray());
        Collection bookDyns = bookDynMap.values();
        for (DynamicObject bookDyn : bookDyns) {
            long orgId = bookDyn.getLong("org.id");
            long bookTypeId = bookDyn.getLong("bookstype.id");
            Map bookTypeBookInfoMap = this.bookInfoMap.computeIfAbsent(orgId, k -> new HashMap(16));
            if (bookTypeBookInfoMap.containsKey(bookTypeId)) continue;
            long periodTypeId = bookDyn.getLong("periodtype.id");
            long curPeriodId = bookDyn.getLong("curperiod.id");
            long baseCurId = bookDyn.getLong("basecurrency.id");
            String baseCurNum = bookDyn.getString("basecurrency.number");
            bookTypeBookInfoMap.put(bookTypeId, new VoucherImportBookInfo(bookDyn.getLong("id"), orgId, bookTypeId, periodTypeId, curPeriodId, baseCurId, baseCurNum));
        }
    }

    private void initPeriodNumberTypeIdMap() {
        if (this.periodNumberTypeInfoMap == null) {
            this.periodNumberTypeInfoMap = new HashMap<String, Map<Long, VoucherImportPeriodInfo>>(this.curBatchPeriodNumberSet.size());
        }
        if (this.periodIdEndDateMap == null) {
            this.periodIdEndDateMap = new HashMap<Long, Date>(this.curBatchPeriodNumberSet.size());
        }
        Set filterNumberSet = this.curBatchPeriodNumberSet.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        filterNumberSet.removeAll(this.periodNumberTypeInfoMap.keySet());
        if (!filterNumberSet.isEmpty()) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("number", "in", filterNumberSet);
            Collection periodDyns = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)String.join((CharSequence)",", "number", "id", "begindate", "enddate", "periodtype.id"), (QFilter[])qfBuilder.toArray()).values();
            for (DynamicObject periodDyn : periodDyns) {
                long periodTypeId = periodDyn.getLong("periodtype.id");
                String periodNumber = periodDyn.getString("number");
                long id = periodDyn.getLong("id");
                Date endDate = periodDyn.getDate("enddate");
                Map periodTypeInfoMap = this.periodNumberTypeInfoMap.computeIfAbsent(periodNumber, k -> new HashMap(16));
                periodTypeInfoMap.put(periodTypeId, new VoucherImportPeriodInfo(id, periodTypeId, periodNumber, periodDyn.getDate("begindate"), endDate));
                this.periodIdEndDateMap.put(id, endDate);
            }
        }
    }

    private void initOpenedPeriodMap() {
        if (this.openedPeriodIdMap == null) {
            this.openedPeriodIdMap = new HashMap<Long, Map<Long, Set<Long>>>(this.bookInfoMap.size());
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "in", this.curBatchOrgIdSet);
        qfBuilder.add("booktype", "in", this.curBatchBookTypeIdSet);
        Map openPeriodDynMap = BusinessDataServiceHelper.loadFromCache((String)"gl_openedperiod", (String)String.join((CharSequence)",", "org.id", "booktype.id", "period.id"), (QFilter[])qfBuilder.toArray());
        Collection openPeriodDyns = openPeriodDynMap.values();
        for (DynamicObject openPeriodDyn : openPeriodDyns) {
            this.openedPeriodIdMap.compute(openPeriodDyn.getLong("org.id"), (k, v) -> {
                if (v == null) {
                    v = new HashMap<Long, Set>(16);
                }
                Set periodIds = v.computeIfAbsent(openPeriodDyn.getLong("booktype.id"), bookTypeId -> new HashSet(16));
                periodIds.add(openPeriodDyn.getLong("period.id"));
                return v;
            });
        }
    }

    private void initPeriodTypePeriodInfoMap(Date minDate, Date maxDate) {
        if (this.periodTypePeriodInfoMap == null) {
            this.periodTypePeriodInfoMap = new HashMap<Long, List<VoucherImportPeriodInfo>>(16);
        }
        if (minDate == null || maxDate == null) {
            return;
        }
        boolean update = true;
        if (this.maxDate == null || this.minDate == null) {
            this.maxDate = maxDate;
            this.minDate = minDate;
        }
        if (this.maxDate.compareTo(maxDate) > 0 && this.minDate.compareTo(minDate) < 0) {
            update = false;
        }
        if (update) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("enddate", ">=", (Object)minDate);
            qfBuilder.add("begindate", "<=", (Object)maxDate);
            try (DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)String.join((CharSequence)",", "number", "id", "begindate", "enddate", "periodtype"), (QFilter[])qfBuilder.toArray(), (String)"id");){
                for (Row row : periodDataSet) {
                    Long periodTypeId = row.getLong("periodtype");
                    String periodNumber = row.getString("number");
                    Long id = row.getLong("id");
                    Date endDate = row.getDate("enddate");
                    this.periodTypePeriodInfoMap.compute(periodTypeId, (k, v) -> {
                        if (null == v) {
                            v = new ArrayList<VoucherImportPeriodInfo>();
                        }
                        v.add(new VoucherImportPeriodInfo(id, periodTypeId, periodNumber, row.getDate("begindate"), endDate));
                        return v;
                    });
                    this.periodIdEndDateMap.put(id, endDate);
                }
            }
        }
    }
}

