/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.ipt;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportInfo;

public class VoucherImportDataCollection
extends ArrayList<VoucherImportInfo> {
    private final Set<String> orgNumberSet;
    private final Set<String> bookTypeNumberSet;
    private final Set<String> periodNumberSet;
    private Date minDate;
    private Date maxDate;
    private final Table<String, String, Set<String>> flex_org_baseDataNums;

    protected VoucherImportDataCollection(int size) {
        super(size);
        this.orgNumberSet = new HashSet<String>(size);
        this.bookTypeNumberSet = new HashSet<String>(size);
        this.periodNumberSet = new HashSet<String>(size);
        this.flex_org_baseDataNums = HashBasedTable.create();
    }

    public VoucherImportDataCollection(List<Map<String, Object>> sourceDataList) {
        this(sourceDataList.size());
        for (Map<String, Object> sourceDataInfoMap : sourceDataList) {
            VoucherImportInfo voucherImportInfo = new VoucherImportInfo(sourceDataInfoMap);
            this.add(voucherImportInfo);
        }
    }

    @Override
    public final boolean add(VoucherImportInfo voucherImportInfo) {
        boolean add = super.add(voucherImportInfo);
        if (add) {
            this.orgNumberSet.add(voucherImportInfo.getOrgNumber());
            this.bookTypeNumberSet.add(voucherImportInfo.getBookTypeNumber());
            this.periodNumberSet.add(voucherImportInfo.getPeriodNumber());
            Date bookedDate = voucherImportInfo.getBookedDate();
            if (this.minDate == null || bookedDate != null && this.minDate.compareTo(bookedDate) > 0) {
                this.minDate = bookedDate;
            }
            if (this.maxDate == null || bookedDate != null && this.maxDate.compareTo(bookedDate) < 0) {
                this.maxDate = bookedDate;
            }
            Map<String, Set<String>> flexFieldBaseDataNumsMap = voucherImportInfo.getVoucherImportEntryInfoCollection().getFlexFieldBaseDataNumsMap();
            for (Map.Entry<String, Set<String>> entry : flexFieldBaseDataNumsMap.entrySet()) {
                HashSet baseDataNums = (HashSet)this.flex_org_baseDataNums.get((Object)entry.getKey(), (Object)voucherImportInfo.getOrgNumber());
                if (baseDataNums == null) {
                    baseDataNums = new HashSet(entry.getValue());
                } else {
                    baseDataNums.addAll(entry.getValue());
                }
                this.flex_org_baseDataNums.put((Object)entry.getKey(), (Object)voucherImportInfo.getOrgNumber(), baseDataNums);
            }
        }
        return add;
    }

    protected List<Map<String, Object>> getSourceDataList() {
        return this.stream().map(VoucherImportInfo::getSourceDataInfoMap).collect(Collectors.toList());
    }

    protected Set<String> getOrgNumberSet() {
        return this.orgNumberSet;
    }

    protected Set<String> getBookTypeNumberSet() {
        return this.bookTypeNumberSet;
    }

    protected Set<String> getPeriodNumberSet() {
        return this.periodNumberSet;
    }

    protected Date getMinDate() {
        return this.minDate;
    }

    protected Date getMaxDate() {
        return this.maxDate;
    }

    protected Table<String, String, Set<String>> getFlex_org_baseDataNums() {
        return this.flex_org_baseDataNums;
    }
}

