/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.ipt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportAccountInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportEntryInfo;
import org.apache.commons.collections4.MapUtils;

public class VoucherImportEntryInfoCollection
extends ArrayList<VoucherImportEntryInfo> {
    private final Set<String> accountNumberSet;
    private final Set<String> mainCFItemNumberSet;
    private final Map<String, Set<String>> flexFieldBaseDataNumsMap;

    protected VoucherImportEntryInfoCollection(List<Map<String, Object>> entryInfoMapList) {
        super(entryInfoMapList.size());
        this.accountNumberSet = new HashSet<String>(entryInfoMapList.size());
        this.flexFieldBaseDataNumsMap = new HashMap<String, Set<String>>(entryInfoMapList.size());
        this.mainCFItemNumberSet = new HashSet<String>(entryInfoMapList.size());
        for (Map<String, Object> entryInfoMap : entryInfoMapList) {
            VoucherImportEntryInfo voucherImportEntryInfo = new VoucherImportEntryInfo(entryInfoMap);
            this.add(voucherImportEntryInfo);
        }
    }

    @Override
    public final boolean add(VoucherImportEntryInfo voucherImportEntryInfo) {
        boolean add = super.add(voucherImportEntryInfo);
        if (add) {
            this.accountNumberSet.add(voucherImportEntryInfo.getAccountNumber());
            Map<String, Object> assgrpInfo = voucherImportEntryInfo.getAssgrp().getFlexFieldValueMap();
            if (StringUtils.isNotBlank((CharSequence)voucherImportEntryInfo.getMainCFItemNumber())) {
                this.mainCFItemNumberSet.add(voucherImportEntryInfo.getMainCFItemNumber());
            }
            if (assgrpInfo != null) {
                for (Map.Entry<String, Object> assgrpEntry : assgrpInfo.entrySet()) {
                    Map valueMap;
                    Object numberValue;
                    Object value = assgrpEntry.getValue();
                    if (!(value instanceof Map) || !((numberValue = (valueMap = (Map)value).get("number")) instanceof String)) continue;
                    Set baseDataNums = this.flexFieldBaseDataNumsMap.computeIfAbsent(assgrpEntry.getKey(), k -> new HashSet(16));
                    baseDataNums.add((String)numberValue);
                }
            }
        }
        return add;
    }

    protected void setAccountInfo(Map<String, VoucherImportAccountInfo> accountNumberInfoMap) {
        if (accountNumberInfoMap == null || accountNumberInfoMap.isEmpty()) {
            for (VoucherImportEntryInfo voucherImportEntryInfo : this) {
                voucherImportEntryInfo.setAccountInfo(VoucherImportAccountInfo.EMPTY);
            }
        } else {
            for (VoucherImportEntryInfo voucherImportEntryInfo : this) {
                String accountNumber = voucherImportEntryInfo.getAccountNumber();
                voucherImportEntryInfo.setAccountInfo(accountNumberInfoMap.getOrDefault(accountNumber, VoucherImportAccountInfo.EMPTY));
            }
        }
    }

    protected void setMainCFItemId(Map<String, CashFlowItemVO> mainCFItemNumberIdMap) {
        if (this.mainCFItemNumberSet.isEmpty()) {
            return;
        }
        if (MapUtils.isEmpty(mainCFItemNumberIdMap)) {
            for (VoucherImportEntryInfo voucherImportEntryInfo : this) {
                voucherImportEntryInfo.setMainCFItemId(0L);
            }
        } else {
            for (VoucherImportEntryInfo voucherImportEntryInfo : this) {
                String mainCFItemNumber = voucherImportEntryInfo.getMainCFItemNumber();
                if (StringUtils.isBlank((CharSequence)mainCFItemNumber)) continue;
                Long mainCFItemId = Optional.ofNullable(mainCFItemNumberIdMap.get(mainCFItemNumber)).map(CashFlowItemVO::getId).orElse(0L);
                voucherImportEntryInfo.setMainCFItemId(mainCFItemId);
            }
        }
    }

    protected Set<String> getAccountNumberSet() {
        return this.accountNumberSet;
    }

    protected Map<String, Set<String>> getFlexFieldBaseDataNumsMap() {
        return this.flexFieldBaseDataNumsMap;
    }

    public Set<String> getMainCFItemNumberSet() {
        return this.mainCFItemNumberSet;
    }
}

