/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;

public class VoucherListSummaryHelper {
    private static final Log LOGGER = LogFactory.getLog(VoucherListSummaryHelper.class);
    private static final String ENTRIES = "entries.";

    private static boolean isBalQueryEnable() {
        boolean isBalQueryEnable = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.query.balQuery.enable", (boolean)false);
        LOGGER.info("VoucherListSummaryHelper_isBalQueryEnable:" + isBalQueryEnable);
        return isBalQueryEnable;
    }

    public static boolean checkBalQueryEnable(QueryBuilder queryBuilder) {
        if (!VoucherListSummaryHelper.isBalQueryEnable()) {
            return false;
        }
        List sumFields = queryBuilder.getSumFields();
        if (CollectionUtils.isEmpty((Collection)sumFields)) {
            return false;
        }
        QFilter[] filters = queryBuilder.getFilters();
        if (filters == null || filters.length == 0) {
            return false;
        }
        if (sumFields.stream().allMatch(x -> "debitlocal".equalsIgnoreCase(x.getKey()) || "creditlocal".equalsIgnoreCase(x.getKey()) || "debitori".equalsIgnoreCase(x.getKey()) || "creditori".equalsIgnoreCase(x.getKey())) && Arrays.stream(filters).allMatch(x -> VoucherListSummaryHelper.isFilterMatchBalanceDim(x, true))) {
            return true;
        }
        return sumFields.stream().allMatch(x -> "debitlocal".equalsIgnoreCase(x.getKey()) || "creditlocal".equalsIgnoreCase(x.getKey()) || "debitori".equalsIgnoreCase(x.getKey()) || "creditori".equalsIgnoreCase(x.getKey()) || "debitlocamount".equalsIgnoreCase(x.getKey()) || "creditlocamount".equalsIgnoreCase(x.getKey())) && Arrays.stream(filters).allMatch(x -> VoucherListSummaryHelper.isFilterMatchBalanceDim(x, false));
    }

    private static boolean isFilterMatchBalanceDim(QFilter filter, boolean withEntry) {
        String property;
        return CollectionUtils.isEmpty((Collection)filter.getNests(false)) && (property = filter.getProperty()) != null && (VoucherListSummaryHelper.isStatusFilterMatchBalQuery(filter) || property.startsWith("org") || property.startsWith("booktype") || property.startsWith("period") || property.startsWith("accounttable") || property.startsWith("entries.eorg") || property.startsWith("entries.eperiod") || withEntry && (property.equalsIgnoreCase("entries.account") || property.equalsIgnoreCase("entries.account.id") || property.equalsIgnoreCase("entries.assgrp") || property.equalsIgnoreCase("entries.assgrp.id") || property.startsWith("entries.currency") || property.startsWith("entries.measureunit") || ComAssistTable.getMaxCommonAssistKeys().stream().map(k -> ENTRIES + k).anyMatch(x -> property.equalsIgnoreCase((String)x) || property.equalsIgnoreCase(x + ".id"))));
    }

    private static boolean isStatusFilterMatchBalQuery(QFilter filter) {
        if ("billstatus".equalsIgnoreCase(filter.getProperty())) {
            Set<String> statusInFilter = VoucherListSummaryHelper.getStatusInFilter(filter);
            return statusInFilter.contains("B") && statusInFilter.contains("C");
        }
        return false;
    }

    private static Set<String> getStatusInFilter(QFilter statusFilter) {
        String cp = statusFilter.getCP();
        Set<String> statusInFilter = VoucherListSummaryHelper.convertValueToList(statusFilter.getValue()).stream().map(Object::toString).collect(Collectors.toSet());
        switch (cp) {
            case "in": 
            case "=": {
                return statusInFilter;
            }
            case "not in": 
            case "!=": {
                HashSet allStatus = Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D"});
                allStatus.removeIf(statusInFilter::contains);
                return allStatus;
            }
        }
        return Collections.emptySet();
    }

    private static List<Object> convertValueToList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (value != null && value.getClass().isArray()) {
            return Arrays.stream((Object[])value).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (value != null) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    public static Optional<List<SummaryResult>> getSummaryResult(QueryBuilder queryBuilder, ComAssistTable comAssistTable) {
        if (!VoucherListSummaryHelper.checkBalQueryEnable(queryBuilder)) {
            return Optional.empty();
        }
        List<SummaryResult> summaryResults = VoucherListSummaryHelper.sumVoucher(queryBuilder);
        Object[] balSums = VoucherListSummaryHelper.sumBalance(queryBuilder, comAssistTable);
        for (int i = 0; i < summaryResults.size(); ++i) {
            if (StringUtils.isBlank((Object)balSums[i])) continue;
            SummaryResult summaryResult = summaryResults.get(i);
            summaryResult.addResult(new BigDecimal(balSums[i].toString()));
        }
        return Optional.of(summaryResults);
    }

    private static List<SummaryResult> sumVoucher(QueryBuilder queryBuilder) {
        QFilter[] filters = queryBuilder.getFilters();
        List<QFilter> voucherFilters = Arrays.stream(filters).collect(Collectors.toList());
        List statusFilters = Arrays.stream(filters).filter(VoucherListSummaryHelper::isStatusFilterMatchBalQuery).collect(Collectors.toList());
        Set status = statusFilters.stream().flatMap(x -> VoucherListSummaryHelper.getStatusInFilter(x).stream()).collect(Collectors.toSet());
        if (status.isEmpty()) {
            voucherFilters.add(new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "D"})));
        } else {
            voucherFilters.removeAll(statusFilters);
            status.remove("B");
            status.remove("C");
            if (!status.isEmpty()) {
                voucherFilters.add(new QFilter("billstatus", "in", status));
            } else {
                List sumFields = queryBuilder.getSumFields();
                ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>(sumFields.size());
                for (ListField sumField : sumFields) {
                    SummaryResult summaryResult = new SummaryResult(sumField.getListFieldKey().replace('.', '_'), BigDecimal.ZERO, sumField.getSummary());
                    summaryResults.add(summaryResult);
                }
                return summaryResults;
            }
        }
        queryBuilder.setFilters(voucherFilters.toArray(new QFilter[0]));
        List summaryResults = SumQuery.getSummaryResults((QueryBuilder)queryBuilder);
        queryBuilder.setFilters(filters);
        return summaryResults;
    }

    private static Object[] sumBalance(QueryBuilder queryBuilder, ComAssistTable comAssistTable) {
        QFilter[] filters = queryBuilder.getFilters();
        ArrayList balanceFilters = new ArrayList(filters.length);
        Arrays.stream(filters).forEach(x -> VoucherListSummaryHelper.convertVoucherFilterToBalanceFilter(x, comAssistTable).ifPresent(balanceFilters::add));
        if (balanceFilters.isEmpty()) {
            return queryBuilder.getSumFields().stream().map(x -> BigDecimal.ZERO).toArray();
        }
        List sumFields = queryBuilder.getSumFields();
        String[] sums = (String[])sumFields.stream().map(x -> {
            Optional<String> balanceAmtField = VoucherListSummaryHelper.mapToBalanceAmtField(x.getKey());
            return balanceAmtField.map(s -> "sum(" + s + ") " + x.getKey()).orElse(null);
        }).filter(Objects::nonNull).toArray(String[]::new);
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_balance", (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_balance"));
        return orm.aggregate(queryBuilder.getEntityType().getDBRouteKey(), "gl_balance", sums, balanceFilters.toArray(new QFilter[0]));
    }

    private static Optional<String> mapToBalanceAmtField(String voucherAmtField) {
        switch (voucherAmtField) {
            case "debitlocal": 
            case "debitlocamount": {
                return Optional.of("debitlocal");
            }
            case "creditlocal": 
            case "creditlocamount": {
                return Optional.of("creditlocal");
            }
            case "debitori": {
                return Optional.of("debitfor");
            }
            case "creditori": {
                return Optional.of("creditfor");
            }
        }
        return Optional.empty();
    }

    private static Optional<QFilter> convertVoucherFilterToBalanceFilter(QFilter qFilter, ComAssistTable comAssistTable) {
        String comAssistKey;
        Optional commonAssist;
        String property = qFilter.getProperty();
        if (property == null || property.startsWith("entries.eorg") || property.startsWith("entries.eperiod")) {
            return Optional.empty();
        }
        if (property.startsWith("org") || property.startsWith("booktype") || property.startsWith("period") || property.startsWith("accounttable")) {
            return Optional.of(qFilter);
        }
        if (property.equalsIgnoreCase("entries.assgrp") || property.equalsIgnoreCase("entries.assgrp.id") || property.startsWith("entries.currency") || property.startsWith("entries.measureunit")) {
            return Optional.of(new QFilter(qFilter.getProperty().replace(ENTRIES, ""), qFilter.getCP(), qFilter.getValue()));
        }
        if (property.startsWith("entries.account")) {
            QFilter idF = new QFilter("id", qFilter.getCP(), qFilter.getValue());
            List mids = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"masterid", (QFilter[])idF.toArray()).values().stream().map(acct -> acct.getLong("masterid")).collect(Collectors.toList());
            return Optional.of(new QFilter("account", "in", mids));
        }
        if (comAssistTable != null && property.startsWith("entries.comassist") && (commonAssist = comAssistTable.getCommonAssist(comAssistKey = property.split("\\.")[1])).isPresent()) {
            String comAssistEntity = ((CommonAssist)commonAssist.get()).getValueSource();
            Set mids = BusinessDataServiceHelper.loadFromCache((String)comAssistEntity, (String)"masterid", (QFilter[])new QFilter("id", qFilter.getCP(), qFilter.getValue()).toArray()).values().stream().map(dyo -> dyo.getLong("masterid")).collect(Collectors.toSet());
            return Optional.of(new QFilter(comAssistKey, "in", mids));
        }
        return Optional.empty();
    }
}

