/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.query.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.OrderEnhanceParam;
import kd.fi.bd.service.balance.VoucherOrderbyEnhancer;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.iterators.IBufferContextWrapper;
import kd.fi.bd.util.iterators.impl.ArrayBufferContextWrapper;
import kd.fi.bd.util.iterators.impl.BaseBufferedIterator;
import kd.fi.bd.util.xdb.FIXDBShardingHelper;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.formplugin.voucher.VoucherSqlQuery;
import kd.fi.gl.formplugin.voucher.list.cache.VoucherListCache;
import kd.fi.gl.formplugin.voucher.list.ctx.VoucherListContext;
import kd.fi.gl.formplugin.voucher.list.enums.SortType;
import kd.fi.gl.formplugin.voucher.list.query.BatchPageQuery;
import kd.fi.gl.formplugin.voucher.list.query.QueryBuilderWrapper;
import kd.fi.gl.formplugin.voucher.list.query.impl.WithoutEntryOrderQuery;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRange;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangesHelper;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRangesParam;
import kd.fi.gl.formplugin.voucher.list.result.VoucherRowsResultBuilder;
import kd.fi.gl.formplugin.voucher.list.utils.QFilterUtil;
import kd.fi.gl.formplugin.voucher.list.utils.SortUtil;

public class MultiOrgQuery
extends VoucherSqlQuery {
    private VoucherListContext context;

    public MultiOrgQuery(VoucherListContext context) {
        this.context = context;
    }

    public VoucherListContext getContext() {
        return this.context;
    }

    public void setContext(VoucherListContext context) {
        this.context = context;
    }

    private int getMaximumApplicablePageIndex() {
        return 5;
    }

    private int getBatchSize() {
        return Math.min(GLBillParamEnum.VOUCHER_MULTI_ORG_QUERY_BATCH_SIZE.getIntegerValue(), HugeInConfig.inThreshold());
    }

    @Override
    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        int start;
        List<Object> sortedOrgIdList;
        OrderEnhanceParam enhanceParam = new OrderEnhanceParam(queryBuilder.getFilters(), queryBuilder.getOrderBys(), this.getContext().isSelectEntry());
        enhanceParam.setForceEnhancers(new VoucherOrderbyEnhancer.OrderEnhancerEnum[]{VoucherOrderbyEnhancer.OrderEnhancerEnum.BOOKEDDATE_ORDER, VoucherOrderbyEnhancer.OrderEnhancerEnum.PERIOD_ORDER});
        queryBuilder.setOrderBys(VoucherOrderbyEnhancer.enhanceOrderby((OrderEnhanceParam)enhanceParam));
        if (this.getContext().getPageNumber() > this.getMaximumApplicablePageIndex()) {
            return super.getData(queryBuilder);
        }
        QFilterBuilder filters = QFilterUtil.removeOrgIdFilters(Arrays.asList(queryBuilder.getFilters()));
        Set<Long> filterOrgIds = this.context.getFilterOrgIds();
        Comparator comparator = SortUtil.tryGetSortType(queryBuilder.getOrderBys(), "org").orElse(SortType.DESC).getComparator();
        Optional<PageLastOrg> lastPageLastOrg = this.tryGetLastPageLastOrg();
        if (lastPageLastOrg.isPresent()) {
            sortedOrgIdList = SortUtil.sort(filterOrgIds, comparator, lastPageLastOrg.get().getOrgId());
            start = lastPageLastOrg.get().count;
        } else {
            sortedOrgIdList = SortUtil.sort(filterOrgIds, comparator, null);
            start = queryBuilder.getStart();
        }
        int batchSize = Math.min(sortedOrgIdList.size(), this.getBatchSize());
        BaseBufferedIterator bufferedIterator = new BaseBufferedIterator(sortedOrgIdList.iterator(), (IBufferContextWrapper)new ArrayBufferContextWrapper((Object[])new Long[batchSize], true));
        QueryBuilderWrapper queryBuilderWrapper = new QueryBuilderWrapper(queryBuilder);
        VoucherRowsResultBuilder resultBuilder = new VoucherRowsResultBuilder(queryBuilder);
        PageLastOrg currentPageLastOrg = new PageLastOrg();
        BatchPageQuery batchPageQuery = new BatchPageQuery(bufferedIterator, (Consumer<Row>)((Consumer)row -> currentPageLastOrg.count(row.getLong("org"))), (Consumer<Row>)((Consumer)row -> {
            Row persist = RowUtil.persist((Row)row);
            currentPageLastOrg.count(persist.getLong("org"));
            resultBuilder.addRow(persist);
        }), param -> {
            queryBuilderWrapper.setTempStart(param.getStart());
            queryBuilderWrapper.setTempLimit(param.getLimit());
            DataSet dataSet = WithoutEntryOrderQuery.query(queryBuilderWrapper, qbw -> this.queryVoucher((QueryBuilderWrapper)qbw, filters, (Long[])param.getParam()));
            if (resultBuilder.getRowMeta() == null) {
                resultBuilder.setRowMeta(dataSet.getRowMeta());
            }
            return dataSet;
        });
        batchPageQuery.query(start, queryBuilder.getLimit());
        this.cacheCurrentPageLastOrg(currentPageLastOrg);
        return this.buildResult(resultBuilder.build(), resultBuilder.getRowMeta(), queryBuilder);
    }

    private DataSet queryVoucher(QueryBuilderWrapper wrapper, QFilterBuilder filterBuilder, Long[] ids) {
        wrapper.setTempFilters(filterBuilder.toArray(new QFilter[]{new QFilter("org", "in", (Object)ids)}));
        VoucherRangesParam param = new VoucherRangesParam(wrapper.getTempStart(), wrapper.getTempLimit());
        param.setFilters(wrapper.getTempFilters());
        param.setOrderBy(wrapper.getTempOrderBys());
        param.setEntryCounted(this.getContext().isSelectEntry());
        param.setUsingListCache(false);
        param.setMaxLimit(wrapper.getQueryBuilder().getStart() + wrapper.getQueryBuilder().getLimit());
        Optional<List<VoucherRange>> pageRanges = VoucherRangesHelper.tryGetPageRanges(param);
        if (pageRanges.isPresent()) {
            return VoucherRangesHelper.queryDataSet(pageRanges.get(), wrapper);
        }
        return (DataSet)FIXDBShardingHelper.doSharingTableOperation((String)"gl_voucher", (QFilterBuilder)new QFilterBuilder(wrapper.getTempFilters()), (ctx, hints) -> wrapper.getOrm().queryDataSet(((Object)((Object)this)).getClass().getName(), wrapper.getQueryBuilder().getEntityName(), wrapper.getSelect(), wrapper.getTempFilters(), wrapper.getTempOrderBys(), wrapper.getTempStart(), wrapper.getTempLimit(), (Distinctable)WithEntityEntryDistinctable.get()));
    }

    private Optional<PageLastOrg> tryGetLastPageLastOrg() {
        return VoucherListCache.get("page_last_org_" + (this.getContext().getPageNumber() - 1), value -> {
            if (StringUtils.isEmpty((String)value)) {
                return Optional.empty();
            }
            return Optional.ofNullable(SerializationUtils.fromJsonString((String)value, PageLastOrg.class));
        });
    }

    private void cacheCurrentPageLastOrg(PageLastOrg pageLastOrg) {
        VoucherListCache.put("page_last_org_" + this.getContext().getPageNumber(), SerializationUtils.toJsonString((Object)pageLastOrg));
    }

    public static class PageLastOrg {
        private long orgId;
        private int count;

        public long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(long orgId) {
            this.orgId = orgId;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        private void refresh(long orgId) {
            this.setOrgId(orgId);
            this.setCount(0);
        }

        public void count(long orgId) {
            if (this.getOrgId() != orgId) {
                this.refresh(orgId);
            }
            this.setCount(this.getCount() + 1);
        }
    }
}

